<?php

function prv_geoLocationByIP() {

	// Accepts a single ip or comma delimited list of IP addresses

	$ipArray = explode(",", sanitize("ip"));

	$_ENV['contentTitle'] = "GeoLocation";

	$_ENV['templateData'] = geoLocationEventsByIP($ipArray);

	$_ENV['template'] = "template_geoLocation.php";

}

function poll_liveGeoLocation() {

	if (!getVar("id")) setVar("id", 0);
	if (!getVar("risk")) setVar("risk", 0);
	if (!getVar("num")) setVar("num", 10);

	$_ENV['contentTitle'] = "Live GeoLocation";

	$_ENV['template'] = "template_liveGeoLocationPoll.php";

}

function prv_liveGeoLocation() {

	if (!getVar("id")) setVar("id", 0);
	if (!getVar("risk")) setVar("risk", 0);
	if (!getVar("num")) setVar("num", 10);

	$_ENV['contentTitle'] = "Live GeoLocation";

	$queryArray[] = "recent:" . sanitize("num");
	if (sanitize("id")) $queryArray[] = "sensor:" . sanitize("id");
	if (sanitize("risk")) $queryArray[] = "risk:" . sanitize("risk");

	$query = implode(" ", $queryArray);

	$_ENV['templateData'] = liveGeoLocationEvents($query);

	$_ENV['template'] = "template_liveGeoLocation.php";

}

function displayLiveGeoLocationSensors() {
	
	// Sensor list

	$out .= itemRenderer("liveGeoLocationSensorSelection", array("id" => 0, "name" => "All Sensors"));

	$result = $_ENV['appDB']->query("SELECT * FROM idsSensor WHERE id IN (" . $_SESSION["user"]["sensors"] . ") AND enabled = 1 ORDER BY module, name");
	
	if ($result) {
	
		while ($row = mysql_fetch_assoc($result)) {
	
			if ($row["module"] == 1) {
			
				$row["moduleName"] = "Snort";
			
			} else if ($row["module"] == 2) {
	
				$row["moduleName"] = "Syslog";
			
			} else {
	
				$row["moduleName"] = "";
			
			}
	
			$out .= itemRenderer("liveGeoLocationSensorSelection", $row);
				
		}

	} else {
	
		$out = "No available sensors";
	
	}

	return $out;

}

function geoLocationEventsByIP($ipArray) {

	$trackArray = array();

	foreach ($ipArray as $ip) {

		// GeoLocation data
		
		// check if ip is in the no plot list
		$noPlot = noPlotTest($ip);
		
		if (!$noPlot) {
		
			$latLonArray = getLatLonCoordinates($ip);
			
			$lat = $latLonArray[0];
			$lon = $latLonArray[1];
			
			if ($lat) {

				if (!in_array("$lat,$lon", $trackArray)) {
				
					$js .= "\tvar event_" . ip2long($ip) . " = new google.maps.LatLng($lat,$lon);\n";
					$js .= "\tvar eventMarker_" . ip2long($ip) . " = new google.maps.Marker({position: event_" . ip2long($ip) . ", map: gMap, animation: google.maps.Animation.DROP, title:'IP: " . $ip . "'});\n";

					$js .= "\n";
					
					$trackArray[] = "$lat,$lon";

				} else {
				
				}
		
			} else {
			
				$message = "GeoLocation plot results not available for this address ($ip).";
			
			}

		} else {
		
			$message = "This address resides within the user defined No Plot list ($ip).";
		
		}
		
		// Delete old cache (if applicable)

		deleteOldGeoCache();
		
	}

	$array = arrayToObject(array("js" => $js, "message" => $message));
	
	return $array;

}

function liveGeoLocationEvents($query = "recent:25") {

	$trackArray = array();
	$eventArray = array();

	$searchObj = new coreSearch();
	$searchObj->setVar("query", $query);
	$searchObj->setVar("store", ops("site_activeDataStore"));

	// Animation settings
	
	$animation = "animation: google.maps.Animation.DROP,";	
	if (sanitize("noAnimation")) $animation = "";

	// Get event id's

	foreach ($searchObj->searchProcess() as $data) {

		$eventArray[] = $data;

	}
	
	// Process event id's
	
	foreach ($eventArray as $data) {

		// Event data

		$tmp = explode(":", $data);
		
		$store = $tmp[0];
		$eventID = $tmp[1];

		$searchObj->setVar("store", $store);

		$eventData = $searchObj->getDetailsByID(trim($eventID));

		// GeoLocation data
		
		// check if ip is in the no plot list
		$noPlot = noPlotTest($eventData["sip"]);
		
		if (!$noPlot) {
		
			$latLonArray = getLatLonCoordinates($eventData["sip"]);
			
			$lat = $latLonArray[0];
			$lon = $latLonArray[1];
			
			if ($lat) {

				if (!in_array("$lat,$lon", $trackArray)) {
				
					// Sensor GeoLocation data
			
					$loc = trim(getLocationNameByID($eventData["sensorID"]));
					$loc = str_replace(" ", ",", $loc);
					$loc = explode(",", $loc);
				
					$js .= "\n";
				
					$js .= "\tvar sensor_" . $eventData["sensorID"] . " = new google.maps.LatLng(" . $loc[0] . ", " . $loc[1] . ");\n";
					$js .= "\tvar sensorMarker_" . $eventData["sensorID"] . " = new google.maps.Marker({position: sensor_" . $eventData["sensorID"] . ", icon: blueMarker, map: gMap, $animation title:'Sensor: " . $eventData["sensorID"] . "'});\n";
				
					$js .= "\n";
				
					$js .= "\tvar event_$eventID = new google.maps.LatLng($lat,$lon);\n";
					$js .= "\tvar eventMarker_$eventID = new google.maps.Marker({position: event_$eventID, map: gMap, $animation title:'Event ID: $eventID Source IP: " . long2ip($eventData["sip"]) . "'});\n";

					$js .= "\n";
				
					$js .= "\tvar linePathCoordinates_$eventID = [ new google.maps.LatLng($lat,$lon), new google.maps.LatLng(" . $loc[0] . ", " . $loc[1] . ") ];\n";
					$js .= "\tvar linePath_$eventID = new google.maps.Polyline({ path: linePathCoordinates_$eventID, strokeColor: '#000000', strokeOpacity: 0.5, strokeWeight: 1 });\n";

					$js .= "\n";
		
					$js .= "markersArray.push(sensorMarker_" . $eventData["sensorID"] . ");\n";
					$js .= "markersArray.push(eventMarker_$eventID);\n";
					$js .= "markersArray.push(linePath_$eventID);\n";

					$js .= "\n";
		
					$js .= "\tlinePath_$eventID.setMap(gMap);\n";

					$js .= "\n";
					
					$trackArray[] = "$lat,$lon";

				} else {
				
				}
				
		
			}

		}

		// Delete old cache (if applicable)

		deleteOldGeoCache();
		
	}

	return $js;

}

function noPlotTest($longIP) {

	if (strstr($longIP, ".")) $longIP = ip2long($longIP);

	$noPlotArray = explode(",", str_replace(" ", "", ops("site_geoLocationNoPlotList")));
	
	foreach ($noPlotArray as $net) {
	
		$tmp = explode("-", cidrconv($net));
		
		if ($longIP >= ip2long($tmp[0]) && $longIP <= ip2long($tmp[1])) {

			return true;

		}
	
	}
	
	return false;

}

function deleteOldGeoCache() {

	$cacheAgeLimit = time() - 604800;

	$_ENV['appDB']->query("DELETE FROM idsGeoCache WHERE timestamp < '$cacheAgeLimit' LIMIT 25");

}

function prv_downloadGeoDatabase() {

	ops("site_downloadGeoDatabaseNow", 1);
	
    // Redirect

    $_ENV['redirect'] = array("prv_main", 5000);
    
    $_ENV['redirectMessage'] = "Initiating Geo Database Download (may take some time)";

    $_ENV['template'] = "template_redirectGeneral.php";

}

?>