<?php

function prv_eventSearch() {

	if (!sanitize("query")) {
	
		$query = buildQueryFromBrowserForm();
		
	} else {
	
		$query = sanitize("query");
	
	}
	
	if (stristr($query, "report:")) {

		$transaction = reportSubmit($query);

		$_ENV['contentTitle'] = "Event Report Request: $query";

	    // Redirect
	
	    $_ENV['redirect'] = array("prv_myReports", DEFAULT_REDIRECT_TIMEOUT);
	    $_ENV['redirectMessage'] = "Event Report Requested";
	
	    $_ENV['template'] = "template_redirectGeneral.php";
	
	} else {

		$transaction = searchSubmit($query);
	
		$_ENV['contentTitle'] = "Event Search Results: $query";
	
		$_ENV['contentData'] = arrayToObject(array("query" => $query, "transaction" => $transaction));
	
		$_ENV['template'] = "template_eventSearchResultsPoll.php";
		
	}

}

function prv_eventSearchResults() {

	$page = sanitize("page");
	$transaction = sanitize("transaction");

    $data = file("tmp/search/search-" . login("id") . "-" . $transaction . ".events");
    $totalResults = trim($data[4]);
    $query = trim($data[3]);

	$chartData = eventTimelineJSData_fromSearchResults($transaction);

	$_ENV['contentTitle'] = "Event Search Results: $query";

	$_ENV['contentData'] = arrayToObject(array("query" => "$query", "totalResults" => "$totalResults", "page" => "$page", "transaction" => "$transaction", "chart" => $chartData));

	$_ENV['template'] = "template_eventSearchResults.php";

}

function eventTimelineJSData_fromSearchResults($transaction) {

    $data = file("tmp/search/search-" . login("id") . "-" . $transaction . ".events");
    $totalResults = trim($data[4]);

	if ($totalResults > 750) {
	
		$div = round($totalResults / 750);
		
	} else {
	
		$div = 1;
	
	}	
    
	$cnt = 0;
    
    foreach ($data as $row) {

		if ($go == true) {
		
			if ($cnt == 0) {
		
				$tmp = explode(":", $row);
				$idArray[] = trim($tmp[1]);
				
			}
			
			$cnt++;
		
			if ($cnt >= $div) $cnt = 0;
		
		}
		
		if (strstr($row, "---")) $go = true;

	}    

	$jsObject = array();

	$q = $_ENV['appDB']->query("SELECT evt.timestamp AS timestamp, count(mas.id) AS cnt FROM idsDataStore_" . login("activeSearchStore") . "_Master AS mas JOIN idsDataStore_" . login("activeSearchStore") . "_Events AS evt ON (mas.id = evt.id) WHERE mas.id IN (" . implode(",", $idArray) . ") GROUP BY evt.timestamp ORDER BY evt.timestamp");

	$numRows = mysql_num_rows($q);
	
	while ($row = @mysql_fetch_assoc($q)) {

		$jsObject[] = "{t: " . "new Date('" . date("m/d/Y H:i:s", $row['timestamp']) . "')" . ", e: " . $row['timestamp'] . ", c: " . $row['cnt'] . "}";
		
	}

	return "var chartData = [" . implode(",", $jsObject) . "]";

}

function searchSubmit($query) {

    // Store Check
    
    if (strstr($query, "store:")) {

        preg_match("/(?<=store\:)[0-9]+/", $query, $match);
        $store = $match[0];

    } else if (strstr($query, "collection:")) {

        $store = login("activeSearchStore");

    } else if (strstr($query, "eventid:")) {

        $store = login("activeSearchStore");

    } else if (strstr($query, "recent:")) {

        $store = login("activeSearchStore");

    } else if (stristr($query, "delete:")) {

        $store = login("activeSearchStore");

    }

    if (!$store) {

        $store = login("activeSearchStore");

        for ($i = 0; $i < ops("site_datastoreSearchWindow"); $i++) {

            $tmp = $store - $i;
            if ($tmp < 1000) break;

            $storeArray[] = $tmp;

        }

        $store = implode(",", $storeArray);

    }

    $transaction = time();
    
    // Queue search
    
    $mObject = arrayToObject(array("type" => 1, "data" => "$query", "options" => "$transaction|$store"));
    
    $mQueue = new messageQueue();
    $mQueue->add($mObject);
        
	return $transaction;

}

function reportSubmit($query) {

    // Store Check
    
    $query = trim(str_ireplace("report:", "", $query));
    
    if (strstr($query, "store:")) {

        preg_match("/(?<=store\:)[0-9]+/", $query, $match);
        $store = $match[0];

    } else if (strstr($query, "collection:")) {

        $store = login("activeSearchStore");

    } else if (strstr($query, "eventid:")) {

        $store = login("activeSearchStore");

    } else if (strstr($query, "recent:")) {

        $store = login("activeSearchStore");

    } else if (stristr($query, "delete:")) {

        $store = login("activeSearchStore");

    }

    if (!$store) {

        $store = login("activeSearchStore");

        for ($i = 0; $i < ops("site_datastoreSearchWindow"); $i++) {

            $tmp = $store - $i;
            if ($tmp < 1000) break;

            $storeArray[] = $tmp;

        }

        $store = implode(",", $storeArray);

    }
    
    $transaction = time();

	$_ENV['appDB']->query("INSERT INTO idsReportSchedule (name, userid, email, query, store, type, status, viewed, mon, tue, wed, thu, fri, sat, sun, runtime, runlast, enabled, intime) 
    	values (
    		'$query',
    		'" . $_SESSION['user']['id'] . "',
    		'',
    		'$query',
    		'$store',
    		'1',
    		'0',
    		'0',
    		'0',
    		'0',
    		'0',
    		'0',
    		'0',
    		'0',
    		'0',
    		'00:00',
    		'0',
    		'1',
    		'" . $transaction . "'
    	)");

    // Queue report
    
    $mObject = arrayToObject(array("type" => 2, "data" => "$transaction"));
    
    $mQueue = new messageQueue();
    $mQueue->add($mObject);
    
	return $transaction;

}

function poll_eventSearchResults() {

	$transaction = sanitize("transaction");
    if (!$transaction) return;

    if (@file_exists("tmp/search/search-" . login("id") . "-" . $transaction . ".events")) {
	    
	    echo $transaction;

    } else {
    
    	echo 0;

    }

}

function returnEventHTML($transaction, $page) {

	$number = 25;

    if (!$page || $page == "") $page = 1;
    $page--;

    if ($page == 0) {
    
    	$start = 0;
    	
    } else {
    
    	$start = $page * $number;
            
    }

    $totalInSet = 0;
    $totalIgnores = 0;
    $numCount = 0;

    $data = file("tmp/search/search-" . login("id") . "-" . $transaction . ".events");

    $totalResults = trim($data[4]);

    $searchObj = new coreSearch();

    // Shift items off of array
    $data = array_slice($data, 6);

    for ($i = $start; $i < count($data); $i++) {
   
	    $totalInSet++;
	    $numCount++;
	
	    $tmp = explode(":", $data[$i]);
	
	    $store = $tmp[0];
	    $eventID = $tmp[1];
	
	    $searchObj->setVar("store", $store);
	
	    $eventData = $searchObj->getDetailsByID(trim($eventID));
	
	    $eventAge = consoleTimeConversion(time()) - sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"]);
	    if ($eventAge < 0) $eventAge = 0;
	
		$out .= itemRenderer('event', $eventData);
	
	    if ($numCount >= $number) break;

    }

    return $out;
}


function buildQueryFromBrowserForm() {

	if (sanitize("report")) $qArray[] = "report:";

	if (sanitize("sip")) $qArray[] = "sip:" . sanitize("sip");
	if (sanitize("dip")) $qArray[] = "dip:" . sanitize("dip");

	if (sanitize("sport")) $qArray[] = "sport:" . sanitize("sport");
	if (sanitize("dport")) $qArray[] = "dport:" . sanitize("dport");

	if (sanitize("string")) $qArray[] = sanitize("string");

	if (sanitize("protocol")) $qArray[] = "protocol:" . sanitize("protocol");

	if (sanitize("risk")) $qArray[] = "risk:" . sanitize("risk");

	if (sanitize("signature")) $qArray[] = "signature:" . sanitize("signature");
	if (sanitize("category")) $qArray[] = "category:" . sanitize("category");
	
	if (getVar("sensors")) $qArray[] = "sensor:" . implode(",", getVar("sensors"));
	
	$query = implode(" ", $qArray);
	
	return $query;
	
}

function search($query) {

	$totalResults = 0;
	$totalInSet = 0;
	$totalIgnores = 0;

	if (!$query) {
	
		$query = "recent:10";
	
		$_ENV['contentTitle'] = "Event Browser > No query -- using: " . $query;
		
	}

	$searchObj = new coreSearch();
	$searchObj->setVar("query", $query);
	$searchObj->setVar("store", ops("site_activeDataStore"));

	// Get event id's

	foreach ($searchObj->searchProcess() as $data) {

		$eventArray[] = $data;

	}
	
	// Reverse array for proper sort order (top is most recent for live monitor)
	
	rsort($eventArray);
	
	// Process event id's
	
	foreach ($eventArray as $data) {

		$totalInSet++;

		$tmp = explode(":", $data);
		
		$store = $tmp[0];
		$eventID = $tmp[1];

		$searchObj->setVar("store", $store);

		$eventData = $searchObj->getDetailsByID(trim($eventID));

		if (!$eventData["sport"]) $eventData["sport"] = "-";
		if (!$eventData["dport"]) $eventData["dport"] = "-";

		$eventAge = consoleTimeConversion(time()) - sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"]);
		if ($eventAge < 0) $eventAge = 0;
		
		$eventData["eventAge"] = $eventAge;
		
		$out .= itemRenderer('event', $eventData);

	}
	
	return $out;

}

function liveResults($query = "recent:10") {

	$totalResults = 0;
	$totalInSet = 0;
	$totalIgnores = 0;

	$eventArray = array();

	$searchObj = new coreSearch();
	$searchObj->setVar("query", $query);
	$searchObj->setVar("store", ops("site_activeDataStore"));

	// Get event id's

	foreach ($searchObj->searchProcess() as $data) {

		$eventArray[] = $data;

	}
	
	// Reverse array for proper sort order (top is most recent for live monitor)
	
	rsort($eventArray);
	
	// Process event id's
	
	foreach ($eventArray as $data) {

		$totalInSet++;

		$tmp = explode(":", $data);
		
		$store = $tmp[0];
		$eventID = $tmp[1];

		$searchObj->setVar("store", $store);

		$eventData = $searchObj->getDetailsByID(trim($eventID));

		if (!$eventData["sport"]) $eventData["sport"] = "-";
		if (!$eventData["dport"]) $eventData["dport"] = "-";

		$eventAge = consoleTimeConversion(time()) - sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"]);
		if ($eventAge < 0) $eventAge = 0;
		
		$eventData["eventAge"] = $eventAge;

		$out .= itemRenderer('event', $eventData);	

	}
	
	if (!$out) $out = "There are no events to display at this time.";
	
	return $out;

}

function tickerText($query = "recent:10") {

	$totalResults = 0;
	$totalInSet = 0;
	$totalIgnores = 0;

	$eventArray = array();
	$outArray = array();

	$searchObj = new coreSearch();
	$searchObj->setVar("query", $query);
	$searchObj->setVar("store", ops("site_activeDataStore"));

	// Get event id's

	foreach ($searchObj->searchProcess() as $data) {

		$eventArray[] = $data;

	}
	
	// Reverse array for proper sort order (top is most recent for live monitor)
	
	rsort($eventArray);
	
	// Process event id's
	
	foreach ($eventArray as $data) {

		$totalInSet++;

		$tmp = explode(":", $data);
		
		$store = $tmp[0];
		$eventID = $tmp[1];

		$searchObj->setVar("store", $store);

		$eventData = $searchObj->getDetailsByID(trim($eventID));

		if (!$eventData["sport"]) $eventData["sport"] = "-";
		if (!$eventData["dport"]) $eventData["dport"] = "-";

		$eventAge = consoleTimeConversion(time()) - sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"]);
		if ($eventAge < 0) $eventAge = 0;
		
		$eventData["eventAge"] = $eventAge;

		if ($eventData['signatureName']) $outArray[] = "<a href=\"?op=prv_eventDetails&id=" . $eventData['id'] . "\">" . $eventData['signatureName'] . " (" . $eventData['className'] . ")</a>";

	}
	
	if (count($outArray) > 0) {
	
		$out = implode("&nbsp;&nbsp; - &nbsp;&nbsp;", $outArray);
		
	} else {
	
		$out = "There are no events to display at this time.";
		
	}
	
	return $out;

}

?>