<?php

function prv_signatureManagement() {

	/*
	
		Note: renderers are generated after template data, because the default policy (if not selected) is set
	
	*/

	// Get details

	$_ENV['templateData1'] = policyData();

	// Build renderers

	$_ENV['templateRenderer1'] = signatureCategoryData();

	$_ENV['templateRenderer2'] = signatureData();

	// Template

	$_ENV['contentTitle'] = "Signature Management";

	$_ENV['template'] = "template_signatureManagement.php";

}

function policyData() {

	$q = $_ENV['appDB']->query("SELECT * FROM idsSensorPolicy ORDER BY id DESC");
	while ($row = mysql_fetch_object($q)) {

		if (!getVar("policy")) setVar("policy", $row->id);

		$row->signatureCount = 0;
		$row->sensorCount = 0;

		// Count this policies signatures
		
		$q2 = $_ENV['appDB']->query("SELECT count(*) as cnt FROM idsSignaturePolicyIndex WHERE pid = '" . $row->id . "'");
		while ($row2 = mysql_fetch_assoc($q2)) {

			$row->signatureCount = $row2->cnt;

		}		

		// Count sensors using this policy
		
		$q2 = $_ENV['appDB']->query("SELECT count(*) as cnt FROM idsSensor WHERE confPolicy = '" . $row->id . "'");
		while ($row2 = mysql_fetch_assoc($q2)) {

			$row->sensorCount = $row2->cnt;

		}		

		$resultArray[] = $row;
		
	}

	return $resultArray;

}

function signatureCategoryData() {

	$policy = sanitize("policy");

	$filter = sanitize("filter");

	if ($filter) {
	
		$filterQuery = "AND (idsSignatures.data LIKE '%$filter%' OR idsSignatures.msg LIKE '%$filter%')";
	
	}

	$q = $_ENV['appDB']->query("SELECT file as name, count(id) AS total FROM idsSignatures WHERE id != 0 $filterQuery GROUP BY file ORDER BY file");
	while ($row = mysql_fetch_assoc($q)) {

		$q2 = $_ENV['appDB']->query("SELECT count(idsSignatures.id) as active FROM idsSignatures JOIN idsSignaturePolicyIndex ON (idsSignatures.id = idsSignaturePolicyIndex.sid) WHERE idsSignaturePolicyIndex.pid = '$policy' $filterQuery AND idsSignatures.file = '" . $row["name"] . "'");
		while ($row2 = mysql_fetch_assoc($q2)) {
		
			$row["active"] = $row2["active"];
		
		}

		if (!getVar("category")) setVar("category", $row['name']);
	
		$out .= itemRenderer('signatureManagement', $row);	

	}


	return $out;
}

function signatureData() {

	$policy = sanitize("policy");

	$category = sanitize("category");

	$filter = sanitize("filter");

	$enabledArray = array(99999933);

	if ($filter) {
	
		$filterQuery = "AND (idsSignatures.data LIKE '%$filter%' OR idsSignatures.msg LIKE '%$filter%')";
	
	}

	$q = $_ENV['appDB']->query("SELECT idsSignatures.id, idsSignatures.sid, idsSignatures.gid, idsSignatures.rev, idsSignatures.msg, idsSignatures.data as sigdata FROM idsSignatures JOIN idsSignaturePolicyIndex ON (idsSignatures.id = idsSignaturePolicyIndex.sid) WHERE idsSignaturePolicyIndex.pid = '$policy' $filterQuery AND idsSignatures.file = '$category'");
	while ($row = mysql_fetch_assoc($q)) {

		$enabledArray[] = $row["id"];

		$row["enabled"] = 1;

		$out .= itemRenderer('signatureSelection', $row);	

	}
	
	$q = $_ENV['appDB']->query("SELECT idsSignatures.id, idsSignatures.sid, idsSignatures.gid, idsSignatures.rev, idsSignatures.msg, idsSignatures.data as sigdata FROM idsSignatures WHERE idsSignatures.file = '$category' AND idsSignatures.id NOT IN (" . implode(",", $enabledArray) . ") $filterQuery");
	while ($row = mysql_fetch_assoc($q)) {

		$row["enabled"] = 0;

		$out .= itemRenderer('signatureSelection', $row);	

	}

	return $out;

}

function prv_signatureSourceList() {
	global $idsDB;

	$xml = "<document>\n";
	
	$xml .= "\t<options>\n";

	$xml .= "\t\t<enabled><![CDATA[" . ops("site_sigProcessorEnabled") . "]]></enabled>\n";
	$xml .= "\t\t<oinkcode><![CDATA[" . ops("site_sigOinkCode") . "]]></oinkcode>\n";
	$xml .= "\t\t<frequency><![CDATA[" . ops("site_sigProcessorFrequency") . "]]></frequency>\n";

	$xml .= "\t</options>\n";

	$xml .= "\t<sources>\n";

	$q = $idsDB->query("SELECT * FROM idsSignatureSources ORDER BY id");
	while ($row = mysql_fetch_assoc($q)) {

		$xml .= "\t\t<source>\n";

		if ($row["lastDownload"] == 0) {
			$row["lastDownload"] = "never";
		} else {
			$row["lastDownload"] = date(ops("site_timeDateFormat"), $row["lastDownload"]);
		}

		foreach ($row as $key => $val) {

			$xml .= "\t\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t\t</source>\n";

	}

	$xml .= "\t</sources>\n";
    
	$xml .= "</document>\n";

	return $xml;
}

function prv_signatureSourceUpdate() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$name = sanitize("name");
	$location = sanitize("location");
	$enabled = sanitize("enabled");

	$idsDB->query("UPDATE idsSignatureSources SET name = '$name', location = '$location', enabled = '$enabled' WHERE id = '$id'");
	
	$xml = "<document>\n";

	$xml .= "<success>1</success>\n";

	$xml .= "</document>\n";

	return $xml;
}

function prv_signatureSourceCreate() {
	global $idsDB;

	$name = sanitize("name");
	$location = sanitize("location");
	$enabled = sanitize("enabled");

	$idsDB->query("INSERT INTO idsSignatureSources (name, location, enabled) VALUES ('$name', '$location', '$enabled')");
	
	$xml = "<document>\n";

	$xml .= "<success>1</success>\n";

	$xml .= "</document>\n";

	return $xml;
}

function prv_signatureSourceDelete() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$idsDB->query("DELETE FROM idsSignatureSources WHERE id = '$id'");
	
	$xml = "<document>\n";

	$xml .= "<success>1</success>\n";

	$xml .= "</document>\n";

	return $xml;
}

function prv_signatureOptionsUpdate() {

    ops("site_sigProcessorEnabled", sanitize("enabled"));
    ops("site_sigOinkCode", sanitize("oinkcode"));

    ops("site_sigProcessorFrequency", "86400");
    
	$xml = "<document>\n";

	$xml .= "<success>1</success>\n";

	$xml .= "</document>\n";

	return $xml;

}

function prv_signatureTriggerDownload() {

	ops("site_sigProcessorNow", 1);
	
	$xml = "<document>\n";

	$xml .= "<success>1</success>\n";

	$xml .= "</document>\n";

}

function XX_prv_signatureCategoryData() {
	global $idsDB;

	$filter = sanitize("filter");

	if ($filter) {
	
		$filterQuery = "AND (idsSignatures.data LIKE '%$filter%' OR idsSignatures.msg LIKE '%$filter%')";
	
	}

	$xml = "<document>\n";
	
	$xml .= "\t<categories>\n";

	$q = $idsDB->query("SELECT file as name, count(id) AS total FROM idsSignatures WHERE id != 0 $filterQuery GROUP BY file ORDER BY file");
	while ($row = mysql_fetch_assoc($q)) {

		$xml .= "\t\t<category>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t\t</category>\n";

	}

	$xml .= "\t</categories>\n";
    
	$xml .= "</document>\n";

	return $xml;

}

function prv_signatureDetails() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$xml = "<document>\n";
	
	$xml .= "\t<signature>\n";

	$q = $idsDB->query("SELECT * FROM idsSignatures WHERE id = '$id'");
	while ($row = mysql_fetch_assoc($q)) {

		$q2 = $idsDB->query("SELECT * FROM idsSignatureSources WHERE id = '" . $row["source"] . "'");
		while ($row2 = mysql_fetch_assoc($q2)) {

			$row["sourceName"] = $row2["name"];
	
		}

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

	}

	$xml .= "\t</signature>\n";
    
	$xml .= "</document>\n";

	return $xml;

}

function prv_updateSignatures() {

	$sigs = getVar("sigs");
	
	if ($sigs) {
		$sids = implode(",", $sigs);
	} else {
		$sids = "";
	}
	
	$policy = sanitize("policy");

	$category = sanitize("category");

	// Disable signatures
	
	$q = $_ENV['appDB']->query("SELECT id FROM idsSignatures WHERE file = '$category'");
	while ($row = mysql_fetch_assoc($q)) {

		$sigArray[] = $row["id"];

	}

	$_ENV['appDB']->query("DELETE FROM idsSignaturePolicyIndex WHERE sid IN (" . implode(",", $sigArray)  . ") AND pid = '$policy'");

	// Enable signatures

	$sidsArray = explode(",", $sids);

	foreach ($sidsArray as $id) {

		$_ENV['appDB']->query("INSERT INTO idsSignaturePolicyIndex (pid, sid) VALUES ('$policy', '$id')");
	
	}
	
	// Update snort rules files
	
	snortRulesFile_write($policy, $category);

	// Build snort conf files who share this policy
	
	$q = $_ENV['appDB']->query("SELECT id FROM idsSensor WHERE confPolicy = '$policy'");
	while ($row = mysql_fetch_assoc($q)) {

	    snortConfWrite($row["id"]);

	}

    // Redirect

    $_ENV['redirect'] = array("prv_signatureManagement&category=$category&policy=$policy", DEFAULT_REDIRECT_TIMEOUT);

    $_ENV['redirectMessage'] = "Updating Signatures";

    $_ENV['template'] = "template_redirectGeneral.php";

}

function prv_enableAllSignatures() {
	global $idsDB;

	$policy = sanitize("policy");
	if (!$policy) return;

	$category = sanitize("category");

	$filter = sanitize("filter");

	if ($filter) {
	
		$filterQuery = "AND (idsSignatures.data LIKE '%$filter%' OR idsSignatures.msg LIKE '%$filter%')";
	
	}

	// Build a list of all signatures in the category

	$q = $idsDB->query("SELECT id FROM idsSignatures WHERE file = '$category' $filterQuery");
	while ($row = mysql_fetch_assoc($q)) {

		$sigArray[] = $row["id"];

	}

	// disable all signatures so we do not duplicate when enabling all
	
	$idsDB->query("DELETE FROM idsSignaturePolicyIndex WHERE sid IN (" . implode(",", $sigArray)  . ") AND pid = '$policy'");
	
	// enable all signatures
	
	foreach ($sigArray as $id) {

		$idsDB->query("INSERT INTO idsSignaturePolicyIndex (pid, sid) VALUES ('$policy', '$id')");
	
	}
	
	// Update snort rules files
	
	snortRulesFile_write($policy, $category);

	// Build snort conf files who share this policy
	
	$q = $idsDB->query("SELECT id FROM idsSensor WHERE confPolicy = '$policy'");
	while ($row = mysql_fetch_assoc($q)) {

	    snortConfWrite($row["id"]);

	}

	// Output

	$xml = "<document>\n";
	
	$xml .= "\t<response>1</response>\n";

	$xml .= "</document>\n";

	return $xml;
}

function prv_disableAllSignatures() {
	global $idsDB;

	$policy = sanitize("policy");
	if (!$policy) return;

	$category = sanitize("category");

	$filter = sanitize("filter");

	if ($filter) {
	
		$filterQuery = "AND (idsSignatures.data LIKE '%$filter%' OR idsSignatures.msg LIKE '%$filter%')";
	
	}

	// Build a list of all signatures in the category

	$q = $idsDB->query("SELECT id FROM idsSignatures WHERE file = '$category' $filterQuery");
	while ($row = mysql_fetch_assoc($q)) {

		$sigArray[] = $row["id"];

	}

	// disable all signatures
	
	$idsDB->query("DELETE FROM idsSignaturePolicyIndex WHERE sid IN (" . implode(",", $sigArray)  . ") AND pid = '$policy'");
	
	// Update snort rules files
	
	snortRulesFile_write($policy, $category);

	// Build snort conf files who share this policy
	
	$q = $idsDB->query("SELECT id FROM idsSensor WHERE confPolicy = '$policy'");
	while ($row = mysql_fetch_assoc($q)) {

	    snortConfWrite($row["id"]);

	}

	// Output

	$xml = "<document>\n";
	
	$xml .= "\t<response>1</response>\n";

	$xml .= "</document>\n";

	return $xml;
	
}

function prv_rebuildAllRulesFiles() {
	global $idsDB;

	$policy = sanitize("policy");
	if (!$policy) return;

	$xml = "<document>\n";
	
	$xml .= "\t<categories>\n";

	$q = $idsDB->query("SELECT file as name, count(id) AS total FROM idsSignatures WHERE id != 0 GROUP BY file ORDER BY file");
	while ($row = mysql_fetch_assoc($q)) {

		// Update snort rules files
	
		snortRulesFile_write($policy, $row["name"]);

		$xml .= "\t\t<category>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t\t</category>\n";

	}

	$xml .= "\t</categories>\n";
    
	$xml .= "</document>\n";
	
	// Build snort conf files who share this policy
	
	$q = $idsDB->query("SELECT id FROM idsSensor WHERE confPolicy = '$policy'");
	while ($row = mysql_fetch_assoc($q)) {

	    snortConfWrite($row["id"]);

	}

	return $xml;

}

function prv_snortPolicySettings() {

	$xml = "<document>\n";

		$xml .= "\t<node>\n";

		$xml .= "\t\t<status><![CDATA[" . ops("site_sigProcessorEnabled") . "]]></status>\n";
		$xml .= "\t\t<urls><![CDATA[" . ops("site_sigDownloadURL") . "]]></urls>\n";
		$xml .= "\t\t<oinkcode><![CDATA[" . ops("site_sigOinkCode") . "]]></oinkcode>\n";
		$xml .= "\t\t<frequency><![CDATA[" . ops("site_sigProcessorFrequency") . "]]></frequency>\n";

		$xml .= "\t</node>\n";
	
	$xml .= "</document>\n";

	return $xml;

}

?>