<?php

function prv_situationalAwareness() {

	// Set default if not selected

	$timeSelection = sanitize('timeSelection');
	if (!$timeSelection) setVar('timeSelection', '86400');

	$_ENV['contentTitle'] = "Situational Awareness";

	$_ENV['templateData'] = situationalAwareness();

	$_ENV['template'] = "template_situationalAwareness.php";

}

function situationalAwareness() {

	if (sanitize('timeSelection') > 1) {
	
		$time = time() - sanitize('timeSelection');

		$timeQuery = "AND evt.timestamp > $time";
	
	} else {
	
		$timeQuery = "";
		
	}

	$data = arrayToObject(array());

	$eventCount = 0;
	$eventSourceCount = 0;
	$eventDestinationCount = 0;
	
	$datastoreEventTotal = eventsInDatastore($_SESSION["user"]["activeSearchStore"]);
	
	// Device type
	
	$q = $_ENV['appDB']->query("SELECT idsDeviceTypes.*, COUNT(idsDevices.id) AS deviceCount FROM idsDevices JOIN idsDeviceTypes ON (idsDevices.type = idsDeviceTypes.id) GROUP BY idsDeviceTypes.id ORDER BY idsDeviceTypes.name");
	while ($row = mysql_fetch_object($q)) {

		$q2 = $_ENV['appDB']->query("SELECT idsDeviceAddresses.ip FROM idsDevices JOIN idsDeviceTypes ON (idsDevices.type = idsDeviceTypes.id) JOIN idsDeviceAddresses ON (idsDevices.id = idsDeviceAddresses.deviceID) WHERE idsDevices.type = '" . $row->id . "' GROUP BY idsDeviceAddresses.ip");
		while ($row2 = mysql_fetch_object($q2)) {

			$allAddressArray[] = $row2->ip;
			$addressArray[] = $row2->ip;
		
		}

		$q2 = $_ENV['appDB']->query("SELECT count(mas.id) AS cnt FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master as mas LEFT JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Events as evt USING (id) where mas.sensorID in (" . $_SESSION["user"]["sensors"] . ") AND evt.sip IN (" . implode(",", $addressArray) . ") $timeQuery");
		$result = mysql_fetch_object($q2);
		
		$row->eventSourceCount = $result->cnt;
		$eventSourceCount += $result->cnt;
		
		$eventCount += $result->cnt;
		
		$q2 = $_ENV['appDB']->query("SELECT count(mas.id) AS cnt FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master as mas LEFT JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Events as evt USING (id) where mas.sensorID in (" . $_SESSION["user"]["sensors"] . ") AND evt.dip IN (" . implode(",", $addressArray) . ") $timeQuery");
		$result = mysql_fetch_object($q2);
		
		$row->eventDestinationCount = $result->cnt;
		$eventDestinationCount += $result->cnt;

		$eventCount += $result->cnt;
	
		$data->deviceTypeArray[] = $row;
		
		unset($addressArray);
	
	}
	
		// do some percentage stats and add to array for display
		
		for ($i = 0; $i < count($data->deviceTypeArray); $i++) {
		
			$data->deviceTypeArray[$i]->sourcePercentage = @($data->deviceTypeArray[$i]->eventSourceCount / $eventSourceCount * 100);
			$data->deviceTypeArray[$i]->sourceTotalPercentage = @($data->deviceTypeArray[$i]->eventSourceCount / $datastoreEventTotal * 100);
	
			$data->deviceTypeArray[$i]->destinationPercentage = @($data->deviceTypeArray[$i]->eventDestinationCount / $eventDestinationCount * 100);
			$data->deviceTypeArray[$i]->destinationTotalPercentage = @($data->deviceTypeArray[$i]->eventDestinationCount / $datastoreEventTotal * 100);
		
		}

	$data->datastoreEventTotal = $datastoreEventTotal;
	
	$data->totalEventCount = $eventCount;
	$data->totalEventSourceCount = $eventSourceCount;
	$data->totalEventDestinationCount = $eventDestinationCount;

	// Reset values for device run

	$eventSourceCount = 0;
	$eventDestinationCount = 0;

	// Devices

	$q = $_ENV['appDB']->query("SELECT idsDevices.*, idsDeviceTypes.name AS typeName FROM idsDevices JOIN idsDeviceTypes ON (idsDevices.type = idsDeviceTypes.id) ORDER BY idsDeviceTypes.name");
	while ($row = mysql_fetch_object($q)) {

		$q2 = $_ENV['appDB']->query("SELECT idsDeviceAddresses.ip FROM idsDevices JOIN idsDeviceTypes ON (idsDevices.type = idsDeviceTypes.id) JOIN idsDeviceAddresses ON (idsDevices.id = idsDeviceAddresses.deviceID) WHERE idsDevices.id = '" . $row->id . "'");
		while ($row2 = mysql_fetch_object($q2)) {

			$addressArray[] = $row2->ip;
		
		}

		$q2 = $_ENV['appDB']->query("SELECT count(mas.id) AS cnt FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master as mas LEFT JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Events as evt USING (id) where mas.sensorID in (" . $_SESSION["user"]["sensors"] . ") AND evt.sip IN (" . implode(",", $addressArray) . ") $timeQuery");
		$result = mysql_fetch_object($q2);
		
		$row->eventSourceCount = $result->cnt;
		$eventSourceCount += $result->cnt;
		
		$q2 = $_ENV['appDB']->query("SELECT count(mas.id) AS cnt FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master as mas LEFT JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Events as evt USING (id) where mas.sensorID in (" . $_SESSION["user"]["sensors"] . ") AND evt.dip IN (" . implode(",", $addressArray) . ") $timeQuery");
		$result = mysql_fetch_object($q2);
		
		$row->eventDestinationCount = $result->cnt;
		$eventDestinationCount += $result->cnt;

		$q2 = $_ENV['appDB']->query("SELECT evt.sip, idsDeviceAddresses.name AS addressName, COUNT(evt.priority) AS total,
	    SUM(CASE evt.priority WHEN '1' THEN 1 ELSE 0 END) as pri1,
	    SUM(CASE evt.priority WHEN '2' THEN 1 ELSE 0 END) as pri2,
	    SUM(CASE evt.priority WHEN '3' THEN 1 ELSE 0 END) as pri3,
	    SUM(CASE evt.priority WHEN '4' THEN 1 ELSE 0 END) as pri4,
	    SUM(CASE evt.priority WHEN '5' THEN 1 ELSE 0 END) as pri5
		FROM idsDataStore_" . login("activeSearchStore") . "_Master AS mas JOIN idsDataStore_" . login("activeSearchStore") . "_Events as evt ON (mas.id = evt.id) JOIN idsDeviceAddresses ON (evt.sip = idsDeviceAddresses.ip)
		WHERE mas.sensorID IN (" . login("sensors") . ") AND evt.sip IN (" . implode(",", $addressArray) . ") GROUP BY evt.sip");
		while ($row2 = mysql_fetch_object($q2)) {

			$row->sourceRiskArray[] = $row2;

		}

		$q2 = $_ENV['appDB']->query("SELECT evt.dip, idsDeviceAddresses.name AS addressName, COUNT(evt.priority) AS total,
	    SUM(CASE evt.priority WHEN '1' THEN 1 ELSE 0 END) as pri1,
	    SUM(CASE evt.priority WHEN '2' THEN 1 ELSE 0 END) as pri2,
	    SUM(CASE evt.priority WHEN '3' THEN 1 ELSE 0 END) as pri3,
	    SUM(CASE evt.priority WHEN '4' THEN 1 ELSE 0 END) as pri4,
	    SUM(CASE evt.priority WHEN '5' THEN 1 ELSE 0 END) as pri5
		FROM idsDataStore_" . login("activeSearchStore") . "_Master AS mas JOIN idsDataStore_" . login("activeSearchStore") . "_Events as evt ON (mas.id = evt.id) JOIN idsDeviceAddresses ON (evt.dip = idsDeviceAddresses.ip)
		WHERE mas.sensorID IN (" . login("sensors") . ") AND evt.dip IN (" . implode(",", $addressArray) . ") GROUP BY evt.dip");
		while ($row2 = mysql_fetch_object($q2)) {

			$row->destinationRiskArray[] = $row2;

		}
	
		$data->deviceArray[] = $row;

		unset($addressArray);

	}

		// do some percentage stats and add to array for display
		
		for ($i = 0; $i < count($data->deviceArray); $i++) {
		
			$data->deviceArray[$i]->sourcePercentage = @($data->deviceArray[$i]->eventSourceCount / $eventSourceCount * 100);
			$data->deviceArray[$i]->sourceTotalPercentage = @($data->deviceArray[$i]->eventSourceCount / $datastoreEventTotal * 100);
	
			$data->deviceArray[$i]->destinationPercentage = @($data->deviceArray[$i]->eventDestinationCount / $eventDestinationCount * 100);
			$data->deviceArray[$i]->destinationTotalPercentage = @($data->deviceArray[$i]->eventDestinationCount / $datastoreEventTotal * 100);
		
		}




	// Timeline
	
//	$data->chart = eventTimelineJSDataByDevice_fromEventsTable($allAddressArray);

	return $data;
	
}

function eventTimelineJSDataByDevice_fromEventsTable($ipArray) {

	$jsObject = array();

	$query = "SELECT evt.sip, COUNT(evt.priority) AS total,
    SUM(CASE evt.priority WHEN '1' THEN 1 ELSE 0 END) as pri1,
    SUM(CASE evt.priority WHEN '2' THEN 1 ELSE 0 END) as pri2,
    SUM(CASE evt.priority WHEN '3' THEN 1 ELSE 0 END) as pri3,
    SUM(CASE evt.priority WHEN '4' THEN 1 ELSE 0 END) as pri4,
    SUM(CASE evt.priority WHEN '5' THEN 1 ELSE 0 END) as pri5
	FROM idsDataStore_" . login("activeSearchStore") . "_Master AS mas JOIN idsDataStore_" . login("activeSearchStore") . "_Events as evt ON (mas.id = evt.id) WHERE mas.sensorID IN (" . login("sensors") . ") AND evt.sip IN (" . implode(",", $ipArray) . ") GROUP BY evt.sip";

	echo $query;





	$cnt = 0;

	$q = $_ENV['appDB']->query($query);
	
	$numRows = mysql_num_rows($q);
	
	if ($numRows > 750) {
	
		$div = round($numRows / 750);
		
	} else {
	
		$div = 1;
	
	}	
	
	while ($row = @mysql_fetch_assoc($q)) {
	
		if ($cnt == 0) {
		
			$jsObject[] = "{t: " . "new Date('" . date("m/d/Y H:i:s", $row['timestamp']) . "')" . ", e: " . $row['timestamp'] . ", c: " . $row['total'] . ", pri1: " . $row['pri1'] . ", pri2: " . $row['pri2'] . ", pri3: " . $row['pri3'] . ", pri4: " . $row['pri4'] . ", pri5: " . $row['pri5'] . "}";
		
		}
		
		$cnt++;
		
		if ($cnt >= $div) $cnt = 0;
	
	}
	
	return "var chartData = [" . implode(",", $jsObject) . "]";

}

?>