<?php

function pub_checkMessages() {

	$_ENV['templateData'] = messageData();

	$_ENV['template'] = "template_smt.php";

}

function pub_getConf() {

	$_ENV['templateData'] = getConf();

	$_ENV['template'] = "template_smt.php";

}

function pub_getRules() {

	$_ENV['templateData'] = getRules();

	$_ENV['template'] = "template_smt.php";

}

function pub_getRule() {

	$_ENV['templateData'] = getRule();

	$_ENV['template'] = "template_smt.php";

}

function pub_SMTUpdate() {

	$_ENV['templateData'] = SMTUpdate();

	$_ENV['template'] = "template_smt.php";

}

function messageData() {

	// Returns the next waiting message in order

    $id = sanitize("id");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
			commonOperations($id);
    		
    		heartbeatUpdate($id);
    		
    		$out = sensorMessage($id);
    		
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;
	
}

function pub_snortStatus() {

	// Updates status of snort process from smt

    $id = sanitize("id");
    $data = sanitize("data");

    if (!$id) {
    
    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
			commonOperations($id);
    		
    		heartbeatUpdate($id);
    	
			if ($data == 1) {
			
				$_ENV['appDB']->query("update idsSensor set status = '1', lastStatusCheck = '" . time() . "', countStatusFailure = '0' where smtid = '$id'");
				
			} else {
			
				$_ENV['appDB']->query("update idsSensor set status = '0', lastStatusCheck = '" . time() . "', countStatusFailure = (countStatusFailure + 1) where smtid = '$id'");
				
			}

    	}
    
    }

	if (!$out) $out = 1;

	$_ENV['templateData'] = $out;

	$_ENV['template'] = "template_smt.php";
	
}

function pub_sensorUptime() {

	// Receives uptime from smt

    $id = sanitize("id");
    $data = sanitize("data");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
    	}
    	
    }

	if (!$out) $out = 1;

	$_ENV['templateData'] = $out;

	$_ENV['template'] = "template_smt.php";

}

function pub_sendConf() {

	// Receives and saves snort conf from smt

    $id = sanitize("id");
    $file = sanitize("file");
    $data = getVar("data");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
	        if ($fp = @fopen("smt/sensorData/$id/$file", "w")) {
	
	        	fputs ($fp, urlBase64_decode($data));
	
	            fclose($fp);
	
				$_ENV['appDB']->query("update idsSensor set confFile = '$file' where smtid = '$id'");
				
	        } else {
	        
				$_ENV['appLog']->log('ERROR', "File: 'smt/sensorData/$id/$file' could not be opened for writing");
	        
	        }
    		
    	}
    	
    }

	if (!$out) $out = 1;

	$_ENV['templateData'] = $out;

	$_ENV['template'] = "template_smt.php";
	
}

function getConf() {

	// Sends snort conf to smt

    $id = sanitize("id");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
	        $idsQueryA = $_ENV['appDB']->query("select confFile from idsSensor where smtid = '$id'");
			for ($i = 0; $row = mysql_fetch_row($idsQueryA); $i++) {
				$confFile = $row[0];
			}
	    	
	        $data = @file_get_contents("smt/sensorData/$id/$confFile");
	        
	        if ($data) {
	        
		        $out = urlBase64_encode($data);
		        
	        } else {
	        
	        	$out = 0;
	        	
	        }
    		
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;

}

function pub_sendRule() {

	// Receives and saves snort rule from smt

    $id = sanitize("id");
    $file = sanitize("file");
    $data = getVar("data");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
			if (!file_exists("smt/snortRules/smt-$id")) {
				@mkdir("smt/snortRules/smt-$id");
				@mkdir("smt/snortRules/smt-$id/rules");
			}
	
			// Write snort rules to package directory
	        if ($fp = @fopen("smt/snortRules/smt-$id/rules/$file", "w")) {
	
	        	fputs ($fp, urlBase64_decode($data));
	
	        	// Close file handle
	            fclose($fp);
	            
	        } else {
	        
				$_ENV['appLog']->log('ERROR', "File: 'smt/snortRules/smt-$id/rules/$file' could not be opened for writing");
	        
	        }
	
			// Create and store policy file
			
			$ruleFile = @file("smt/snortRules/smt-$id/rules/$file");
			
			foreach ($ruleFile as $line) {
			
				unset($array, $sid, $gid, $rev, $foundSignature, $newSignatureID, $disabled);
			
				if (strstr($line, "alert") && strstr($line, "sid:")) {

					# Signature line

					$line = trim($line);

					// Check if rule is disabled					
					if (strstr(substr($line, 0, 3), "#")) {
					
						$disabled = true;
						
					}
					
					if (strstr(substr($line, 0, 1), "#")) $line = substr($line, 1);
					$line = trim($line);
		
					preg_match("/sid:\s*[0-9]+/", $line, $match);
					$sid = trim(str_replace("sid:", "", $match[0]));
		
					preg_match("/gid:\s*[0-9]+/", $line, $match);
					$gid = trim(str_replace("gid:", "", $match[0]));
					if (!$gid) $gid = 1;

					preg_match("/rev:\s*[0-9]+/", $line, $match);
					$rev = trim(str_replace("rev:", "", $match[0]));
					if (!$rev) $rev = 1;

					preg_match("/classtype:\s?([^;]*);/", $line, $match);
					$class = trim(str_replace("classtype:", "", $match[0]));
					$class = str_replace(";", "", $class);
					$class = addslashes($class);
				
					preg_match("/msg:\s?\"([^\"]*)\"/", $line, $match);
					$msg = trim(str_replace("msg:", "", $match[0]));
					$msg = str_replace("\"", "", $msg);
					$msg = addslashes($msg);
					
					$data = addslashes($line);
				
	   	 			$idsQueryA = $_ENV['appDB']->query("SELECT * from idsSignatures WHERE sid = '$sid' AND gid = '$gid' ORDER BY rev DESC LIMIT 1");
					while ($row = mysql_fetch_assoc($idsQueryA)) {
		
						# Found existing signature
						
						$foundSignature = true;
						
						// If revision is greater, we'll insert into db and update policies if applicable						
						
						if ($rev > $row["rev"]) {
						
							// New revision of signature available

							// Insert
															
			   	 			$idsQueryA = $_ENV['appDB']->query("INSERT INTO idsSignatures (sid, gid, rev, msg, class, file, source, data, intime) VALUES ('$sid', '$gid', '$rev', '$msg', '$class', '$file', '$source', '$data', '" . time() . "')");

							$newSignatureID = mysql_insert_id();
							
							// Update any matching id's in the policy index

							if (ops("site_policyRevisionUpdate") == 1) {

				   	 			$_ENV['appDB']->query("UPDATE idsSignaturePolicyIndex SET sid = '$newSignatureID' WHERE sid = '" . $row["id"] . "'");
				   	 			
				   	 			$update_count++;
				   	 			
				   	 		}

							// Delete existing signature
							
							if (ops("site_signatureRevisionReplace") == 1) {

				   	 			$_ENV['appDB']->query("DELETE FROM idsSignatures WHERE id = '" . $row["id"] . "'");

				   	 			$delete_count++;

							}								

#								echo "INSERT REVISION: $file - SID:$sid GID:$gid REV:$rev CLASS:$class\n";

							$revision_count++;
							
			   	 			$rev_array[] = $newSignatureID;
							
							if (!$disabled) {
							
								// Signature ID array for policy index
								$sigPolicy_array[] = $newSignatureID;
								
							}
							
						} else {

#								echo "SKIPPING: $file - SID:$sid GID:$gid REV:$rev CLASS:$class\n";

							$skip_count++;
						
							if (!$disabled) {
							
								// Signature ID array for policy index
								$sigPolicy_array[] = $row["id"];
								
							}
							
						}

					}
					
					if (!$foundSignature) {
					
						// Signature not found in database
						
		   	 			$_ENV['appDB']->query("INSERT INTO idsSignatures (sid, gid, rev, msg, class, file, source, data, intime) VALUES ('$sid', '$gid', '$rev', '$msg', '$class', '$file', '$source', '$data', '" . time() . "')");
						
						$newSignatureID = mysql_insert_id();
						
#							echo "INSERT: $file - SID:$sid GID:$gid REV:$rev CLASS:$class\n";
						
						$insert_count++;
						
		   	 			$insert_array[] = $newSignatureID;
						
						if (!$disabled) {

							// Signature ID array for policy index
							$sigPolicy_array[] = $newSignatureID;
							
						}
						
					}
					
			
				} else {
				
					# Not a signature line
				
				}

			}			
		    		
    	}
    	
    	if ($sigPolicy_array) {
    	
	        $idsQueryA = $_ENV['appDB']->query("SELECT id, confPolicy FROM idsSensor WHERE smtid = '$id'");
			while ($row = mysql_fetch_assoc($idsQueryA)) {
			
				// Policy found
			
				if ($row["confPolicy"] > 0) {
	
					$policyFound = $row["confPolicy"];

				}
			
			}
			
			if ($policyFound) {

				// Insert signatures into policy
				
				foreach ($sigPolicy_array as $sig) {
					
					$_ENV['appDB']->query("INSERT INTO idsSignaturePolicyIndex (pid, sid) VALUES ('" . $policyFound . "', '$sig')");
				
				}
			
			} else {

				// Create new policy for this sensor

				$_ENV['appDB']->query("INSERT INTO idsSensorPolicy (name) VALUES ('SMT Policy - $id')");
			
				$newPolicyID = mysql_insert_id();
				
				$_ENV['appDB']->query("UPDATE idsSensor SET confPolicy = '$newPolicyID' WHERE smtid = '$id'");
				
				foreach ($sigPolicy_array as $sig) {
					
					$_ENV['appDB']->query("INSERT INTO idsSignaturePolicyIndex (pid, sid) VALUES ('" . $newPolicyID . "', '$sig')");
				
				}
				
			}
    	
    	}
    	
    }

	if (!$out) $out = 1;

	$_ENV['templateData'] = $out;

	$_ENV['template'] = "template_smt.php";

}

function getRules() {

	// Sends list of rule files to smt

    $id = sanitize("id");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
	        $q = $_ENV['appDB']->query("SELECT confFile, confPolicy FROM idsSensor WHERE smtid = '$id'");
			while ($row = mysql_fetch_assoc($q)) {
			
				$confFile = $row["confFile"];
				$policy = $row["confPolicy"];
				
			}    	
	    	
	        if ($rulesDir = @dir("smt/policyData/$policy/")) {

		        while ($file = $rulesDir->read()) {
		            if ($file != "." && $file != ".." && $file != "readme.txt" && $file != "$confFile") {
		            
		                $out .= "$file\n";
		                
		            }
		        }

	        } else {
	        
	        	$out = 0;
	        
	        }
	        
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;

}

function getRule() {

	// Sends rule file to smt

    $id = sanitize("id");
    $rule = sanitize("rule");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
    		$policy = getPolicyBySMTID($id);
    		
	        $data = file_get_contents("smt/policyData/$policy/$rule");
	        
	        $out = urlBase64_encode($data);
    		
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;
	
}

function SMTUpdate() {

	// Sends smt.php to smt

    $id = sanitize("id");
    $rule = sanitize("rule");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
	        $data = file_get_contents("contrib/smt/smt.php");
	        
	        $out = urlBase64_encode($data);
    		
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;

}

?>