<?php

function prv_snortConfiguration() {

	// Build renderers

	$_ENV['templateRenderer'] = displayAllSnortAanvalSensors();
	$_ENV['templateRenderer'] .= displayAllSnortSensors();
			
	// Get details

	$_ENV['templateData'] = snortSensorDetailsBySID(sanitize("sid"));

	// Template

	$_ENV['contentTitle'] = "Snort Configuration";

	$_ENV['template'] = "template_snortConfiguration.php";

}

function prv_snortSensorPermissionsUpdate() {

	$id = sanitize("id");
	$sid = sanitize("sid");

	toggleSensorForUser($sid, $id);

	// Get snort sid by id for return to snort configuration page
	
	$snortSID = getSnortSIDByID($sid);

    // Redirect

    $_ENV['redirect'] = array("prv_snortConfiguration&sid=$snortSID", DEFAULT_REDIRECT_TIMEOUT);
	
    $_ENV['redirectMessage'] = "Updating Sensor Permissions";
		
    $_ENV['template'] = "template_redirectGeneral.php";

}

function displayAllSnortAanvalSensors() {
	
	// Load module
	
	$idsQueryA = $_ENV['appDB']->query("SELECT * FROM idsModules where id = '1'");
	$modArray = mysql_fetch_assoc($idsQueryA);

	$moduleDB = new moduleDB();
	$moduleDB->load($modArray);
	
	// Sensor list

	$q1 = $moduleDB->query("SELECT sid, hostname, interface, last_cid FROM sensor ORDER BY sid");
	
	if ($q1) {
	
		while ($row1 = mysql_fetch_assoc($q1)) {
	
			$q2 = $_ENV['appDB']->query("SELECT id, name, enabled, location, description, os, timezone, lastEvent, smtid, intime, type FROM idsSensor WHERE module = 1 AND sid = '" . $row1['sid'] . "'");
			
			if (mysql_num_rows($q2) > 0) {
			
				$row2 = mysql_fetch_assoc($q2);
	
				$sensorArray = array_merge($row1, $row2);
	
				if (!getVar("sid")) setVar("sid", $row1['sid']);
	
				$out .= itemRenderer('snortConfiguration', $sensorArray);	
				
			} else {
		
	//			$sensorArray = $row1;
			
			}
	
			
		}
		
	} else {
	
		$out = "No sensors available";
	
	}

	$moduleDB->close();	
	
	return $out;

}

function displayAllSnortSensors() {
	
	// Load module
	
	$idsQueryA = $_ENV['appDB']->query("SELECT * FROM idsModules where id = '1'");
	$modArray = mysql_fetch_assoc($idsQueryA);

	$moduleDB = new moduleDB();
	$moduleDB->load($modArray);
	
	// Sensor list

	$q1 = $moduleDB->query("SELECT sid, hostname, interface, last_cid FROM sensor ORDER BY sid");
	
	if ($q1) {
	
		while ($row1 = mysql_fetch_assoc($q1)) {
	
			$q2 = $_ENV['appDB']->query("SELECT id, name, enabled, location, description, os, timezone, lastEvent, smtid, intime, type FROM idsSensor WHERE module = 1 AND sid = '" . $row1['sid'] . "'");
			
			if (mysql_num_rows($q2) > 0) {
			
				$row2 = mysql_fetch_assoc($q2);
	
			} else {
		
				$sensorArray = $row1;
	
				if (!getVar("sid")) setVar("sid", $row1['sid']);
	
				$out .= itemRenderer('snortConfiguration', $sensorArray);	
			
			}
	
			
		}

	} else {
	
	}

	$moduleDB->close();	
	
	return $out;

}

function snortSensorDetailsByID($id) {
	
	$q = $_ENV['appDB']->query("SELECT * FROM idsSensor WHERE id = '$id' AND module = '1'");
	$result = mysql_fetch_object($q);
	
	$snortConfFile = "smt/sensorData/" . $result->smtid . "/" . $result->confFile;

	$result->lastStatusCheckDiff = time() - $result->lastStatusCheck;
	$result->lastHeartbeatDiff = time() - $result->hb;

	if (!file_exists($snortConfFile)) {

		// throw error log or warning
	
	} else {

		$result->snortConfData = file_get_contents($snortConfFile);
	
	}
	
	return $result;
	
}

function snortSensorDetailsBySID($sid) {
	
	$q = $_ENV['appDB']->query("SELECT * FROM idsSensor WHERE sid = '$sid' AND module = '1'");
	$result = mysql_fetch_object($q);
	
	$snortConfFile = "smt/sensorData/" . $result->smtid . "/" . $result->confFile;

	$result->lastStatusCheckDiff = time() - $result->lastStatusCheck;
	$result->lastHeartbeatDiff = time() - $result->hb;

	if (!file_exists($snortConfFile)) {

		// throw error log or warning
	
	} else {

		$result->snortConfData = file_get_contents($snortConfFile);
	
	}
	
	return $result;
	
}

function prv_snortConfigurationUpdate() {

	$id = sanitize("id");
	$sid = sanitize("sid");

	$enabled = sanitize("enabled");

	$name = sanitize("name");
	$description = sanitize("description");
	$location = sanitize("location");
	$os = sanitize("os");
	$smtid = sanitize("smtid");
	
	$timezone = sanitize("timezoneSelect");
	
	if ($enabled == 1) {

		// Enable sensor

		// check if sensor already enabled (if so, just update details)
		
		$q = $_ENV['appDB']->query("SELECT id FROM idsSensor WHERE sid = '$sid' AND module = 1 AND enabled = 1");
		if (mysql_num_rows($q) > 0) {

			$policy = 1;

			// Update sensor details

			$_ENV['appDB']->query("UPDATE idsSensor SET name = '$name', description = '$description', location = '$location', os = '$os', smtid = '$smtid', timezone = '$timezone' WHERE id = '$id'");

		} else {		

			$q = $_ENV['appDB']->query("SELECT count(id) AS cnt FROM idsSensor WHERE module = 1 AND enabled = 1");
			$row = mysql_fetch_array($q);
	
			if ((countUpperCaseArray("6")+countUpperCaseArray("7")+countUpperCaseArray("4")+countUpperCaseArray("5")+countUpperCaseArray("1")) == 0) { $useVar = 1; } else if (countUpperCaseArray("6") >= 1) { $useVar = time(); } else { $useVar = countUpperCaseArray("4")+countUpperCaseArray("1"); }
			if (($row["cnt"]+1) > $useVar) { $policy = 0; } else {
		
				$policy = 1;
			
				// Check if sid exists
				
				$q = $_ENV['appDB']->query("SELECT id FROM idsSensor WHERE sid = '$sid' AND module = 1");
				if (mysql_num_rows($q) > 0) {
				
					$_ENV['appDB']->query("UPDATE idsSensor SET enabled = '1' WHERE sid = '$sid' AND module = 1");
				
				} else {
				
					$_ENV['appDB']->query("INSERT INTO idsSensor (sid, name, enabled, module, smtid, timezone, intime) VALUES ('$sid', 'Not Configured', '1', '1', '', '62', '" . time() . "')");
				
					$id = mysql_insert_id();
				
				}
				
				// Update sensor details

				if(!$smtid) $smtid = time() . rand(100,999);

				$_ENV['appDB']->query("UPDATE idsSensor SET name = '$name', description = '$description', location = '$location', os = '$os', smtid = '$smtid', timezone = '$timezone' WHERE id = '$id'");
		
			}

		}

	} else {
	
		// Disable sensor
		
		$policy = 1;
		
		$_ENV['appDB']->query("UPDATE idsSensor SET enabled = '0' where id = '$id' AND module = '1'");
	
		removeSensorFromAllUsers($id);
	
		// Delete data from idsSensorManage table
		$idsQueryA = $_ENV['appDB']->query("DELETE FROM idsSensorManage where sid = '$id'");
	
	}
		
	if ($policy == 0) {
	
    	$_ENV['redirect'] = array("prv_snortConfiguration&sid=$sid", 5000);
		
	    $_ENV['redirectMessage'] = "Not enough licenses available";
	
	} else {
	
	    $_ENV['redirect'] = array("prv_snortConfiguration&sid=$sid", DEFAULT_REDIRECT_TIMEOUT);
	
	    $_ENV['redirectMessage'] = "Updating Sensor Details";
	
	}
		
    // Redirect

    $_ENV['template'] = "template_redirectGeneral.php";
		
}

function prv_snortTrackerReset() {

	$id = sanitize("id");
	$sid = sanitize("sid");

	$_ENV['appDB']->query("UPDATE idsSensor SET lastEvent = '" . time() . "' WHERE id = '$id'");

    // Redirect
	
   	$_ENV['redirect'] = array("prv_snortConfiguration&sid=$sid", DEFAULT_REDIRECT_TIMEOUT);
	
    $_ENV['redirectMessage'] = "Resetting Last Event Tracker";
	
    $_ENV['template'] = "template_redirectGeneral.php";
		
}

function prv_snortReimportData() {

	$id = sanitize("id");
	$sid = sanitize("sid");

	$_ENV['appDB']->query("UPDATE idsSensor SET lastEvent = 0 WHERE id = '$id'");

    // Redirect
	
   	$_ENV['redirect'] = array("prv_snortConfiguration&sid=$sid", DEFAULT_REDIRECT_TIMEOUT);
	
    $_ENV['redirectMessage'] = "Forcing Data Re-import";
	
    $_ENV['template'] = "template_redirectGeneral.php";
		
}

?>