<?php

function prv_status() {

	$_ENV['contentTitle'] = "Status";

	$_ENV['templateData'] = rawStatusData();

	$_ENV['template'] = "template_status.php";

}

function prv_statusSubmit() {

	$email = sanitize("email");
	$name = sanitize("name");
	$subject = sanitize("subject");
	$message = getVar("message");
	$ticketid = strtoupper(sanitize("ticketid"));

	$raw = getVar("raw");

	// If ticket id specified, add ticket id to subject
	
	if ($ticketid) $subject = $subject . " [Ticket ID: $ticketid]";

	// Send via email to support.group@aanval.com

	sendmailNow($email, $name, "support.group@aanval.com", "Support Group", $subject, $message . "\n\n----------\n\nConsole Status Details\n\n----------\n\n" . $raw);
		
    // Redirect

    $_ENV['redirect'] = array("prv_status", 5000);

    $_ENV['redirectMessage'] = "Submitting Status (you will be notified via email in ~5 minutes)";

    $_ENV['template'] = "template_redirectGeneral.php";
		
}

function rawStatusData() {

	$versionData = versionData();
	
	$out['versionData'] = $versionData->major . "." . $versionData->minor . " Build: " . $versionData->build;
	$out['phpModuleData'] = implode(", ", get_loaded_extensions());

	// License

	$q = $_ENV['appDB']->query("SELECT * FROM idsLicense ORDER BY id ASC");
	while ($row = mysql_fetch_assoc($q)) {
	
		$out['licenseData'] .= $row['license'] . " (" . strtoupper(upperCaseArray($row['license'])) . ") [" . upperCaseString($row['license']) . "]" . "\n";
	
	}

	// Aanval sensor

	$q = $_ENV['appDB']->query("SELECT * FROM idsSensor ORDER BY id DESC");
	while ($row = mysql_fetch_assoc($q)) {
	
		$out['sensorData'] .= "ID: " . $row['id'] . "\n";
		$out['sensorData'] .= "SID: " . $row['sid'] . "\n";
		$out['sensorData'] .= "Module: " . $row['module'] . "\n";
		$out['sensorData'] .= "Enabled: " . $row['enabled'] . "\n";
		$out['sensorData'] .= "Last Event: " . date(ops("site_timeDateFormat"), consoleTimeConversion($row['lastEvent'])) . "\n";
		$out['sensorData'] .= "Last Heartbeat: " . date(ops("site_timeDateFormat"), consoleTimeConversion($row['hb'])) . " (Count: " . $row['hbcount'] . ")\n";
		$out['sensorData'] .= "Location: " . $row['location'] . "\n";
	
	}
	
	// Snort sensor
	
	$idsQueryA = $_ENV['appDB']->query("SELECT * FROM idsModules where id = '1'");
	$modArray = mysql_fetch_assoc($idsQueryA);

	$moduleDB = new moduleDB();
	$moduleDB->load($modArray);
	
	$q = $moduleDB->query("SELECT sid, interface, last_cid FROM sensor ORDER BY sid");
	while ($row = mysql_fetch_assoc($q)) {
	
		$out['snortData'] .= "SID: " . $row['sid'] . "\n";
		$out['snortData'] .= "Interface: " . $row['interface'] . "\n";
		$out['snortData'] .= "Last CID: " . $row['last_cid'] . "\n";
		
		$p = $moduleDB->query("SELECT timestamp FROM event WHERE sid = '" . $row['sid'] . "' ORDER BY timestamp DESC LIMIT 1");
		$result = mysql_fetch_assoc($p);

		$out['snortData'] .= "Last Timestamp: " . $result['timestamp'] . "\n";
		
	}
	
	// BPU
	
	$tmp = bpuStatus();
	
	$out['bpuData'] .= $tmp[0]['file'] . " " . $tmp[0]['status'] . "\n";
	$out['bpuData'] .= $tmp[1]['file'] . " " . $tmp[1]['status'] . "\n";
	$out['bpuData'] .= $tmp[2]['file'] . " " . $tmp[2]['status'] . "\n";
	
	// Tables
	
	$q = $_ENV['appDB']->query("SHOW TABLES");
	while ($row1 = mysql_fetch_row($q)) {

		if (stristr($row1[0], 'idsdatastore_')) {		

			$out['tableData'] .= $row1[0] . "\n";

		} else {

			$p = $_ENV['appDB']->query("SELECT COUNT(*) AS cnt FROM " . $row1[0]);
			$result = mysql_fetch_assoc($p);
	
			$out['tableData'] .= $row1[0] . " : " . $result['cnt'] . "\n";
			
		}
	
	}
	
	// Ops
	
	$q = $_ENV['appDB']->query("SELECT var, val FROM idsOps ORDER BY var ASC");
	while ($row = mysql_fetch_assoc($q)) {
	
		$out['opsData'] .= $row['var'] . " : " . $row['val'] . "\n";
	
	}
	
	// Defaults
	if (!$out['licenseData']) $out['licenseData'] = "No licenses installed";
	if (!$out['sensorData']) $out['sensorData'] = "No sensors listed";
	if (!$out['snortData']) $out['snortData'] = "No sensors listed";
	
	return arrayToObject($out);
	
}

?>