<?php

function prv_syslogConfiguration() {

	$_ENV['templateRenderer'] = displayAllSyslogSensors();

	$_ENV['templateData'] = syslogSensorDetails(sanitize("id"));

	$_ENV['contentTitle'] = "Syslog Configuration";

	$_ENV['template'] = "template_syslogConfiguration.php";

}

function prv_syslogSensorPermissionsUpdate() {

	$id = sanitize("id");
	$sid = sanitize("sid");

	toggleSensorForUser($sid, $id);

    // Redirect

    $_ENV['redirect'] = array("prv_syslogConfiguration&id=$sid", DEFAULT_REDIRECT_TIMEOUT);
	
    $_ENV['redirectMessage'] = "Updating Sensor Permissions";
		
    $_ENV['template'] = "template_redirectGeneral.php";

}

function displayAllSyslogSensors() {
		
	// Sensor list

	$q = $_ENV['appDB']->query("SELECT idsSensor.id, idsSensor.sid, idsSensor.name, idsSensor.enabled, idsSensor.location, idsSensor.description, idsSensor.os, idsSensor.timezone, idsSensor.lastEvent, idsSensor.intime, idsSyslogModule.type FROM idsSensor JOIN idsSyslogModule ON (idsSensor.sid = idsSyslogModule.id) WHERE module = '2'");
	while ($row = mysql_fetch_assoc($q)) {

		if (!getVar("id")) setVar("id", $row['id']);

		$out .= itemRenderer('syslogConfiguration', $row);
		
	}
	
	return $out;

}

function syslogSensorDetails($id) {
	
	$q = $_ENV['appDB']->query("SELECT idsSensor.id, idsSensor.sid, idsSensor.name, idsSensor.enabled, idsSensor.location, idsSensor.path, idsSensor.description, idsSensor.os, idsSensor.timezone, idsSensor.lastEvent, idsSensor.intime, idsSyslogModule.type FROM idsSensor JOIN idsSyslogModule ON (idsSensor.sid = idsSyslogModule.id) WHERE idsSensor.id = '$id' AND idsSensor.module = '2'");
	
	return arrayToObject(mysql_fetch_assoc($q));
	
}

function prv_syslogSensorCreate() {

	$source = sanitize("source");
	if (!$source) $source = "/not/configured";
	
	$_ENV['appDB']->query("insert into idsSyslogModule (source, type) values ('$source', '2')");

	$last = mysql_insert_id();

	$_ENV['appDB']->query("insert into idsSensor (sid, name, enabled, module, path, timezone, intime) values ('$last', 'Not Configured', '0', '2', '$source', '62', '" . time() . "')");

	$last = mysql_insert_id();

    // Redirect

    $_ENV['redirect'] = array("prv_syslogConfiguration&id=$last", DEFAULT_REDIRECT_TIMEOUT);
	
    $_ENV['redirectMessage'] = "Creating Syslog Sensor";
		
    $_ENV['template'] = "template_redirectGeneral.php";

}

function prv_syslogSensorDelete() {

	$sid = sanitize("sid");
	if (!$sid) $sid = 0;

	$idsQueryA = $_ENV['appDB']->query("SELECT * FROM idsSensor where sid = '$sid'");
	while ($row = mysql_fetch_assoc($idsQueryA)) {

		removeSensorFromAllUsers($row["id"]);
		
	}
	
	$_ENV['appDB']->query("DELETE FROM idsSensor WHERE sid = '$sid' AND module = '2'");
	$_ENV['appDB']->query("DELETE FROM idsSyslogModule WHERE id = '$sid'");

    // Redirect

    $_ENV['redirect'] = array("prv_syslogConfiguration", DEFAULT_REDIRECT_TIMEOUT);
	
    $_ENV['redirectMessage'] = "Deleting Syslog Sensor";
		
    $_ENV['template'] = "template_redirectGeneral.php";

}

function prv_syslogConfigurationUpdate() {

	$id = sanitize("id");

	$name = sanitize("name");
	$description = sanitize("description");
	$location = sanitize("location");
	$os = sanitize("os");
	$path = sanitize("path");
	$enabled = sanitize("enabled");

	$timezone = sanitize("timezoneSelect");

	// Update sensor details

	$_ENV['appDB']->query("update idsSensor set name = '$name', description = '$description', location = '$location', os = '$os', path = '$path', timezone = '$timezone' where id = '$id'");

	if ($enabled == 1) {

		// Enable sensor

		// check if sensor already enabled (if so, do nothing)
		
		$q = $_ENV['appDB']->query("SELECT id FROM idsSensor where id = '$id' and module = 2 and enabled = 1");
		if (mysql_num_rows($q) > 0) {

			$policy = 1;

		} else {		

			$q = $_ENV['appDB']->query("SELECT count(id) as cnt FROM idsSensor where module = 2 and enabled = 1");
			$row = mysql_fetch_array($q);
			
			if ((countUpperCaseArray("6")+countUpperCaseArray("7")+countUpperCaseArray("4")+countUpperCaseArray("5")+countUpperCaseArray("1")) == 0) { $useVar = 1; } else if (countUpperCaseArray("7") >= 1) { $useVar = time(); } else { $useVar = countUpperCaseArray("5")+countUpperCaseArray("1"); }

			if (($row["cnt"]+1) > $useVar) { $policy = 0; } else {
			
				$policy = 1;
							
				$_ENV['appDB']->query("update idsSensor set enabled = '1' where id = '$id' and module = 2");
				
			}

		}

	} else {
	
		// Disable sensor
		
		$policy = 1;
		
		$_ENV['appDB']->query("update idsSensor set enabled = '0' where id = '$id' and module = '2'");

		removeSensorFromAllUsers($id);
		
	}
		
	if ($policy == 0) {
	
    	$_ENV['redirect'] = array("prv_syslogConfiguration&id=$id", 5000);
		
	    $_ENV['redirectMessage'] = "Not enough licenses available";
	
	} else {
	
	    $_ENV['redirect'] = array("prv_syslogConfiguration&id=$id", DEFAULT_REDIRECT_TIMEOUT);
	
	    $_ENV['redirectMessage'] = "Updating Sensor Details";
	
	}
		
    // Redirect

    $_ENV['template'] = "template_redirectGeneral.php";
		
}

?>