<script type="text/javascript">
    var chart;

	<?php 
	
		echo $_ENV['contentData']->chart . ";";
	
	?>

    AmCharts.ready(function () {

        // SERIAL CHART
        chart = new AmCharts.AmSerialChart();
        chart.pathToImages = "console/assets/js/images/";
        chart.zoomOutButton = {
            backgroundColor: '#000000',
            backgroundAlpha: 0.15
        };
        chart.dataProvider = chartData;
        chart.categoryField = "t";

        // data updated event will be fired when chart is first displayed,
        // also when data will be updated. We'll use it to set some
        // initial zoom
        chart.addListener("dataUpdated", zoomChart);

        // AXES
        // Category
        var categoryAxis = chart.categoryAxis;
        categoryAxis.parseDates = true; // in order char to understand dates, we should set parseDates to true
        categoryAxis.minPeriod = "ss"; // as we have data with minute interval, we have to set "mm" here.			 
        categoryAxis.gridAlpha = 0.07;
        categoryAxis.axisColor = "#DADADA";

        // Value
        var valueAxis = new AmCharts.ValueAxis();
        valueAxis.gridAlpha = 0.07;
        valueAxis.title = "Results Timeline";
        chart.addValueAxis(valueAxis);

        // GRAPH
        var graph = new AmCharts.AmGraph();
        graph.type = "line"; // try to change it to "column"
        graph.title = "Results Timeline";
        graph.valueField = "c";
        graph.connect = false;
        graph.lineAlpha = 1;
        graph.lineColor = "#BEDE83";
        graph.fillAlphas = 0.3; // setting fillAlphas to > 0 value makes it area graph
        graph.bullet = "square";
        graph.bulletAlpha = 0;
        graph.bulletSize = 7;
        graph.bulletBorderSize = 10;
        graph.bulletBorderAlpha = 10;
        
        chart.addGraph(graph);

        // CURSOR
        var chartCursor = new AmCharts.ChartCursor();
        chartCursor.cursorAlpha = 1;
        chartCursor.cursorColor = "#B9D97E";
        chartCursor.color = "#000000";
        chartCursor.cursorPosition = "mouse";
        chartCursor.categoryBalloonDateFormat = "MMMM DD JJ:NN:SS";
        chart.addChartCursor(chartCursor);

        // SCROLLBAR
        var chartScrollbar = new AmCharts.ChartScrollbar();
		chartScrollbar.graph = graph;
		chartScrollbar.autoGridCount = true;
		chartScrollbar.scrollbarHeight = 25;
        chart.addChartScrollbar(chartScrollbar);

        // WRITE
        chart.write("chartdiv");
    });

    // this method is called when chart is first inited as we listen for "dataUpdated" event
    function zoomChart() {
        // different zoom methods can be used - zoomToIndexes, zoomToDates, zoomToCategoryValues
        chart.zoomToIndexes(chartData.length - 40, chartData.length - 1);
    }
    
    function handleClick(event){
    
        var graphDataItem = event.item;
        
		window.location = '?op=prv_eventSearch&query=imported:' + graphDataItem.dataContext.e;

    }
    
</script>

<table width="100%" style="height: 100%;">

	<tr>	
		
		<td valign="top">		
		
			<table width="100%">
			
				<tr>
				
					<td valign="top" align="left">
					
						<p>Search Results: "<?php echo $_ENV['contentData']->query; ?>"</p>
					
					</td>
					
					<td valign="middle" align="right">
					
					<p style="font-size: 0.8em;"><a href="?op=prv_eventSearch&query=<?php echo $_ENV['contentData']->query; ?> report:">Generate a report from these results</a></p>
					
					</td>
				
				</tr>
			
			</table>
			
			<br>
			<hr>
			<br>
		
		</td>
	
	</tr>

	<tr>
	
		<td valign="top">

			<table width="100%">
			
				<tr>
				
					<td valign="top" align="left">

						<?php
						
							if ($_ENV['contentData']->totalResults > 0) {
						
								echo pagingComponent(floor($_ENV['contentData']->totalResults / 25)+1, $_ENV['contentData']->page);
								
							}
						
						?>
						
					</td>

					<td valign="top" align="right">

						<?php
						
							if ($_ENV['contentData']->totalResults > 0) {
						
								echo number_format($_ENV['contentData']->totalResults) . " results in " . (floor($_ENV['contentData']->totalResults / 25)+1) . " pages";
								
							} else {
							
								echo "0 results found";
							
							}
						
						?>
					
					</td>
					
				</tr>
				
			</table>
			
			<br>

		</td>			
	
	</tr>
	
	<tr style="height: 100%;">
	
		<td valign="top">

			<div id="searchResults" style="overflow-y: scroll; height: 100%; padding-right: 10px;">
			
				<?php
				
					echo returnEventHTML($_ENV['contentData']->transaction, $_ENV['contentData']->page);
				
				?>

			</div>

		</td>
	
	</tr>
	
	<tr>
	
		<td valign="top">

			<div id="chartdiv" style="width:100%; height:200px;"></div>		
			
		</td>
	
	</tr>

</table>