<script type="text/javascript">
var chart;

<?php 

	echo $_ENV['templateData']->chart;

?>

AmCharts.ready(function () {

	// SERIAL CHART
    chart = new AmCharts.AmSerialChart();
    chart.pathToImages = "console/assets/js/images/";
    chart.zoomOutButton = {
        backgroundColor: '#000000',
        backgroundAlpha: 0.15
    };
    chart.dataProvider = chartData;
    chart.categoryField = "t";

    // data updated event will be fired when chart is first displayed,
    // also when data will be updated. We'll use it to set some
    // initial zoom
    chart.addListener("dataUpdated", zoomChart);

    // AXES
    // Category
    var categoryAxis = chart.categoryAxis;
    categoryAxis.parseDates = true; // in order char to understand dates, we should set parseDates to true
    categoryAxis.minPeriod = "ss"; // as we have data with minute interval, we have to set "mm" here.			 
    categoryAxis.gridAlpha = 0.07;
    categoryAxis.axisColor = "#DADADA";

    // Value
    var valueAxis = new AmCharts.ValueAxis();
    valueAxis.gridAlpha = 0.07;
    valueAxis.title = "Event Timeline";
    chart.addValueAxis(valueAxis);

    // GRAPH
    var graph = new AmCharts.AmGraph();
    graph.type = "line"; // try to change it to "column"
    graph.title = "Total Events";
    graph.valueField = "c";
    graph.connect = false;
    graph.lineAlpha = 1;
    graph.lineColor = "#d1cf2a";
    graph.fillAlphas = 0; // setting fillAlphas to > 0 value makes it area graph
    graph.bullet = "square";
    graph.bulletAlpha = 0;
    graph.bulletSize = 7;
    graph.bulletBorderSize = 10;
    graph.bulletBorderAlpha = 10;
    chart.addGraph(graph);

    // GRAPH 1
    var graph1 = new AmCharts.AmGraph();
    graph1.type = "line"; // try to change it to "column"
    graph1.title = "Risk Level 1";
    graph1.valueField = "pri1";
    graph1.connect = false;
    graph1.lineAlpha = 1;
    graph1.lineColor = "#D80000";
    graph1.fillAlphas = 0.3; // setting fillAlphas to > 0 value makes it area graph
    graph1.bullet = "square";
    graph1.bulletAlpha = 0;
    graph1.bulletSize = 7;
    graph1.bulletBorderSize = 10;
    graph1.bulletBorderAlpha = 10;
    chart.addGraph(graph1);

    // GRAPH 2
    var graph2 = new AmCharts.AmGraph();
    graph2.type = "line"; // try to change it to "column"
    graph2.title = "Risk Level 2";
    graph2.valueField = "pri2";
    graph2.urlField = "url";
    graph2.connect = false;
    graph2.lineAlpha = 1;
    graph2.lineColor = "#FE7F00";
    graph2.fillAlphas = 0.3; // setting fillAlphas to > 0 value makes it area graph
    graph2.bullet = "square";
    graph2.bulletAlpha = 0;
    graph2.bulletSize = 7;
    graph2.bulletBorderSize = 10;
    graph2.bulletBorderAlpha = 10;
    chart.addGraph(graph2);

    // GRAPH 3
    var graph3 = new AmCharts.AmGraph();
    graph3.type = "line"; // try to change it to "column"
    graph3.title = "Risk Level 3";
    graph3.valueField = "pri3";
    graph3.connect = false;
    graph3.lineAlpha = 1;
    graph3.lineColor = "#007FFE";
    graph3.fillAlphas = 0.3; // setting fillAlphas to > 0 value makes it area graph
    graph3.bullet = "square";
    graph3.bulletAlpha = 0;
    graph3.bulletSize = 7;
    graph3.bulletBorderSize = 10;
    graph3.bulletBorderAlpha = 10;
    chart.addGraph(graph3);

    // GRAPH 4
    var graph4 = new AmCharts.AmGraph();
    graph4.type = "line"; // try to change it to "column"
    graph4.title = "Risk Level 4";
    graph4.valueField = "pri4";
    graph4.connect = false;
    graph4.lineAlpha = 1;
    graph4.lineColor = "#3FD83F";
    graph4.fillAlphas = 0.3; // setting fillAlphas to > 0 value makes it area graph
    graph4.bullet = "square";
    graph4.bulletAlpha = 0;
    graph4.bulletSize = 7;
    graph4.bulletBorderSize = 10;
    graph4.bulletBorderAlpha = 10;
    chart.addGraph(graph4);

    // GRAPH 5
    var graph5 = new AmCharts.AmGraph();
    graph5.type = "line"; // try to change it to "column"
    graph5.title = "Risk Level 5";
    graph5.valueField = "pri5";
    graph5.connect = false;
    graph5.lineAlpha = 1;
    graph5.lineColor = "#D8D8D8";
    graph5.fillAlphas = 0.3; // setting fillAlphas to > 0 value makes it area graph
    graph5.bullet = "square";
    graph5.bulletAlpha = 0;
    graph5.bulletSize = 7;
    graph5.bulletBorderSize = 10;
    graph5.bulletBorderAlpha = 10;
    chart.addGraph(graph5);

    // CURSOR
    var chartCursor = new AmCharts.ChartCursor();
    chartCursor.cursorAlpha = 1;
    chartCursor.cursorColor = "#B9D97E";
    chartCursor.color = "#000000";
    chartCursor.cursorPosition = "mouse";
    chartCursor.categoryBalloonDateFormat = "MMMM DD JJ:NN:SS";
    chart.addChartCursor(chartCursor);

    // SCROLLBAR
    var chartScrollbar = new AmCharts.ChartScrollbar();
	chartScrollbar.graph = graph;
	chartScrollbar.autoGridCount = true;
	chartScrollbar.scrollbarHeight = 25;
    chart.addChartScrollbar(chartScrollbar);
    
    // listener
    chart.addListener("clickGraphItem", handleClick);
    
    var legend = new AmCharts.AmLegend();
    chart.addLegend(legend);

    // WRITE
    chart.write("chartdiv");    
});

function zoomChart() {

    chart.zoomToIndexes(chartData.length - 40, chartData.length - 1);
    
}

function handleClick(event){

    var graphDataItem = event.item;
    
	window.location = '?op=prv_eventSearch&query=sip:' + graphDataItem.dataContext.e + ' OR dip:' + graphDataItem.dataContext.e;

}

</script>

<table width="100%">

	<tr>	
		
		<td valign="top">		
		
			<table width="100%">
			
				<tr>
				
					<td>
					
						<p>IP Summary > <?php echo sanitize('ip'); ?> (<?php echo doHostnameLookup(sanitize('ip')); ?>)</p>
					
					</td>
					<td width="50%" style="text-align: right; font-size: 13px;">
					
					</td>
				
				</tr>
			
			</table>
		
			<br>
			<hr>
			<br>

			<div id="chartdiv" style="width:100%; height:250px;"></div>		

			<table class="noClass" width="100%" style="font-size: 1em; border: 1px solid #CDCDCD;">
			
				<tr bgcolor="#EDEDED">	
					<td width="250" valign="middle" style="padding: 2px;">
						Geo IP Location Details
					</td>
					<td style="padding: 2px;">
					
						<?php if (file_exists("console/assets/images/flags/" . strtolower($_ENV['templateData']->geo->country) . ".png")) { ?>
					
							<a href="?op=prv_geoLocationByIP&ip=<?php echo sanitize('ip'); ?>"><img src="console/assets/images/flags/<?php echo strtolower($_ENV['templateData']->geo->country); ?>.png" title="<?php echo $_ENV['templateData']->geo->country; ?>"></a>
							
						<?php } ?>
						
					</td>
				</tr>
				
				<tr>	
					<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						Country
					</td>
					<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						<?php echo $_ENV['templateData']->geo->country; ?>
					</td>
				</tr>

				<tr>	
					<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						State / Region
					</td>
					<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						<?php echo htmlentities($_ENV['templateData']->geo->region); ?>
					</td>
				</tr>
			
				<tr>	
					<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						City
					</td>
					<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						<?php echo htmlentities($_ENV['templateData']->geo->city); ?>
					</td>
				</tr>

				<tr>	
					<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						Postal Code
					</td>
					<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						<?php echo $_ENV['templateData']->geo->postalCode; ?>
					</td>
				</tr>

				<tr>	
					<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						Metro Code
					</td>
					<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						<?php echo $_ENV['templateData']->geo->metroCode; ?>
					</td>
				</tr>
			
				<tr>	
					<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						Area Code
					</td>
					<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						<?php echo $_ENV['templateData']->geo->areaCode; ?>
					</td>
				</tr>
			
				<tr>	
					<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						Longitude / Latitude
					</td>
					<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						<?php echo $_ENV['templateData']->geo->longitude; ?> <?php echo $_ENV['templateData']->geo->latitude; ?>
					</td>
				</tr>
			
			</table>						

			<p><?php echo $_ENV['templateData']->sip->total; ?> events with <?php echo sanitize('ip'); ?> as source</p>

			<table class="noClass" width="100%" style="font-size: 1em; border: 1px solid #CDCDCD;">
			<tr bgcolor="#EDEDED">	
				<td valign="top" style="padding: 2px;">
					Event signatures with <?php echo sanitize('ip'); ?> as source
				</td>
				<td width="100" style="padding: 2px;">
					Events
				</td>
				<td width="25">&nbsp;</td>
			</tr>
			
			<?php
			
				foreach ($_ENV['templateData']->sip->signatureArray as $data) {
		
					?>
					
						<tr>	
							<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
								<a href="?op=prv_signatureSummary&signature=<?php echo $data->signature; ?>"><?php echo $data->signatureName; ?></a>
							</td>
							<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
								<?php echo $data->cnt; ?>
							</td>
							<td style="text-align: center; border: 1px solid #CDCDCD; padding: 2px;">
							
								<a href="?op=prv_eventSearch&query=sip:<?php echo sanitize('ip'); ?> signature:<?php echo $data->signature; ?>"><img src="console/assets/images/icons/event_search.png" title="Search Events"/></a>
								
							</td>
						</tr>
					
					<?php									
				
				}
				
			?>
			
			</table>						

			<br>
			
			<table class="noClass" width="100%" style="font-size: 1em; border: 1px solid #CDCDCD;">
			<tr bgcolor="#EDEDED">	
				<td valign="top" style="padding: 2px;">
					Event categories with <?php echo sanitize('ip'); ?> as source
				</td>
				<td width="100" style="padding: 2px;">
					Events
				</td>
				<td width="25">&nbsp;</td>
			</tr>
			
			<?php
			
				foreach ($_ENV['templateData']->sip->classArray as $data) {
		
					?>
					
						<tr>	
							<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
								<?php echo $data->className; ?>
							</td>
							<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
								<?php echo $data->cnt; ?>
							</td>
							<td style="text-align: center; border: 1px solid #CDCDCD; padding: 2px;">
							
								<a href="?op=prv_eventSearch&query=sip:<?php echo sanitize('ip'); ?> category:<?php echo $data->category; ?>"><img src="console/assets/images/icons/event_search.png" title="Search Events"/></a>
								
							</td>
						</tr>
					
					<?php									
				
				}
				
			?>
			
			</table>		
			<p><?php echo $_ENV['templateData']->dip->total; ?> events with <?php echo sanitize('ip'); ?> as destination</p>

			<table class="noClass" width="100%" style="font-size: 1em; border: 1px solid #CDCDCD;">
			<tr bgcolor="#EDEDED">	
				<td valign="top" style="padding: 2px;">
					Event signatures with <?php echo sanitize('ip'); ?> as destination
				</td>
				<td width="100" style="padding: 2px;">
					Events
				</td>
				<td width="25">&nbsp;</td>
			</tr>
			
			<?php
			
				foreach ($_ENV['templateData']->dip->signatureArray as $data) {
		
					?>
					
						<tr>	
							<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
								<a href="?op=prv_signatureSummary&signature=<?php echo $data->signature; ?>"><?php echo $data->signatureName; ?></a>
							</td>
							<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
								<?php echo $data->cnt; ?>
							</td>
							<td style="text-align: center; border: 1px solid #CDCDCD; padding: 2px;">
							
								<a href="?op=prv_eventSearch&query=dip:<?php echo sanitize('ip'); ?> signature:<?php echo $data->signature; ?>"><img src="console/assets/images/icons/event_search.png" title="Search Events"/></a>
								
							</td>
						</tr>
					
					<?php									
				
				}
				
			?>
			
			</table>
			
			<br>

			<table class="noClass" width="100%" style="font-size: 1em; border: 1px solid #CDCDCD;">
			<tr bgcolor="#EDEDED">	
				<td valign="top" style="padding: 2px;">
					Event categories with <?php echo sanitize('ip'); ?> as destination
				</td>
				<td width="100" style="padding: 2px;">
					Events
				</td>
				<td width="25">&nbsp;</td>
			</tr>
			
			<?php
			
				foreach ($_ENV['templateData']->dip->classArray as $data) {
		
					?>
					
						<tr>	
							<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
								<?php echo $data->className; ?>
							</td>
							<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
								<?php echo $data->cnt; ?>
							</td>
							<td style="text-align: center; border: 1px solid #CDCDCD; padding: 2px;">
							
								<a href="?op=prv_eventSearch&query=dip:<?php echo sanitize('ip'); ?> category:<?php echo $data->category; ?>"><img src="console/assets/images/icons/event_search.png" title="Search Events"/></a>
								
							</td>
						</tr>
					
					<?php									
				
				}
				
			?>
			
			</table>
		
		</td>
	
	</tr>
	
</table>
