<script type="text/javascript">
var chart;

<?php 

	echo $_ENV['templateData']['jsTimelineData'];

?>

AmCharts.ready(function () {

    // SERIAL CHART
    chart = new AmCharts.AmSerialChart();
    chart.pathToImages = "console/assets/js/images/";
    chart.zoomOutButton = {
        backgroundColor: '#000000',
        backgroundAlpha: 0.15
    };
    chart.dataProvider = chartData;
    chart.categoryField = "t";

    // data updated event will be fired when chart is first displayed,
    // also when data will be updated. We'll use it to set some
    // initial zoom
    chart.addListener("dataUpdated", zoomChart);

    // AXES
    // Category
    var categoryAxis = chart.categoryAxis;
    categoryAxis.parseDates = true; // in order char to understand dates, we should set parseDates to true
    categoryAxis.minPeriod = "ss"; // as we have data with minute interval, we have to set "mm" here.			 
    categoryAxis.gridAlpha = 0.07;
    categoryAxis.axisColor = "#DADADA";

    // Value
    var valueAxis = new AmCharts.ValueAxis();
    valueAxis.gridAlpha = 0.07;
    valueAxis.title = "Import Timeline";
    chart.addValueAxis(valueAxis);

    // GRAPH
    var graph = new AmCharts.AmGraph();
    graph.type = "line"; // try to change it to "column"
    graph.title = "Event Timeline";
    graph.valueField = "c";
    graph.connect = false;
    graph.lineAlpha = 1;
    graph.lineColor = "#BEDE83";
    graph.fillAlphas = 0.3; // setting fillAlphas to > 0 value makes it area graph
    graph.bullet = "square";
    graph.bulletAlpha = 0;
    graph.bulletSize = 7;
    graph.bulletBorderSize = 10;
    graph.bulletBorderAlpha = 10;
    
    chart.addGraph(graph);

    // CURSOR
    var chartCursor = new AmCharts.ChartCursor();
    chartCursor.cursorAlpha = 1;
    chartCursor.cursorColor = "#B9D97E";
    chartCursor.color = "#000000";
    chartCursor.cursorPosition = "mouse";
    chartCursor.categoryBalloonDateFormat = "MMMM DD JJ:NN:SS";
    chart.addChartCursor(chartCursor);
    
    // listener
    chart.addListener("clickGraphItem", handleClick);

    // SCROLLBAR
    var chartScrollbar = new AmCharts.ChartScrollbar();
	chartScrollbar.graph = graph;
	chartScrollbar.autoGridCount = true;
	chartScrollbar.scrollbarHeight = 25;
    chart.addChartScrollbar(chartScrollbar);

    // WRITE
    chart.write("chartdiv");
});

// this method is called when chart is first inited as we listen for "dataUpdated" event
function zoomChart() {
    // different zoom methods can be used - zoomToIndexes, zoomToDates, zoomToCategoryValues
    chart.zoomToIndexes(chartData.length - 40, chartData.length - 1);
}

function handleClick(event){

    var graphDataItem = event.item;
    
	window.location = '?op=prv_eventSearch&query=imported:' + graphDataItem.dataContext.e;

}

</script>

<table width="100%" style="height: 100%;">

	<tr>
	
		<td>

			<table width="100%" border="0">
	
				<tr valign="middle">
				
					<td>
					
						<div style="padding: 5px; border: 1px solid #CECECE; vertical-align: middle; text-align: center; ">
					
							<span style="font-size: 26px;"><?php echo eventsPerSecond(); ?></span> 
							<br>
							<span style="font-size: 12px;">Events per Second</span>
		
						</div>
						
					</td>			
					<td width="15">&nbsp;</td>			
					<td>
		
						<div style="padding: 5px; border: 1px solid #CECECE; vertical-align: middle; margin-left: auto; margin-right: auto; text-align: center;">
					
							<span style="font-size: 26px;"><?php echo eventsPerHour(); ?></span> 
							<br>
							<span style="font-size: 12px;">Events per Hour</span>
		
						</div>
					
					</td>
					<td width="15">&nbsp;</td>			
					<td>
		
						<div style="padding: 5px; border: 1px solid #CECECE; vertical-align: middle; margin-left: auto; margin-right: auto; text-align: center;">
					
							<span style="font-size: 26px;"><?php echo eventsToday(); ?></span> 
							<br>
							<span style="font-size: 12px;">Events Today</span>
		
						</div>
					
					</td>
					<td width="15">&nbsp;</td>			
					<td>
		
						<div style="padding: 5px; border: 1px solid #CECECE; vertical-align: middle; margin-left: auto; margin-right: 0px; text-align: center;">
					
							<span style="font-size: 26px;"><?php echo date(ops("site_timeDateFormat"), consoleTimeConversion(time())); ?></span> 
							<br>
							<span style="font-size: 12px;">Current Time - <a href="?">refresh</a></span>
		
						</div>
					
					</td>
				
				</tr>
				
			</table>
			
			<br>
			
		</td>
		
	</tr>

<?php

/*

	<tr style="height: 195px;">	
		
		<td valign="top" style="padding: 5px;">
		
		
			<table border="0" width="100%" cellpadding="0" cellspacing="0">
			
				<tr>
				
					<td valign="top" width="50%">
					
						<table id="eventsByHour" class="alternateColors" style="width: 100%; font-size: 14px;">
					
							<tr style="height: 25px;">
							
								<td>Events per 5 minute</td>
								
								<td width="240">Events</td>
								
								<td width="15">%</td>
								
							</tr>
			
						</table>					
					
						<?php
						
							foreach (eventsLastHour() as $data) {

								echo itemRenderer('eventsPerX', $data);
									
							}
		
						?>
					
					</td>
					
					<td width="10"></td>
					
					<td valign="top">
					
						<table id="eventsByHour" class="alternateColors" style="width: 100%; font-size: 14px;">
					
							<tr style="height: 25px;">
							
								<td>Events per 15 minute</td>
								
								<td width="240">Events</td>
								
								<td width="15">%</td>
								
							</tr>
			
						</table>
						
						<?php
						
							foreach (eventsLastDay() as $data) {

								echo itemRenderer('eventsPerX', $data);
									
							}
		
						?>						
											
					</td>
				
				</tr>
			
			</table>

		
		</td>
		
	</tr>

*/
			
?>
	
	<tr style="height: 100%;">
	
		<td valign="top" style="padding: 5px; ">

			<div style="overflow-y: scroll; height: 100%; padding-right: 10px;">

				<?php
				
				echo liveResults("recent:25");
				
				?>
		
			</div>
		
		</td>
	
	</tr>

	<tr>
	
		<td valign="top" style="padding: 5px; ">
		
			<div id="chartdiv" style="width:100%; height:200px;"></div>		
		
		</td>
	
	</tr>

</table>

	<script>
	
		$(document).ready(function()
		{
		
		   $('#eventsPerPercent[title]').qtip(
		   {
		      content: {
		         attr: 'title'
		      },
		      position: {
			      at: 'bottom right'
			  },
		      style: {
		         classes: 'ui-tooltip-tipsy ui-tooltip-shadow'
		      }
		   });
		});
		
	</script>