<script type="text/javascript">
var chart;

<?php 

	echo $_ENV['templateData']->chart . ";";

?>

AmCharts.ready(function () {

	// SERIAL CHART
    chart = new AmCharts.AmSerialChart();
    chart.pathToImages = "console/assets/js/images/";
    chart.zoomOutButton = {
        backgroundColor: '#000000',
        backgroundAlpha: 0.15
    };
    chart.dataProvider = chartData;
    chart.categoryField = "t";

    // data updated event will be fired when chart is first displayed,
    // also when data will be updated. We'll use it to set some
    // initial zoom
    chart.addListener("dataUpdated", zoomChart);

    // AXES
    // Category
    var categoryAxis = chart.categoryAxis;
    categoryAxis.parseDates = true; // in order char to understand dates, we should set parseDates to true
    categoryAxis.minPeriod = "ss"; // as we have data with minute interval, we have to set "mm" here.			 
    categoryAxis.gridAlpha = 0.07;
    categoryAxis.axisColor = "#DADADA";

    // Value
    var valueAxis = new AmCharts.ValueAxis();
    valueAxis.gridAlpha = 0.07;
    valueAxis.title = "Event Timeline";
    chart.addValueAxis(valueAxis);

    // GRAPH
    var graph = new AmCharts.AmGraph();
    graph.type = "line"; // try to change it to "column"
    graph.title = "Total Events";
    graph.valueField = "c";
    graph.connect = false;
    graph.lineAlpha = 1;
    graph.lineColor = "#d1cf2a";
    graph.fillAlphas = 0.3; // setting fillAlphas to > 0 value makes it area graph
    graph.bullet = "square";
    graph.bulletAlpha = 0;
    graph.bulletSize = 7;
    graph.bulletBorderSize = 10;
    graph.bulletBorderAlpha = 10;
    chart.addGraph(graph);

    // CURSOR
    var chartCursor = new AmCharts.ChartCursor();
    chartCursor.cursorAlpha = 1;
    chartCursor.cursorColor = "#B9D97E";
    chartCursor.color = "#000000";
    chartCursor.cursorPosition = "mouse";
    chartCursor.categoryBalloonDateFormat = "MMMM DD JJ:NN:SS";
    chart.addChartCursor(chartCursor);

    // SCROLLBAR
    var chartScrollbar = new AmCharts.ChartScrollbar();
	chartScrollbar.graph = graph;
	chartScrollbar.autoGridCount = true;
	chartScrollbar.scrollbarHeight = 25;
    chart.addChartScrollbar(chartScrollbar);
    
    // listener
    chart.addListener("clickGraphItem", handleClick);
    
    var legend = new AmCharts.AmLegend();
    chart.addLegend(legend);

    // WRITE
    chart.write("chartdiv");    
});

function zoomChart() {

    chart.zoomToIndexes(chartData.length - 40, chartData.length - 1);
    
}

function handleClick(event){

    var graphDataItem = event.item;
    
	window.location = '?op=prv_eventSearch&query=signature:' + graphDataItem.dataContext.e;

}

</script>

<table width="100%">

	<tr>	
		
		<td valign="top">		
		
			<table width="100%">
			
				<tr>
				
					<td>
					
						<p>Signature Summary > <?php echo $_ENV['templateData']->signature->name; ?> (<?php echo sanitize('signature'); ?>)</p>
					
					</td>
					<td width="50%" style="text-align: right; font-size: 13px;">
					
					</td>
				
				</tr>
			
			</table>
		
			<br>
			<hr>
			<br>

			<div id="chartdiv" style="width:100%; height:250px;"></div>		

			<p><?php echo $_ENV['templateData']->signature->total; ?> events with signature <?php echo sanitize('signature'); ?></p>

			<table class="noClass" width="100%" style="font-size: 1em; border: 1px solid #CDCDCD;">
				<tr bgcolor="#EDEDED">	
					<td valign="top" style="padding: 2px;">
						Signature Details
					</td>
				</tr>
				
				<tr>	
					<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
						<?php echo htmlentities($_ENV['templateData']->signature->data); ?>
					</td>
				</tr>
			</table>						

			<br>

			<table class="noClass" width="100%" style="font-size: 1em; border: 1px solid #CDCDCD;">
			<tr bgcolor="#EDEDED">	
				<td valign="top" style="padding: 2px;">
					Sources with this signature
				</td>
				<td width="100" style="padding: 2px;">
					Events
				</td>
				<td width="25">&nbsp;</td>
			</tr>
			
			<?php
			
				foreach ($_ENV['templateData']->signature->sipArray as $data) {
		
					?>
					
						<tr>	
							<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
							
								<?php
								
								if ($deviceData = getDeviceDataByIP($data->sip)) {
								
								?>
	
									<a href="?op=prv_ipSummary&ip=<?php echo long2ip($data->sip); ?>"><?php echo $deviceData->deviceName; ?></a> <?php echo $deviceData->addressName; ?></a>
								
								<?php } else { ?>
	
									<a href="?op=prv_ipSummary&ip=<?php echo long2ip($data->sip); ?>"><?php echo long2ip($data->sip); ?></a>
	
								<?php } ?>
							
							</td>
							<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
								<?php echo $data->cnt; ?>
							</td>
							<td style="text-align: center; border: 1px solid #CDCDCD; padding: 2px;">
							
								<a href="?op=prv_eventSearch&query=sip:<?php echo long2ip($data->sip); ?> signature:<?php echo sanitize("signature"); ?>"><img src="console/assets/images/icons/event_search.png" title="Search Events"/></a>
								
							</td>
						</tr>
					
					<?php									
				
				}
				
			?>
			
			</table>						

			<br>
			
			</table>		

			<table class="noClass" width="100%" style="font-size: 1em; border: 1px solid #CDCDCD;">
			<tr bgcolor="#EDEDED">	
				<td valign="top" style="padding: 2px;">
					Destinations with this signature
				</td>
				<td width="100" style="padding: 2px;">
					Events
				</td>
				<td width="25">&nbsp;</td>
			</tr>
			
			<?php
			
				foreach ($_ENV['templateData']->signature->dipArray as $data) {
		
					?>
					
						<tr>	
							<td valign="top" style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
							
								<?php
								
								if ($deviceData = getDeviceDataByIP($data->dip)) {
								
								?>
	
									<a href="?op=prv_ipSummary&ip=<?php echo long2ip($data->dip); ?>"><?php echo $deviceData->deviceName; ?></a> <?php echo $deviceData->addressName; ?></a>
								
								<?php } else { ?>
	
									<a href="?op=prv_ipSummary&ip=<?php echo long2ip($data->dip); ?>"><?php echo long2ip($data->dip); ?></a>
	
								<?php } ?>
								
							</td>
							<td style="font-size: 0.8em; border: 1px solid #CDCDCD; padding: 2px;">
								<?php echo $data->cnt; ?>
							</td>
							<td style="text-align: center; border: 1px solid #CDCDCD; padding: 2px;">
							
								<a href="?op=prv_eventSearch&query=dip:<?php echo long2ip($data->dip); ?> signature:<?php echo sanitize("signature"); ?>"><img src="console/assets/images/icons/event_search.png" title="Search Events"/></a>
								
							</td>
						</tr>
					
					<?php									
				
				}
				
			?>
			
			</table>
		
		</td>
	
	</tr>
	
</table>
