<?php

/** Copyright 2012 Tactical FLEX, Inc.
 *
 * This program is owned and licensed by Tactical FLEX, Inc; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX, Inc and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX, Inc or Aanval agents.
 *
 * Tactical FLEX, Inc and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

######################################################################
# Adjust the following variables to match your Aanval sensor options #
######################################################################

# !! Note: Trailing slashes are required (see below)

# This is a unique Sensor Management ID required for each sensor to 
# be managed by the Console - This SMT ID is available from the
# configuration section of the console for each snort sensor.
$id = "00000000000";

# Where this conf.php and the sensor management tools are located
$sensorDataPath = "/smt/";

# Protocol to use for connection to aanval console (http or https)
$protocol = "http";

# Host address of the aanval console (site.com or 192.168.1.1)
# Basic Authentication is available "user:pass@www.site.com"
$consoleHost = "www.site.com";

# URL of the aanval console (use / if located in root of URL)
$consoleHostPath = "/aanval/";

# Change these commands to the appropriate start/stop used
$cmdSnortStart = "service snortd start";
$cmdSnortStop = "service snortd stop";

// alternative snort stop commands
// $cmdSnortStop = "kill `ps -A|awk '/firefox/{print $1}'`";
// $cmdSnortStop = "pkill snort";

# Change these commands to the appropriate snort rule reload command
# (snort must be compiled with rules reload option)
$cmdSnortReload = "";

# Change this to retrieve the snort line of a ps command for your OS
$cmdSnortStatus = "ps ax | grep -v grep | grep snort";

# Change this to retrieve the current uptime status from your OS
$cmdUptime = "uptime";

# Location of snort.conf and snort rules
$confSnort = "/etc/snort/snort.conf";
$rulesSnort = "/etc/snort/rules/";

# Logging Enable (1) / Disable (0) [help debug problems]
$logging = 0;
$logfile = "debug_$id.log";

?>