#!/usr/bin/perl -w

# USE
use English;
use Getopt::Long;
use POSIX;

# DEFINES
my $start;
my $stop;
my %children;
my $children = 0;
my @sigs;

$smtDir = `cd \`dirname $0\`;pwd`;
chop($smtDir);

# OPTIONS
GetOptions (
		'start' => \$start,
		'stop' => \$stop,
		'help|?' => \$help
		);

# Prepare for launch! T minus 3...2...1
launch();

################ FUNCTIONS ################

sub launch {

	my $run = 1;

	# Change to SMT directory
	chdir("$smtDir");

	if ($stop) {
		print "Stopping SMT's\n";
		if (-e "$smtDir/smtPid") { 
			system("kill -9 `cat $smtDir/smtPid` 2>/dev/null");
			system("rm -f $smtDir/smtPid");
			print "Stopped\n";
		} else {
			print "Nothing to stop\n";
		}
		exit;
	} 	
	
	# Exit immediately if this launch isn't going anywhere
	if (!$start && !$help) { print "\nNothing to do. Try -help\n\n"; $run = 0; }
	
	# Display Help
	if ($help) { displayHelp(); $run = 0; }
	
	if ($run == 1) {
		daemonRun();
		main();
	}

	exit;
}

sub main {

	$0 = "Aanval SMT";
	while(1) {
        if (-e "smt.php.NEW") {
            system("cp -f smt.php.NEW smt.php --reply=yes");
            system("rm -f smt.php.NEW");
        }	
		system("php -q $smtDir/smt.php > /dev/null");
		sleep 5;
	}
}

sub daemonRun {
	my $pid = fork;
	
	defined ($pid) or die "Cannot start Aanval SMT's as daemon: $!";
	
	if ($pid) {
		print "Aanval SMT's launched in daemon mode [PID: $pid].\n";

		open(DAT,">$smtDir/smtPid") || die("smtPid Cannot Be Written");
		print DAT "$pid";
		close(DAT);		
	}
	
	exit if $pid; # Return control to the user
	
	POSIX::setsid(); # Become a session mojo-master
	
	close (STDOUT); # Close file handles to detach from any terminals if necessary
	close (STDIN);
	close (STDERR);
	
	# Any death trigger will kill everything
	
	$SIG{HUP} = $SIG{INT} = $SIG{TERM} = sub {
		my $sig = shift;
		$SIG{$sig} = 'IGNORE';
		kill 'INT' => keys %children;
		die "killed by $sig\n";
		exit;
	};      
	
}

sub displayHelp {

	print "Usage: ./idsSensor.pl [options]\n\n";
	
	print "-start       Start the Aanval Sensor Management Tools\n";
	print "-stop        Stop the Aanval Sensor Management Tools\n";
	print "-help        This Help Information\n";
	print "\n";

}

