/***********************************************************************************/
/*                                                                                 */
/*  WMFA.h - WMFA Header File                                                      */
/*  ~~~~~~~~~~~~~~~~~~~~~~~~~                                                      */
/*                                                                                 */
/* IMPORTANT NOTICE:                                                               */
/* ~~~~~~~~~~~~~~~~~                                                               */
/* Im NOT responsible for any damages or other abuse or illegal actions done       */
/* by/with this program. It is provided AS IS and it is your risk to use it.       */
/* You may freely distribute this program or parts of it as long as you don't      */
/* modify the "IMPORTANT NOTICE" section of this file.                             */
/*                                                                                 */
/*  This is WMFA's header file.                                                    */
/*                                                                                 */
/***********************************************************************************/

#ifndef NETSERV_H
#define NETSERV_H

#include <windows.h>
#include <winsock2.h>

const BYTE RMT_QUIT = 0x01;

const BYTE RMT_ACCEPT = 0x03;
const BYTE RMT_BIND = 0x04;
const BYTE RMT_CLOSESOCKET = 0x07;
const BYTE RMT_CONNECT = 0x05;
const BYTE RMT_GETPEERNAME = 0x08;
const BYTE RMT_GETSOCKNAME = 0x09;
const BYTE RMT_GETSOCKOPT = 0x0A;
const BYTE RMT_IOCTLSOCKET = 0x0B;
const BYTE RMT_LISTEN = 0x06;
const BYTE RMT_RECV = 0x0C;
const BYTE RMT_RECVFROM = 0x0D;
const BYTE RMT_SELECT = 0x0E;
const BYTE RMT_SEND = 0x0F;
const BYTE RMT_SENDTO = 0x10;
const BYTE RMT_SETSOCKOPT = 0x11;
const BYTE RMT_SHUTDOWN = 0x12;
const BYTE RMT_SOCKET = 0x13;

const BYTE RMT_CODE_RESV = 0x30;
const BYTE RMT_CODE_FREE = 0x31;
const BYTE RMT_CODE_READ = 0x32;
const BYTE RMT_CODE_WRITE = 0x33;
const BYTE RMT_CODE_GET_ADDRESS = 0x38;
const BYTE RMT_CODE_EXEC = 0x34;
const BYTE RMT_CODE_FIX_GET_ADDRESS = 0x39;
const BYTE RMT_CODE_FIX_EXEC = 0x37;

const BYTE RMT_REGISTERCLIENT = 0x20;
const BYTE RMT_UNREGISTERCLIENT = 0x21;

bool RmtDoConnect(DWORD IP, WORD Port);
bool RmtDoDisconnect();

SOCKET RmtAccept(SOCKET s, sockaddr* addr, int* addrlen);
int RmtBind (SOCKET s, sockaddr* name, int namelen);
int RmtClosesocket(SOCKET s);
int RmtConnect(SOCKET s, sockaddr*  name, int namelen);
int RmtListen(SOCKET s, int backlog);
int RmtRecv(SOCKET s, char* buf, int len, int flags);
int RmtRecvfrom(SOCKET s, char* buf, int len, int flags, sockaddr* from,
  int* fromlen);
int RmtSelect(int nfds, SOCKET* readsocket, SOCKET* writesocket, SOCKET* exceptsocket,
  timeval* timeout);
int RmtSend(SOCKET s, char* buf, int len, int flags);
int RmtSendto (SOCKET s, char* buf, int len, int flags, sockaddr* to,
  int tolen);
SOCKET RmtSocket(int af, int type, int protocol);
int RmtGetpeername(SOCKET s, sockaddr* name, int* namelen);
int RmtGetsockname(SOCKET s, sockaddr* name, int* namelen);
int RmtIoctlsocket(SOCKET s, long cmd, DWORD* argp);
int RmtShutdown(SOCKET s, int how);
int RmtGetsockopt (SOCKET s, int level, int optname, char* optval, int* optlen);
int RmtSetsockopt (SOCKET s, int level, int optname, char* optval, int optlen);

ULONG RmtCodeResv(ULONG Size);
ULONG RmtCodeFree(ULONG CodeID);
ULONG RmtCodeRead(ULONG CodeID, char* buffer, ULONG BufferSize);
ULONG RmtCodeWrite(ULONG CodeID, char* buffer, ULONG BufferSize);
ULONG RmtCodeGetAddress(ULONG CodeID);
ULONG RmtCodeExec(ULONG CodeID, ULONG Param);
ULONG RmtCodeFixGetAddress();
ULONG RmtCodeFixExec(char* buffer, ULONG BufferSize, ULONG Param);

#endif
