/**************************************************************************************/
/*                                                                                    */
/*  WMFACLIENT.cpp - WMFA Client Program                                              */
/*  ~~~~~~~~~~~~~~~~~~~~~~~~~                                                         */
/*                                                                                    */
/* IMPORTANT NOTICE:                                                                  */
/* ~~~~~~~~~~~~~~~~~                                                                  */
/* Im NOT responsible for any damages or other abuse or illegal actions done          */
/* by/with this program. It is provided AS IS and it is your risk to use it.          */
/* You may freely distribute this program or parts of it as long as you don't         */
/* modify the "IMPORTANT NOTICE" section of this file.                                */
/*                                                                                    */
/*  This program establishes a connection via WMFA.                                   */
/*                                                                                    */
/*  Compile as follows with Borland(tm) compiler:		                      */
/*  bcc32 WMFACLIENT.cpp                                                              */
/*                                                                                    */
/**************************************************************************************/

//---------------------------------------------------------------------------
#include <windows.h>
#include <winsock2.h>
#include <iostream.h>
#include <conio.h>
#include "WMFA.h"
#pragma hdrstop
#define USEFUL_STRING
#include "useful.h"
#include "WMFA.cpp"
//---------------------------------------------------------------------------
SOCKET connectedSocket;
bool disconnect = false;
bool candisc = false;
bool wait = false;
HANDLE hFile;

const ULONG MAX_CODES = 20;
const ULONG MAX_CODE_LENGTH = 5000;

int startWinsock(void)
{
  WSADATA wsa;
  return WSAStartup(MAKEWORD(2,0),&wsa);
}

ULONG* TheCodes;
ULONG* TheCodeLength;

void CloseCodes()
{
    delete[] TheCodeLength;
    delete[] TheCodes;
}


DWORD WINAPI RecvThread(LPVOID junk);

USHORT RemotePortVal = 0;
in_addr RemoteAddr;


#pragma argsused
int main(int argc, char* argv[])
{
    long rc;
    SOCKADDR_IN addr;
    char* msg = new char[505];
    char* Port = new char[10];
    char* IP = new char[300];
    USHORT PortVal = 0;
    bool corr = true;
    in_addr theAddr;
    hostent* phe;
    DWORD tid;
    HANDLE hRecvThread;

    TheCodes = new ULONG[MAX_CODES];
    TheCodeLength = new ULONG[MAX_CODES];
    for (int i = 0; i < MAX_CODES; i++)
    {
        TheCodes[i] = (ULONG) -1;
        TheCodeLength[i] = 0;
    }

    // Winsock starten
    rc=startWinsock();
    if(rc!=0)
    {
        printf("\nError: Couldn't start WinSock, error code: %d\n",rc);
        delete[] msg;
        delete[] Port;
        delete[] IP;
        CloseCodes();
        return -1;
    }

    cout << "Remote Server Port: ";
    GetStr(Port, 6);
    RemotePortVal = StrToVal(Port, &corr);
    cout << "\nRemote Server IP: ";
    GetStr(IP, 100);
    phe = gethostbyname((char*) (IP));
    if (phe)
    {
        memcpy(&RemoteAddr, phe->h_addr_list[0], sizeof(in_addr));
        cout << "\n Remote Address: " << inet_ntoa(RemoteAddr);
    }
    else
    {
        cout << "\n Error";
        delete[] msg;
        delete[] Port;
        delete[] IP;
        CloseCodes();
        getch();
        WSACleanup();
        return -1;
    }

    if (RmtDoConnect(RemoteAddr.S_un.S_addr, RemotePortVal) == false)
    {
        cout << "\n  Remote Connection Error";
        delete[] msg;
        delete[] Port;
        delete[] IP;
        CloseCodes();
        getch();
        WSACleanup();
        return -1;
    }
    cout << "\nAddress to connect to: ";
    GetStr(IP, 300);
    if (strlen(IP) > 0)
    {
        phe = gethostbyname((char*) (IP));
        if (phe)
        {
            memcpy(&theAddr, phe->h_addr_list[0], sizeof(in_addr));
            cout << "\nAddress: " << inet_ntoa(theAddr);
        }
        else
        {
            cout << "\nError: Couldn't find specified address";
            RmtDoDisconnect();
            WSACleanup();
            delete[] msg;
            delete[] Port;
            delete[] IP;
            CloseCodes();
            return -1;
        }
    }
    else
    {
        cout << "\nError: Couldn't find specified address";
        RmtDoDisconnect();
        WSACleanup();
        delete[] msg;
        delete[] Port;
        delete[] IP;
        CloseCodes();
        return -1;
    }
    cout << "\nPort which the server is listening on: ";
    GetStr(Port, 6);
    corr = true;
    PortVal = StrToVal(Port, &corr);
    if ((!corr))
    {
        cout << "\nError: invalid port number";
        RmtDoDisconnect();
        WSACleanup();
        delete[] msg;
        delete[] Port;
        delete[] IP;
        CloseCodes();
        return -1;
    }
    connectedSocket = RmtSocket(AF_INET, SOCK_STREAM, 0);
    if (connectedSocket == -1)
    {
        cout << "\nError: Couldn't create socket";
        delete[] msg;
        delete[] Port;
        delete[] IP;
        CloseCodes();
        RmtDoDisconnect();
        WSACleanup();
        return -1;
    }
    memset(&addr, 0, sizeof(SOCKADDR));
    addr.sin_addr = theAddr;
    addr.sin_family = AF_INET;
    addr.sin_port = htons(PortVal);
    rc = RmtConnect(connectedSocket, (sockaddr*) &addr, sizeof(sockaddr));
    if (rc == SOCKET_ERROR)
    {
        cout << "\nError: Couldn't connect to server";
        RmtClosesocket(connectedSocket);
        delete[] msg;
        delete[] Port;
        delete[] IP;
        CloseCodes();
        RmtDoDisconnect();
        WSACleanup();
        return -1;
    }
    cout << "\nInfo: Connection established";
    DeleteFile("ICLog.txt");
    hFile = CreateFile("ICLog.txt", GENERIC_READ | GENERIC_WRITE, 0, NULL,
      CREATE_NEW, FILE_ATTRIBUTE_NORMAL, 0);
    hRecvThread = CreateThread(NULL, 0, &RecvThread, 0, 0, &tid);
    if (hRecvThread == INVALID_HANDLE_VALUE)
    {
        cout << "\nFatal Error: Couldn't create thread";
        RmtClosesocket(connectedSocket);
        CloseHandle(hFile);
        delete[] msg;
        delete[] Port;
        delete[] IP;
        CloseCodes();
        RmtDoDisconnect();
        WSACleanup();
        return -1;
    }
    char* tmpc = new char[100];
    DWORD tmp = 0;
    strcpy(tmpc, "\015\012Client sent:\015\012");
    bool ret;
    char command;
    USHORT tmptwo;
    HANDLE hSendFile;
    char* buffer = new char[500];
    if (argc > 1)
    {
        wait = true;
        strcpy(msg, argv[1]);
        hSendFile = CreateFile(msg, GENERIC_READ, 0, NULL,
          OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
        if (hSendFile == INVALID_HANDLE_VALUE)
        {
            cout << "\nError: Couldn't open file\n";
        }
        else
        {
            bool leave = false;
            WriteFile(hFile, tmpc, 16, &tmp, 0);
            while (!leave)
            {
                ReadFile(hSendFile, buffer, 500, &tmp, 0);
                if (tmp == 0)
                    leave = true;
                else
                {
                    RmtSend(connectedSocket, buffer, tmp, 0);
                    WriteFile(hFile, buffer, tmp, &tmp, 0);
                }
            }
            CloseHandle(hSendFile);
            cout << "\n";
        }
        wait = false;
    }
    for(;;)
    {
        while(!kbhit())
        {
            if (disconnect) break;
        }
        if (disconnect) break;
        command = getch();
        switch(command)
        {
            case 'd':
            {
                disconnect = true;
            }
            break;
            case 'r':
            {
                wait = true;
                cout << "\nText: ";
                GetStr(msg, 500);
                tmptwo = strlen(msg);
                RmtSend(connectedSocket, msg, tmptwo, 0);
                WriteFile(hFile, tmpc, 16, &tmp, 0);
                WriteFile(hFile, msg, tmptwo, &tmp, 0);
                cout << "\n";
                wait = false;
            }
            break;
            case 's':
            {
                wait = true;
                cout << "\nText: ";
                GetStr(msg, 500);
                tmptwo = strlen(msg);
                msg[tmptwo] = '\012';
                tmptwo++;
                msg[tmptwo] = '\0';
                RmtSend(connectedSocket, msg, tmptwo, 0);
                WriteFile(hFile, tmpc, 16, &tmp, 0);
                WriteFile(hFile, msg, tmptwo, &tmp, 0);
                cout << "\n";
                wait = false;
            }
            break;
            case 'e':
            {
                wait = true;
                cout << "\nText: ";
                GetStr(msg, 500);
                tmptwo = strlen(msg);
                msg[tmptwo] = '\015';
                tmptwo++;
                msg[tmptwo] = '\012';
                tmptwo++;
                msg[tmptwo] = '\0';
                RmtSend(connectedSocket, msg, tmptwo, 0);
                WriteFile(hFile, tmpc, 16, &tmp, 0);
                WriteFile(hFile, msg, tmptwo, &tmp, 0);
                cout << "\n";
                wait = false;
            }
            break;
            case 'f':
            {
                wait = true;
                cout << "\nFile: ";
                GetStr(msg, 500);
                hSendFile = CreateFile(msg, GENERIC_READ, 0, NULL,
                  OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
                if (hSendFile == INVALID_HANDLE_VALUE)
                {
                    cout << "\nError: Couldn't open file\n";
                    wait = false;
                    break;
                }
                bool leave = false;
                WriteFile(hFile, tmpc, 16, &tmp, 0);
                while (!leave)
                {
                    ReadFile(hSendFile, buffer, 500, &tmp, 0);
                    if (tmp == 0)
                        leave = true;
                    else
                    {
                        RmtSend(connectedSocket, buffer, tmp, 0);
                        WriteFile(hFile, buffer, tmp, &tmp, 0);
                    }
                }
                CloseHandle(hSendFile);
                cout << "\n";
                wait = false;
            }
            break;
            case 'c':
            {
                wait = true;
                char scmd;
                cout << "\nCode Command: ";
                scmd = getch();
                char* temp = 0;
                ULONG tempval = 0;
                ULONG offset = 0;
                ULONG address = 0;
                switch(scmd)
                {
                    case 'r':        // Reserve
                    {
                        temp = new char[500];
                        cout << "\nOffset: ";
                        GetStr(temp, 5);
                        corr = true;
                        tempval = StrToVal(temp, &corr);
                        if (tempval >= MAX_CODES)
                        {
                            cout << "\nOut of range";
                            delete[] temp;
                            break;
                        }
                        if (TheCodes[tempval] != (ULONG) -1)
                        {
                            cout << "\nOffset already in use";
                            delete[] temp;
                            break;
                        }
                        offset = tempval;
                        cout << "\nSize: ";
                        GetStr(temp, 20);
                        tempval = StrToVal(temp, &corr);
                        delete[] temp;
                        if (tempval > MAX_CODE_LENGTH)
                        {
                            cout << "\nToo long";
                            break;
                        }
                        TheCodes[offset] = RmtCodeResv(tempval);
                        TheCodeLength[offset] = tempval;
                    }
                    break;
                    case 'f':        // Free
                    {
                        temp = new char[500];
                        cout << "\nOffset: ";
                        GetStr(temp, 5);
                        corr = true;
                        tempval = StrToVal(temp, &corr);
                        if (tempval >= MAX_CODES)
                        {
                            cout << "\nOut of range";
                            delete[] temp;
                            break;
                        }
                        delete[] temp;
                        if (TheCodes[tempval] == (ULONG) -1)
                        {
                            cout << "\nOffset not in use";
                            break;
                        }
                        RmtCodeFree(TheCodes[tempval]);
                        TheCodes[tempval] = (ULONG) -1;
                    }
                    break;
                    case 'a':        // Get Address
                    {
                        temp = new char[500];
                        cout << "\nOffset: ";
                        GetStr(temp, 5);
                        corr = true;
                        tempval = StrToVal(temp, &corr);
                        if (tempval >= MAX_CODES)
                        {
                            cout << "\nOut of range";
                            delete[] temp;
                            break;
                        }
                        delete[] temp;
                        if (TheCodes[tempval] == (ULONG) -1)
                        {
                            cout << "\nOffset not in use";
                            break;
                        }
                        address = RmtCodeGetAddress(TheCodes[tempval]);
                        temp = DecToHex(address);
                        cout << "\nAddress: " << temp;
                        delete[] temp;
                    }
                    break;
                    case 'l':           // Load
                    {
                        temp = new char[500];
                        cout << "\nOffset: ";
                        GetStr(temp, 5);
                        corr = true;
                        tempval = StrToVal(temp, &corr);
                        if (tempval >= MAX_CODES)
                        {
                            cout << "\nOut of range";
                            delete[] temp;
                            break;
                        }
                        delete[] temp;
                        offset = tempval;
                        if (TheCodes[tempval] == (ULONG) -1)
                        {
                            cout << "\nOffset not in use";
                            break;
                        }
                        temp = new char[TheCodeLength[offset]];
                        RmtCodeRead(TheCodes[offset], temp,
                          TheCodeLength[offset]);
                        cout << "\nBuffer: " << temp;
                        delete[] temp;
                    }
                    break;
                    case 'w':         // Write
                    {
                        temp = new char[500];
                        cout << "\nOffset: ";
                        GetStr(temp, 5);
                        corr = true;
                        tempval = StrToVal(temp, &corr);
                        if (tempval >= MAX_CODES)
                        {
                            cout << "\nOut of range";
                            delete[] temp;
                            break;
                        }
                        delete[] temp;
                        offset = tempval;
                        if (TheCodes[tempval] == (ULONG) -1)
                        {
                            cout << "\nOffset not in use";
                            break;
                        }
                        temp = new char[TheCodeLength[offset]];
                        char choice = 0;
                        cout << "\nLoad From File(j/n)?";
                        while((choice != 'j') && (choice != 'n'))
                            choice = getch();
                        if (choice == 'j')
                        {
                            char* file = new char[MAX_PATH + 500];
                            cout << "\nCode File: ";
                            GetStr(file, MAX_PATH + 500);
                            HANDLE hFile = CreateFile(file, GENERIC_READ,
                              0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
                            DWORD tmp = 0;
                            if (hFile != INVALID_HANDLE_VALUE)
                            {
                                ReadFile(hFile, temp, TheCodeLength[offset],
                                  &tmp, NULL);
                                CloseHandle(hFile);
                                RmtCodeWrite(TheCodes[offset], temp,
                                  TheCodeLength[offset]);
                            }
                            else
                            {
                                cout << "\nFile not found";
                                delete[] file;
                                delete[] temp;
                                break;
                            }
                            delete[] file;
                        }
                        else
                        {
                            cout << "\nData: ";
                            GetStr(temp, TheCodeLength[offset]);
                            RmtCodeWrite(TheCodes[offset], temp,
                              TheCodeLength[offset]);
                        }
                        delete[] temp;
                    }
                    break;
                    case 'e':          // Execute
                    {
                        temp = new char[500];
                        cout << "\nOffset: ";
                        GetStr(temp, 5);
                        corr = true;
                        tempval = StrToVal(temp, &corr);
                        if (tempval >= MAX_CODES)
                        {
                            cout << "\nOut of range";
                            delete[] temp;
                            break;
                        }
                        delete[] temp;
                        offset = tempval;
                        if (TheCodes[tempval] == (ULONG) -1)
                        {
                            cout << "\nOffset not in use";
                            break;
                        }
                        temp = new char[30];
                        cout << "\nParameter: ";
                        GetStr(temp, 30);
                        ULONG Param = 0;
                        if (temp[0] == '#')
                            Param = RmtCodeGetAddress(TheCodes[offset]);
                        else
                            Param = StrToVal(temp, &corr);
                        ULONG RetVal = RmtCodeExec(TheCodes[tempval], Param);
                        delete[] temp;
                        cout << "\nReturn Value: " << RetVal;
                    }
                    break;
                    case 'k':      // Code Size
                    {
                        temp = new char[500];
                        cout << "\nOffset: ";
                        GetStr(temp, 5);
                        corr = true;
                        tempval = StrToVal(temp, &corr);
                        if (tempval >= MAX_CODES)
                        {
                            cout << "\nOut of range";
                            delete[] temp;
                            break;
                        }
                        delete[] temp;
                        offset = tempval;
                        if (TheCodes[tempval] == (ULONG) -1)
                        {
                            cout << "\nOffset not in use";
                            break;
                        }
                        cout << "\nSize: " << TheCodeLength[offset];
                    }
                    break;
                    case 'g':      // Get Fixed Address
                    {
                        address = RmtCodeFixGetAddress();
                        temp = DecToHex(address);
                        cout << "\nAddress: " << temp;
                        delete[] temp;
                    }
                    break;
                    case 's':      // Start Fixed Code
                    {
                        temp = new char[MAX_CODE_LENGTH + 2];
                        char choice = 0;
                        cout << "\nLoad From File(j/n)?";
                        while((choice != 'j') && (choice != 'n'))
                            choice = getch();
                        if (choice == 'j')
                        {
                            ULONG Length = 0;
                            char* file = new char[MAX_PATH + 500];
                            cout << "\nCode File: ";
                            GetStr(file, MAX_PATH + 500);
                            HANDLE hFile = CreateFile(file, GENERIC_READ,
                              0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
                            DWORD tmp = 0;
                            if (hFile != INVALID_HANDLE_VALUE)
                            {
                                Length = GetFileSize(hFile, 0);
                                if (Length > MAX_CODE_LENGTH)
                                    Length = MAX_CODE_LENGTH;
                                ReadFile(hFile, temp, Length,
                                  &tmp, NULL);
                                CloseHandle(hFile);
                            }                            
                            else
                            {
                                cout << "\nFile not found";
                                delete[] file;
                                delete[] temp;
                                break;
                            }
                            delete[] file;
                        }
                        else
                        {
                            cout << "\nData: ";
                            GetStr(temp, MAX_CODE_LENGTH);
                        }
                        char* parm = new char[30];
                        cout << "\nParameter: ";
                        GetStr(parm, 30);
                        ULONG Param = 0;
                        if (parm[0] == '#')
                            Param = RmtCodeFixGetAddress();
                        else
                            Param = StrToVal(parm, &corr);
                        delete[] parm;
                        ULONG RetVal = RmtCodeFixExec(temp, MAX_CODE_LENGTH,
                          Param);
                        cout << "\nReturn Value: " << RetVal;
                        delete[] temp;
                    }
                    break;
                    default:
                    {
                    }
                    break;
                }
                cout << "\n";
                wait = false;
            }
            break;
            default:
            {
                cout << "\nError: Unknown command\n";
            }
        }
        if (disconnect) break;
    }
    while (!candisc)
    {
    }
    WaitForSingleObject(hRecvThread, INFINITE);
    RmtClosesocket(connectedSocket);
    CloseHandle(hFile);
    delete[] tmpc;
    delete[] msg;
    delete[] Port;
    delete[] IP;
    delete[] buffer;
    CloseCodes();
    RmtDoDisconnect();
    WSACleanup();
    return 0;
}
//---------------------------------------------------------------------------

DWORD WINAPI RecvThread(LPVOID junk)
{
    SOCKET a, b, c;
    a = connectedSocket;
    b = INVALID_SOCKET;
    c = INVALID_SOCKET;
    char* rcv = new char[501];
    char* tmps = new char[100];
    DWORD tmp = 0;
    strcpy(tmps, "\015\012Server sent:\015\012");
    long rc;
    DWORD vdata = 0;
    timeval tval;
    tval.tv_sec = 1;
    tval.tv_usec = 1;
    for (;;)
    {
        if (disconnect) break;
        while(wait)
        {
            if (disconnect) break;
        }
        RmtSelect(0, &a, &b, &c, &tval);
        if (a == connectedSocket)
        {
            RmtIoctlsocket(connectedSocket, FIONREAD, &vdata);
            if (vdata == 0)
            {
                break;
            }
            cout << "\n";
            for(;;)
            {
                if (vdata >= 500)
                {
                    rc = RmtRecv(connectedSocket, rcv, 500, 0);
                    if ((rc == 0) && (rc == SOCKET_ERROR))
                    {
                        disconnect = true;
                        break;
                    }
                    rcv[rc] = '\0';
                    vdata -= 500;
                }
                else
                {
                    rc = RmtRecv(connectedSocket, rcv, vdata, 0);
                    if ((rc == 0) && (rc == SOCKET_ERROR))
                    {
                        disconnect = true;
                        break;
                    }
                    rcv[rc] = '\0';
                    vdata = 0;
                }
                while(wait)
                {
                    if (disconnect) break;
                }
                WriteFile(hFile, tmps, 16, &tmp, 0);
                cout << rcv;
                WriteFile(hFile, rcv, rc, &tmp, 0);
                if (vdata == 0)
                    break;
            }
        }
        else
        {
            a = connectedSocket;
        }
    }
    disconnect = true;
    delete[] rcv;
    delete[] tmps;
    candisc = true;
    return 0;
}
