/***********************************************************************************/
/*                                                                                 */
/*  WMFA.cpp - WMFA Remote Functions Definitions                                   */
/*  ~~~~~~~~~~~~~~~~~~~~~~~~~                                                      */
/*                                                                                 */
/* IMPORTANT NOTICE:                                                               */
/* ~~~~~~~~~~~~~~~~~                                                               */
/* Im NOT responsible for any damages or other abuse or illegal actions done       */
/* by/with this program. It is provided AS IS and it is your risk to use it.       */
/* You may freely distribute this program or parts of it as long as you don't      */
/* modify the "IMPORTANT NOTICE" section of this file.                             */
/*                                                                                 */
/*  This file includes WMFA remote control functions.                              */
/*                                                                                 */
/***********************************************************************************/


#ifndef NETSERV_CPP
#define NETSERV_CPP

#include <windows.h>
#include <winsock2.h>

BYTE theCmd;
DWORD Param1;
DWORD Param2;
DWORD Param3;
DWORD Param4;
DWORD Param5;
DWORD Param6;
DWORD Ret;
SOCKET TheRmtSocket = INVALID_SOCKET;
bool RmtConnected = false;

DWORD TheRecv(DWORD TheHandle, void* Buffer, DWORD Length);
DWORD TheSend(DWORD TheHandle, void* Buffer, DWORD Length);

// --------------------------------------------------------------------------

DWORD TheRecv(DWORD TheHandle, void* Buffer, DWORD Length)
{
    return ((DWORD) recv((SOCKET) TheHandle, (char*) Buffer, Length, 0));
}

DWORD TheSend(DWORD TheHandle, void* Buffer, DWORD Length)
{
    return ((DWORD) send((SOCKET) TheHandle, (char*) Buffer, Length, 0));
}

// --------------------------------------------------------------------------

bool RmtDoConnect(DWORD IP, WORD Port)
{
    if (RmtConnected) return false;
    long rc;
    SOCKADDR_IN addr;
    TheRmtSocket = socket(AF_INET, SOCK_STREAM, 0);
    if (TheRmtSocket == INVALID_SOCKET)
        return false;
    memset(&addr,0,sizeof(SOCKADDR_IN));
    addr.sin_family=AF_INET;
    addr.sin_port=htons(Port);
    addr.sin_addr.s_addr = IP;
    rc=connect(TheRmtSocket,(SOCKADDR*)&addr,sizeof(SOCKADDR));
    if(rc==SOCKET_ERROR)
    {
        closesocket(TheRmtSocket);
        return false;
    }
    theCmd = RMT_REGISTERCLIENT;
    TheSend(TheRmtSocket, &theCmd, 1);
    RmtConnected = true;
    return true;
}

bool RmtDoDisconnect()
{
    if (!RmtConnected) return false;
    theCmd = RMT_UNREGISTERCLIENT;
    TheSend(TheRmtSocket, &theCmd, 1);
    theCmd = RMT_QUIT;
    TheSend(TheRmtSocket, &theCmd, 1);
    closesocket(TheRmtSocket);
    TheRmtSocket = INVALID_SOCKET;
    RmtConnected = false;
    return true;
}

SOCKET RmtAccept(SOCKET s, sockaddr* addr, int* addrlen)
{
    theCmd = RMT_ACCEPT;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, addr, sizeof(sockaddr));
    TheSend(TheRmtSocket, addrlen, 4);
    TheRecv(TheRmtSocket, addr, sizeof(sockaddr));
    TheRecv(TheRmtSocket, addrlen, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((SOCKET) Ret);
}

int RmtBind (SOCKET s, sockaddr* name, int namelen)
{
    theCmd = RMT_BIND;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, name, sizeof(sockaddr));
    TheSend(TheRmtSocket, &namelen, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

int RmtClosesocket(SOCKET s)
{
    theCmd = RMT_CLOSESOCKET;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

int RmtConnect(SOCKET s, sockaddr*  name, int namelen)
{
    theCmd = RMT_CONNECT;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, name, sizeof(sockaddr));
    TheSend(TheRmtSocket, &namelen, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

int RmtListen(SOCKET s, int backlog)
{
    theCmd = RMT_LISTEN;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, &backlog, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

int RmtRecv(SOCKET s, char* buf, int len, int flags)
{
    theCmd = RMT_RECV;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, &len, 4);
    TheSend(TheRmtSocket, &flags, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    TheRecv(TheRmtSocket, buf, Ret);
    return ((int) Ret);
}

int RmtRecvfrom(SOCKET s, char* buf, int len, int flags, sockaddr* from,
  int* fromlen)
{
    theCmd = RMT_RECVFROM;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, &len, 4);
    TheSend(TheRmtSocket, &flags, 4);
    TheSend(TheRmtSocket, from, sizeof(sockaddr));
    TheSend(TheRmtSocket, fromlen, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    TheRecv(TheRmtSocket, buf, Ret);
    TheRecv(TheRmtSocket, from, sizeof(sockaddr));
    TheRecv(TheRmtSocket, fromlen, 4); 
    return ((int) Ret);
}

int RmtSelect(int nfds, SOCKET* readsocket, SOCKET* writesocket, SOCKET* exceptsocket,
  timeval* timeout)
{
    theCmd = RMT_SELECT;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &nfds, 4);
    TheSend(TheRmtSocket, readsocket, 4);
    TheSend(TheRmtSocket, writesocket, 4);
    TheSend(TheRmtSocket, exceptsocket, 4);
    TheSend(TheRmtSocket, timeout, sizeof(timeval));
    TheRecv(TheRmtSocket, readsocket, 4);
    TheRecv(TheRmtSocket, writesocket, 4);
    TheRecv(TheRmtSocket, exceptsocket, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

int RmtSend(SOCKET s, char* buf, int len, int flags)
{
    theCmd = RMT_SEND;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, &len, 4);
    TheSend(TheRmtSocket, buf, len);
    TheSend(TheRmtSocket, &flags, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

int RmtSendto (SOCKET s, char* buf, int len, int flags, sockaddr* to,
  int tolen)
{
    theCmd = RMT_SENDTO;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, &len, 4);
    TheSend(TheRmtSocket, buf, len);
    TheSend(TheRmtSocket, &flags, 4);
    TheSend(TheRmtSocket, to, sizeof(sockaddr));
    TheSend(TheRmtSocket, &tolen, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

SOCKET RmtSocket(int af, int type, int protocol)
{
    theCmd = RMT_SOCKET;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &af, 4);
    TheSend(TheRmtSocket, &type, 4);
    TheSend(TheRmtSocket, &protocol, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((SOCKET) Ret);
}

int RmtGetpeername(SOCKET s, sockaddr* name, int* namelen)
{
    theCmd = RMT_GETPEERNAME;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, name, sizeof(sockaddr));
    TheSend(TheRmtSocket, namelen, 4);
    TheRecv(TheRmtSocket, name, sizeof(sockaddr));
    TheRecv(TheRmtSocket, namelen, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

int RmtGetsockname(SOCKET s, sockaddr* name, int* namelen)
{
    theCmd = RMT_GETSOCKNAME;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, name, sizeof(sockaddr));
    TheSend(TheRmtSocket, namelen, 4);
    TheRecv(TheRmtSocket, name, sizeof(sockaddr));
    TheRecv(TheRmtSocket, namelen, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

int RmtIoctlsocket(SOCKET s, long cmd, DWORD* argp)
{
    theCmd = RMT_IOCTLSOCKET;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, &cmd, 4);
    TheSend(TheRmtSocket, argp, 4);
    TheRecv(TheRmtSocket, argp, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

int RmtShutdown(SOCKET s, int how)
{
    theCmd = RMT_SHUTDOWN;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, &how, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

int RmtGetsockopt (SOCKET s, int level, int optname, char* optval, int* optlen)
{
    theCmd = RMT_GETSOCKOPT;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, &level, 4);
    TheSend(TheRmtSocket, &optname, 4);
    TheSend(TheRmtSocket, optlen, 4);
    TheRecv(TheRmtSocket, optlen, 4);
    TheRecv(TheRmtSocket, optval, *optlen);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

int RmtSetsockopt (SOCKET s, int level, int optname, char* optval, int optlen)
{
    theCmd = RMT_SETSOCKOPT;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &s, 4);
    TheSend(TheRmtSocket, &level, 4);
    TheSend(TheRmtSocket, &optname, 4);
    TheSend(TheRmtSocket, &optlen, 4);
    TheSend(TheRmtSocket, optval, optlen);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

ULONG RmtCodeResv(ULONG Size)
{
    theCmd = RMT_CODE_RESV;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &Size, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

ULONG RmtCodeFree(ULONG CodeID)
{
    theCmd = RMT_CODE_FREE;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &CodeID, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

ULONG RmtCodeRead(ULONG CodeID, char* buffer, ULONG BufferSize)
{
    theCmd = RMT_CODE_READ;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &CodeID, 4);
    TheSend(TheRmtSocket, &BufferSize, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    if (Ret != (ULONG)-1)
        TheRecv(TheRmtSocket, buffer, Ret);
    return ((int) Ret);
}

ULONG RmtCodeWrite(ULONG CodeID, char* buffer, ULONG BufferSize)
{
    theCmd = RMT_CODE_WRITE;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &CodeID, 4);
    TheSend(TheRmtSocket, &BufferSize, 4);
    TheSend(TheRmtSocket, buffer, BufferSize);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

ULONG RmtCodeGetAddress(ULONG CodeID)
{
    theCmd = RMT_CODE_GET_ADDRESS;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &CodeID, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

ULONG RmtCodeExec(ULONG CodeID, ULONG Param)
{
    theCmd = RMT_CODE_EXEC;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &CodeID, 4);
    TheSend(TheRmtSocket, &Param, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

ULONG RmtCodeFixGetAddress()
{
    theCmd = RMT_CODE_FIX_GET_ADDRESS;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

ULONG RmtCodeFixExec(char* buffer, ULONG BufferSize, ULONG Param)
{
    theCmd = RMT_CODE_FIX_EXEC;
    TheSend(TheRmtSocket, &theCmd, 1);
    TheSend(TheRmtSocket, &BufferSize, 4);
    TheSend(TheRmtSocket, buffer, BufferSize);
    TheSend(TheRmtSocket, &Param, 4);
    TheRecv(TheRmtSocket, &Ret, 4);
    return ((int) Ret);
}

#endif
