/***********************************************************************************/
/*                                                                                 */
/*  WMFACONNC.cpp - WMFA Connection Program                                        */
/*  ~~~~~~~~~~~~~~~~~~~~~~~~~                                                      */
/*                                                                                 */
/* IMPORTANT NOTICE:                                                               */
/* ~~~~~~~~~~~~~~~~~                                                               */
/* Im NOT responsible for any damages or other abuse or illegal actions done       */
/* by/with this program. It is provided AS IS and it is your risk to use it.       */
/* You may freely distribute this program or parts of it as long as you don't      */
/* modify the "IMPORTANT NOTICE" section of this file.                             */
/*                                                                                 */
/*  This program establishes a connection via WMFA.                                */
/*                                                                                 */
/*  Compile as follows with Borland(tm) compiler:		                   */
/*  bcc32 WMFACONNC.cpp                                                            */
/*                                                                                 */
/*                                                                                 */
/***********************************************************************************/

//---------------------------------------------------------------------------
#include <windows.h>
#include <winsock2.h>
#include <fstream.h>
#include <conio.h>
#include "WMFA.h"
#pragma hdrstop
#define USEFUL_STRING
#include "useful.h"
#include "WMFA.cpp"


  bool wait = false;
  long rc;
  SOCKET acceptSocket;
  SOCKET ClientSocket;
  SOCKET ServerSocket;
  char* Clientrcv;
  char* ClientPort;
  USHORT ClientPortVal = 0;
  bool * corr;
  SOCKADDR_IN addr;
  char* Serverrcv;
  char* ServerPort;
  char* IP;
  USHORT ServerPortVal = 0;
  USHORT RemotePortVal = 0;
  in_addr theAddr;
  in_addr RemoteAddr;
  hostent* phe;
  HANDLE hLog;
  DWORD BytesWritten = 0;
  bool disc = false;
//---------------------------------------------------------------------------

int startWinsock(void)
{
  WSADATA wsa;
  return WSAStartup(MAKEWORD(2,0),&wsa);
}


DWORD WINAPI DataThread(LPVOID junk);


#pragma argsused
int main(int argc, char* argv[])
{
    DeleteFile("ConncLog.txt");
    hLog = CreateFile("ConncLog.txt", GENERIC_WRITE, 0, NULL,
      CREATE_NEW, FILE_ATTRIBUTE_NORMAL, 0);
  Clientrcv = new char[0x1024];
  ClientPort = new char[10];
  corr = new bool;
  Serverrcv = new char[1024];
  ServerPort = new char[10];
  IP = new char[100];
  // Winsock starten
  rc=startWinsock();
  if(rc!=0)
  {
    printf("Fehler: startWinsock, fehler code: %d\n",rc);
    return 1;
  }
  else
  {
    printf("Winsock gestartet!\n");
  }

  cout << "Remote Server Port: ";
  GetStr(ServerPort, 6);
  RemotePortVal = StrToVal(ServerPort, corr);
  cout << "\nRemote Server IP: ";
  GetStr(IP, 100);
    phe = gethostbyname((char*) (IP));
    if (phe)
    {
        memcpy(&RemoteAddr, phe->h_addr_list[0], sizeof(in_addr));
        cout << "\n Remote Address: " << inet_ntoa(RemoteAddr);
    }
    else
    {
        cout << "\n Error";
        getch();
        WSACleanup();
        return 0;
    }

  if (RmtDoConnect(RemoteAddr.S_un.S_addr, RemotePortVal) == false)
  {
    cout << "\n  Remote Connection Error";
    getch();
    delete[] Clientrcv;
    delete[] ClientPort;
    delete corr;
    delete[] Serverrcv;
    delete[] ServerPort;
    delete[] IP;
    WSACleanup();
    return -1;
  }


  cout << "\nClientPort: ";
  GetStr(ClientPort, 6);
  ClientPortVal = StrToVal(ClientPort, corr);

  cout << "\nReal ServerPort: ";
  GetStr(ServerPort, 6);
  ServerPortVal = StrToVal(ServerPort, corr);
  cout << "\nReal Server IP: ";
  GetStr(IP, 100);
    phe = gethostbyname((char*) (IP));
    if (phe)
    {
        memcpy(&theAddr, phe->h_addr_list[0], sizeof(in_addr));
        cout << "\n Address: " << inet_ntoa(theAddr);
    }
    else
    {
        cout << "\n Error";
        getch();
        WSACleanup();
        return 0;
    }


  // Socket erstellen
  acceptSocket=RmtSocket(AF_INET,SOCK_STREAM,0);
  // Socket binden
  memset(&addr,0,sizeof(SOCKADDR_IN));
  addr.sin_family=AF_INET;
  addr.sin_port=htons(ClientPortVal);
  addr.sin_addr.s_addr=ADDR_ANY;
  rc=RmtBind(acceptSocket,(SOCKADDR*)&addr,sizeof(SOCKADDR_IN));
  if(rc==SOCKET_ERROR)
  {
    printf("Fehler: bind, fehler code: %d\n",WSAGetLastError());
    return 1;
  }
  // In den listen Modus
  rc=RmtListen(acceptSocket,10);
  if(rc==SOCKET_ERROR)
  {
    printf("Fehler: listen, fehler code: %d\n",WSAGetLastError());
    return 1;
  }
  else
  {
    printf("acceptSocket ist im listen Modus....\n");
  }

  sockaddr x;
  memset(&x, 0, sizeof(sockaddr));
  int namelen = sizeof(sockaddr);
  // Verbindung annehmen
  ClientSocket=RmtAccept(acceptSocket,&x, &namelen);
  {
    printf("Neue Verbindung wurde akzeptiert!\n");
  }

  ServerSocket=RmtSocket(AF_INET,SOCK_STREAM,0);
  {
    printf("Socket erstellt!\n");
  }

  // Socket verbinden
  memset(&addr,0,sizeof(SOCKADDR_IN));
  addr.sin_family=AF_INET;
  addr.sin_port=htons(ServerPortVal);
  addr.sin_addr.S_un.S_addr = theAddr.S_un.S_addr;
  rc=RmtConnect(ServerSocket,(SOCKADDR*)&addr,sizeof(SOCKADDR_IN));
  if(rc==SOCKET_ERROR)
  {
    printf("Fehler: bind, fehler code: %d\n",WSAGetLastError());
    return 1;
  }
  else
  {
    printf("ServerSocket an port %d verbunden\n", ServerPortVal);
  }

    DWORD tid;
    HANDLE hData = CreateThread(NULL, 0, &DataThread, 0, 0, &tid);

    WaitForSingleObject(hData, INFINITE);

    CloseHandle(hLog);
    RmtClosesocket(acceptSocket);
    RmtClosesocket(ServerSocket);
    RmtClosesocket(ClientSocket);
    delete[] Clientrcv;
    delete corr;
    delete[] ClientPort;
    delete[] Serverrcv;
    delete[] ServerPort;
    delete[] IP;
    RmtDoDisconnect();
    WSACleanup();
    return 0;
}
//---------------------------------------------------------------------------

DWORD WINAPI DataThread(LPVOID junk)
{
    timeval y;
    y.tv_sec = 0;
    y.tv_usec = 0;
    SOCKET a, b = INVALID_SOCKET, c = INVALID_SOCKET;
    for(;;)
    {
        if (disc) break;
        a = ServerSocket;
        b = INVALID_SOCKET;
        c = INVALID_SOCKET;
        RmtSelect(0, &a, &b, &c, &y);
        if (a == ServerSocket)
        {
            rc = RmtRecv(ServerSocket, Serverrcv, 1024, 0);
            if ((rc != SOCKET_ERROR) && (rc != 0))
            {
                Serverrcv[rc] = '\0';
                char tmp = 0;
                USHORT tmpTwo  = 0;
                cout << "\nServer sent:\n";
                WriteFile(hLog, "\015\012Server sent:\015\12", 16, &BytesWritten, 0);
                WriteFile(hLog, Serverrcv, rc, &BytesWritten, 0);
                tmpTwo = 0;
                char* tmpThre = 0;
                for (long i = 0; i < rc; i++)
                {
                    tmp = Serverrcv[i];
                    tmpTwo = tmp;
                    if (tmpTwo < 16)
                     cout << "0";
                    tmpThre = DecToHex(tmpTwo);
                    cout << tmpThre;
                    cout << " ";
                    delete[] tmpThre;
                }
                cout << "\nDispatch... \n";
                RmtSend(ClientSocket, Serverrcv, rc, 0);
                cout << "\nFinish\n";
            }
            else
            {
                disc = true;
                return 0;
            }
        }
        else
        {
            a = ServerSocket;
        }
        // Client
        if (disc) break;
        a = ClientSocket;
        b = INVALID_SOCKET;
        c = INVALID_SOCKET;
        RmtSelect(0, &a, &b, &c, &y);
        if (a == ClientSocket)
        {
            rc = RmtRecv(ClientSocket, Clientrcv, 1024, 0);
            if ((rc != SOCKET_ERROR) && (rc != 0))
            {
                Clientrcv[rc] = '\0';
                char tmp = 0;
                USHORT tmpTwo  = 0;
                cout << "\nClient sent:\n";
                WriteFile(hLog, "\015\012Client sent:\015\012", 16, &BytesWritten, 0);
                WriteFile(hLog, Clientrcv, rc, &BytesWritten, 0);
                tmpTwo = 0;
                char* tmpThre = 0;
                for (long i = 0; i < rc; i++)
                {
                    tmp = Clientrcv[i];
                    tmpTwo = tmp;
                    if (tmpTwo < 16)
                     cout << "0";
                    tmpThre = DecToHex(tmpTwo);
                    cout << tmpThre;
                    cout << " ";
                    delete[] tmpThre;
                }
                cout << "\nDispatch... \n";
                RmtSend(ServerSocket, Clientrcv, rc, 0);
                cout << "\nFinish\n";
            }
            else
            {
                disc = true;
                return 0;
            }
        }
        else
        {
            a = ClientSocket;
        }
    }
    return 0;
}

