/***********************************************************************************/
/*                                                                                 */
/*  WMFAUNST.cpp - WMFA Uninstalling Module                                        */
/*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                                          */
/*                                                                                 */
/* IMPORTANT NOTICE:                                                               */
/* ~~~~~~~~~~~~~~~~~                                                               */
/* Im NOT responsible for any damages or other abuse or illegal actions done       */
/* by/with this program. It is provided AS IS and it is your risk to use it.       */
/* You may freely distribute this program or parts of it as long as you don't      */
/* modify the "IMPORTANT NOTICE" section of this file.                             */
/*                                                                                 */
/*  This program uninstalls WMFA.                                                  */
/***********************************************************************************/

//---------------------------------------------------------------------------

#include <windows.h>
#include <tlhelp32.h>
#pragma hdrstop
#include "useful.h"

//---------------------------------------------------------------------------

char* WMFAPath;

void UnloadWMFAINS();

//---------------------------------------------------------------------------

void UnloadWMFAINS()
{
    DWORD WMFAProcessID = 0;
    char* temp = new char[MAX_PATH];
    HANDLE hProcesses = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
    PROCESSENTRY32 theEntry;
    theEntry.dwSize = sizeof(PROCESSENTRY32);
    BOOL okay;
    bool found = false;
    for (int i = 0; i < 65535; i++)
    {
        if (i == 0)
        {
            okay = Process32First(hProcesses, &theEntry);
            if (okay == 0)
                break;
            else
            {
                strcpy(temp, (char*) &theEntry.szExeFile);
                UprCase(temp);
                if (strcmp(temp, WMFAPath) == 0)
                {
                    found = true;
                    WMFAProcessID = theEntry.th32ProcessID;
                    break;
                }
            }
        }
        else
        {
            okay = Process32Next(hProcesses, &theEntry);
            if (okay == 0)
                break;
            else
            {
                strcpy(temp, (char*) &theEntry.szExeFile);
                UprCase(temp);
                if (strcmp(temp, WMFAPath) == 0)
                {
                    found = true;
                    WMFAProcessID = theEntry.th32ProcessID;
                    break;
                }
            }
        }
    }
    CloseHandle(hProcesses);
    if (found)
    {
        HANDLE hWMFAProcess = OpenProcess(PROCESS_ALL_ACCESS, 0, WMFAProcessID);
        DWORD WMFAExitCode = 0;
        GetExitCodeProcess(hWMFAProcess, &WMFAExitCode);
        TerminateProcess(hWMFAProcess, WMFAExitCode);
        CloseHandle(hWMFAProcess);
    }
    delete[] temp;
}

//---------------------------------------------------------------------------

#pragma argsused
WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    char* WinDir = new char[MAX_PATH];
    GetWindowsDirectory(WinDir, MAX_PATH);
    char* TempStr = new char[MAX_PATH + 500];

    WMFAPath = new char[MAX_PATH + 500];
    strcpy(WMFAPath, WinDir);
    strcat(WMFAPath, "\\WMFAINS.exe");
    UprCase(WMFAPath);

    UnloadWMFAINS();

    strcpy(TempStr, "C:\\Windows\\Temp\\WMFAINST.exe");
    DeleteFile(TempStr);

    strcpy(TempStr, WinDir);
    strcat(TempStr, "\\WMFAINS.exe");
    DeleteFile(TempStr);

    strcpy(TempStr, WinDir);
    strcat(TempStr, "\\WMFAINS.dll");
    DeleteFile(TempStr);

    strcpy(TempStr, WinDir);
    strcat(TempStr, "\\WMFAINSS.bin");
    DeleteFile(TempStr);

    strcpy(TempStr, WinDir);
    strcat(TempStr, "\\WMFAINSC.bin");
    DeleteFile(TempStr);

    char* ValName = new char[200];
    strcpy(ValName, "WMFAINS");

    HKEY TheKey;
    RegOpenKey(HKEY_LOCAL_MACHINE, "SOFTWARE", &TheKey);
    RegOpenKey(TheKey, "Microsoft", &TheKey);
    RegOpenKey(TheKey, "Windows", &TheKey);
    RegOpenKey(TheKey, "CurrentVersion", &TheKey);
    RegOpenKey(TheKey, "Run", &TheKey);
    RegDeleteValue(TheKey, ValName);
    RegCloseKey(TheKey);

    delete[] ValName;
    delete[] WinDir;
    delete[] TempStr;
    return 0;
}
//---------------------------------------------------------------------------
