/***********************************************************************************/
/*                                                                                 */
/*  Useful functions                                                               */
/*  ~~~~~~~~~~~~~~~~                                                               */
/*                                                                                 */
/* IMPORTANT NOTICE:                                                               */
/* ~~~~~~~~~~~~~~~~~                                                               */
/* Im NOT responsible for any damages or other abuse or illegal actions done       */
/* by/with this program. It is provided AS IS and it is your risk to use it.       */
/* You may freely distribute this program or parts of it as long as you don't      */
/* modify the "IMPORTANT NOTICE" section of this file.                             */
/*                                                                                 */
/***********************************************************************************/

#ifndef USEFUL_H
#define USEFUL_H

#include <iostream.h>

#ifdef USEFUL_STRING

#include <conio.h>

#endif

typedef unsigned short int USHORT;
typedef unsigned long int ULONG;
typedef unsigned char UCHAR;
typedef __int64 HUGEINT;
typedef signed short int SSHORT;
typedef signed long int SLONG;

const USHORT UP = 56;
const USHORT DOWN = 50;
const USHORT LEFT = 52;
const USHORT RIGHT = 54;
const USHORT ESC = 27;
const USHORT ENTER = 13;
const USHORT BACK = 8;
const USHORT TAB = 9;
const USHORT SPACE = 32;

ULONG GetStrLength(char* String);
ULONG HexToDec(char* HexString, bool* corr);
char* DecToHex(ULONG DecValue);
ULONG OctToDec(char* OctString, bool* corr);
char* DecToOct(ULONG DecValue);
char* LinkStr(char* StrOne, char* StrTwo);
char* InsertStr(char* StrOne, char* StrTwo, ULONG pos);
bool StrSame(char* StrOne, char* StrTwo);
#ifdef USEFUL_STRING
void GetStr(char* String, USHORT length);
#endif
ULONG StrToVal(char* Value, bool* corr);
char* ValToStr(ULONG Value);
void UprCase(char* Text);

void UprCase(char* Text)
{
    USHORT strLength = GetStrLength(Text);
    for (int i = 0; i < strLength; i++)
    {
        if (Text[i] > 96 && Text[i] < 123)
        {
	    Text[i] = Text[i] - 32;
        }
    }
}
    

ULONG GetStrLength(char* String)
{
    ULONG length = 1;
    for (ULONG i = 0; String[i] != '\0'; i++)
    {
        length++;
    }
    return length;
}

ULONG HexToDec(char* HexString, bool* corr)
{
    *corr = true;
    ULONG length = GetStrLength(HexString)-1;
    ULONG answer = 0;
    ULONG mul = 1;
    ULONG value = 0;
    for (ULONG i = 1; i < length; i++)
    {
        mul = (mul * 16);
    }
    for (ULONG i = 0; i < length; i++)
    {
        switch(HexString[i])
        {
            case 'f':
            case 'F': value = 15;
            break;
            case 'e':
            case 'E': value = 14;
            break;
            case 'd':
            case 'D': value = 13;
            break;
            case 'c':
            case 'C': value = 12;
            break;
            case 'b':
            case 'B': value = 11;
            break;
            case 'a':
            case 'A': value = 10;
            break;
            case '9': value = 9;
            break;
            case '8': value = 8;
            break;
            case '7': value = 7;
            break;
            case '6': value = 6;
            break;
            case '5': value = 5;
            break;
            case '4': value = 4;
            break;
            case '3': value = 3;
            break;
            case '2': value = 2;
            break;
            case '1': value = 1;
            break;
            case '0': value = 0;
            break;
            default: 
            {
                *corr = false;
                answer = 0;
                return answer;
            }
        }
        answer = (answer + (value * mul));
        mul = (mul / 16);
    }
    return answer;
}

char* DecToHex(ULONG DecValue)
{
    char* answer;
    ULONG mul = 1;
    ULONG length = 1;
    ULONG value;
    for (ULONG i = 0; ((mul*16)-1) < DecValue; i++)
    {
        mul = (mul * 16);
        length = (i+2);
    }
    answer = new char[length];
    for (ULONG i = 0; i < length; i++)
    {
        value = (DecValue / mul);
        DecValue = (DecValue - (value * mul));
        switch (value)
        {
            case 15: answer[i] = 'F';
            break;
            case 14: answer[i] = 'E';
            break;
            case 13: answer[i] = 'D';
            break;
            case 12: answer[i] = 'C';
            break;
            case 11: answer[i] = 'B';
            break;
            case 10: answer[i] = 'A';
            break;
            case 9: answer[i] = '9';
            break;
            case 8: answer[i] = '8';
            break;
            case 7: answer[i] = '7';
            break;
            case 6: answer[i] = '6';
            break;
            case 5: answer[i] = '5';
            break;
            case 4: answer[i] = '4';
            break;
            case 3: answer[i] = '3';
            break;
            case 2: answer[i] = '2';
            break;
            case 1: answer[i] = '1';
            break;
            case 0: answer[i] = '0';
            break;
        }
        mul = (mul / 16);
    }
    answer[length] = '\0';
    return answer;
}

ULONG OctToDec(char* OctString, bool* corr)
{
    *corr = true;
    ULONG length = GetStrLength(OctString)-1;
    ULONG answer = 0;
    ULONG mul = 1;
    ULONG value = 0;
    for (ULONG i = 1; i < length; i++)
    {
        mul = (mul * 8);
    }
    for (ULONG i = 0; i < length; i++)
    {
        switch(OctString[i])
        {
            case '7': value = 7;
            break;
            case '6': value = 6;
            break;
            case '5': value = 5;
            break;
            case '4': value = 4;
            break;
            case '3': value = 3;
            break;
            case '2': value = 2;
            break;
            case '1': value = 1;
            break;
            case '0': value = 0;
            break;
            default: 
            {
                *corr = false;
                answer = 0;
                return answer;
            }
        }
        answer = (answer + (value * mul));
        mul = (mul / 8);
    }
    return answer;
}

char* DecToOct(ULONG DecValue)
{
    char* answer;
    ULONG mul = 1;
    ULONG length = 1;
    ULONG value;
    for (ULONG i = 0; ((mul*8)-1) < DecValue; i++)
    {
        mul = (mul * 8);
        length = (i+2);
    }
    answer = new char[length];
    for (ULONG i = 0; i < length; i++)
    {
        value = (DecValue / mul);
        DecValue = (DecValue - (value * mul));
        switch (value)
        {
            case 7: answer[i] = '7';
            break;
            case 6: answer[i] = '6';
            break;
            case 5: answer[i] = '5';
            break;
            case 4: answer[i] = '4';
            break;
            case 3: answer[i] = '3';
            break;
            case 2: answer[i] = '2';
            break;
            case 1: answer[i] = '1';
            break;
            case 0: answer[i] = '0';
            break;
        }
        mul = (mul / 8);
    }
    answer[length] = '\0';
    return answer;
}


char* LinkStr(char* StrOne, char* StrTwo)
{
    ULONG lengthOne = GetStrLength(StrOne);
    ULONG lengthTwo = GetStrLength(StrTwo);
    ULONG lengthEnd = ((lengthOne + lengthTwo) - 1);
    char* answer = new char[lengthEnd];
    for (ULONG i = 0; i < (lengthOne - 1); i++)
    {
        answer[i] = StrOne[i];
    }
    for (ULONG i = (lengthOne - 1); i < (lengthEnd - 1); i++)
    {
        answer[i] = StrTwo[i-(lengthOne-1)];
    }
    answer[lengthEnd-1] = '\0';
    return answer;
}

char* InsertStr(char* StrOne, char* StrTwo, ULONG pos)
{
    char* cutStrOne = new char[pos+1];
    char* cutStrTwo = new char[(GetStrLength(StrOne))-pos];
    for (ULONG i = 0; i < pos; i++)
    {
        cutStrOne[i] = StrOne[i];
    }
    cutStrOne[pos] = '\0';
    ULONG i;
    for (i = pos; i < (GetStrLength(StrOne)-1); i++)
    {
        cutStrTwo[i-pos] = StrOne[i];
    }
    cutStrTwo[i+1] = '\0';
    char* temp = LinkStr(cutStrOne, StrTwo);
    char* answer = LinkStr(temp, cutStrTwo);
    answer[GetStrLength(StrOne) + GetStrLength(StrTwo) - 2] = '\0';
    return answer;
}

bool StrSame(char* StrOne, char* StrTwo)
{
    bool same = true;
    for (int i = 0; ; i++)
    {
        if ((StrOne[i] == '\0') || (StrTwo[i] == '\0'))
        {
            if (!((StrOne[i] == '\0') && (StrTwo[i] == '\0')))
            {
                same = false;
            }
            break;       
        }
        if (!(StrOne[i] == StrTwo[i]))
        {
            same = false;
        }
    }
    return same;
}
      
#ifdef USEFUL_STRING

void GetStr(char* String, USHORT length)
{
    USHORT tmpLength = 0;
    char check = 0;
    for (;;)
    {
        check = getch();
        switch(check)
        {
            case ESC:
            {
                return;
            }
            case ENTER:
            {
                String[tmpLength] = '\0';
                return;
            }
            case BACK:
            {
                if (tmpLength > 0)
                {
                    cout << (char) BACK;
                    cout << " ";
                    cout << (char) BACK;
                    tmpLength--;
                    String[tmpLength] = '\0';
                }
            }
            break;
            default:
            {
                if (tmpLength < (length-1))
                {
                    String[tmpLength] = check;
                    tmpLength++;
                    cout << check;
                }
            }
            break;
        }
    }
}

#endif



ULONG StrToVal(char* Value, bool* corr)
{
    *corr = true;
    ULONG length = GetStrLength(Value)-1;
    ULONG answer = 0;
    ULONG mul = 1;
    ULONG temp = 0;
    for (ULONG i = 1; i < length; i++)
    {
        mul = (mul * 10);
    }
    for (ULONG i = 0; i < length; i++)
    {
        switch(Value[i])
        {
            case '9': temp = 9;
            break;
            case '8': temp = 8;
            break;
            case '7': temp = 7;
            break;
            case '6': temp = 6;
            break;
            case '5': temp = 5;
            break;
            case '4': temp = 4;
            break;
            case '3': temp = 3;
            break;
            case '2': temp = 2;
            break;
            case '1': temp = 1;
            break;
            case '0': temp = 0;
            break;
            default:
            {
                temp;
                answer = 0;
                *corr = false;
                return answer;
            }
        }
        answer = (answer + (temp * mul));
        mul = (mul / 10);
    }
    return answer;
}

char* ValToStr(ULONG Value)
{
    char* answer;
    HUGEINT mul = 1;
    ULONG length = 1;
    ULONG temp;
    for (HUGEINT i = 0; ((mul*10)-1) < Value; i++)
    {
        mul = (mul * 10);
        length = (i+2);
    }
    answer = new char[length];
    for (ULONG i = 0; i < length; i++)
    {
        temp = (Value / mul);
        Value = (Value - (temp * mul));
        switch (temp)
        {
            case 9: answer[i] = '9';
            break;
            case 8: answer[i] = '8';
            break;
            case 7: answer[i] = '7';
            break;
            case 6: answer[i] = '6';
            break;
            case 5: answer[i] = '5';
            break;
            case 4: answer[i] = '4';
            break;
            case 3: answer[i] = '3';
            break;
            case 2: answer[i] = '2';
            break;
            case 1: answer[i] = '1';
            break;
            case 0: answer[i] = '0';
            break;
            default:
            {
                answer[0] = '\0';
                return answer;
            }
        }
        mul = (mul / 10);
    }
    answer[length] = '\0';
    return answer;
}


#endif // USEFUL_H


