/*
    General HTTP Server Class
    Copyright (C) 2002 Ayan Chakrabarti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    http.cpp
    ========

    Implementation of the http classes.
*/

#include <windows.h>
#include <winsock.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "http.h"
#include "slist.h"
#include "offlist.h"
#include "utils.h"

HTTPServer::HTTPServer()
{
        Server();
        setPort(80);
}


void fixhex(char & c)
{
        if(c >= '0' && c <= '9')
                c -= '0';
        else if(c >= 'a' && c <= 'a')
                c = c + 10 - 'a';
        else
                c = c + 10 - 'A';
}

void parseContent(char * params, HTTPRequest& h)
{
        char key[1024];
        char value[1024];
        char c1,c2;
        int flag = 1, i = 0;
        char * dest = key;

        while(flag)
        {
                switch(params[i])
                {
                        case '=':       *dest = '\0';
                                        dest = value;
                                        break;

                        case '\0':      flag = 0;

                        case '&':       *dest = '\0';
                                        h.postVars.addList(key,value);
                                        dest = key;
                                        break;

                        case '%':       c1 = params[++i];

                                        if(c1 == '%')
                                                *(dest++) = '%';
                                        else
                                        {
                                                c2 = params[++i];

                                                fixhex(c1);
                                                fixhex(c2);
                                                *(dest++) = c1*16+c2;
                                        }
                                        break;

                        case '+':       *(dest++) = ' ';
                                        break;
                                 
                        default:        *(dest++) = params[i];
                }
                i++;
        }
}

void parseUrl(char * s, HTTPRequest& h)
{
        int i;
        char * params;

        params = strchr(s,'?');
        if(params != NULL)
        {
                *params = '\0';
                params++;
        }

        strcpy(h.url,s);

        if(params != NULL)
        {
                char key[1024];
                char value[1024];
                char c1,c2;
                int flag = 1;

                i = 0;

                char * dest = key;

                while(flag)
                {
                        switch(params[i])
                        {
                                case '=':       *dest = '\0';
                                                dest = value;
                                                break;

                                case '\0':      flag = 0;

                                case '&':       *dest = '\0';
                                                h.getVars.addList(key,value);
                                                dest = key;
                                                break;

                                case '%':       c1 = params[++i];

                                                if(c1 == '%')
                                                        *(dest++) = '%';
                                                else
                                                {
                                                        c2 = params[++i];

                                                        fixhex(c1);
                                                        fixhex(c2);
                                                        *(dest++) = c1*16+c2;
                                                }
                                                break;
                                 
                                case '+':       *(dest++) = ' ';
                                                break;

                                default:        *(dest++) = params[i];
                        }
                        i++;
                }
        }

}

void gettempname(char * a)
{
        char c[4];

        strcpy(a,"~1GHT");
        srand(time(NULL));
        c[0] = 'a' + rand() % 26;
        c[1] = 'a' + rand() % 26;
        c[2] = 'a' + rand() % 26;
        c[3] = '\0';
        strcat(a,c);
}

int myfgets(FILE * fp, char * str)
{
        int i = 0,ch;

        ch = fgetc(fp);

        while(ch != -1 && ch != '\r' && ch != '\n' && i < 1023)
        {
                str[i++] = ch;
                ch = fgetc(fp);
        }

        switch(ch)
        {
                case '\r':      str[i++] = ch;
                                str[i++] = fgetc(fp);
                                break;
                case '\n':      str[i++] = ch;
        }

        str[i] = '\0';

        return i;
}

void parsePOSTfile(char * file, OffList & l)
{
        char buf[1024],boundary[1024],name[1024];
        unsigned long start,sz;
        FILE * fp;

        fp = fopen(file,"rb");

        myfgets(fp,boundary);

        if(strchr(boundary,'\r'))
                *strchr(boundary,'\r') = '\0';

        if(strchr(boundary,'\n'))
                *strchr(boundary,'\n') = '\0';


        do
        {
                myfgets(fp,buf);
        } while(!feof(fp) && strstr(buf,boundary) == NULL);


        while(!feof(fp) && *(strstr(buf,boundary)+strlen(boundary)) != '-')
        {
                char * p;
                myfgets(fp,buf);
                p = strstr(buf,"name=\"");
                if(p == NULL)
                        break;
                p+=strlen("name=\"");
                if(strchr(p,'\"') == NULL)
                        break;
                *strchr(p,'\"') = '\0';
                strcpy(name,p);

                do
                {
                        myfgets(fp,buf);
                }
                while(!feof(fp) && buf[0] != '\0' && buf [0] != '\r' && buf[0] != '\n');

                if(feof(fp))
                        break;

                start = ftell(fp);

                int x = - 1;
                do
                {
                        sz = ftell(fp);

                        if(x >= 1)
                                if(buf[x-1] == '\n')
                                        sz--;
                        if(x >= 2)
                                if(buf[x-2] == '\r')
                                        sz--;       

                        x = myfgets(fp,buf);
                } while(!feof(fp) && strstr(buf,boundary) == NULL);

                sz -= start;
                l.addList(name,start,sz);
        }

        fclose(fp);
}



void HTTPServer::serveRequest(SOCKET s)
{
        lineSocket inSock;
        char buf[1024], *t, *t2;
        HTTPRequest h;

        inSock.setSocket(s);

        if(!inSock.readLine(buf,30))
        {
                closesocket(s);
                return;
        }

        t = strchr(buf,' ');
        if(t == NULL)
        {
                closesocket(s);
                return;
        }

        *t = '\0';
        t++;
        strcpy(h.method,buf);

        t2 = strchr(t,' ');

        if(t2 != NULL)
                *t2 = '\0';

        if(strcmp(h.method,"GET") == 0)
                parseUrl(t,h);
        else
                strcpy(h.url,t);

        if(t2 != NULL)
                while(1)
                {
                        if(!inSock.readLine(buf,30))
                        {
                                closesocket(s);
                                return;
                        }

                        if(buf[0] == '\0')
                                break;

                        t = strchr(buf,':');
                        *t = '\0';

                        do
                        {
                                t++;
                        } while(*t == ' ');

                        h.headers.addList(buf,t);
                }

        h.headers.searchList("Content-Type",buf);
        h.filename[0] = '\0';

        if(strcmpi(buf,"application/x-www-form-urlencoded") == 0)
        {
                int size,i;

                h.headers.searchList("Content-Length",buf);

                for(i = 0, size = 0;buf[i] != '\0';i++)
                        size = size * 10 + buf[i] - '0';

                if(size > 1023)
                {
                        closesocket(s);
                        return;
                }

                i = inSock.flush(buf);

                if(i < size)
                {
                        if(!isreadable(s,30))
                        {
                                closesocket(s);
                                return;
                        }

                        i += recv(s,buf,size-i,0);

                        if(i < size)
                        {
                                closesocket(s);
                                return;
                        }
                }

                buf[size] = '\0';

                parseContent(buf,h);
        }
        else if(strncmpi(buf,"multipart/form-data",19) == 0)
        {
                int size, i;
                char boundary[1024],*p,fname[1024];
                FILE * fp;

                p = strstr(buf,"boundary=");

                if(p == NULL)
                {
                        closesocket(s);
                        return;
                }

                p+=9;
                strcpy(boundary,p);

                gettempname(fname);
                fp = fopen(fname,"wb");

                h.headers.searchList("Content-Length",buf);

                for(i = 0, size = 0;buf[i] != '\0';i++)
                        size = size * 10 + buf[i] - '0';

                fwrite(boundary,strlen(boundary),1,fp);
                fwrite("\r\n",2,1,fp);

                i = inSock.flush(buf);
                fwrite(buf,i,1,fp);

                while(i < size)
                {
                        int t;

                        if(!isreadable(s,10))
                        {
                                fclose(fp);
                                closesocket(s);
                                return;
                        }

                        t = recv(s,buf,1023,0);
                        fwrite(buf,t,1,fp);
                        i+=t;
                }


                fclose(fp);
                strcpy(h.filename,fname);
                parsePOSTfile(fname,h.fpostVars);
        }

        showPage(h,s);

        if(h.filename[0] != '\0')
                DeleteFile(h.filename);
}

void HTTPServer::showPage(HTTPRequest & req, SOCKET s)
{
        char buf[1024];

        sendstring(s,"HTTP/1.0 200 OK\r\n");
        sendstring(s,"Content-type: text/html\r\n\r\n");
        sprintf(buf,"<PRE>Method: %s, URL: %s\r\n",req.method,req.url);
        sendstring(s,buf);

        sprintf(buf,"The GET CGI variables are\r\n");
        sendstring(s,buf);

        for(int i = 0;i < req.getVars.index;i++)
        {
                sprintf(buf,"%s = %s\r\n",req.getVars.keys[i],
                                          req.getVars.values[i]);
                sendstring(s,buf);
        }

        sprintf(buf,"\r\nThe POST CGI variables are\r\n");
        sendstring(s,buf);

        for(int i = 0;i < req.postVars.index;i++)
        {
                sprintf(buf,"%s = %s\r\n",req.postVars.keys[i],
                                          req.postVars.values[i]);
                sendstring(s,buf);
        }

        sprintf(buf,"\r\nThe extended POST CGI variables are\r\n");
        sendstring(s,buf);

        for(int i = 0;i < req.fpostVars.index;i++)
        {
                sprintf(buf,"%s = (%d,%d)\r\n",req.fpostVars.keys[i],
                                          *(req.fpostVars.starts[i]),
                                          *(req.fpostVars.szs[i]));
                sendstring(s,buf);
        }


        sprintf(buf,"\r\nThe HTTP headers are\r\n");
        sendstring(s,buf);

        for(int i = 0;i < req.headers.index;i++)
        {
                sprintf(buf,"%s = %s\r\n",req.headers.keys[i],
                                          req.headers.values[i]);
                sendstring(s,buf);
        }

        sendstring(s,"\r\nThis page is automatically generated by HTTPServer::showPage\r\n");
        closesocket(s);
}
