/*
    General HTTP Server Class
    Copyright (C) 2002 Ayan Chakrabarti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    http.h
    ======

    Definition for the http classes.
*/

#ifndef HTTP_H_
#define HTTP_H_

#include <windows.h>
#include <winsock.h>
#include "server.h"
#include "slist.h"
#include "offlist.h"

struct HTTPRequest
{
        char method[10];        // GET, POST
        char url[256];
        StringList headers;
        StringList getVars;
        StringList postVars;
        char filename[1024];
        OffList fpostVars;        
};


class HTTPServer : public Server
{

        public:
                HTTPServer();

                virtual void serveRequest(SOCKET);
                virtual void showPage(HTTPRequest &, SOCKET);
};


#endif
