/*
    Dynamic Offset List Class
    Copyright (C) 2002 Ayan Chakrabarti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    offlist.cpp
    ===========

    Implementation the offset list class.
*/

#include "offlist.h"
#include <string.h>


OffList::OffList()
{
        index = 0;
}

OffList::~OffList()
{
        for(int i=0;i < index;i++)
        {
                delete [] keys[i];
                delete starts[i];
                delete szs[i];
        }
}

void OffList::addList(char * key,int start, int sz)
{
        if(index >= MAXLIST)
                return;

        keys[index] = new char[strlen(key)+1];
        starts[index] = new int;
        szs[index] = new int;
        
        strcpy(keys[index],key);
        *starts[index] = start;
        *szs[index] = sz;

        index++;
}

void OffList::searchList(char * key, int * start, int * sz)
{
        int i;

        for(i = 0;i < index;i++)
                if(strcmpi(keys[i],key) == 0)
                        break;
        if(i < index)
        {
                *start = *starts[i];
                *sz = *szs[i];
        }
        else
                *start = -1;
}
