/*
    General Server Class
    Copyright (C) 2002 Ayan Chakrabarti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    server.cpp
    ==========

    Implementation for the server class.
*/

#include <windows.h>
#include <winsock.h>
#include "server.h"
#include "utils.h"

long WINAPI threadForRequest(LPVOID);
long WINAPI threadForRun(LPVOID);

void Server::run(void)
{
        HANDLE h;

        
        runLock = 1;
        CreateThread(NULL,0,(LPTHREAD_START_ROUTINE) threadForRun,
                     (LPVOID) this,0,(LPDWORD) &h);
        if(h)
                CloseHandle(h);
}

void Server::stop(void)
{
        runLock = 0;

        while(runLock == 0)
                continue;
        
        runLock = 0;
}

void Server::threadRun(void)
{
        struct sockaddr_in addr;
        unsigned int i;

        threadHandles = new HANDLE[maxConns];

        if(threadHandles == NULL)
                return;

        for(i = 0;i < maxConns;i++)
                threadHandles[i] = INVALID_HANDLE_VALUE;

        listenSocket = socket(AF_INET,SOCK_STREAM,0);
        addr.sin_family = AF_INET;
        addr.sin_port = htons(port);
        addr.sin_addr.s_addr = INADDR_ANY;
        bind(listenSocket,(sockaddr *)&addr,sizeof(addr));

        listen(listenSocket,maxConns);

        while(runLock == 1)
        {
              while(runLock == 1 && !isreadable(listenSocket,1));

              if(runLock != 1)
                      break;

                tempSocket = accept(listenSocket,NULL,NULL);

                for(i = 0;i < maxConns;i++)
                        if(threadHandles[i] == INVALID_HANDLE_VALUE)
                                break;

                if(i == maxConns)
                {
                        closesocket(tempSocket);
                        continue;
                }

                threadLock = 1;
                threadIndex = i;

                CreateThread(NULL,0,(LPTHREAD_START_ROUTINE) threadForRequest,
                             (LPVOID) this,0,(LPDWORD) &threadHandles[i]);
                if(threadHandles[i])
                {
                        CloseHandle(threadHandles[i]);
                        while(threadLock == 1)
                                continue;
                }
        }

        closesocket(listenSocket);
        delete threadHandles;

        runLock = -1;
}


Server::Server()
{
        port = 3000;
        maxConns = 10;
        threadHandles = NULL;
        runLock = threadLock = 0;
}

void Server::serveRequest(SOCKET s)
{
        sendstring(s,"Server::serveRequest has to be subclassed and implemented.\r\n");
        closesocket(s);
}

SOCKET Server::getSocket(void)
{
        return tempSocket;
}

int Server::getThreadIndex(void)
{
        return threadIndex;
}

void Server::releaseLock(void)
{
        threadLock = 0;
}

void Server::threadOver(unsigned int index)
{
        if(index < maxConns)
                threadHandles[index] = INVALID_HANDLE_VALUE;
}

void Server::setPort(unsigned long p)
{
        if(runLock == 0)
                port = p;
}

void Server::setMaxConnections(unsigned int m)
{
        if(runLock == 0)
                maxConns = m;
}

long WINAPI threadForRequest(LPVOID ptr)
{
        Server * obj;
        SOCKET s;
        unsigned int index;

        obj = (Server *) ptr;
        
        s = obj->getSocket();
        index = obj->getThreadIndex();
        obj->releaseLock();

        obj->serveRequest(s);

        obj->threadOver(index);

        return 0;
}

long WINAPI threadForRun(LPVOID ptr)
{
        Server * obj;

        obj = (Server *) ptr;

        obj->threadRun();
        return 0;
}
