/*
    General Server Class
    Copyright (C) 2002 Ayan Chakrabarti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    server.h
    ========

    Definition for the server class.
*/

#ifndef SERVER_H_
#define SERVER_H_

#include <windows.h>
#include <winsock.h>

class Server
{
        private:
                SOCKET listenSocket;
                SOCKET tempSocket;              // To be passed to thread.

                char threadLock;
                char runLock;

                unsigned long port;
                unsigned int maxConns;

                HANDLE * threadHandles;
                int threadIndex;                // To be passed to thread.

        public:
                Server();

                void setPort(unsigned long);
                void setMaxConnections(unsigned int);

                // Functions called by thread

                virtual void serveRequest(SOCKET);
                SOCKET getSocket(void);
                int getThreadIndex(void);
                void releaseLock(void);
                void threadOver(unsigned int);

                void threadRun(void);

                void run(void);
                void stop(void);

};

#endif
