/*
    Dynamic String List Class
    Copyright (C) 2002 Ayan Chakrabarti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    slist.cpp
    =========

    Implementation the string list class.
*/

#include "slist.h"
#include <string.h>


StringList::StringList()
{
        index = 0;
}

StringList::~StringList()
{
        for(int i=0;i < index;i++)
        {
                delete [] keys[i];
                delete [] values[i];
        }
}

void StringList::addList(char * key,char * value)
{
        if(index >= MAXSTRINGS)
                return;

        keys[index] = new char[strlen(key)+1];
        values[index] = new char[strlen(value)+1];

        strcpy(keys[index],key);
        strcpy(values[index],value);

        index++;
}

void StringList::searchList(char * key, char * value)
{
        int i;

        for(i = 0;i < index;i++)
                if(strcmpi(keys[i],key) == 0)
                        break;
        if(i == index)
                strcpy(value,"");
        else
                strcpy(value,values[i]);
}
