/*
    Socket Utility Functions
    Copyright (C) 2002 Ayan Chakrabarti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    utils.cpp
    =========

    Implementation for the utility functions.
*/

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <string.h>
#include "utils.h"

void sendstring(SOCKET s,char * st)
{
        send(s,st,strlen(st),0);
}

int isreadable(SOCKET s,int sec)
{
        fd_set rset;
        struct timeval tv;

        FD_ZERO(&rset);
        FD_SET(s,&rset);

        tv.tv_sec = sec;
        tv.tv_usec = 0;

        return (select(s + 1,&rset,NULL,NULL,&tv));
}

int docheck(char * str,char * buf,int * bpos)
{
        int i,j;
        for(i = 0;i < *bpos;i++)
                if(buf[i] == '\r' || buf[i] == '\n')
                        break;
        if(i == *bpos)
                return 0;

        for(j = 0;j < i;j++)
                str[j] = buf[j];

        str[j] = '\0';

        if(buf[i] == '\r' && buf[i+1] == '\n')
                i+=2;
        else
                i++;

        for(j = 0;i < *bpos;i++,j++)
                buf[j] = buf[i];
        *bpos = j;
        return 1;
}

int readline(SOCKET s,char * str,char * buf,int * bpos, int timeout)
{
        int n;

        while(1)
        {
                if(docheck(str,buf,bpos))
                        return 1;
                if(*bpos >= 1023)
                        *bpos = 0;
                if(!isreadable(s,timeout))
                {
                        closesocket(s);
                        return 0;
                }
                n = recv(s,&buf[*bpos],1023-*bpos,0);
                if(n <= 0)
                {
                        closesocket(s);
                        return 0;
                }
                (*bpos) += n;
                
        }
}

void lineSocket::setSocket(SOCKET sock)
{
        s = sock;
        bpos = 0;
}

int lineSocket::readLine(char * str,int timeout)
{

        return readline(s,str,buf,&bpos,timeout);
}

int lineSocket::flush(char * str)
{
        int ret;

        for(int i = 0;i < bpos;i++)
                str[i] = buf[i];

        ret = bpos;
        bpos = 0;
        return ret;
}
