/*
    URL mapper
    Copyright (C) 2002 Ayan Chakrabarti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    mapit.cpp
    =========

    URL to file mapper.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

void convert(char * fname, FILE * fout, int i)
{
        FILE * fin;
        int ch;
        unsigned long sz = 0;

        fin = fopen(fname,"rb");
        if(!fin)
        {
                printf("Could not open file %s.\n",fname);
                exit(0);
        }

        fprintf(fout,"char filearr%c%c%c[] = \n{\n",i%10+'0',(i/10)%10+'0',i/100+'0');

        ch = fgetc(fin);

        while(ch != -1)
        {
                fprintf(fout,"%d",ch);
                sz++;

                ch = fgetc(fin);
                if(ch != -1)
                {
                        fprintf(fout,",");
                        if(sz % 20 == 0)
                                fprintf(fout,"\n");
                }
        }

        fprintf(fout,"\n};\n");
        fprintf(fout,"const unsigned long arrsz%c%c%c = %lu;\n\n",i%10+'0',(i/10)%10+'0',i/100+'0',sz);
        fclose(fin);
}

void addcode(FILE * fp, char * url, char * type, int i)
{
        fprintf(fp,"\tif(strcmp(url,\"%s\") == 0)\n\t{\n",url);
        fprintf(fp,"\t\tstrcpy(type,\"%s\");\n",type);
        fprintf(fp,"\t\t*sz = arrsz%c%c%c;\n",i%10+'0',(i/10)%10+'0',i/100+'0');
        fprintf(fp,"\t\treturn filearr%c%c%c;\n",i%10+'0',(i/10)%10+'0',i/100+'0');
        fprintf(fp,"\t}\n");
}

int main(int argc,char ** argv)
{
        FILE *fin, *defs, *code, *include;
        int i = 0;

        if(argc != 2)
        {
                printf("USAGE: mapit listfile\n");
                return 0;
        }

        fin = fopen(argv[1],"rt");
        defs = fopen("defs.h","wt");
        code = fopen("filemap.cpp","wt");
        include = fopen("filemap.h","wt");

        if(!fin || !defs || !code || !include)
        {
                printf("IO ERROR.\n");
                return 0;
        }

        fprintf(include,"#ifndef FILEMAP_H_\n#define FILEMAP_H_\n");
        fprintf(include,"const char * processURL(char *,unsigned long *, char *);\n");
        fprintf(include,"#endif\n");
        fclose(include);

        fprintf(code,"#include <string.h>\n#include \"defs.h\"\n\n");
        fprintf(code,"const char * processURL(char * url,unsigned long * sz, char * type)\n{\n");

        while(1)
        {
                char url[1024],name[1024],type[1024];

                fgets(url,1023,fin);
                fgets(name,1023,fin);
                fgets(type,1023,fin);

                if(feof(fin))
                        break;

                url[strlen(url)-1] = '\0';
                name[strlen(name)-1] = '\0';
                type[strlen(type)-1] = '\0';

                convert(name,defs,i);
                addcode(code,url,type,i);

                i++;
        }

        fprintf(code,"\treturn NULL;\n}\n");
        fclose(code);
        fclose(defs);
        fclose(fin);
}
