/*

    alias.c - alias routines
    
    Copyright (C) 1999 David Tuvin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdlib.h>
#include <stdio.h>
#include "alias.h"

ALIAS *load_aliases (ALIAS *aliases)
{
   FILE *fp;
   char dir[128];
   char buffer[80];
   char alias[16];
   char command[64];
   char *home;
   
   int lines = 0, i = 0, a = 0;
   
   if ((home = getenv("HOME")) == NULL)
      return (NULL);
   else
      sprintf (dir, "%s/.nil/aliases", home);
      
   /* open file '~/.nil/aliases', do nothing if error occours */
   if ((fp = fopen(dir, "r")) != NULL)
   {
      /* count number of lines in file */
      while (fgets(buffer, 80, fp) != NULL)
      {
         if (buffer[0] == '\n' || buffer[0] == '#')
            continue;
         else
            a++;
      }
      
      /* allocate enough memory for alias structure */
      aliases = (ALIAS *)malloc(sizeof(ALIAS));
      aliases->aliases = (ALIAS_ENTRY *)malloc(sizeof(ALIAS_ENTRY) * a);
      
      if (!aliases || !aliases->aliases)
      {
         printf ("Unable to allocate memory\n");
         return (NULL);
      }
      
      rewind (fp);
      a = 0;
      
      /* do the same again, but save the aliases */
      while (fgets(buffer, 80, fp) != NULL)
      {
         /* check if first char is newline or comment */
         if (buffer[0] == '\n' || buffer[0] == '#')
            continue;
               
         /* get the alias */
         sscanf(buffer, "%s", alias);
         
         /* copy next chars on line to command */
         strcpy(command, &buffer[strlen(alias)+1]);
         
         fix_string(alias);
         fix_string(command);
         
         strcpy(aliases->aliases[a].alias, alias);
         strcpy(aliases->aliases[a].command, command);
      
         a++;
      }
      
      /* save number of aliases */
      aliases->num_aliases = a;
   }
   return (aliases);
}

void unload_aliases (ALIAS *aliases)
{
   if (aliases)
   {
      free (aliases->aliases);
      free (aliases);
   }
}

int check_if_alias (char *buffer, ALIAS *aliases)
{
   int i;
   char alias[16];
   
   /* make sure alias structure is allocated */
   if (aliases == NULL)
      return (-1);
      
   sscanf (buffer, "%s", alias);
   
   for (i=0; i<aliases->num_aliases; i++)
   {
      if (strcmp(alias, aliases->aliases[i].alias) == 0)
      {
         parse_command (aliases->aliases[i].command);
         return (0);
      }
   }
   return (-1);
}
