/*

    nil.c - user interface
    
    Copyright (C) 1999 David Tuvin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>

#include <unistd.h> /* for fcntl() */
#include <fcntl.h>

#include "nil.h"
#include "socket.h"
#include "commands.h"
#include "alias.h"

int done = 0;				/* flags if program finished */

ALIAS *aliases;				/* aliases */
STATUS *status;				/* status */

char command_prompt[] = "<NIL> ";       /* command prompt */

void fix_string(char *string)
{
   /* delete any ending newline */
   
   if (string[strlen(string)-1] == '\n')
      string[strlen(string)-1] = '\0';
}
            
void prompt (void)
{
   printf ("%s%s%s", C_PRM, command_prompt, C_N);
}
   
void read_line (char *string)
{
   if (!(fgets(string, 80, stdin) != NULL))
      string[0] = -1;
}

void parse_command (char *command)
{
   char c1[64], c2[64], c3[64];
   char keffo[128];
   int i;
   
   /* check if command is an empty line */
   if (command[0] == 0)
      return;
      
   /* rip out words in command */
   sscanf(command, "%s %s %s", c1, c2, c3);
   
   fix_string (command);
   
   #ifdef USE_ALIASES

   /* check if existing alias */
   if (check_if_alias (c1, aliases) == 0)
      return;

   #endif
   
   if (strcmp(c1, "connect") == 0)
      connect_ (c2);
   
   else if (strcmp(c1, "disconnect") == 0)
      disconnect ();
   
   else if (strcmp(c1, "help") == 0)
      show_help ();
   
   else if (strcmp(c1, "version") == 0)
      show_version ();
      
   else if (strcmp(c1, "show_aliases") == 0)
      show_aliases (aliases);
      
   else if (strcmp(c1, "status") == 0)
      show_status ();
      
   else if (strcmp(c1, "quit") == 0)
      quit ();
   
   else if (strcmp(c1, "password") == 0)
      password (c2);
   
   else if (strcmp(c1, "close_server") == 0)
      close_server ();
   
   else if (strcmp(c1, "remove_server") == 0)
      remove_server ();
   
   else if (strcmp(c1, "exit_win") == 0)
      exit_win ();
   
   else if (strcmp(c1, "power_off") == 0)
      power_off ();
   
   else if (strcmp(c1, "reboot") == 0)
      reboot_ ();
   
   else if (strcmp(c1, "shutdown") == 0)
      shutdown_ ();
   
   else if (strcmp(c1, "send_keys") == 0)
      send_keys (c2);

   else if (strcmp(c1, "key_beep") == 0)
      key_beep (c2);
      
   else if (strcmp(c1, "disable_keys") == 0)
      disable_keys (c2);
      
   else if (strcmp(c1, "eject") == 0)
      eject (c2);
   
   else if (strcmp(c1, "show_image") == 0)
      show_image ((char *)&c2);
   
   else if (strcmp(c1, "remove_image") == 0)
      remove_image ();
   
   else if (strcmp(c1, "swap_mouse") == 0)
      swap_mouse (c2);
   
   else if (strcmp(c1, "start_app") == 0)
      start_app (c2);
   
   else if (strcmp(c1, "get_info") == 0)
      get_info ();
   
   else if (strcmp(c1, "play_sound") == 0)
      play_sound (c2);
   
   else if (strcmp(c1, "mouse_pos") == 0)
      mouse_pos (c2, c3);
   
   else if (strcmp(c1, "listen") == 0)
      listen_ (c2);
   
   else if (strcmp(c1, "url") == 0)
      url (c2);
   
   else
      msg ("Command/alias not found");
}

void create_dir (void)
{
   char *home;
   char dir[64];
   
   /* create .nil directory */
   if ((home = getenv("HOME")) == NULL)
      printf ("HOME variable not set\n");
   else
   {
      sprintf (dir, "%s/.nil", home);
      mkdir (dir, 0755);
   }
}
   
int main (int argc, char **argv)
{
   char line[80];
   char data[256];
   char dir[128];
   int a;
   
   #ifdef USE_COLOR
   
   printf ("\n%sNIL %s                                   \n"
           "                                             \n"
           "%swritten by David Tuvin (tuvin@gmx.net)     \n"
           "                                             \n"
           "%stype %shelp %sfor a list of commands%s   \n\n", 
           C_MSG,VERSION,
           C_MSG,
           C_MSG,C_CMD,C_MSG,C_N);
   
   #else
   
   printf ("\nNIL %s, by David Tuvin (tuvin@gmx.net)     \n"
           "type help for a list of commands           \n\n",
           VERSION);
   
   #endif
   
   /* create .nil dir */
   create_dir();
   
   #ifdef USE_ALIASES
   
   /* load aliases */
   aliases = load_aliases (aliases);
   
   #endif
   
   /* make stdin nonblocking */
   if (fcntl(0, F_SETFL, O_NONBLOCK) < 0)
   {
      fprintf (stderr, "Unable to manipulate stdin. exiting.");
      return;
   }
   
   /* allocate memory for status structure */
   if ((status = (STATUS *)malloc(sizeof(STATUS))) == NULL)
   {
      fprintf (stderr, "Not enough memory\n");
      return;
   }
   
   prompt ();
   
   while (!done)
   {
      if (status->listen)
         if (get_listen_data() == 0)
            prompt ();
            
      read_line (line);
      
      if (line[0] != -1)	/* if string is typed */
      {
         parse_command (line);
         if (!done)
            prompt ();
      }
   }

   unload_aliases (aliases);
}
