/*

    socket.c - socket routines
    
    Copyright (C) 1999 David Tuvin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include "socket.h"

int create_socket (void)
{
   if ((s = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
      return (-1);

   return (1);
}

int try_connect (char *host)
{
   addr.sin_family = PF_INET;
   addr.sin_port = htons(12345);
   addr.sin_addr.s_addr = inet_addr(host);
   
   if ((connect(s, (struct sockaddr *)&addr, sizeof(addr))) < 0)
      return (-1);
                              
   /* make socket nonblocking */
                             
   if ((fcntl(s, F_SETFL, O_NONBLOCK)) < 0)
      return (-1);
                                          
   return (1);
}
                                             
int read_socket (char *buf, int length)
{
   return (recv(s, buf, length, 0));
}

int write_socket (char *buf)
{
   return (send(s, buf, strlen(buf), 0));
}

void close_socket (void)
{
   close (s);
}
