//Please refer to http://dansguardian.org/?page=copyright2
//for the license for this code.
//Written by Daniel Barron (daniel@jadeb//.com).
//For support go to http://groups.yahoo.com/group/dansguardian

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "autoconf/platform.h"
#include <syslog.h>
#include "ConnectionHandler.hpp"
#include "DataBuffer.hpp"
#include "Socket.hpp"
#include "UDSocket.hpp"
#include "Ident.hpp"
#ifdef __BSD  // A bodge to get round the problem of a truncated UDS file
	#define __IPC "/tmp/.dguardianipcc"
#else
	#define __IPC "/tmp/.dguardianipc"
#endif
#include "NaughtyFilter.hpp"
#include "HTTPHeader.hpp"
#include "FDTunnel.hpp"
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <cstdio>
#include <algorithm>
#include <istream.h>
#include <fstream>
#include <iostream>
#include <netdb.h>
#include <cstdlib>
#include <unistd.h>
#include <sys/time.h>

extern OptionContainer o;

void ConnectionHandler::handleConnection(Socket peerconn) {

    peerconn.setTimeout(10);

    HTTPHeader header;  // to hold the incoming client request header

    header.setTimeout(10);  // set a timeout as we don't want blocking 4 eva

    HTTPHeader docheader;  // to hold the returned page header from proxy

    docheader.setTimeout(20);

    DataBuffer docbody;  // to hold the returned page

    docbody.setTimeout(60);

    bool waschecked = false;  // flags
    bool wasrequested = false;
    bool isexception = false;
    bool isourwebserver = false;

    String url;
    String urld;

    std::string exceptionreason;  // to hold the reason for not blocking

    int docsize = 0;  // to store the size of the returned document for loggin

    Ident ident;  // for holding

    std::string clientip = peerconn.getPeerIP();  // hold the clients ip

    #ifdef DGDEBUG  // debug stuff surprisingly enough
        std::cout << "got connection" << std::endl;
        std::cout << clientip << std::endl;
    #endif



    Socket proxysock;  // to hold connection to proxy

    // connect to proxy
    int rc = proxysock.connect(o.proxy_ip, o.proxy_port);

    if (rc) {
        #ifdef DGDEBUG
            std::cerr << "Error connecting to proxy" << std::endl;
        #endif
        syslog(LOG_ERR, "%s","Error connecting to proxy");
        return;  // if we can't connect to the proxy, there is no point
                 // in continuing
    }

    try {
        header.in(peerconn);  // get header from client
        url = header.url();
        urld = header.decode(url);
        if (header.malformedURL(url)) {
            // checks for bad URLs to prevent security hole
            try { // writestring throws exception on error/timeout
                peerconn.writeString("HTTP/1.0 400 Bad Request\n");
                peerconn.writeString("Content-Type: text/html\n\n");
                peerconn.writeString("<HTML><HEAD><TITLE>DansGuardian - 400 Bad Request</TITLE></HEAD><BODY><H1>DansGuardian - 400 Bad Request</H1> The requested URL is malformed.</BODY></HTML>\n");
            } catch (exception& e) {}
            return;
        }

        std::string clientuser = ident.getUsername(&header, &peerconn);
                                                   // extract username

        // Modification based on a submitted patch by
        // Jimmy Myrick (jmyrick@tiger1.tiger.org)
        if (o.use_xforwardedfor == 1) {
            std::string xforwardip = header.getXForwardedForIP();
            if (xforwardip.length() > 6) {
                clientip = xforwardip;
            }
            #ifdef DGDEBUG  // debug stuff surprisingly enough
                std::cout << "using x-forwardedfor:" << clientip << std::endl;
            #endif
        }


        if (o.forwarded_for == 1) {
            header.addXForwardedFor(clientip);  // add squid-like entry
        }

        if (o.inipexceptions(clientip)) {  // admin pc
            isexception = true;
            exceptionreason = "Exception client IP match.";
        }
        else if (o.inuserexceptions(clientuser)) { // admin user
            isexception = true;
            exceptionreason = "Exception client user match.";
        }
        else if (o.inexceptions(urld)) {  // allowed site
            if (o.iswebserver(url)) {
                isourwebserver = true;
            }
            else {
                isexception = true;
                exceptionreason = "Exception site match.";
            }
        }
        else if (o.inurlexceptions(urld)) {  // allowed url
            isexception = true;
            exceptionreason = "Exception url match.";
        }

        #ifdef DGDEBUG
            std::cout << "extracted url:" << urld << std::endl;
        #endif

        if ( ((o.inipexceptions(clientip)  // admin pc
                || o.inuserexceptions(clientuser) // admin user
                || o.inurlexceptions(urld) // ok part of site
                || o.inexceptions(urld)) // ok site
                && !o.inBannedIPList(clientip)  // bad users pc
                && !o.inBannedUserList(clientuser)) ||  // bad user
                isourwebserver  // don't filter the web server
                 ) {

            proxysock.readyForOutput(10);  // exception on timeout or error
            header.out(proxysock);  // send proxy the request
            try {
                FDTunnel fdt;  // make a tunnel object
                // tunnel from client to proxy and back
                fdt.tunnel(proxysock.getFD(), peerconn.getFD()); // not expected to exception
                docsize = fdt.throughput;
                if (!isourwebserver) {  // don't log requests to the web server
                    decideHowToLog(clientuser, clientip, url.toCharArray(), exceptionreason, header.requesttype().toCharArray(), docsize, o.ll, false, isexception, o.log_exception_hits, false);
                }
            } catch (exception& e) {}
            try {
                proxysock.close();  // close connection to proxy
            } catch (exception& e) {}
            return;  // connection dealt with so exit
        }

        if (!o.inexceptions(urld)
                || !o.inurlexceptions(urld)
                || o.inBannedIPList(clientip)
                || o.inBannedUserList(clientuser)
                 ) {
            NaughtyFilter checkme;  // our filter object
            int i;
            String temp;
            temp = urld;

            if (o.blanketblock == 1) {
                checkme.isItNaughty = true;
                checkme.whatIsNaughty = "Blanket Block is active and that site is not on the white list.";
                checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
            }

            if (!checkme.isItNaughty) {
                if (o.inBannedIPList(clientip)) {
                    checkme.isItNaughty = true;
                    checkme.whatIsNaughtyLog = "Your IP address is not allowed to web browse: " + clientip;
                    checkme.whatIsNaughty = "Your IP address is not allowed to web browse.";
                }
            }

            if (!checkme.isItNaughty) {
                if (o.inBannedUserList(clientuser)) {
                    checkme.isItNaughty = true;
                    checkme.whatIsNaughtyLog = "Your username is not allowed to web browse: " + clientuser;
                    checkme.whatIsNaughty = checkme.whatIsNaughtyLog;
                }
            }

            if (!checkme.isItNaughty) {
                i = o.inBannedRegExpURLList(temp);
                if (i >= 0) {
                    checkme.isItNaughty = true;
                    checkme.whatIsNaughtyLog = "Banned Regular Expression URL: " + o.banned_regexpurl_list.getItemAt(i);
                    checkme.whatIsNaughty = "Banned Regular Expression URL found.";
                }
            }
            if (!checkme.isItNaughty) {
                i = o.inBannedURLList(temp);
                if (i >= 0) {
                    checkme.whatIsNaughty = "Banned URL: " + o.banned_url_list.getItemAt(i);
                    checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                    checkme.isItNaughty = true;
                }
            }
            if (!checkme.isItNaughty) {
                i = o.inBannedSiteList(temp);
                if (i == -2) {
                    checkme.isItNaughty = true;
                    checkme.whatIsNaughty = "Blanket IP Block is active and that address is an IP only address.";
                    checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                }
                if (i >= 0) {
                    checkme.whatIsNaughty = "Banned site: " + o.banned_site_list.getItemAt(i);
                    checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                    checkme.isItNaughty = true;
                }
            }


            if (!checkme.isItNaughty && o.max_upload_size > -1) {
                if (header.isPostUpload()) {
                    #ifdef DGDEBUG
                        std::cout << "is post upload" << std::endl;
                    #endif
                    if (o.max_upload_size == 0) {
                        checkme.whatIsNaughty = "Web upload is banned.";
                        checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                        checkme.isItNaughty = true;
                    }
                    else if (header.contentlength() > o.max_upload_size) {
                        checkme.whatIsNaughty = "Web upload limit exceeded.";
                        checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                        checkme.isItNaughty = true;
                    }
                }
            }


            if (!checkme.isItNaughty && header.requesttype().startsWith("CONNECT")) {
                // can't filter content of CONNECT
                proxysock.readyForOutput(10);  // exception on timeout or error
                header.out(proxysock);  // send proxy the request
                try {
                    FDTunnel fdt;  // make a tunnel object
                    // tunnel from client to proxy and back
                    fdt.tunnel(proxysock.getFD(), peerconn.getFD()); // not expected to exception
                    docsize = fdt.throughput;
                    decideHowToLog(clientuser, clientip, url.toCharArray(), exceptionreason, header.requesttype().toCharArray(), docsize, o.ll, false, isexception, o.log_exception_hits, false);
                } catch (exception& e) {}
                try {
                    proxysock.close();  // close connection to proxy
                } catch (exception& e) {}
                return;  // connection dealt with so exit
            }


            if (!checkme.isItNaughty) {
                proxysock.readyForOutput(10);
                header.out(proxysock);  // send header to proxy
                proxysock.checkForInput(60);
                docheader.in(proxysock);  // get header from proxy
                #ifdef DGDEBUG
                    std::cout << "got header from proxy" << std::endl;
                #endif
                wasrequested = true;  // so we know where we are later

                temp = docheader.getcontenttype();

                i = o.banned_mimetype_list.findInList(temp.toCharArray());
                if (i >= 0) {
                    checkme.whatIsNaughty = "Banned MIME Type: " + o.banned_mimetype_list.getItemAt(i);
                    checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                    checkme.isItNaughty = true;
                }
                #ifdef DGDEBUG
                    std::cout << temp.length() << std::endl;
                    std::cout << ":" << temp;
                    std::cout << ":" << std::endl;
                #endif


                if (!checkme.isItNaughty && !docheader.isRedirection()) {
                    // Can't ban file extensions of URLs that just redirect
                    String tempurl = urld;
                    String tempdispos = docheader.disposition();
                    if (tempdispos.length() > 1) {
                        // dispos filename must take presidense
                        #ifdef DGDEBUG
                             std::cout << "Disposition filename:" << tempdispos << ":" << std::endl;
                        #endif
                        // The function expects a url so we have to
                        // generate a psudo one.
                        tempdispos = "http://foo.bar/" + tempdispos;
                        i = o.inBannedExtensionList(tempdispos);
                        if (i >= 0) {
                            checkme.whatIsNaughty = "Banned extension: " + o.banned_extension_list.getItemAt(i);
                            checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                            checkme.isItNaughty = true;
                        }
                    }
                    else {
                        if (!tempurl.contains("?")) {
                            i = o.inBannedExtensionList(tempurl);
                            if (i >= 0) {
                                checkme.whatIsNaughty = "Banned extension: " + o.banned_extension_list.getItemAt(i);
                                checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                                checkme.isItNaughty = true;
                            }
                        }
                        if (temp.contains("application/")) {
                            while (tempurl.endsWith("?")) {
                                tempurl.chop();
                            }
                            while(tempurl.contains("/")) {  // no slash no url
                                i = o.inBannedExtensionList(tempurl);
                                if (i >= 0) {
                                    checkme.whatIsNaughty = "Banned extension: " + o.banned_extension_list.getItemAt(i);
                                    checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                                    checkme.isItNaughty = true;
                                    break;
                                }
                                while (tempurl.contains("/") && !tempurl.endsWith("?")) {
                                    tempurl.chop();
                                }
                                tempurl.chop();  // get rid of the ?

                            }
                        }
                    }
                }


                if (docheader.iscontenttype("text") && !checkme.isItNaughty) {
                    waschecked = true;
                    proxysock.checkForInput(60);
                    if (docheader.isCompressed()) {
                        docbody.setDecompress(docheader.contentEncoding());
                        #ifdef DGDEBUG
                            std::cout << docheader.contentEncoding() << std::endl;
                        #endif
                    }
                    #ifdef DGDEBUG
                        std::cout << "about to get body from proxy" << std::endl;
                    #endif
                    docbody.in(proxysock);  // get body from proxy
                    #ifdef DGDEBUG
                        std::cout << "got body from proxy" << std::endl;
                    #endif
                    int dblen = docbody.length();
                    docsize = dblen;

                    if (docheader.isCompressed()) {
                        docheader.removeEncoding(dblen);
                        // need to modify header to mark as not compressed
                        // it also modifies Content-Length as well
                    }
                    #ifdef DGDEBUG
                        system("date");
                    #endif
                    checkme.checkme(&docbody);  // content filtering
                    #ifdef DGDEBUG
                        system("date");
                    #endif

                }
            }

            if (checkme.isException) {
                isexception = true;
                exceptionreason = checkme.whatIsNaughtyLog;
            }

            if (docheader.isRedirection()) {
                checkme.isItNaughty = false;
            }

            if (checkme.isItNaughty) {  // then we deny

                decideHowToLog(clientuser, clientip, url.toCharArray(), checkme.whatIsNaughtyLog, header.requesttype().toCharArray(), docsize, o.ll, true, false, false, false);

                try { // writestring throws exception on error/timeout
                    if (o.reporting_level == 3) {
                        proxysock.close();  // finshed with proxy
                        peerconn.readyForOutput(10);
                        if (header.requesttype().startsWith("CONNECT")) {
                            String redirhttps = url.after("://");
                            if (!redirhttps.contains("/")) {
                                redirhttps += "/";
                            }
                            redirhttps = "http://" + redirhttps;
                    //  The idea is that redirecting it back to the http page
                    // of itself will also get blocked but won't confuse the
                    // browser when it gets unencrypted content

                            try { // writestring throws exception on error/timeout
                                peerconn.writeString("HTTP/1.0 302 Redirect\n");
                                peerconn.writeString("Location: ");
                                peerconn.writeString(redirhttps.toCharArray());
                                peerconn.writeString("\n\n");
                            } catch (exception& e) {}
                        }
                        else {
                            peerconn.writeString("HTTP/1.0 200 OK\n");
                            peerconn.writeString("Content-type: text/html\n\n");
                            o.html_template.display(&peerconn,
                                url.toCharArray(),
                                checkme.whatIsNaughty.c_str(),
                                checkme.whatIsNaughtyLog.c_str(),
                                clientuser.c_str(),
                                clientip.c_str());
                        }
                    }
                    else if (o.reporting_level > 0) {
                        proxysock.close();  // finshed with proxy
                        peerconn.readyForOutput(10);
                        if (checkme.whatIsNaughty.length() > 256) {
                            checkme.whatIsNaughty = String(checkme.whatIsNaughty.c_str()).subString(0, 512).toCharArray();
                        }
                        if (checkme.whatIsNaughtyLog.length() > 256) {
                            checkme.whatIsNaughtyLog = String(checkme.whatIsNaughtyLog.c_str()).subString(0, 512).toCharArray();
                        }
                        peerconn.writeString("HTTP/1.0 302 Redirect\n");
                        peerconn.writeString("Location: ");
                        peerconn.writeString(o.access_denied_address.c_str());
                        peerconn.writeString("?DENIEDURL=");
                        peerconn.writeString(url.toCharArray());
                        peerconn.writeString("&REASON=");
                        if (o.reporting_level == 1) {
                            peerconn.writeString(miniURLEncode(checkme.whatIsNaughty).c_str());
                        }
                        else {
                            peerconn.writeString(miniURLEncode(checkme.whatIsNaughtyLog).c_str());
                        }
                        peerconn.writeString("&USER=");
                        peerconn.writeString(clientuser.c_str());
                        peerconn.writeString("\n\n");
                    }
                    else if (o.reporting_level == 0) {
                        proxysock.close();  // finshed with proxy
                        peerconn.readyForOutput(10);
                        peerconn.writeString("HTTP/1.0 200 OK\n");
                        peerconn.writeString("Content-type: text/html\n\n");
                        peerconn.writeString("<HTML><HEAD><TITLE>DansGuardian - Access Denied</TITLE></HEAD>");
                        peerconn.writeString("<BODY><CENTER><H1>DansGuardian - Access Denied</H1></CENTER></BODY></HTML>");
                    }
                    else if (o.reporting_level == -1) {  // stealth
                        checkme.isItNaughty = false;  // dont block
                        #ifdef DGDEBUG
                            std::cout << "STEALTHMODE!" << std::endl;
                        #endif
                    }
                } catch (exception& e) {}
                if (checkme.isItNaughty) { // not stealth mode then
                    try {
                        peerconn.readyForOutput(10);  //as best a flush as I can
                    } catch (exception& e) {}
                    return;  // we said no, so return
                }
            }
        }

        if (wasrequested == false) {
            proxysock.readyForOutput(10); // exceptions on error/timeout
            header.out(proxysock); // exceptions on error/timeout
            proxysock.checkForInput(60); // exceptions on error/timeout
            docheader.in(proxysock);  // get reply header from proxy
        }



        #ifdef DGDEBUG
            std::cout << "sending header to client" << std::endl;
        #endif
        peerconn.readyForOutput(10);  // exceptions on error/timeout
        docheader.out(peerconn);  // send header to client
        #ifdef DGDEBUG
             std::cout << "sent header to client" << std::endl;
        #endif
        if (waschecked) {
            decideHowToLog(clientuser, clientip, url.toCharArray(), exceptionreason, header.requesttype().toCharArray(), docsize, o.ll, false, isexception, o.log_exception_hits, docheader.iscontenttype("text"));

            #ifdef DGDEBUG
                std::cout << "sending body to client" << std::endl;
            #endif
            peerconn.readyForOutput(10); // check for error/timeout needed
            docbody.out(peerconn); // send doc body to client
            #ifdef DGDEBUG
                std::cout << "sent body to client" << std::endl;
            #endif
        }
        else {  // was not supposed to be checked
            FDTunnel fdt;
            #ifdef DGDEBUG
                std::cout << "tunnel activated" << std::endl;
            #endif
            fdt.tunnel(proxysock.getFD(), peerconn.getFD());
            docsize = fdt.throughput;

            decideHowToLog(clientuser, clientip, url.toCharArray(), exceptionreason, header.requesttype().toCharArray(), docsize, o.ll, false, isexception, o.log_exception_hits, docheader.iscontenttype("text"));

        }
    } catch (exception& e) {
        #ifdef DGDEBUG
            std::cout << "connection handler caught an exception" << std::endl;
        #endif
        return;
    }
    try {
        proxysock.close();  // close conection to squid
    } catch (exception& e) {}
    try {
        peerconn.readyForOutput(10);
    }
    catch (exception& e) {
        return;
    }
    return;
}

// if we don't do this the browsers complain
std::string ConnectionHandler::miniURLEncode(std::string s) {
    std::string encoded;
    char* buf = new char[16];  // way longer than needed
    unsigned char c;
    for(int i=0; i < (signed)s.length(); i++) {
        c = s[i];
        if ((c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') ||  c == '.' || c == '-' || c == '_') {  // allowed characters in a url that have non special meaning
            encoded += c;
            continue;
        }
        sprintf(buf, "%x", c);
        encoded += "%";
        encoded += buf;
    }
    delete[] buf;
    return encoded;
}

void ConnectionHandler::doTheLogMan(std::string who, std::string from, std::string where, std::string what, std::string how, int size){
    std::string logline,year,month,day,hour,min,sec,when,ssize;
    String temp;
    time_t tnow;  // to hold the result from time()
    struct tm *tmnow;  // to hold the result from localtime()
    time(&tnow);  // get the time after the lock so all entries in order
    tmnow = localtime(&tnow);  // convert to local time (BST, etc)
    year = String(tmnow->tm_year + 1900).toCharArray();
    month = String(tmnow->tm_mon + 1).toCharArray();
    day = String(tmnow->tm_mday).toCharArray();
    hour = String(tmnow->tm_hour).toCharArray();
    temp = String(tmnow->tm_min);
    if (temp.length() == 1) { temp = "0" + temp;}
    min = temp.toCharArray();
    temp = String(tmnow->tm_sec);
    if (temp.length() == 1) { temp = "0" + temp;}
    sec = temp.toCharArray();
    ssize = String(size).toCharArray();
    when = year + "." + month + "." + day + " " + hour + ":" + min + ":" + sec;
    if (o.log_file_format == 1) {
        logline = when +" "+ who + " " + from + " " + where + " " + what + " " + how + " " + ssize + "\n";
    }
    else {
        logline = "\"" + when +"\",\""+ who + "\",\"" + from + "\",\"" + where + "\",\"" + what + "\",\"" + how + "\",\"" + ssize + "\"\n";
    }
    UDSocket ipcsock;
    if (ipcsock.getFD() < 0) {
        syslog(LOG_ERR, "%s","Error creating ipc socket to log");
        return;
    }
    if (ipcsock.connect(__IPC) < 0) {  // connect to dedicated logging proc
        syslog(LOG_ERR, "%s","Error connecting via ipc to log");
        return;
    }
    ipcsock.writeString(logline.c_str());
    ipcsock.close();
}



void ConnectionHandler::decideHowToLog(std::string who, std::string from, std::string where, std::string what, std::string how, int size, int loglevel, bool isnaughty, bool isexception, int logexceptions, bool istext) {

    if (loglevel == 0) {
        return;
    }
        if (isnaughty) {
            what = "*DENIED* " + what;
            // make it stand out in the logs and also
            // more easily findable with a search
        }
        if (isexception) {
            if (logexceptions == 1) {
                what = "*EXCEPTION* " + what;
            }
            else {
                what = "";
            }
        }
    if ((isexception && logexceptions == 1)
         || isnaughty
         || loglevel == 3
         || (loglevel == 2 && istext)) {
        doTheLogMan(who, from, where, what, how, size);
    }
}
