//Please refer to http://dansguardian.org/?page=copyright2
//for the license for this code.
//Written by Daniel Barron (daniel@jadeb.com).
//For support go to http://groups.yahoo.com/group/dansguardian

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __HPP_OPTIONCONTAINER
#define __HPP_OPTIONCONTAINER
#include "String.hpp"
#include "HTMLTemplate.hpp"
#include "ListContainer.hpp"
#include <string>
#include <deque>

class OptionContainer {

public:
    bool read(std::string filename);
    void reset();
    bool inexceptions(String url);
    bool iswebserver(String url);
    bool inurlexceptions(String url);
    bool inipexceptions(std::string ip);
    bool inuserexceptions(std::string user);
    bool inBannedIPList(std::string ip);
    bool inBannedUserList(std::string user);
    int inBannedSiteList(String url);
    int inBannedURLList(String url);
    int inBannedRegExpURLList(String url);
    int inBannedExtensionList(String url);
    int log_exception_hits;
    int log_file_format;
    int weighted_phrase_mode;
    int naughtyness_limit;
    int show_weighted_found;
    int forwarded_for;
    int createlistcachefiles;
    int enable_PICS;
    int blanketblock;
    int blanket_ip_block;
    int reverse_lookups;
    int use_xforwardedfor;
    int uim_proxyauth;
    int uim_ntlm;
    int uim_ident;
    int logconerror;
    int filter_port;
    int proxy_port;
    std::string proxy_ip;
    std::string filter_ip;
    int ll;
    int reporting_level;
    int max_children;
    int pics_rsac_violence;
    int pics_rsac_sex;
    int pics_rsac_nudity;
    int pics_rsac_language;
    int pics_icra_chat;
    int pics_icra_moderatedchat;
    int pics_icra_languagesexual;
    int pics_icra_languageprofanity;
    int pics_icra_languagemildexpletives;
    int pics_icra_nuditygraphic;
    int pics_icra_nuditymalegraphic;
    int pics_icra_nudityfemalegraphic;
    int pics_icra_nuditytopless;
    int pics_icra_nuditybottoms;
    int pics_icra_nuditysexualacts;
    int pics_icra_nudityobscuredsexualacts;
    int pics_icra_nuditysexualtouching;
    int pics_icra_nuditykissing;
    int pics_icra_nudityartistic;
    int pics_icra_nudityeducational;
    int pics_icra_nuditymedical;
    int pics_icra_drugstobacco;
    int pics_icra_drugsalcohol;
    int pics_icra_drugsuse;
    int pics_icra_gambling;
    int pics_icra_weaponuse;
    int pics_icra_intolerance;
    int pics_icra_badexample;
    int pics_icra_pgmaterial;
    int pics_icra_violencerape;
    int pics_icra_violencetohumans;
    int pics_icra_violencetoanimals;
    int pics_icra_violencetofantasy;
    int pics_icra_violencekillinghumans;
    int pics_icra_violencekillinganimals;
    int pics_icra_violencekillingfantasy;
    int pics_icra_violenceinjuryhumans;
    int pics_icra_violenceinjuryanimals;
    int pics_icra_violenceinjuryfantasy;
    int pics_icra_violenceartisitic;
    int pics_icra_violenceeducational;
    int pics_icra_violencemedical;
    int pics_icra_violencesports;
    int pics_evaluweb_rating;
    int pics_cybernot_sex;
    int pics_cybernot_other;
    int pics_safesurf_agerange;
    int pics_safesurf_profanity;
    int pics_safesurf_heterosexualthemes;
    int pics_safesurf_homosexualthemes;
    int pics_safesurf_nudity;
    int pics_safesurf_violence;
    int pics_safesurf_sexviolenceandprofanity;
    int pics_safesurf_intolerance;
    int pics_safesurf_druguse;
    int pics_safesurf_otheradultthemes;
    int pics_safesurf_gambling;
    int pics_weburbia_rating;
    int pics_vancouver_multiculturalism;
    int pics_vancouver_educationalcontent;
    int pics_vancouver_environmentalawareness;
    int pics_vancouver_tolerance;
    int pics_vancouver_violence;
    int pics_vancouver_sex;
    int pics_vancouver_profanity;
    int pics_vancouver_safety;
    int pics_vancouver_canadiancontent;
    int pics_vancouver_commercialcontent;
    int pics_vancouver_gambling;
    std::string html_template_location;
    std::string banned_phrase_list_location;
    std::string exception_phrase_list_location;
    std::string weighted_phrase_list_location;
    std::string banned_ip_list_location;
    std::string banned_user_list_location;
    std::string banned_site_list_location;
    std::string banned_url_list_location;
    std::string banned_regexpurl_list_location;
    std::string banned_extension_list_location;
    std::string banned_mimetype_list_location;
    std::string exceptions_site_list_location;
    std::string exceptions_url_list_location;
    std::string exceptions_user_list_location;
    std::string exceptions_ip_list_location;
    std::string access_denied_address;
    std::string loglocation;
    int max_upload_size;
    HTMLTemplate html_template;
    ListContainer banned_phrase_list;
    ListContainer exception_phrase_list;
    ListContainer exception_site_list;
    ListContainer exception_url_list;
    ListContainer exception_user_list;
    ListContainer exception_ip_list;
    ListContainer banned_extension_list;
    ListContainer banned_mimetype_list;
    ListContainer banned_site_list;
    ListContainer banned_url_list;
    ListContainer banned_ip_list;
    ListContainer banned_user_list;
    ListContainer banned_regexpurl_list;
    ListContainer weighted_phrase_list;
    std::deque<int> banned_phrase_list_index;

private:
    std::deque<std::string> conffile;
    String ada;
    bool readbplfile(const char* banned, const char* exception, const char* weighted);
    bool readbilfile(const char* filename);
    bool readbuslfile(const char* filename);
    bool readeslfile(const char* filename);
    bool readeurllfile(const char* filename);
    bool readeulfile(const char* filename);
    bool readeilfile(const char* filename);
    bool readbelfile(const char* filename);
    bool readbmlfile(const char* filename);
    bool readbslfile(const char* filename);
    bool readbulfile(const char* filename);
    bool readbreulfile(const char* filename);
    bool readwplfile(const char* filename);
    bool readwpmfile(const char* filename);
    bool readeplfile(const char* filename);
    void bwlfilehelper(String line, int index);
    void bwlfilehelperhelper(String line, int index);
    int findoptionI(const char* option);
    std::string findoptionS(const char* option);
    bool realitycheck(String s, int minl, int maxl, char* emessage);
    std::deque<String> ipToHostname(String ip);
    bool isIPHostname(String url);
};

#endif
