//Please refer to http://dansguardian.org/?page=copyright2
//for the license for this code.
//Written by Daniel Barron (daniel@jadeb.com).
//For support go to http://groups.yahoo.com/group/dansguardian

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "String.hpp"
#include <algorithm>
#include <iostream>
#include <strstream> // for std::ostrstream
                     // FixIt: deprecated feature [D.7]
                     // use sstream [27.7/1] instead.
#include <cstdlib>
#include <cstring>

String::String()  // default contructor - i.e. an empty String
:data(new char[1]), sl(0) {
    data[0] = '\0';
}

String::~String() {  // destructor - called when String is destroyed
    delete[] data;
}

String::String(const char* bs) {  // constructor from a c-string
    int l = strlen(bs);
    data = new char[l + 1];
    memcpy(data, bs, l);
    sl = l;
    data[sl] = '\0';
}

String::String(const String& s) {  // contructor from a String - i.e. copy
    int l = s.sl;
    data = new char[l + 1];
    memcpy(data, s.data, l + 1);
    sl = l;
}

// Suggested replacement function by lucky agp95@mail.ru
// uses pure c++ rather than sprintf()
String::String(const int num) {
    std::ostrstream buf; // FixIt: deprecated feature [D.7]
                         // use std::basic_ostringstream [27.7.3] instead.
    buf << num << std::ends;
    data = buf.str();  // with side effect: it calls buf.freeze()
    sl = buf.pcount() - 1;
}

String::String(const char* bs, int len) {
    data = new char[len + 1];
    memcpy(data, bs, len);
    sl = len;
    data[sl] = '\0';
}

String::String(const char* bs, int start, int len) {
    data = new char[len + 1];
    memcpy(data, bs + start, len);
    sl = len;
    data[sl] = '\0';
}

ostream& operator << (ostream& out, const String& s) {
    out.write(s.data, s.sl);
//    out.flush();
    return out;
}

String& String:: operator = (const String& s) {
    if (&s == this) {
        return *this;
    }
    delete[] data;
    data = new char[s.sl + 1];
    memcpy(data, s.data, s.sl + 1);
    sl = s.sl;
    return *this;
}

bool String:: operator != (const String& s) {
    if (sl != s.sl) {
        return true;
    }
    int result = memcmp(data, s.data, sl);
    if (result == 0) {
        return false;
    }
    return true;
}

bool String:: operator == (const String& s) {
    if (sl != s.sl) {
        return false;
    }
    int result = memcmp(data, s.data, sl);
    if (result == 0) {
        return true;
    }
    return false;
}


String& String:: operator += (const String& s) {  // concation
    if (&s == this) {
        return *this;
    }
    char* temp = new char[sl + s.sl + 1];
    memcpy(temp, data, sl);
    memcpy(temp + sl, s.data, s.sl + 1);
    delete[] data;
    sl += s.sl;
    data = temp;
    return *this;
}

String String:: operator + (const String& s) {  // concation
    String t(*this);
    t += s;
    return (t);
}

String operator+ (const String & lhs, const String & s) {
    String t(lhs);
    t += s;
    return (t);
}

char String:: operator [] (int i) const {
    return (data[i]);
}

String String::after(const char* bs) {
    int l = strlen(bs);
    if (l >= sl) {
        return(String(""));
    }
    char* result = NULL;
    result = strstr(data, bs);
    if (result == NULL) {
        return(String(""));
    }
    return(String(result + l));
}


String String::before(const char* bs) {
    int l = strlen(bs);
    if (l >= sl) {
        return(String(""));
    }
    char* result = NULL;
    result = strstr(data, bs);
    if (result == NULL) {
        return(String(""));
    }
    return(String(data, (int)(result - data)));
}


bool String::startsWith(const String s) {
    if (!strncmp(data, s.data, s.sl)) {
        return true;
    }
    return false;
}

bool String::endsWith(const String s) {
    if (s.sl > sl) {
        return false;
    }
    if (!strncmp((data + sl - s.sl), s.data, s.sl)) {
        return true;
    }
    return false;
}

String String::subString(int start, int l) {
    if ((start + l) > sl) {
        return(String(""));
    }
    return(String(data + start, l));
}


int String::toInteger() {
    if (sl == 0) {
        return 0;
    }
    return (atoi(data));
}


int String::length() {
    return sl;
}

char* String::toCharArray() {
    return data;
}

int String::indexOf(const char *s) {
    if (sl == 0) {
        return -1;
    }
    if ((signed)strlen(s) > sl) {
        return -1;
    }
    char* pos;
    pos = strstr(data, s);
    if (pos == NULL) {
        return -1;
    }
    return((int)(pos - data));
}

void String::chop() {  // removes a char from the end
    if (sl < 1) return;  // can't have -ve String length
    char* temp = new char[sl];
    memcpy(temp, data, sl - 1);
    delete[] data;
    data = temp;
    sl -= 1;
    data[sl] = '\0';
}


void String::lop() {  // removes a char from the begining
    if (sl < 1) return;  // can't have -ve String length
    char* temp = new char[sl];
    memcpy(temp, data + 1, sl - 1);
    delete[] data;
    data = temp;
    sl -= 1;
    data[sl] = '\0';
}

bool String::contains(const char *s) {
    if (indexOf(s) != -1) {
        return true;
    }
    return false;
}

void String::toLower() {
    for(int i = 0; i < sl; i++) {
        if ((data[i] >= 'A') && (data[i] <= 'Z')) {
            data[i] = 'a' + data[i] - 'A';
        }
    }
}

void String::removeWhiteSpace() {
    if (sl < 1) return;  // nothing to remove
    while((unsigned char)data[sl - 1] < 33 && sl > 0) {
        chop();
    }
    while((unsigned char)data[0] < 33 && sl > 0) {
        lop();
    }
}

unsigned char String::charAt(int index) {
    if (index >= sl) {
        return 0;
    }
    if (index < 0) {
        return 0;
    }
    unsigned char c = data[index];
    return c;
}

void String::removePTP() {
    if (startsWith("http://") || startsWith("ftp://")
                              || startsWith("https://")) {
        int pos = strstr(data, "://") - data + 3;
        char* temp = new char[sl - pos + 1];
        memcpy(temp, data + pos, sl - pos);
        delete[] data;
        data = temp;
        sl -= pos;
        data[sl] = '\0';
    }
}
