//Please refer to http://dansguardian.org/?page=copyright2
//for the license for this code.
//Written by Daniel Barron (daniel@jadeb//.com).
//For support go to http://groups.yahoo.com/group/dansguardian

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "autoconf/platform.h"
#include <syslog.h>
#include "ConnectionHandler.hpp"
#include "DataBuffer.hpp"
#include "Socket.hpp"
#include "UDSocket.hpp"
#include "Ident.hpp"
#ifdef __BSD  // A bodge to get round the problem of a truncated UDS file
	#define __IPC "/tmp/.dguardianipcc"
	#define __URLIPC "/tmp/.dguardianurlipcc"
#else
	#define __IPC "/tmp/.dguardianipc"
	#define __URLIPC "/tmp/.dguardianurlipc"
#endif
#include "NaughtyFilter.hpp"
#include "HTTPHeader.hpp"
#include "FDTunnel.hpp"
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <cstdio>
#include <algorithm>
#include <fstream>
#include <iostream>
#include <netdb.h>
#include <cstdlib>
#include <unistd.h>
#include <sys/time.h>

#ifdef __GCCVER3
    #include <istream>
#else
    #include <istream.h>
#endif

extern OptionContainer o;

void ConnectionHandler::handleConnection(Socket peerconn) {

    struct timeval thestart;
    struct timezone notused;
    gettimeofday(&thestart, &notused);

    peerconn.setTimeout(10);

    HTTPHeader header;  // to hold the incoming client request header

    header.setTimeout(10);  // set a timeout as we don't want blocking 4 eva

    HTTPHeader docheader;  // to hold the returned page header from proxy

    docheader.setTimeout(20);

    DataBuffer docbody;  // to hold the returned page

    docbody.setTimeout(60);

    bool waschecked = false;  // flags
    bool wasrequested = false;
    bool isexception = false;
    bool isourwebserver = false;
    bool wasclean = true;
    bool cachehit = false;

    std::string mimetype = "-";

    String url;
    String urld;

    std::string exceptionreason;  // to hold the reason for not blocking

    int docsize = 0;  // to store the size of the returned document for loggin

    Ident ident;  // for holding

    std::string clientip = peerconn.getPeerIP();  // hold the clients ip

    #ifdef DGDEBUG  // debug stuff surprisingly enough
        std::cout << "got connection" << std::endl;
        std::cout << clientip << std::endl;
    #endif

    Socket proxysock;  // to hold connection to proxy

    // connect to proxy
    int rc = proxysock.connect(o.proxy_ip, o.proxy_port);

    if (rc) {
        #ifdef DGDEBUG
            std::cerr << "Error connecting to proxy" << std::endl;
        #endif
        syslog(LOG_ERR, "%s","Error connecting to proxy");
        return;  // if we can't connect to the proxy, there is no point
                 // in continuing
    }

    try {
        header.in(peerconn);  // get header from client
        url = header.url();
        urld = header.decode(url);

        if (header.malformedURL(url)) {
            // checks for bad URLs to prevent security hole
            try { // writestring throws exception on error/timeout
                peerconn.writeString("HTTP/1.0 400 Bad Request\n");
                peerconn.writeString("Content-Type: text/html\n\n");
                peerconn.writeString("<HTML><HEAD><TITLE>DansGuardian - 400 Bad Request</TITLE></HEAD><BODY><H1>DansGuardian - 400 Bad Request</H1> ");
                peerconn.writeString(o.language_list.getTranslation(200));
                // The requested URL is malformed.
                peerconn.writeString("</BODY></HTML>\n");
            } catch (exception& e) {}
            try {
                proxysock.close();  // close connection to proxy
            } catch (exception& e) {}
            return;
        }

        std::string clientuser = ident.getUsername(&header, &peerconn);
                                                   // extract username

        if (o.use_xforwardedfor == 1) {
            std::string xforwardip = header.getXForwardedForIP();
            if (xforwardip.length() > 6) {
                clientip = xforwardip;
            }
            #ifdef DGDEBUG  // debug stuff surprisingly enough
                std::cout << "using x-forwardedfor:" << clientip << std::endl;
            #endif
        }
        if (o.forwarded_for == 1) {
            header.addXForwardedFor(clientip);  // add squid-like entry
        }

        if (o.inipexceptions(clientip)) {  // admin pc
            isexception = true;
            exceptionreason = o.language_list.getTranslation(600);
            // Exception client IP match.
        }
        else if (o.inuserexceptions(clientuser)) { // admin user
            isexception = true;
            exceptionreason = o.language_list.getTranslation(601);
            // Exception client user match.
        }
        else if (o.inexceptions(urld)) {  // allowed site
            if (o.iswebserver(url)) {
                isourwebserver = true;
            }
            else {
                isexception = true;
                exceptionreason = o.language_list.getTranslation(602);
                // Exception site match.
            }
        }
        else if (o.inurlexceptions(urld)) {  // allowed url
            isexception = true;
            exceptionreason = o.language_list.getTranslation(603);
            // Exception url match.
        }

        #ifdef DGDEBUG
            std::cout << "extracted url:" << urld << std::endl;
        #endif


        if ( ((o.inipexceptions(clientip)  // admin pc
                || o.inuserexceptions(clientuser) // admin user
                || o.inurlexceptions(urld) // ok part of site
                || o.inexceptions(urld)) // ok site
                && !o.inBannedIPList(clientip)  // bad users pc
                && !o.inBannedUserList(clientuser)) ||  // bad user
                isourwebserver  // don't filter the web server
                 ) {

            proxysock.readyForOutput(10);  // exception on timeout or error
            header.out(proxysock);  // send proxy the request
            try {
                FDTunnel fdt;  // make a tunnel object
                // tunnel from client to proxy and back
                fdt.tunnel(proxysock.getFD(), peerconn.getFD()); // not expected to exception
                docsize = fdt.throughput;
                if (!isourwebserver) {  // don't log requests to the web server
                    decideHowToLog(clientuser, clientip, url.toCharArray(), exceptionreason, header.requesttype().toCharArray(), docsize, o.ll, false, isexception, o.log_exception_hits, false, &thestart, cachehit, 200, mimetype);
                }

            } catch (exception& e) {}
            try {
                proxysock.close();  // close connection to proxy
            } catch (exception& e) {}
            return;  // connection dealt with so exit
        }

        if (!o.inexceptions(urld)
                || !o.inurlexceptions(urld)
                || o.inBannedIPList(clientip)
                || o.inBannedUserList(clientuser)
                 ) {
            NaughtyFilter checkme;  // our filter object
            int i;
            String temp;
            temp = urld;

            if (o.blanketblock == 1) {
                checkme.isItNaughty = true;
                checkme.whatIsNaughty = o.language_list.getTranslation(502);
                // Blanket Block is active and that site is not on the white list.
                checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
            }

            if (!checkme.isItNaughty) {
                if (o.inBannedIPList(clientip)) {
                    checkme.isItNaughty = true;
                    checkme.whatIsNaughtyLog = o.language_list.getTranslation(100);
                    // Your IP address is not allowed to web browse:
                    checkme.whatIsNaughtyLog += clientip;

                    checkme.whatIsNaughty = o.language_list.getTranslation(101);
                    // Your IP address is not allowed to web browse.
                }
            }

            if (!checkme.isItNaughty) {
                if (o.inBannedUserList(clientuser)) {
                    checkme.isItNaughty = true;
                    checkme.whatIsNaughtyLog = o.language_list.getTranslation(102);
                    // Your username is not allowed to web browse:
                    checkme.whatIsNaughtyLog += clientuser;
                    checkme.whatIsNaughty = checkme.whatIsNaughtyLog;
                }
            }

            if (!checkme.isItNaughty) {
                i = o.inBannedRegExpURLList(temp);
                if (i >= 0) {
                    checkme.isItNaughty = true;
                    checkme.whatIsNaughtyLog = o.language_list.getTranslation(503);
                    // Banned Regular Expression URL:
                    checkme.whatIsNaughtyLog += o.banned_regexpurl_list.getItemAt(i);
                    checkme.whatIsNaughty = o.language_list.getTranslation(504);
                    // Banned Regular Expression URL found.
                }
            }
            if (!checkme.isItNaughty) {
                i = o.inBannedURLList(temp);
                if (i >= 0) {
                    checkme.whatIsNaughty = o.language_list.getTranslation(501);
                    // Banned URL:
                    checkme.whatIsNaughty += o.banned_url_list.getItemAt(i);
                    checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                    checkme.isItNaughty = true;
                }
            }
            if (!checkme.isItNaughty) {
                i = o.inBannedSiteList(temp);
                if (i == -2) {
                    checkme.isItNaughty = true;
                    checkme.whatIsNaughty = o.language_list.getTranslation(502);
                    //Blanket IP Block is active and that address is an IP only address.
                    checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                }
                if (i >= 0) {
                    checkme.whatIsNaughty = o.language_list.getTranslation(500); // banned site
                    checkme.whatIsNaughty += o.banned_site_list.getItemAt(i);
                    checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                    checkme.isItNaughty = true;
                }
            }


            if (!checkme.isItNaughty && o.max_upload_size > -1) {
                if (header.isPostUpload()) {
                    #ifdef DGDEBUG
                        std::cout << "is post upload" << std::endl;
                    #endif
                    if (o.max_upload_size == 0) {
                        checkme.whatIsNaughty = o.language_list.getTranslation(700);
                        // Web upload is banned.
                        checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                        checkme.isItNaughty = true;
                    }
                    else if (header.contentlength() > o.max_upload_size) {
                        checkme.whatIsNaughty = o.language_list.getTranslation(701);
                        // Web upload limit exceeded.
                        checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                        checkme.isItNaughty = true;
                    }
                }
            }

            if (!checkme.isItNaughty && header.requesttype().startsWith("CONNECT")) {
                // can't filter content of CONNECT
                proxysock.readyForOutput(10);  // exception on timeout or error
                header.out(proxysock);  // send proxy the request
                try {
                    FDTunnel fdt;  // make a tunnel object
                    // tunnel from client to proxy and back
                    fdt.tunnel(proxysock.getFD(), peerconn.getFD()); // not expected to exception
                    docsize = fdt.throughput;
                    decideHowToLog(clientuser, clientip, url.toCharArray(), exceptionreason, header.requesttype().toCharArray(), docsize, o.ll, false, isexception, o.log_exception_hits, false, &thestart, cachehit, 200, mimetype);
                } catch (exception& e) {}
                try {
                    proxysock.close();  // close connection to proxy
                } catch (exception& e) {}
                return;  // connection dealt with so exit
            }


            if (!checkme.isItNaughty) {
                proxysock.readyForOutput(10);
                header.out(proxysock);  // send header to proxy
                proxysock.checkForInput(60);
                docheader.in(proxysock);  // get header from proxy
                #ifdef DGDEBUG
                    std::cout << "got header from proxy" << std::endl;
                #endif
                wasrequested = true;  // so we know where we are later

                mimetype = docheader.getcontenttype().toCharArray();

                i = o.banned_mimetype_list.findInList((char*)mimetype.c_str());
                if (i >= 0) {
                    checkme.whatIsNaughty = o.language_list.getTranslation(800);
                    // Banned MIME Type:
                    checkme.whatIsNaughty += o.banned_mimetype_list.getItemAt(i);

                    checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                    checkme.isItNaughty = true;
                }
                #ifdef DGDEBUG
                    std::cout << mimetype.length() << std::endl;
                    std::cout << ":" << mimetype;
                    std::cout << ":" << std::endl;
                #endif


                if (!checkme.isItNaughty && !docheader.isRedirection()) {
                    // Can't ban file extensions of URLs that just redirect
                    String tempurl = urld;
                    String tempdispos = docheader.disposition();
                    if (tempdispos.length() > 1) {
                        // dispos filename must take presidense
                        #ifdef DGDEBUG
                             std::cout << "Disposition filename:" << tempdispos << ":" << std::endl;
                        #endif
                        // The function expects a url so we have to
                        // generate a psudo one.
                        tempdispos = "http://foo.bar/" + tempdispos;
                        i = o.inBannedExtensionList(tempdispos);
                        if (i >= 0) {
                            checkme.whatIsNaughty = o.language_list.getTranslation(900);
                            // Banned extension:
                            checkme.whatIsNaughty += o.banned_extension_list.getItemAt(i);
                            checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                            checkme.isItNaughty = true;
                        }
                    }
                    else {
                        if (!tempurl.contains("?")) {
                            i = o.inBannedExtensionList(tempurl);
                            if (i >= 0) {
                                checkme.whatIsNaughty =  o.language_list.getTranslation(900);
                                // Banned extension:
                                checkme.whatIsNaughty += o.banned_extension_list.getItemAt(i);
                                checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                                checkme.isItNaughty = true;
                            }
                        }
                        if (String(mimetype.c_str()).contains("application/")) {
                            while (tempurl.endsWith("?")) {
                                tempurl.chop();
                            }
                            while(tempurl.contains("/")) {  // no slash no url
                                i = o.inBannedExtensionList(tempurl);
                                if (i >= 0) {
                                    checkme.whatIsNaughty =  o.language_list.getTranslation(900);
                                    // Banned extension:
                                    checkme.whatIsNaughty += o.banned_extension_list.getItemAt(i);
                                    checkme.whatIsNaughtyLog = checkme.whatIsNaughty;
                                    checkme.isItNaughty = true;
                                    break;
                                }
                                while (tempurl.contains("/") && !tempurl.endsWith("?")) {
                                    tempurl.chop();
                                }
                                tempurl.chop();  // get rid of the ?

                            }
                        }
                    }
                }

                if (docheader.iscontenttype("text") && !checkme.isItNaughty) {
                    // here we check if its a known good one
                    // if so we skip content checking



                    waschecked = true;
                    proxysock.checkForInput(60);
                    if (docheader.isCompressed()) {
                        docbody.setDecompress(docheader.contentEncoding());
                        #ifdef DGDEBUG
                            std::cout << docheader.contentEncoding() << std::endl;
                        #endif
                    }
                    #ifdef DGDEBUG
                        std::cout << "about to get body from proxy" << std::endl;
                    #endif
                    docbody.in(proxysock);  // get body from proxy
                    #ifdef DGDEBUG
                        std::cout << "got body from proxy" << std::endl;
                    #endif

                    int dblen = docbody.length();
                    docsize = dblen;

                    if (docheader.isCompressed()) {
                        docheader.removeEncoding(dblen);
                        // need to modify header to mark as not compressed
                        // it also modifies Content-Length as well
                    }


                    wasclean = false;
                    if (o.url_cache_number > 0) {
                        if (wasClean(urld)) {
                            wasclean = true;
                            #ifdef DGDEBUG
                                std::cout << "url was clean skipping content checking" << std::endl;
                            #endif
                        }
                    }
                    if (!wasclean) {
                        #ifdef DGDEBUG
                            system("date");
                        #endif
                        if (dblen < o.max_content_filter_size
                            || o.max_content_filter_size == 0) {
                            checkme.checkme(&docbody);  // content filtering
                        }
                        #ifdef DGDEBUG
                            else {
                                std::cout << "content length large so skipping content filtering" << std::endl;
                            }
                            system("date");
                        #endif
                    }
                    else {
                        cachehit = true;
                    }
                    #ifdef DGDEBUG
                        system("date");
                    #endif
                    if (dblen < o.max_content_filter_size
                        || o.max_content_filter_size == 0) {
                        docbody.contentRegExp();  // content modifying
                                              // uses global variable
                    }
                    #ifdef DGDEBUG
                        else {
                            std::cout << "content length large so skipping content modifying" << std::endl;
                        }
                        system("date");
                    #endif

                    docheader.setContentLength(docbody.buffer_length);
                // here if its OK then request addition to good url database

                }

            }

            if (checkme.isException) {
                isexception = true;
                exceptionreason = checkme.whatIsNaughtyLog;
            }

            if (docheader.isRedirection()) {
                checkme.isItNaughty = false;
            }

            if (o.url_cache_number > 0) {
                if (!wasclean && !checkme.isItNaughty) {
                    addToClean(urld);
                }
            }

            if (checkme.isItNaughty) {  // then we deny

                decideHowToLog(clientuser, clientip, url.toCharArray(), checkme.whatIsNaughtyLog, header.requesttype().toCharArray(), docsize, o.ll, true, false, false, false, &thestart, cachehit, 403, mimetype);

                try { // writestring throws exception on error/timeout
                    if (o.reporting_level == 3) {
                        proxysock.close();  // finshed with proxy
                        peerconn.readyForOutput(10);
                        if (header.requesttype().startsWith("CONNECT")) {
                            String redirhttps = url.after("://");
                            if (!redirhttps.contains("/")) {
                                redirhttps += "/";
                            }
                            redirhttps = "http://" + redirhttps;
                    //  The idea is that redirecting it back to the http page
                    // of itself will also get blocked but won't confuse the
                    // browser when it gets unencrypted content

                            try { // writestring throws exception on error/timeout
                                peerconn.writeString("HTTP/1.0 302 Redirect\n");
                                peerconn.writeString("Location: ");
                                peerconn.writeString(redirhttps.toCharArray());
                                peerconn.writeString("\n\n");
                            } catch (exception& e) {}
                        }
                        else {
                            peerconn.writeString("HTTP/1.0 200 OK\n");
                            peerconn.writeString("Content-type: text/html\n\n");
                            o.html_template.display(&peerconn,
                                url.toCharArray(),
                                checkme.whatIsNaughty.c_str(),
                                checkme.whatIsNaughtyLog.c_str(),
                                clientuser.c_str(),
                                clientip.c_str());
                        }
                    }
                    else if (o.reporting_level > 0) {
                        proxysock.close();  // finshed with proxy
                        peerconn.readyForOutput(10);
                        if (checkme.whatIsNaughty.length() > 2048) {
                            checkme.whatIsNaughty = String(checkme.whatIsNaughty.c_str()).subString(0, 2048).toCharArray();
                        }
                        if (checkme.whatIsNaughtyLog.length() > 2048) {
                            checkme.whatIsNaughtyLog = String(checkme.whatIsNaughtyLog.c_str()).subString(0, 2048).toCharArray();
                        }
                        peerconn.writeString("HTTP/1.0 302 Redirect\n");
                        peerconn.writeString("Location: ");
                        peerconn.writeString(o.access_denied_address.c_str());
                        peerconn.writeString("?DENIEDURL=");
                        peerconn.writeString(miniURLEncode(url.toCharArray()).c_str());
                        peerconn.writeString("&REASON=");
                        if (o.reporting_level == 1) {
                            peerconn.writeString(miniURLEncode(checkme.whatIsNaughty).c_str());
                        }
                        else {
                            peerconn.writeString(miniURLEncode(checkme.whatIsNaughtyLog).c_str());
                        }
                        peerconn.writeString("&USER=");
                        peerconn.writeString(clientuser.c_str());
                        peerconn.writeString("\n\n");
                    }
                    else if (o.reporting_level == 0) {
                        proxysock.close();  // finshed with proxy
                        peerconn.readyForOutput(10);
                        peerconn.writeString("HTTP/1.0 200 OK\n");
                        peerconn.writeString("Content-type: text/html\n\n");
                        peerconn.writeString("<HTML><HEAD><TITLE>DansGuardian - ");
                        peerconn.writeString(o.language_list.getTranslation(1)); // access denied
                        peerconn.writeString("</TITLE></HEAD><BODY><CENTER><H1>DansGuardian - ");
                        peerconn.writeString(o.language_list.getTranslation(1)); // access denied
                        peerconn.writeString("</H1></CENTER></BODY></HTML>");
                    }
                    else if (o.reporting_level == -1) {  // stealth
                        checkme.isItNaughty = false;  // dont block
                    }
                } catch (exception& e) {}
                if (checkme.isItNaughty) { // not stealth mode then
                    try {
                        peerconn.readyForOutput(10);  //as best a flush as I can
                    } catch (exception& e) {}
                    try {
                        proxysock.close();  // close connection to proxy
                    } catch (exception& e) {}
                    return;  // we said no, so return
                }
            }
        }

        if (wasrequested == false) {
            proxysock.readyForOutput(10); // exceptions on error/timeout
            header.out(proxysock); // exceptions on error/timeout
            proxysock.checkForInput(60); // exceptions on error/timeout
            docheader.in(proxysock);  // get reply header from proxy
        }



        #ifdef DGDEBUG
            std::cout << "sending header to client" << std::endl;
        #endif
        peerconn.readyForOutput(10);  // exceptions on error/timeout
        docheader.out(peerconn);  // send header to client
        #ifdef DGDEBUG
             std::cout << "sent header to client" << std::endl;
        #endif
        if (waschecked) {
            decideHowToLog(clientuser, clientip, url.toCharArray(), exceptionreason, header.requesttype().toCharArray(), docsize, o.ll, false, isexception, o.log_exception_hits, docheader.iscontenttype("text"), &thestart, cachehit, 200, mimetype);

            #ifdef DGDEBUG
                std::cout << "sending body to client" << std::endl;
            #endif
            peerconn.readyForOutput(10); // check for error/timeout needed
            docbody.out(peerconn); // send doc body to client
            #ifdef DGDEBUG
                std::cout << "sent body to client" << std::endl;
            #endif
        }
        else {  // was not supposed to be checked
            FDTunnel fdt;
            #ifdef DGDEBUG
                std::cout << "tunnel activated" << std::endl;
            #endif
            fdt.tunnel(proxysock.getFD(), peerconn.getFD());
            docsize = fdt.throughput;

            decideHowToLog(clientuser, clientip, url.toCharArray(), exceptionreason, header.requesttype().toCharArray(), docsize, o.ll, false, isexception, o.log_exception_hits, docheader.iscontenttype("text"), &thestart, cachehit, 200, mimetype);

        }
    } catch (exception& e) {
        #ifdef DGDEBUG
            std::cout << "connection handler caught an exception" << std::endl;
        #endif
        try {
            proxysock.close();  // close connection to proxy
        } catch (exception& e) {}
        return;
    }

    try {
        proxysock.close();  // close conection to squid
    } catch (exception& e) {}
    try {
        peerconn.readyForOutput(10);
    }
    catch (exception& e) {
        return;
    }
    return;
}

// if we don't do this the browsers complain
std::string ConnectionHandler::miniURLEncode(std::string s) {
    std::string encoded;
    char* buf = new char[16];  // way longer than needed
    unsigned char c;
    for(int i=0; i < (signed)s.length(); i++) {
        c = s[i];
        if ((c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') ||  c == '.' || c == '-' || c == '_') {  // allowed characters in a url that have non special meaning
            encoded += c;
            continue;
        }
        sprintf(buf, "%x", c);
        encoded += "%";
        encoded += buf;
    }
    delete[] buf;
    return encoded;
}

void ConnectionHandler::doTheLogMan(std::string who, std::string from, std::string where, std::string what, std::string how, int size, struct timeval *thestart, bool cachehit, int code, std::string mimetype) {
    std::string logline,year,month,day,hour,min,sec,when,ssize,duration, utime, hitmiss, hier;
    struct timeval theend;
    struct timezone notused;
    gettimeofday(&theend, &notused);
    long durationsecs, durationusecs;
    durationsecs = theend.tv_sec - (*thestart).tv_sec;
    durationusecs = theend.tv_usec - (*thestart).tv_usec;
    durationusecs = (durationusecs / 1000) + durationsecs * 1000;
    String temp = String((int)durationusecs);
    while (temp.length() < 6) {
        temp = " " + temp;
    }
    duration = temp.toCharArray();
    temp = String((int)(theend.tv_usec / 1000));
    while (temp.length() < 3) {
        temp = "0" + temp;
    }
    if (temp.length() > 3) {
        temp = "999";
    }
    utime = temp.toCharArray();
    utime = "." + utime;
    utime = String((int)theend.tv_sec).toCharArray() + utime;


    if (code == 403) {
        hitmiss = "TCP_DENIED/403";
    }
    else {
        if (cachehit) {
            hitmiss = "TCP_HIT/";
            hitmiss += String(code).toCharArray();
        }
        else {
           hitmiss = "TCP_MISS/";
           hitmiss += String(code).toCharArray();
        }
    }
    hier = "DEFAULT_PARENT/";
    hier += o.proxy_ip;

    time_t tnow;  // to hold the result from time()
    struct tm *tmnow;  // to hold the result from localtime()
    time(&tnow);  // get the time after the lock so all entries in order
    tmnow = localtime(&tnow);  // convert to local time (BST, etc)
    year = String(tmnow->tm_year + 1900).toCharArray();
    month = String(tmnow->tm_mon + 1).toCharArray();
    day = String(tmnow->tm_mday).toCharArray();
    hour = String(tmnow->tm_hour).toCharArray();
    temp = String(tmnow->tm_min);
    if (temp.length() == 1) { temp = "0" + temp;}
    min = temp.toCharArray();
    temp = String(tmnow->tm_sec);
    if (temp.length() == 1) { temp = "0" + temp;}
    sec = temp.toCharArray();
    ssize = String(size).toCharArray();
    when = year + "." + month + "." + day + " " + hour + ":" + min + ":" + sec;
    switch(o.log_file_format){
        case 4:
            logline = when +"\t"+ who + "\t" + from + "\t" + where + "\t" + what + "\t" + how + "\t" + ssize + "\n";
            break;
        case 3:
            logline = utime + " " + duration + " " + from + " " + hitmiss + " " + ssize + " " + how + " " + where + " " + who + " " + hier + " " + mimetype + "\n";
            break;

        case 2:
            logline = "\"" + when +"\",\""+ who + "\",\"" + from + "\",\"" + where + "\",\"" + what + "\",\"" + how + "\",\"" + ssize + "\"\n";
            break;
        default:
            logline = when +" "+ who + " " + from + " " + where + " " + what + " " + how + " " + ssize + "\n";
    }
    UDSocket ipcsock;
    if (ipcsock.getFD() < 0) {
        syslog(LOG_ERR, "%s","Error creating ipc socket to log");
        return;
    }
    if (ipcsock.connect(__IPC) < 0) {  // connect to dedicated logging proc
        syslog(LOG_ERR, "%s","Error connecting via ipc to log");
        ipcsock.close();
        return;
    }
    ipcsock.writeString(logline.c_str());
    ipcsock.close();
}



void ConnectionHandler::decideHowToLog(std::string who, std::string from, std::string where, std::string what, std::string how, int size, int loglevel, bool isnaughty, bool isexception, int logexceptions, bool istext, struct timeval *thestart, bool cachehit, int code, std::string mimetype) {

    if (loglevel == 0) {
        return;
    }
        if (isnaughty) {
            what = "*DENIED* " + what;
            // make it stand out in the logs and also
            // more easily findable with a search
        }
        if (isexception) {
            if (logexceptions == 1) {
                what = "*EXCEPTION* " + what;
            }
            else {
                what = "";
            }
        }
    if ((isexception && logexceptions == 1)
         || isnaughty
         || loglevel == 3
         || (loglevel == 2 && istext)) {
        doTheLogMan(who, from, where, what, how, size, thestart, cachehit, code, mimetype);
    }
}



bool ConnectionHandler::wasClean(String url) {
    url = url.after("://");
    UDSocket ipcsock;
    if (ipcsock.getFD() < 0) {
        syslog(LOG_ERR, "%s","Error creating ipc socket to url cache");
        return false;
    }
    if (ipcsock.connect(__URLIPC) < 0) {  // conn to dedicated url cach proc
        syslog(LOG_ERR, "%s","Error connecting via ipc to url cache");
        return false;
    }
    url += "\n";
    char* reply = new char[8];
    #ifdef DGDEBUG
        std::cout << "sending clean request:" << url.toCharArray() << std::endl;
    #endif
    try {
        ipcsock.writeString(url.toCharArray());  // throws on err
    }
    catch (exception& e) {
        #ifdef DGDEBUG
            std::cerr << "Exception writing to url cache" << std::endl;
            std::cerr << e.what() << std::endl;
        #endif
        syslog(LOG_ERR, "%s","Exception writing to url cache");
        syslog(LOG_ERR, "%s", e.what());
    }
    try {
        ipcsock.getline(reply, 7, 6);  // throws on err
    }
    catch (exception& e) {
        #ifdef DGDEBUG
            std::cerr << "Exception reading from url cache" << std::endl;
            std::cerr << e.what() << std::endl;
        #endif
        syslog(LOG_ERR, "%s","Exception reading from url cache");
        syslog(LOG_ERR, "%s", e.what());
    }
    ipcsock.close();
    if (reply[0] == 'Y') {
        delete[] reply;
        return true;
    }
    delete[] reply;
    return false;
}


void ConnectionHandler::addToClean(String url) {
    url = url.after("://");
    UDSocket ipcsock;
    if (ipcsock.getFD() < 0) {
        syslog(LOG_ERR, "%s","Error creating ipc socket to url cache");
        return;
    }
    if (ipcsock.connect(__URLIPC) < 0) {  // conn to dedicated url cach proc
        syslog(LOG_ERR, "%s","Error connecting via ipc to url cache");
        #ifdef DGDEBUG
            std::cout << "Error connecting via ipc to url cache" << std::endl;
        #endif
        return;
    }
    url += "\n";
    url = "A " + url;
    try {
        ipcsock.writeString(url.toCharArray());  // throws on err
    }
    catch (exception& e) {
        #ifdef DGDEBUG
            std::cerr << "Exception adding to url cache" << std::endl;
            std::cerr << e.what() << std::endl;
        #endif
        syslog(LOG_ERR, "%s","Exception adding to url cache");
        syslog(LOG_ERR, "%s", e.what());
    }
    ipcsock.close();
}

