//Please refer to http://dansguardian.org/?page=copyright2
//for the license for this code.
//Written by Daniel Barron (daniel@jadeb.com).
//For support go to http://groups.yahoo.com/group/dansguardian

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __HPP_FATCONTROLLER
#define __HPP_FATCONTROLLER
#include "OptionContainer.hpp"
#include "UDSocket.hpp"
#include <string>

extern "C" {

    void sig_chld(int signo);  // The kernal knows nothing of objects so
                               // we have to have a lump of c
    void sig_term(int signo);  // This is so we can kill our children
    void sig_hup(int signo);  // This is so we know if we should re-read
                              // our config.

}

// static volatile bool timetoreap = false;  // not used any more

static volatile bool ttg = false;

static volatile bool reloadconfig = false;


class FatController {



public:
    int controlIt(int pidfilefd);
    bool testProxy(std::string proxyip, int proxyport, bool report);

private:
    int logListener(UDSocket ipcsock, std::string loglocation, int logconerror);
    bool daemonise(int pidfilefd);
    int urlListListener(UDSocket ipcsock, int logconerror);
};

#endif
