<?php

///// Main Function

function browserrecon($rawheader, $database='', $mode='besthit'){
	return announcefingerprintmatches(generatematchstatistics(identifyglobalfingerprint($database, $rawheader)), $mode);
}

///// Header Extraction

function getfullheaders(){
	$headers = apache_request_headers();
	
	foreach($headers as $header => $value){
		$full_header.= $header.': '.$value."\n";
	}

	return $full_header;
}

function getheadervalue($rawheader, $headername){
	$headers = explode("\n", $rawheader, 64);
	$headernamesmall = strtolower($headername);

	foreach($headers as $header){
		$header_data = explode(':', $header, 2);
		if(strtolower($header_data['0']) == $headernamesmall){
			return trim($header_data['1']);
		}
	}
}

function getheaderorder($rawheader){
	$headers = explode("\n", $rawheader, 64);

	foreach($headers as $header){
		$header_data = explode(':', $header, 2);
		if(strlen($header_data['0']) > 2){
			$header_order.= trim($header_data['0']).', ';
		}
	}

	return $header_order;
}

///// Database Search

// Find all entries in the data base which match the given header elements
function identifyglobalfingerprint($database, $rawheader){
	$matchlist = findmatchindatabase($database.'user-agent.fdb', getheadervalue($rawheader, 'User-Agent'));
	$matchlist.= findmatchindatabase($database.'accept.fdb', getheadervalue($rawheader, 'Accept'));
	$matchlist.= findmatchindatabase($database.'accept-language.fdb', getheadervalue($rawheader, 'Accept-Language'));
	$matchlist.= findmatchindatabase($database.'accept-encoding.fdb', getheadervalue($rawheader, 'Accept-Encoding'));
	$matchlist.= findmatchindatabase($database.'accept-charset.fdb', getheadervalue($rawheader, 'Accept-Charset'));
	$matchlist.= findmatchindatabase($database.'keep-alive.fdb', getheadervalue($rawheader, 'Keep-Alive'));
	$matchlist.= findmatchindatabase($database.'connection.fdb', getheadervalue($rawheader, 'Connection'));
	$matchlist.= findmatchindatabase($database.'cache-control.fdb', getheadervalue($rawheader, 'Cache-Control'));
	$matchlist.= findmatchindatabase($database.'ua-pixels.fdb', getheadervalue($rawheader, 'UA-Pixels'));
	$matchlist.= findmatchindatabase($database.'ua-color.fdb', getheadervalue($rawheader, 'UA-Color'));
	$matchlist.= findmatchindatabase($database.'ua-os.fdb', getheadervalue($rawheader, 'UA-OS'));
	$matchlist.= findmatchindatabase($database.'ua-cpu.fdb', getheadervalue($rawheader, 'UA-CPU'));
	$matchlist.= findmatchindatabase($database.'te.fdb', getheadervalue($rawheader, 'TE'));
	$matchlist.= findmatchindatabase($database.'header-order.fdb', getheaderorder($rawheader));

	return $matchlist;
}

// Add a new implementation to the data base as long as the same entry does not exist yet
function addtodatabase($databasefile, $implementation, $value){
	if(strlen($implementation) && strlen($value)){
		if(!isindatabase($databasefile, $implementation, $value)){
			if(is_writable($databasefile)){
				if($fh = fopen($databasefile, 'a')){
					fwrite($fh, $implementation.';'.$value."\n");
					fclose($fh);
				}
			}
		}
	}
}

// Identify duplicate entries before adding a fingerprint to the data base
function isindatabase($databasefile, $implementation, $value){
	$database = file_get_contents($databasefile);

	if(strpos($database, $implementation.';'.$value) === FALSE){
		return 0;
	}else{
		return 1;
	}
}

// Find a match within the data base
function findmatchindatabase($databasefile, $fingerprint){
	$database = file($databasefile);
	
	foreach($database as $entry){
		$entryarray = explode(';', $entry, 2);
		if(strtolower($fingerprint) == rtrim(strtolower($entryarray['1']))){
			$matches.= $entryarray['0'].';';
		}
	}

	return $matches;
}

/////  Announcement

function announcefingerprintmatches($fullmatchlist, $mode='besthit'){
	$resultlist = generatematchstatistics($fullmatchlist);
	$resultarray = explode("\n", $resultlist);
	
	foreach($resultarray as $result){
		$entry = explode(':', $result);

		if(strlen($entry['0'])){
			if($scan_besthitcount < $entry['1']){
				$scan_besthitname = $entry['0'];
				$scan_besthitcount = $entry['1'];
			}
			$scan_resultlist.= $entry['0'].': '.$entry['1'].'<br />';
		}
	}

	if($mode == 'list'){
		return $scan_resultlist;
	}elseif($mode == 'besthitdetail'){
		return $scan_besthitname.' ('.$scan_besthitcount.' hits)';
	}else{
		return $scan_besthitname;
	}
}

function generatematchstatistics($matchlist){
	$matchesarray = explode(';', $matchlist);
	$matches = array_unique($matchesarray);
	
	foreach($matches as $match){
		$matchstatistic.= $match.':'.countif($matchesarray, $match)."\n";
	}

	return $matchstatistic;
}

function countif($input, $search){
	foreach($input as $entry){
		if($entry == $search){
			++$sum;
		}
	}
	return $sum;
}

///// Save Fingerprints

function sendfingerprint($implementation, $fingerprint){
	$mailmessage = 'Implementation: '.$implementation."\n\n";
	$mailmessage.= $fingerprint."\n";
	mail('marc.ruef@computec.ch', '[browserrecon] fingerprint upload', $mailmessage);
}

function saveallfingerprintstodatabase($rawheader, $implementation){
	savenewfingerprinttodatabase('scan/user-agent.fdb', $implementation, getheadervalue($rawheader, 'User-Agent'));
	savenewfingerprinttodatabase('scan/accept.fdb', $implementation, getheadervalue($rawheader, 'Accept'));
	savenewfingerprinttodatabase('scan/accept-language.fdb', $implementation, getheadervalue($rawheader, 'Accept-Language'));
	savenewfingerprinttodatabase('scan/accept-encoding.fdb', $implementation, getheadervalue($rawheader, 'Accept-Encoding'));
	savenewfingerprinttodatabase('scan/accept-charset.fdb', $implementation, getheadervalue($rawheader, 'Accept-Charset'));
	savenewfingerprinttodatabase('scan/keep-alive.fdb', $implementation, getheadervalue($rawheader, 'Keep-Alive'));
	savenewfingerprinttodatabase('scan/connection.fdb', $implementation, getheadervalue($rawheader, 'Connection'));
	savenewfingerprinttodatabase('scan/cache-control.fdb', $implementation, getheadervalue($rawheader, 'Cache-Control'));
	savenewfingerprinttodatabase('scan/ua-pixels.fdb', $implementation, getheadervalue($rawheader, 'UA-Pixels'));
	savenewfingerprinttodatabase('scan/ua-color.fdb', $implementation, getheadervalue($rawheader, 'UA-Color'));
	savenewfingerprinttodatabase('scan/ua-os.fdb', $implementation, getheadervalue($rawheader, 'UA-OS'));
	savenewfingerprinttodatabase('scan/ua-cpu.fdb', $implementation, getheadervalue($rawheader, 'UA-CPU'));
	savenewfingerprinttodatabase('scan/te.fdb', $implementation, getheadervalue($rawheader, 'TE'));
	savenewfingerprinttodatabase('scan/header-order.fdb', $implementation, getheaderorder($rawheader));
}

function savenewfingerprinttodatabase($filename, $implementation, $value){
	addtodatabase($filename, $implementation, $value);
}

?>