#include "gui.h"

#ifdef HAVE_GTK

void
gui_init (int ac, char *av[])
{
  /* X Windows */
  GtkWidget *window;
  GtkWidget *box1, *box2;
  GtkWidget *btn_close;
  GtkWidget *btn_clear;
  GtkWidget *label1;
  GtkWidget *btn_about;
  GtkWidget *chk_cache, *chk_cook, *chk_hist, *chk_drop;
  char buffer[100];

  gtk_init (&ac, &av);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  sprintf (buffer, "ComClear v%s", VERSION);
  gtk_window_set_title (GTK_WINDOW (window), buffer);
  gtk_window_set_default_size (GTK_WINDOW (window), 200, 200);
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (window), 10);

  box1 = gtk_vbox_new (FALSE, 0);
  box2 = gtk_hbox_new (FALSE, 0);
  label1 = gtk_label_new ("Please select the items to clear.");

  /* Buttons */
  btn_clear = gtk_button_new_with_label ("Clear");
  btn_about = gtk_button_new_with_label ("About");
  btn_close = gtk_button_new_with_label ("Close");

  /* Checkboxes */
  chk_cache = gtk_check_button_new_with_label ("Clear cache");
  chk_cook = gtk_check_button_new_with_label ("Clear cookies");
  chk_hist = gtk_check_button_new_with_label ("Clear history");
  chk_drop = gtk_check_button_new_with_label ("Clear drop-down");

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (destroy), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (destroy), NULL);
  gtk_signal_connect (GTK_OBJECT (btn_clear), "clicked",
		      GTK_SIGNAL_FUNC (gui_clear), NULL);
  gtk_signal_connect (GTK_OBJECT (btn_close), "clicked",
		      GTK_SIGNAL_FUNC (destroy), NULL);
  gtk_signal_connect (GTK_OBJECT (btn_about), "clicked",
		      GTK_SIGNAL_FUNC (about), NULL);

  /* Check buttons, has to be a cleaner way */
  gtk_signal_connect (GTK_OBJECT (chk_cache), "toggled",
		      GTK_SIGNAL_FUNC (toggle_cache), NULL);
  gtk_signal_connect (GTK_OBJECT (chk_hist), "toggled",
		      GTK_SIGNAL_FUNC (toggle_hist), NULL);
  gtk_signal_connect (GTK_OBJECT (chk_drop), "toggled",
		      GTK_SIGNAL_FUNC (toggle_drop), NULL);
  gtk_signal_connect (GTK_OBJECT (chk_cook), "toggled",
		      GTK_SIGNAL_FUNC (toggle_cook), NULL);

  gtk_container_add (GTK_CONTAINER (window), box1);

  gtk_box_pack_start (GTK_BOX (box2), btn_clear, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (box2), btn_about, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (box2), btn_close, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX (box1), label1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (box1), chk_cache, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (box1), chk_cook, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (box1), chk_hist, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (box1), chk_drop, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);

  gtk_widget_show_all (window);
  gtk_main ();
  return;
}

void
destroy (GtkWidget * widget, gpointer data)
{
  gtk_main_quit ();
}

void
about (GtkWidget * widget, gpointer data)
{
  GtkWidget *about, *label, *homepage, *okay;

  about = gtk_dialog_new ();
  label = gtk_label_new (info);

  gtk_window_set_title (GTK_WINDOW (about), "About ComClear");
  gtk_window_set_default_size (GTK_WINDOW (about), 300, 60);
  gtk_window_set_policy (GTK_WINDOW (about), FALSE, FALSE, FALSE);
  gtk_window_set_modal(GTK_WINDOW(about), TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (about), 10);

  homepage = gtk_button_new_with_label ("Homepage");
  okay = gtk_button_new_with_label ("OK");

  gtk_signal_connect_object (GTK_OBJECT (okay), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (about));
  gtk_signal_connect_object (GTK_OBJECT (homepage), "clicked",
			     GTK_SIGNAL_FUNC (gohome), NULL);

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (about)->action_area),
		     homepage);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (about)->action_area), okay);

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (about)->vbox), label);

  gtk_window_set_modal (GTK_WINDOW (about), TRUE);
  gtk_window_set_position (GTK_WINDOW (about), GTK_WIN_POS_CENTER);
  gtk_widget_show_all (about);

}

void
gui_clear (GtkWidget * widget, gpointer data)
{
  /* Build a dialog and then call the comclear() function
   * with the proper call back item */
  GtkWidget *about, *label, *okay;

  about = gtk_dialog_new ();
  label = gtk_label_new ("Starting clear...");
  gtk_window_set_title (GTK_WINDOW (about), "Clearing...");
  gtk_window_set_default_size (GTK_WINDOW (about), 500, 100);

  gtk_window_set_policy (GTK_WINDOW (about), FALSE, FALSE, TRUE);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (about)->vbox), label);
  gtk_window_set_modal (GTK_WINDOW (about), TRUE);
  gtk_window_set_position (GTK_WINDOW (about), GTK_WIN_POS_CENTER);
  gtk_widget_show_all (about);

  comclear (gui_callback, gui_error, (void *) label, 1);
}

void
gui_callback (char *msg, int level, void *data)
{
  gtk_label_set_text (GTK_LABEL (data), msg);
  while (gtk_events_pending ())
    gtk_main_iteration ();
  /* printf("%s\n", msg); */
}

void
gui_error (char *errmsg)
{
  /* This needs a data pointer to allow it to close the
   * status callback window */
  GtkWidget *error, *label, *okay;

  error = gtk_dialog_new ();
  label = gtk_label_new (errmsg);
  okay = gtk_button_new_with_label ("OK");
  gtk_window_set_default_size (GTK_WINDOW (error), 300, 100);
  gtk_window_set_title (GTK_WINDOW (error), "Error");
  gtk_signal_connect (GTK_OBJECT (error), "destroy",
		      GTK_SIGNAL_FUNC (gtk_exit), NULL);
  gtk_signal_connect_object (GTK_OBJECT (okay), "clicked",
			     GTK_SIGNAL_FUNC (gtk_exit), NULL);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (error)->action_area), okay);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (error)->vbox), label);
  gtk_window_set_modal (GTK_WINDOW (error), TRUE);
  gtk_window_set_position (GTK_WINDOW (error), GTK_WIN_POS_CENTER);
  gtk_widget_show_all (error);
}

void
toggle_cache (GtkWidget * widget, gpointer data)
{
  if (GTK_TOGGLE_BUTTON (widget)->active)
    cache = 1;
  else
    cache = 0;
}

void
toggle_cook (GtkWidget * widget, gpointer data)
{
  if (GTK_TOGGLE_BUTTON (widget)->active)
    cookies = 1;
  else
    cookies = 0;
}

void
toggle_hist (GtkWidget * widget, gpointer data)
{
  if (GTK_TOGGLE_BUTTON (widget)->active)
    history = 1;
  else
    history = 0;
}

void
toggle_drop (GtkWidget * widget, gpointer data)
{
  if (GTK_TOGGLE_BUTTON (widget)->active)
    dropdown = 1;
  else
    dropdown = 0;
}

void
gohome (void)
{
  char *args[] = { "/bin/sh", "-c",
    "netscape http://www.neuro-tech.net/comclearu.xml"
  };

  switch (fork ())
    {
    case -1:
      return;
    case 0:
      if (execv (args[0], args) == -1)
	{
	  perror (args[0]);
	  exit (errno);
	}
    default:
      return;
    }

}

#endif
