#!/usr/bin/python
# cookiemonster.py (Tom Neaves - tom@tomneaves.com)
# v1.6 (10/03/2010)
# 
# ./cookiemonster.py -h hostname -c number_of_cookies -i -d -r "regular expression"
# -i will import a raw text file full of cookies (format is hostname.txt)
# -d will perform hexadecimal calculations (will only work on hex values, obviously)
# -r will allow you to input custom regular expression with multiple matches (use speech marks)
#
# Is it possible to predict cookie values?  I've got a feeling it just might be possible.
# Cookie values are assigned from some kind of algorithm (exactly the way encryption works),
# therefore the less complex the algorithm is (crap entropy) then the easier it becomes to
# figure out exactly how that algorithm works and be able to predict what comes next!
#
# Cookie Monster will grab cookies from a host and assign each character a number.
# This number can then be used to perform mathematical calculations on the differences
# in order to find a pattern and see if cookie prediction is possible.
#
# For more information, see http://www.tomneaves.com/tools/cookiemonster.html
#

import string, sys, socket, re, pprint, pickle, getopt, os, urllib2, binascii
from pylab import *


def COOKIE(host):
	global results
	getresult=None

# legacy raw socket goodness.
#        s1 = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
#        s1.connect((host, port))

        req=urllib2.Request(host)
        opener=urllib2.build_opener()
        stream=opener.open(req)
        data=stream.headers.headers
        data = string.join(data, '')
        #debug stylee
        #print data
        #print type(data)
        
# old socket way of doing goodness.  urllib2 serves the purpose better.
# left in for legacy or whatever reasons.
#        if ssl:
#                ssl_sock = socket.ssl(s1)
#                ssl_sock.write("GET / HTTP/1.0\r\n")
#                ssl_sock.write("User-Agent: MONSTER\r\n\r\n")
#            data = ssl_sock.read(1024)
#                del ssl_sock
#
#       else:
#      
#                s1.send("GET / HTTP/1.0\r\n")
#                s1.send("User-Agent: MONSTER\r\n\r\n")
#                data = s1.recv(1024)

        match = re.search('Set-Cookie: (.*?);',data)
        if match:
            getresult = match.group(1)
            print getresult
        else:
            print "Ack! No cookies found."

#	s1.close()
	return getresult

def SAVE(filename):
	global results
	save = open(filename, 'wb')
	pickle.dump(results, save)
	save.close()

def LOAD(filename):
	global results
	load = open(filename, 'rb')
	results = pickle.load(load)
	load.close()

def FILELOAD(filename):
        global results
        results = open(filename, 'r').readlines()

def ascii(lastcookie, cookie):
    global results

    c_value = []
    last_cookie = []
    for char in cookie:
	    c_value.append(ord(char))

    for char in lastcookie:
	    last_cookie.append(ord(char))


    diff = 0
    for i in range(len(c_value)):
            diff += abs(c_value[i] - last_cookie[i])

    return diff

def hex(lastcookie, cookie):
    global results

    diff = 0
    for i in range(len(cookie)/2):
            realindex = i*2
            diff += abs(int(cookie[realindex:realindex+2],16) - int(lastcookie[realindex:realindex+2],16))
    return diff

host=sys.argv[1]

print """
============================================================================================
Cookie Monster v1.6 - Tom Neaves (tom@tomneaves.com)
============================================================================================
"""

count=11
host=None
fimport=False
hexflag=False
rexinput=None

opts, args = getopt.getopt(sys.argv[1:], "h:c:idur:", ["host=","cookie=","import","useage","regex="])

for o,a in opts:
	if o in ("-h", "--host="):
		host=a

	if o in ("-c", "--cookie="):
		count=a
		
	if o in ("-i", "--import"):
                fimport=True

        if o in ("-d", "--decode"):
                hexflag=True

        if o in ("-u", "--useage"):
                print "Useage: cookiemonster.py -h hostname -c amount_of_cookies | -i (import) -r regex\n"

        if o in ("-r", "--regex"):
                rexinput=a
		
if not host:
	print "Huh?  A host to look for cookies would be nice."

print host

filename = re.match('https?://([^/:]*)', host).group(1)

fileimport=filename+".txt"

diffsummary=[[]]
asciisummary=[[]]
hexsummary=[[]]

global results
results = []

if fimport:
        FILELOAD(fileimport)
        SAVE(filename)

if not os.path.exists(filename):
    grab = True
else:
    grab = False
    LOAD(filename)
    count = len(results)

xlabel('Amount of Cookies')
ylabel('Cookie Difference Value')
title('Cookie Monster v1.6 - Tom Neaves (tom@tomneaves.com)')
grid(True)

if grab:
    ion()

first_loop = True
for i in range(int(count)):

    if grab:
        raw_cookie = COOKIE(host)
        results.append(raw_cookie)
    else:
        raw_cookie = results[i]

    print raw_cookie
    cookies = []
    if not rexinput:
        r = re.compile('[:;]')
        for cookie in r.split(raw_cookie):
            print cookie
            cookies.append(re.search(r'.*?=(.*)', cookie).group(1))
                           
    else:
        match = re.search(rexinput, raw_cookie)
        if match:
            cookies = match.groups()
        else:
            print "Ack! No cookies found."
            break

    print cookies
    
    if first_loop:
            last_cookies = cookies
            first_loop = False
            for i in range(len(cookies)):
                #print i
                asciisummary.append([])
            continue

    for i in range(len(cookies)):
        diff = ascii(last_cookies[i], cookies[i])
        asciisummary[i].append(diff)

        if grab:
            plot(asciisummary[i], 'ro:')
    
        if hexflag:        
            diff = hex(last_cookies[i], cookies[i])    
            hexsummary[i].append(diff)

            if grab:
                plot(hexsummary[i], 'bo:')
     

for i in range(len(cookies)):
    if len(cookies)>1:
        subplot(len(cookies), 1, i+1)
        plot(asciisummary[i],'ro:')
        title('Cookie / Regex #'+str(i+1))
        if hexflag:
            plot(hexsummary[i], 'bo:')
            legend(('ASCII','HEX'), 'upper right', shadow=True, borderpad=0.5)
        else:
            legend(('ASCII',), 'upper right', shadow=True, borderpad=1.0)
        grid(True)
        xlabel('Amount of Cookies')
        ylabel('Cookie Difference Value')

    else:
        plot(asciisummary[i], 'ro:')
        plot(hexsummary[i], 'bo:')

    
if hexflag:
    legend(('ASCII','HEX'), 'upper right', shadow=True, borderpad=0.5) 
else:
    legend(('ASCII',), 'upper right', shadow=True, borderpad=1.0)

if grab:
    SAVE(filename)

ioff()
show()

