#include "config.h"
#include <arpa/inet.h>
#include <errno.h>
#include <fcntl.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#if HAVE_SYS_FILIO_H
#include <sys/filio.h>
#endif

#define bufsize 1024
char linefeed[] = "\x0A\x0D\x0A\x0D";

void usage (void) {
	printf("corkscrew %s (agroman@agroman.net)\n\n", VERSION);
	printf("usage: corkscrew <proxhost> [proxyport (default 80)] <desthost> <destport>\n");
}

int sock_connect(const char *hname, int port) {
	int fd;
	struct sockaddr_in addr;
	struct hostent *hent;

	fd = socket(AF_INET, SOCK_STREAM, 0);
	if (fd == -1)
		return -1;

	hent = gethostbyname(hname);
	if (hent == NULL)
		addr.sin_addr.s_addr = inet_addr(hname);
	else
		memcpy(&addr.sin_addr, hent->h_addr, hent->h_length);
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	
	if (connect(fd, (struct sockaddr *)&addr, sizeof(addr)))
		return -1;

	return fd;
}

int xmit(int fd1, int fd2) {
	int len;
	char iobuf[bufsize];

	len = read(fd1, iobuf, sizeof(iobuf));
	if (len<=0) return -1;

	len = write(fd2, iobuf, len);
	if (len<=0) return -1;

	return 0;
}

int main (int argc, char *argv[]) {
	char uri[1024] = "", host[1024] = "", buffer[bufsize], version[bufsize], descr[bufsize], desthost[1024], destport[1024];
	int len, c, port, sent, setup, code, csock;
	fd_set rfd, sfd;

	port = 80;

	if ((argc == 4) || (argc == 5)) {
		strncpy(host,argv[1],strlen(argv[1]));
		if (argc == 4) {
			strncat(desthost,argv[2],strlen(argv[2]));
			strncat(destport,argv[3],strlen(argv[3]));
		} else {
			port = atoi(argv[2]);
			strncat(desthost,argv[3],strlen(argv[3]));
			strncat(destport,argv[4],strlen(argv[4]));
		}
	} else {
		usage();
		exit(-1);
	}
	
	strcpy(uri,"CONNECT ");
	strncat(uri,desthost,strlen(desthost));
	strcat(uri,":");
	strncat(uri,destport,strlen(destport));
	strcat(uri," HTTP/1.0");
	strncat(uri,linefeed,strlen(linefeed));

	csock = sock_connect(host, port);
	if(csock == -1) {
		fprintf(stderr, "Couldn't establish connection to proxy.\n");
		exit(-1);
	}

	FD_ZERO(&sfd);
	FD_ZERO(&rfd);
	sent = 0;
	setup = 0;
	for(;;) {
		FD_SET(csock, &sfd);
		FD_SET(csock, &rfd);
		FD_SET(0, &rfd);

		if(select(csock+1,&rfd,&sfd,NULL,0) == -1) break;

		/* there's probably a better way to do this */
		if (setup == 0) {
			if (FD_ISSET(csock, &rfd)) {
				len = read(csock, buffer, sizeof(buffer));
				if (len<=0)
					break;
				else {
					sscanf(buffer,"%s%d%1024c",version,&code,descr);
					if ((strncmp(version,"HTTP/",5) == 0) && (code >= 200) && (code < 300))
						setup = 1;
					else {
						fprintf(stderr, "Proxy could not open connnection to %s\n", desthost);
						exit(-1);
					}
				}
			}
			if (FD_ISSET(csock, &sfd) && (sent == 0)) {
				len = write(csock, uri, strlen(uri));
				if (len<=0)
					break;
				else
					sent = 1;
			}
		} else {
			if (FD_ISSET(csock, &rfd)) {
				if (xmit(csock, 1)) break;
			}

			if (FD_ISSET(0, &rfd)) {
				if (xmit(0, csock)) break;
			}
		}
	}
	exit(0);
}
