#!/usr/bin/perl

# ========================================================================
# Hello! This is the source code for the ELZA interpreter.
# Make sure you edit elza.def before using this script.
# This script is placed in the public domain. Use as you see fit.
# ========================================================================

use Socket; 		use MIME::Base64;
$DEF{'version'} = '1.3.1';	# ELZA Version

# Read various default values from elza.def
$DEFAULTS = 'elza.def';
open DEFAULTS or die "Unable to open defaults file $DEFAULTS: $!";
foreach $Line (<DEFAULTS>) {eval $Line;}
close DEFAULTS;

if ($DefaultsReviewed != 1) {
	print "!!! Please review the defaults in $DEFAULTS before running the ELZA\n";
	exit;
}

# Initally, no successful requests
$TotalRequests = 0;	$SuccessfulRequests = 0;
$BytesSent = 0;		$BytesReceived = 0; 
$OKRequests = 0;	$RedirRequests = 0;


# If we are called via a POST ...

if ($ENV{'REQUEST_METHOD'} eq 'POST') {
	print "Content-type: text/plain\n\n";

	print "--- Hello. This is the ELZA interpreter version $DEF{'version'}.\n";
	print "--- Running in remote mode. Called from $ENV{'REMOTE_ADDR'} .\n";
	# Read the fields of the form
	read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
	@pairs = split(/&/, $buffer);
	foreach $pair (@pairs) {
		($name, $value) = split(/=/, $pair);
		$value =~ tr/+/ /;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$FORM{$name} = $value;
		print "--- Received from POST request: $name \= $value\n";
	}

	# The file to execute is within the 'elza-web-script' field
	$SCRIPT = "<$FORM{'elza-web-script'}";	
	$| = 1;
} else {
	# The file to execute is the first argument of the command line
	print "--- Hello. This is the ELZA interpreter version $DEF{'version'}.\n";
	if ($ARGV[0] eq '') {
		print "??? Please enter script to execute: ";
		$SCRIPT = <STDIN>;
		$SCRIPT =~ s/[\r\n]//g;
		if ($SCRIPT eq '') {
			print "Nothing entered.\n";
			exit;
		} else {
			$SCRIPT = '<'.$SCRIPT;
		}
	} else {
		$SCRIPT = '<'.$ARGV[0];
	}
}

$startclock = time();

open SCRIPT or die "!!! Unable to open script $SCRIPT: $!\n";
print "--- Now processing commands from $SCRIPT.\n";

$IsWebEnabled = 0;

# Process the main command file
while (<SCRIPT>) {
	# Strip CR/LF, whitespace, comments
	s/[\r\n]//g;	s/^[ \t]*//;
	next if(/^\#/);	next if( $_ eq '');
	# Push commands into the command array

	# If the 'elza-web-enabled' is found, the script
	# is safe for remote execution via CGI
	if ($_ eq 'elza-web-enabled') {
		$IsWebEnabled = 1;
	} else {
		push @RawScript, $_;
	}
}
# End processing main command file

if (($ENV{'REQUEST_METHOD'} eq 'POST') && ($IsWebEnabled == 0)) {
	# The script was called via POST, but the command file was not
	# specifically marked. This is to avoid attempts to execute
	# files like /etc/passwd, etc.
	print "!!! This file does not have an elza-web-enabled tag.\n";
	exit;
}

# Begin processing commands
$ScriptEnd = $#RawScript;
$LineNum = 0;
while  ($LineNum <= $ScriptEnd) {
	# Process the command
	&ProcessCommand ($RawScript[$LineNum]);
	$LineNum ++;
}

# End command processing loop

sub ProcessCommand {

	my @TempData;
	$TheCommand = $_[0];

	# Perform subst substitution 
	while (($key,$value) = each %FORM) {
		if (!($TheCommand =~ /^subst $key/)) {
			if (exists $SUBST{$key}) {
				$TheCommand =~ s/$key/$value/g;
			}
		}
	}
	while (($key,$value) = each %SUBST) {
		if (!($TheCommand =~ /^subst $key/)) {
			$TheCommand  =~ s/$key/$value/g
		}
	}

	# Split the command, placing parts in Param and ParamAfter

	my @Param = split(' ',$TheCommand);
	my @ParamAfter = ();
	for $PrmCnt (0..$#Param) {
		$ParamAfter[$PrmCnt] = '';
		for $Index ($PrmCnt..($#Param-1)) {
			$ParamAfter[$PrmCnt] .= "$Param[$Index] ";
		}
		$ParamAfter[$PrmCnt] .= $Param[$#Param];
	}

	if (($Param[0] eq "get") || ($Param[0] eq "post") || ($Param[0] eq "head")) {
		$OPT{'method'} = uc($Param[0]);
		if ($Param[1] eq "url") {
			# Requesting an ordinary URL. Very simple.
			$LastURL = $VAR{'url'};	
			$VAR{'url'} = $Param[2];

		} elsif ($Param[1] eq "refresh" ) {
			# We will now try to find a "refresh" tag.
			$TagCode = 'refresh';
			$TagMethod = 'number';
			$TagMatch= '1';
			&FindTag;
			if ($FoundTag eq '%%NONE%%') {
				print "!!! Did not find an URL to refresh to. ";
				&ProcessError;
			} else {
				$LastURL = $VAR{'url'};
				($Garbage, $VAR{'url'}) = split (/; url=/i,$FoundTag);
				print "<<< Refresh to $VAR{'url'}\n";
			}
		} else {
			# Requesting and URL contained within some tag

			# Look for a <base> tag.
			$TagCode = 'base';
			$TagMethod = 'number';
			$TagMatch= '1';
			&FindTag;
			if ($FoundTag ne '%%NONE%%') {
				print "--- Accepted base URL $VAR{'base'}\n";
				$VAR{'base'} = $FoundTag;
			} else {
				$VAR{'base'} = '';
			}
		
			# Look for the tag specified in the command
			$TagCode = $Param[1];
			$TagMethod = $Param[2];
			$TagMatch = $ParamAfter[3];
			&FindTag;
			if ($FoundTag eq '%%NONE%%') {
				print "!!! Unable to locate tag: $ParamAfter[1]. ";
				&ProcessError;
			} else {
				print "--- URL for $Param[0] located: $FoundTag.\n";
			}

			# Conserve previous URL
			$LastURL = $VAR{'url'};

			# If the next URL is not absolute, add <base>
			if ($FoundTag =~ /($DEF{'http'}|$DEF{'https'})/) {
				$VAR{'url'} = $FoundTag;
			} else {
				$VAR{'url'} = $VAR{'base'}.$FoundTag;
			}
		}
	
		# Send the next request.
		&SendRequestToHost;
		%FLD = ();
		return;
	}

	if ($Param[0] eq 'pause') {
		print "--- Ran into pause command. Hit ENTER to continue ...";
		$Bogus = <STDIN>;
		return;
	}

	if ($Param[0] eq "sleep") {
		print "--- Ran into sleep command. Sleeping for $Param[1] second(s) ...\n";
		sleep $Param[1];
		return;
	}

	if ($Param[0] eq "exec") {
		print "--- Executing $ParamAfter[1] ...\n";
		eval($ParamAfter[1]);
		return;
	}

	if ($Param[0] eq 'return') {
		$LineNum = $VAR{'retpointer'} + 1;
		print "--- Returning back to line number $LineNum .\n";
		return;
	}

	if (($Param[0] eq "subst") || ($Param[0] eq 'field') || 
		($Param[0] eq 'var') || ($Param[0] eq 'cookie')) {

		$TempValue = '';
		$ToBeDeleted = 0;

		if ($Param[2] eq '=') {
			$TempValue = $ParamAfter[3];
			print "--- Setting $Param[0] \'$Param[1]\' .\n";
		}

		if ($Param[2] eq 'v=') {
			$TempValue = $VAR{$ParamAfter[3]};
			print "--- Setting $Param[0] \'$Param[1]\' to current value of var $ParamAfter[3].\n";
		}

		if ($Param[2] eq 'c=') {
			$TempValue = $COOK{$ParamAfter[3]};
			print "--- Setting $Param[0] \'$Param[1]\' to current value of cookie $ParamAfter[3].\n";
		}

		if ($Param[2] eq '-') {
			$ToBeDeleted = 1;
			print "--- Deleting $Param[0] \'$Param[1]\'.\n";
		}

		if ($Param[2] eq 'from') {
			$TagCode = $Param[5];
			$TagMethod = $Param[6];
			$TagMatch = $ParamAfter[7];
			&FindTag;
			if ($FoundTag eq '%%NONE%%') {
				print "!!! Unable to locate value for $Param[1] in $ParamAfter[1]. ";
				&ProcessError;
			} else {
				$TempValue = $TAGA{$Param[3]};
				print "--- Tag for $Param[1] located: $ParamAfter[5] .\n";
			}
		}

		if ($Param[2] eq '?') {
			if ($ENV{'REQUEST_METHOD'} eq 'POST') {
				# If we are called via POST, we will not get value
				# from STDIN, but from %FORM
				$TempValue = $FORM{$Param[1]};
			} else {
				print "??? Please enter value for $Param[0] \'$Param[1]\' [$ParamAfter[3]]: ";
				$TempValue = <STDIN>;
				$TempValue =~ s/[\r\n]//g;
				if ($TempValue eq '') { $TempValue = $ParamAfter[3]};
			}
		}

		if ($Param[2] eq '>') {
			print "--- Overflowing $Param[0] \'$Param[1]\' with $Param[3] characters.\n";
			$TempValue = 'A' x $Param[3];
		}

		if ($Param[2] eq '$') {
			if ($Param[1] ne '%ALL%') {
				$TagCode = 'hidden';
				$TagMethod = 'name';
				$TagMatch = $Param[1];
				&FindTag;
				if ($FoundTag ne '%%NONE%%') {
					print "--- Setting field \'$Param[1]\' to \'$FoundTag\'.\n";
					$FLD{$Param[1]} = $FoundTag;
				} else {
					print "!!! Field $Param[1] not found. ";
					&ProcessError;
				}
			} else {
				$TagEnumerate = 1;
				$TagCode = 'hidden';
				&FindTag;
				$TagEnumerate = 0;
			}
			$AnyFields = 1;
			return;
		}

		if ($Param[0] eq 'subst') {
			if ($ToBeDeleted > 0) {
				delete $SUBST{$Param[1]};
			} else {
				$SUBST{$Param[1]} = $TempValue;
			}
			return;	
		}

		if ($Param[0] eq 'field') {
			if ($Param[1] eq '%BOGUS%') {
				$BogusField = 1;
				$BogusFieldSize = $Param[3];
				$BogusTextSize = $Param[4];
			} elsif ($ToBeDeleted > 0) {
				delete $FLD{$Param[1]};
			} else {
				$FLD{$Param[1]} = $TempValue;
			}
			$AnyFields = 1;
			return;
		}

		if ($Param[0] eq 'var') {
			$VAR{$Param[1]} = $TempValue;
			if ($Param[1] eq "rawfile") {
				unlink $VAR{'rawfile'};
			} elsif ($Param[1] eq "proxy") {
				print "--- Bouncing through $Param[3] on port $Param[4] ...\n";
				$VAR{'proxyserver'} = $Param[3];
				$VAR{'proxyport'} = $Param[4];
			} elsif ($Param[1] eq 'dictionary'){
				$DICTFILE = "<$TempValue";
				open DICTFILE or die "!!! Unable to open dictionary $TempValue: $!\n";
				$DictMode = 1;
			}
			return;
		}

		if ($Param[0] eq 'cookie') {
			if ($ToBeDeleted > 0) {
				if ($Param[1] eq '%ALL%') {
					undef %COOK;
				} else {
					delete $COOK{$Param[1]};
				}
			} elsif ($Param[2] eq 'path') {
				$COOKP{$Param[1]} = $TempValue;
			} elsif ($Param[2] eq 'domain') {
				$COOKD{$Param[1]} = $TempValue;
			} else {
				$COOK{$Param[1]} = $TempValue;
			}
			return;
		}

		print "!!! Syntax errror: $ParamAfter[0].\n";
		exit;
	}

	if ($Param[0] eq 'call') {
		if ($Param[2] eq 'if') {
			if ($VAR{$Param[3]} =~ /$ParamAfter[5]/s) {
				if ($Param[4] eq '==') {
					&ExecProc ($Param[1]);
					return;
				}
			} else {
				if ($Param[4] eq '!=') {
					&ExecProc ($Param[1]);
					return;
				}

			}
			return;
		}

		if ($Param[2] eq '') {
			&ExecProc ($Param[1]);
			return;
		}


	
		if ($#{$PROC{$Param[1]}} == -1) {
			print "!!! Proc $Param[1] not defined.\n";
			exit;
		}

		if ($Param[3] eq '@') {
			# Push the array specified in the directive
			for $Element (4..$#Param) {
				push @TempData, $Param[$Element];
			}
		}

		if ($Param[3] eq 'eachfield') {
			# Rotate for every field available
			@TempData = keys %FLD;
		}

		if ($Param[3] eq '#') {
			for $Element ($Param[4]..$Param[5]) {
				push @TempData, $Element;
			}
		}

		if ($Param[3] eq '?') {
			# Read from STDIN
			$ValueCount = 1;
			print "??? Please enter values for \'$Param[2]\', then blank line to continue:\n";
			print "??? Value number $ValueCount: ";
			RSTD: while (<STDIN>) {
				s/[\r\n]//g;
				if ($_ eq '') {	last RSTD;}
				push @TempData, $_;
				$ValueCount++;
				print "??? Value number $ValueCount: ";
			}
			if ($#TempData == -1) {
				print "!!! No values entered. Exiting.\n";
				exit;
			}
		}

		if ($Param[3] eq '%') {
			# Push the data from the file specified
			$VarFile = $Param[4];
			$DATAFILE = "<$VarFile";
			open DATAFILE or die "!!! Unable to open data file $VarFile: $!\n";
			$PushStart = $LineNum + 1;
			while (<DATAFILE>) {
				$_ =~ s/[\r\n]//g;
				if ($_ ne '') {push @TempData, $_;}
			}
			close DATAFILE;
		}

		# And, finally, perform execute the proc
		foreach $SubstValue (@TempData) {
			$SUBST{$Param[2]} = $SubstValue;
			&ExecProc ($Param[1]);
		}
		return;
	}


	if ($Param[0] eq "insert") {
		print "--- Now processing file $Param[1] ...\n";
		$INCLFILE = "<$Param[1]";
		open INCLFILE or die "!!! Unable to open command file $VarFile: $!\n";
		$TempPos = $LineNum + 1;
		while (<INCLFILE>) {
			s/[\r\n]//g;
			s/^[ \t]*//;
			next if(/^\#/);
			splice @RawScript, $TempPos , 0 , $_;
			$TempPos++;
		}
		$ScriptEnd = $#RawScript;
		close INCLFILE;
		return;
	}

	if ($Param[0] eq 'label') {
		return;
	}

	if ($Param[0] eq 'exit') {
		print "!!! Exiting ... \n";
		exit;
	}

	if ($Param[0] eq 'print') {
		print "=== $ParamAfter[1]\n";
		return;
	}
	if ($Param[0] eq 'continue') {
		print "\n";
		return;
	}

	if ($Param[0] eq 'stats') {
		# Printing statistics
		($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime(time() - $startclock);
		$TotalBytes = $BytesSent + $BytesReceived;
		print "\nSTAT: Time:      $hour hrs / $min min / $sec sec.\n";
		print "STAT: Requests:  $TotalRequests total, $SuccessfulRequests successful.\n";
		print "STAT: Responses: $OKRequests OK, $RedirRequests redirects.\n";
		print "STAT: Bytes:     $TotalBytes total, $BytesSent sent, $BytesReceived received.\n";
	}


	if ($Param[0] eq 'proc') {
		$ProcName = $Param[1];
		@PROC{$ProcName} = ();
		$PushStart = $LineNum + 1;
		$PushEnd = $ScriptEnd;
		$EndFound = -1;

		ARLOOP: for $Index ($PushStart..$PushEnd) {
			if ($RawScript[$Index] ne "endproc $ProcName") {
				push @{$PROC{$ProcName}}, $RawScript[$Index];
			} else {
				$EndFound = $Index;
				last ARLOOP;
			}
		}

		if ($EndFound == -1) {
			print "!!! Procedure $ProcName does not have an \'endproc\'\n";
			exit;
		} else {
			$LineNum = $EndFound;
			return;
		}
	}
}

sub ExecProc {
	for $Index (0..$#{$PROC{$_[0]}}) {
		&ProcessCommand ($PROC{$_[0]}[$Index]);
	}
}


sub ParseURLParts {
# This subroutine will try to canonize an absolute or relative URL

	if ($VAR{'prefix'} eq '') {
		$VAR{'prefix'} = $DEF{'http'};
	}

	if ($VAR{'url'} =~ /^($DEF{'http'}|$DEF{'https'})(.*)/) {
		# The URL is absolute. Parsing...
	
		$RestPortion = $2;
		$VAR{'prefix'} = $1;

		if ($RestPortion =~ /\//) {
			$RestPortion =~ /^(.*?)\/(.*)/;
			$HostPortion = $1;
			$VAR{'request'} = '/'.$2;
		} else {
			$HostPortion = $RestPortion;
			$VAR{'request'} = '/';
		}

		# Set ports depending on protocol

		if ($VAR{'prefix'} eq $DEF{'https'}) {
			$VAR{'ssl'} = 'yes';
			$VAR{'port'} = $DEF{'sslport'};
		} else {
			$VAR{'ssl'} = 'no';
			$VAR{'port'} = $DEF{'port'};
		}

		# If URL contains port, use it instead
		if ($HostPortion =~ /:/) {
			($VAR{'host'}, $VAR{'port'}) = split (':',$HostPortion);
		} else {
			$VAR{'host'} = $HostPortion;
		}
	} else {
		#The URL is relative
		if (!($VAR{'url'} =~ /^\// ) ) {
			# The URL does not begin with '/'
			if ($VAR{'request'} =~ /\/$/)  {
				# The last URL was a directory, so we append
				$VAR{'request'} = $VAR{'request'}.$VAR{'url'};
			} else {
				# The last URL was a file, so we find the dir
				$VAR{'request'} =~ /(.*)\/(.*?)/;
				$VAR{'request'} = $1.'/'.$VAR{'url'};
			}		
		} else {
			# The URL begins with '/' => server root
			$VAR{'request'} = $VAR{'url'};
		}

		if ($VAR{'port'} eq '') {$VAR{'port'} = $DEF{'port'};}

		#Glue parts together
		$VAR{'url'} = $VAR{'prefix'}.$VAR{'host'}.':'.$VAR{'port'}.$VAR{'request'};
	}
}

sub ParseRawResponse {
	($VAR{'protoversion'}, $VAR{'retcode'}, $VAR{'rettext'}) = split (' ', $RawResponse[0]);
	$InHeader = 1;

	if (($DictMode > 0) && ($VAR{'retcode'} == '401') && ($RawAuthPass ne '')) {
		# Display dots if we do a dictionary attack
		print '.';
	} else {
		# Display the response otherwise
		print "<<< Response: $RawResponse[0]";
	}

	if (($DictMode > 0) && ($VAR{'retcode'} != '401')) {
		print "WOW Successful pair: $VAR{'user'} : $RawAuthPass\n";
		$VAR{'password'} = $RawAuthPass;
		$DictMode = 0;
	}

	foreach $RawResponseLine (@RawResponse) {

		# Remove CR/LF stuff
		$RawResponseLine =~ s/[\r\n]//g;

		# Check if we are entering the HTML
		if ($RawResponseLine eq '') {
			$InHeader = 0;
			next;
		}

		if ($InHeader > 0) {
			$RawHeaders.="$RawResponseLine\n";
			# Parse the header
			($RawHeader, $RawHeaderValue) = split (': ',$RawResponseLine);
			$VAR{$RawHeader} = $RawHeaderValue;

			# Extract the cookies
			if ($RawHeader eq 'Set-Cookie') {
				@CookieParams = ();

				# Split the cookie
				@CookieParts = split(';',$RawHeaderValue);

				if ($CookieParts[0] eq '') {
					# If we are sent a cookie without parameters, handle that				
					print "!!! Malformed cookie received: $RawHeaderValue\n";
				} else {
					# Extract name and value from the first part
					# This is not done with split, because I have
					# seen cookies with '=' in them.
					$CookieParts[0] =~ /(.*?)=(.*)/;
					$CookieName = $1; $CookieVal = $2;
					$COOK{$CookieName} = $CookieVal;

					# Extract cookie attributes
					foreach $CookiePart (@CookieParts) {
						($CookieParamName, $CookieParamValue) = split('=',$CookiePart);
						$CookieParamName =~ s/^[ \t]*//;	#Strip whitespace
						$CookieParams{lc($CookieParamName)} = lc($CookieParamValue);
					}
			
					# Place cookie parts in the arrays
					$COOKP{$CookieName} = $CookieParams{'path'};
					$COOKD{$CookieName} = $CookieParams{'domain'};
							
					print "<<< Cookie: $CookieName = $CookieVal\n";
				}
	               	}
		} else {
			# We are in the body
			$VAR{'body'}.="$RawResponseLine\n";
		}
	}

	&PrintToRaw;

	# Act upon a redirect
	if (($VAR{'retcode'} eq '301') or ($VAR{'retcode'} eq '302')) {
		$RedirRequests++;
		print "<<< Redirect: $VAR{'Location'}\n";
		$LastURL = $VAR{'url'};
		$VAR{'url'} = $VAR{'Location'};
		&ParseURLParts;
		$OPT{'method'} = "GET";
		%FLD = ();
		$AnyFields = 0;
		&SendRequestToHost;
		return;
	}

	# Act upon request for authentication by giving credentials
	if ($VAR{'retcode'} eq '401') {

		# Parsing the authenticate header
		if (!($VAR{'WWW-Authenticate'} =~ /(.*) realm=\"(.*)\"/)) {
			print "!!! Unable to parse $VAR{'WWW-Authenticate'}. ";
			&ProcessError;
			return;
		}

		if ($1 ne 'Basic') {
			print "!!! The server requested $1 authentication type. ";
			&ProcessError;
			return;
		} 

		if ($DictMode > 0) {
			$RawAuthPass = <DICTFILE>;
			if ($RawAuthPass eq '') {
				# All username/password pairs exhausted. Giving up.
				print "!!! Dictionary file exhausted. \n";
				&ProcessError;
				return;
			}
			$RawAuthPass =~ s/[\r\n]//g;
		} else {
			if ($RawAuthPass eq $VAR{'password'}) {
				print "!!! Server does not accept HTTP password. ";
				&ProcessError;
				return;			
			} else {
				$RawAuthPass = $VAR{'password'};
			}
		}

		if ($VAR{'realm'} ne $2) {
			print "!!! No user/pass pairs for realm \"$2\". ";
			&ProcessError;
			return;
		}

		&SendRequestToHost;
		return;
	} else {
		$RawAuthPass = '';
	}

	if ($VAR{'retcode'} ne '200') {
		&ProcessError;
	}
}

sub FindTag {
# This engine will scan HTML for tags and return the info contained within
# number, raw, and text are artificial tag attributes

	if ($VAR{'container'} ne '') {
		$WorkingSpace = $VAR{'container'};
	} else {
		$WorkingSpace = $VAR{'body'};
	}

	$FoundTag = '%%NONE%%';
	$TagNumber = 0;

	while ($WorkingSpace =~ s/$TagBegin{$TagCode}(.*?)$RightBrack//is) {
		$TagRest = $'; $TagNumber++;
		$TagBody = $1;
		%TAGA = ();
		$TAGA{'body'} = $TagBegin{$TagCode}.$1.$RightBrack;
		if ($TagClose{$TagCode} ne '') {
			# Tag has a close tag -> find the HTML within
			if ($TagRest =~ s/(.*?)$TagClose{$TagCode}//is) {
				$TagText = $1;
				$PotentialContainer = $TagText;
				$TAGA{'raw'} = $TagText;
				$TagText =~ s/$LeftBrack(.*?)$RightBrack//igs;
				$TagText =~ s/  / /ig;
				$TagText =~ s/&nbsp;/ /ig;
				$TAGA{'text'} = $TagText;
			}
		}

		$TAGA{'number'} = $TagNumber;

		# Collect all attributes of the tag.
		while ($TagBody =~ s|^(([a-zA-Z][a-zA-Z0-9\.\-_]*)\s*)||) {
			$TagAttrib = $2;
			$AttribValue = '';
			if ($TagBody =~ s|(^=\s*([\"\'])(.*?)\2\s*)||s) {
				$AttribValue = $3;
			} elsif ($TagBody =~ s|(^=\s*([^\"\'>\s][^>\s]*)\s*)||) {
				$AttribValue = $2;
			}
			$TAGA{lc($TagAttrib)} = $AttribValue;
		}

		if ($TagCode eq 'hidden') {
			if (lc($TAGA{'type'}) eq 'hidden') {
				$FoundTag = $TAGA{$TagVal{$TagCode}};
			}
		} elsif ($TagCode eq 'refresh') {
			# We have to find a refresh tag.
			# it is in fact a meta http-equiv tag.
			if (lc($TAGA{'http-equiv'}) eq 'refresh') {
				$FoundTag = $TAGA{$TagVal{$TagCode}};
			}
		} else {
			# We are looking for an ordinary tag.
			# See if we match.
			if ($TAGA{$TagMethod} =~ /$TagMatch/) {
				$FoundTag = $TAGA{$TagVal{$TagCode}};
			}
		}
		if ($TagEnumerate > 0) {
			# We have to find all occurences of this tag so
			# we do not stop parsing here.
			if (lc($TAGA{'type'}) eq 'hidden') {
				$FLD{$TAGA{'name'}} = $TAGA{'value'};
				print "<<< Field: $TAGA{'name'} = $FLD{$TAGA{'name'}}\n";
				$AnyFields = 1;
			}
		} else {
			if ($FoundTag ne '%%NONE%%') {
				return;
			}
		}
	}
}

sub SSLSpawnTunnel {
	my $TmpCmdLine;
	
	$TmpCmdLine = $DEF{'sslcmd'};
	$TmpCmdLine =~ s/SSLHOST/$SSLRemoteHost/g;
	$TmpCmdLine =~ s/SSLPORT/$SSLRemotePort/g;

	if ($DEF{'sslconsole'} > 0 ) {
		$SSLProcessFlags = CREATE_NEW_CONSOLE;
	} else {
		$SSLProcessFlags = DETACHED_PROCESS;
	}

	#Spawn SSL Tunnel.
	print "--- Spawning SSL Tunnel to $VAR{'host'}:$VAR{'port'}. Local port is $DEF{'ssllocal'}. ";

	if ($^O =~ /Win/) {
		# Win32::Process::Create and Win32::Sleep are hidden
		# behind print so that the interpreter does not complain
		# about undeclated functions under non-Win32 systems.
		print Win32::Process::Create($SSLTunnelPID, $DEF{'sslapp'}, $TmpCmdLine, 0, $SSLProcessFlags, ".") || die "Unable to spawn SSL Tunnel $!";

		# Sleeping a little bit is necessary to give stunnel.exe
		# time to start listening to the port. Otherwise, we will
		# not be able to connect and an error will occur.
		# Sorry for this race condition ...
		print " Spawned. Waiting for 5 seconds ...";
		print Win32::Sleep 5000;
		print " done ...\n";
	} else {
		print `$TmpCmdLine`;
		print " Spawned.\n";
	}
}

sub SSLKillTunnel {
	print "--- Killing SSL Tunnel to $VAR{'host'}:$VAR{'port'}\n";
	if ($^O =~ /win/i) {
		$SSLTunnelPID->Win32::Process::Kill('') || die "Unable to kill SSL Tunnel $DEF{'sslapp'}. Kill it yourself.";
	} else {
		`killall $DEF{'sslapp'}`;
	}
}

sub SendRequestToHost {
	&ParseURLParts;
	$CombinedFields = '';
	$Contaner = '';
	@RawResponse = ();
	$RawHeaders = '';
	$VAR{'body'} = '';
	$TotalRequests++;

	if ($AnyFields > 0 ) {
		# Build QUERY string
		while (($key,$value) = each %FLD) {
			$CombinedFields.="$key=$value&";
			print ">>> Field: $key=$value\n";
		}
		$AnyFields = 0;
		$CombinedFields =~ s/ /+/g;
		$CombinedFields =~ s/&$//g;
	}

	if ($VAR{'proxyserver'} ne '') {
		# If using proxy, send entire URL
		$RawRequest = $VAR{'url'};
	} else {
		# If not, send just the relative URL
		$RawRequest = $VAR{'request'};
	}

	if ($BogusField > 0) {
		$CombinedFields.= 'F' x $BogusFieldSize;
		$CombinedFields.= '=';
		$CombinedFields.= 'V' x $BogusTextSize;
		$CombinedFields.= '&';
		$BogusField = 0;
	}

	if (($OPT{'method'} eq 'GET') && ($CombinedFields ne '' )){
		# Append fields to the URL
		$RawRequest.="?$CombinedFields";
	}

	# Perform anti-IDS encoding (courtesy of r.f.p)
	if($VAR{'encode'} eq 'on') {
		$RawRequest =~ s/([-a-zA-Z0-9.])/sprintf("%%%x",ord($1))/ge;
	}

	# The first line of the request
	$RawRequest = "$OPT{'method'} $RawRequest HTTP/1.0\n";

	if (($DictMode < 1) || ($RawAuthPass eq '')) {
		print ">>> Request: $RawRequest";
	}

	# Add the Host: part of the request
	$RawRequest.= "Host: $VAR{'host'}:$VAR{'port'}\n";

	# Add the user agent to the request
	if ($VAR{'sendagent'} eq 'on') {
		$RawRequest.= "User-Agent: $VAR{'agent'}\n";
	}

	# Add various bogus fields to the request
	if ($DEF{'headers'} ne '') {
		$RawRequest.= $DEF{'headers'};
	}

	# Add authentication
	if ($RawAuthPass ne '') {
		$AuthEncoded = encode_base64($VAR{'user'}.':'.$RawAuthPass);
		$RawRequest.= "Authorization: Basic $AuthEncoded";
	}

	# Add cookies destined for this path and domain
	$CookieLine = '';
	while (($RawCookieName,$RawCookieVal) = each %COOK) {
		if ($COOKD{$RawCookieName} eq '') {
			print ">>> Our cookie: $RawCookieName = $RawCookieVal\n";
			$CookieLine.= "$RawCookieName=$RawCookieVal; ";
			next;
		}

		if ($VAR{'request'} =~ /^$COOKP{$RawCookieName}/) {
			if ($VAR{'host'} =~ /$COOKD{$RawCookieName}/) {
				print ">>> Their cookie: $RawCookieName = $RawCookieVal\n";
				$CookieLine.= "$RawCookieName=$RawCookieVal; ";
			}
		} 
	}

	if ($CookieLine ne '') {$RawRequest.= "Cookie: $CookieLine\n";}

	# Self-explanatory
	$RawRequest.= "Connection: close\n";

	# Add POST data
	if ($OPT{'method'} eq 'POST') {
		# Append fields to the request.
		$RawRequest.="Content-Type: application/x-www-form-urlencoded\n";
		$RawRequest.="Content-Length: ".length($CombinedFields)."\n\n";
		$RawRequest.="$CombinedFields\n";
	}

	# Terminate request
	$RawRequest.="\n";

	if ($VAR{'ssl'} eq 'yes' ) {
		#If it is a SSL request, send through tunnel
		$RawHost = '127.0.0.1';
		$RawPort = $DEF{'ssllocal'};
		$SSLRemoteHost = $VAR{'host'};
		$SSLRemotePort = $VAR{'port'};
		&SSLSpawnTunnel;
		$SSLTunnelFunctional = 1;
	} elsif ($VAR{'proxyserver'} ne '') {
		# If through proxy, send through proxy
		$RawHost = $VAR{'proxyserver'};
		$RawPort = $VAR{'proxyport'};
	} else {
		$RawHost = $VAR{'host'};
		$RawPort = $VAR{'port'};
	}

        $Protocol = getprotobyname('tcp')||0;
	if(! ($RawIP = inet_aton($RawHost) ) ){
                print "!!! Unable to resolve $RawHost. ";
		&ProcessError;
	}
	if (! (socket(SOCK,PF_INET,SOCK_STREAM,$Protocol) ) ){
		print "!!! Unable to create socket. ";
		&ProcessError;
	} 
	if (connect(SOCK, sockaddr_in($RawPort, $RawIP))){
		select(SOCK);
		$|=1;
		print $RawRequest;
		$BytesSent = $BytesSent + length ($RawRequest);
		$SessionReceived = 0;
		while (<SOCK>) {
			push @RawResponse, $_;
			$SessionReceived = $SessionReceived + length ($_);
		}

		select(STDOUT);
		$BytesReceived = $BytesReceived + $SessionReceived;
		close(SOCK);
		$SuccessfulRequests++;
	} else {
		print "!!! $RawHost does not respond on port $RawPort. ";
		&ProcessError;
 	}

	if ($SSLTunnelFunctional == 1) {
		&SSLKillTunnel;
		$SSLTunnelFunctional = 0;
	}

	if ($RawResponse[0] ne '') {
		&ParseRawResponse;
	}
}

sub LastWin32Message {
	print Win32::FormatMessage(Win32::GetLastError());
}

sub PrintToRaw {
	if ($VAR{'rawfile'} ne '') {
		open FILEOUT, ">>$VAR{'rawfile'}" or die "Unable to open raw file $VAR{'rawfile'}: $!";
		if ($VAR{'dumprequest'} ne '') {
			print FILEOUT "$RawRequest";
		}

		if ($VAR{'dumpheaders'} ne '') {
			print FILEOUT "$RawHeaders\n";
		}

		if ($VAR{'dumpbody'} ne '') {
			print FILEOUT "$VAR{'body'}";
		}
		print FILEOUT "\n";
		close FILEOUT;
	}
}

sub ProcessError {
	&ProcessCommand($VAR{'onerror'});
}
