/*=============================================================================
 *  Copyright 2002-2004 deny all - Asphanet S.A. (http://www.deny-all.com/)
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================
 ***********************************************************************
 * securid_client.h
 * Send request to the SecurID proxy
 ***********************************************************************/

#ifndef _SECURID_CLIENT_H_
# define _SECURID_CLIENT_H_

#include "securid_conf.h"
#include "securid_webid.h"

int securid_call_check (const securid_sconf *sconf,
			const request_rec *r,
			securid_webid *wid,
			const char *username,
			char *passcode);
int securid_call_next (const securid_sconf *sconf,
		       const request_rec *r,
		       securid_webid *wid,
		       char * nextcode);
int securid_call_pin (const securid_sconf *sconf,
		      const request_rec *r,
		      securid_webid *wid,
		      char *pin);

#endif
