/*=============================================================================
 *  Copyright 2002-2004 deny all - Asphanet S.A. (http://www.deny-all.com/)
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================
 *******************************************************************
 * securid_conf.h
 * Structures and definition for server configuration
 *******************************************************************/

#ifndef _SECURID_CONF_H_
# define _SECURID_CONF_H_

/*
 * TTL expire type:
 *   - Cookies expire always after specified time
 *   - Cookies expire if not used for specified time
 */
#define	SECURID_TTL_ALWAYS	0
#define	SECURID_TTL_UNUSED	(!SECURID_TTL_ALWAYS)
#define	SECURID_TTL_ALWAYS_STR	"always_after"
#define	SECURID_TTL_UNUSED_STR	"if_not_used"

/*
 * FromAgent stuff for SecurID server config
 */

#define	SECURID_FROMAGENT_NULL	0	/* disable FromAgent checks	*/
#define	SECURID_FROMAGENT_IP	1	/* use remote-ip		*/
#define	SECURID_FROMAGENT_KEY	2	/* use a special key		*/
#define	SECURID_FROMAGENT_MAX	8	/* max FromAgent keys		*/
typedef struct securid_fromagent1
{
  int			type;		/* SECURID_FROMAGENT_...	*/
  unsigned long		from_net;	/* ip for from addr		*/
  unsigned long		from_msk;	/* mask for from addr		*/
  char			*key_val;	/* key (header) value		*/
  unsigned long		key_msk;	/* key addr mask		*/
} securid_fromagent1;
typedef struct securid_fromagents
{
  int			n;
  securid_fromagent1	k [SECURID_FROMAGENT_MAX];
} securid_fromagents;

/*
 * "Server" config for the module
 */
typedef struct securid_sconf
{
  /*
   * Some vars to hold directives values.
   */
  char			*var_ace;	/* where to find sdconf.rec	*/
  char			*cachefile;	/* auth cache file		*/
  int			resetcache;	/* reset or reuse cache file	*/
  long			cachettltime;	/* auth TTL value		*/
  int			cachettltype;	/* auth TTL type: always/unused	*/
  long			cachettlmax;	/* auth max TTL value,		*/
  					/* regardless auth TTL type	*/
  char			*domaincookie;	/* (en/dis)able domain cookie	*/
  int			securecookie;	/* (en/dis)able secure cookie	*/
  char                  *pathcookie;    /* force "path=" for cookie     */
  securid_fromagents	fromagents;	/* custom remote ip header	*/
  int			maxauthget;	/* max auth get req / fromagent	*/
  int			maxauthpost;	/* max auth post req/ fromagent	*/
  int			maxcachesize;	/* max entry in cache		*/
  int			useragent;	/* User-Agent length to check	*/
  char			*customdir;	/* custom directory		*/
  char			*customtype;	/* custom files Content-type	*/
  int			customlink;	/* (en/dis)able custom SymLinks	*/
  int			nocache;	/* URLs caching policy		*/
  char			*hdlcookie;	/* custom `AceHandle' name	*/
  char			*widcookie;	/* custom `webid2' name		*/
  /*
   * A mask to know which directives have been set.
   */
  int			directives;
# define SECURID_var_ace_SET		00000001
# define SECURID_cachefile_SET		00000002
  /*	 SECURID_resetcache_SET		useless, see cachefile	*/
# define SECURID_cachettltime_SET	000000004
# define SECURID_cachettltype_SET	000000010
# define SECURID_cachettlmax_SET	000000020
# define SECURID_domaincookie_SET	000000040
# define SECURID_securecookie_SET	000000100
# define SECURID_pathcookie_SET		000000200
# define SECURID_fromagent_SET		000000400
# define SECURID_maxauthget_SET		000001000
# define SECURID_maxauthpost_SET	000002000
# define SECURID_maxcachesize_SET	000004000
# define SECURID_useragent_SET		000010000
# define SECURID_customdir_SET		000020000
# define SECURID_customtype_SET		000040000
# define SECURID_customlink_SET		000100000
# define SECURID_nocache_SET		000200000
# define SECURID_hdlcookie_SET		000400000
# define SECURID_widcookie_SET		001000000
# define SECURID_sockdir_SET		002000000
# define SECURID_proxy_SET		004000000

  /*
   * Some "internal" vars:
   * - lockfile is to lock/unlock authentications DB;
   * - cachefileN is (are) the real file name(s) for DB file(s);
   * - sd is the "initial" SD_CLIENT value (after ACE init);
   * - LANG=X for ACE error messages;
   */
  char			*lockfile;	/* auth lock file		*/
  char			*cachefile1;	/* "xx" | "xx".db | "xx".pag	*/
  char			*cachefile2;	/* NULL | NULL    | "xx".dir	*/
  char			*ace_lang;	/* LANG=xxx for ACE library	*/
  char			*sockdir;	/* Dir where the sockets are	*/
  char			*sockfn;       	/* socket file name		*/
  char                  *proxy;         /* path to proxy executable     */
  pid_t			proxy_pid;	/* pid of proxy process		*/
} securid_sconf;

#endif
