/*=============================================================================
 *  Copyright 2002-2004 deny all - Asphanet S.A. (http://www.deny-all.com/)
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================
 ******************************************************************
 * securid_msg.h
 * Messages used for communication between Apache + mod_securid
 * and the SecurID proxy.
 ******************************************************************/

#ifndef _SECURID_MSG_H_
# define _SECURID_MSG_H_

#define MAX_USER_INPUT 64
#define SECURID_BAD_REQUEST -127

/* Requests from the clients to the SecurID proxy */

typedef enum {
  securid_check,
  securid_next,
  securid_pin
} securid_req_command;

typedef struct {
  char username[MAX_USER_INPUT];
  char passcode[MAX_USER_INPUT];
} securid_req_check;

typedef struct {
  SDI_HANDLE sd;
  char nextcode[MAX_USER_INPUT];
} securid_req_next;

typedef struct {
  SDI_HANDLE sd;
  char newpin[MAX_USER_INPUT];
} securid_req_pin;

typedef union {
  securid_req_check req_check;
  securid_req_next req_next;
  securid_req_pin req_pin;
} securid_req_body;

typedef struct {
  securid_req_command cmd;
  securid_req_body bdy;
} securid_request;

/* Replies from the proxy */

typedef enum {
  securid_rep_auth_ok,
  securid_rep_auth_failled,
  securid_rep_next,
  securid_rep_pin,
  securid_rep_pin_accepted,
  securid_rep_pin_rejected,
  securid_rep_error
} securid_rep_status;

typedef struct {
  char shell[LENACMFILE];
} securid_rep_bdy_auth_ok;

typedef struct {
} securid_rep_bdy_auth_failled;

typedef struct {
  SDI_HANDLE sd;
} securid_rep_bdy_next;

typedef struct {
  SDI_HANDLE sd;
  SD_PIN pin_params;
} securid_rep_bdy_pin;

typedef struct {
} securid_rep_bdy_pin_accepted;

typedef struct {
} securid_rep_bdy_pin_rejected;

typedef struct {
} securid_rep_bdy_error;

typedef union {
  securid_rep_bdy_auth_ok auth_ok;
  securid_rep_bdy_auth_failled auth_failled;
  securid_rep_bdy_next next;
  securid_rep_bdy_pin pin;
  securid_rep_bdy_pin_accepted pin_accepted;
  securid_rep_bdy_pin_rejected pin_rejected;
  securid_rep_bdy_error error;
} securid_rep_body;

typedef struct {
  securid_rep_status status;
  securid_rep_body bdy;
} securid_reply;

#endif
