/*=============================================================================
 *  Copyright 2002-2004 deny all - Asphanet S.A. (http://www.deny-all.com/)
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================
 *
 * securid_webid.h
 *
 * A SecurID authentication cookie (see ACE doc, struct is here not exactly the
 * same)
 *
 * Public part is used for webid2 cookie client has to send to authenticate
 * for each request.
 *
 * Public + Private parts are stored in cache. Checks are:
 *   - <webid2 from client>     == <public part from cache>
 *   - <client remote ip>       == <remote ip from cache>
 *   - <user-agent from client> == <user-agent from cache>
 *
 * Note: as ACE doc says, shell field can be used to store the groups the user
 * belongs to (grp1,grp2,...).
 * (actualy, the user cannot belong to several groups).
 */

#ifndef _SECURID_WEBID_H_
# define _SECURID_WEBID_H_

#include <acexport.h>

typedef struct securid_webid
{
  /*
   * Public part: set when really authenticated.
   */
  char			username [LENACMNAME];
  time_t		first_time;		/* first auth. use	*/
  char			shell [LENACMFILE];
  /*
   * Private part: sd is set when user is authenticating.
   */
  SDI_HANDLE		sd;
  SD_PIN		pin_params;
  time_t		last_time;		/* last auth. use	*/
  char			user_agent [64];	/* user-agent		*/
  char			from_agent [16];	/* remote ip		*/
  int			acecalls;		/* failed calls to ACE	*/
  char                  priv_path [64];         /* "private path": this is
                                                 * the restricted <Location>,
                                                 * which will be used for
                                                 * cookie's "path="     */
} securid_webid;

#endif
